/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.plan.analyze.Analyzer;
import org.apache.iotdb.db.mpp.plan.analyze.FakePartitionFetcherImpl;
import org.apache.iotdb.db.mpp.plan.analyze.FakeSchemaFetcherImpl;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.parser.StatementGenerator;
import org.junit.Assert;
import org.junit.Test;

public class AnalyzeFailTest {
    @Test
    public void illegalAggregationTest1() {
        String message = "Raw data and aggregation result hybrid calculation is not supported.";
        this.assertAnalyzeSemanticException("SELECT sum(s1) + s1 FROM root.sg.d1", message);
    }

    @Test
    public void illegalAggregationTest2() {
        String message = "Aggregation results cannot be as input of the aggregation function.";
        this.assertAnalyzeSemanticException("SELECT sum(sum(s1)) FROM root.sg.d1", message);
    }

    @Test
    public void illegalAggregationTest3() {
        String message = "Raw data and aggregation hybrid query is not supported.";
        this.assertAnalyzeSemanticException("SELECT sum(s1), s1 FROM root.sg.d1", message);
    }

    @Test
    public void samePropertyKeyTest() {
        this.assertAnalyzeSemanticException("CREATE TIMESERIES root.sg1.d1.s1 INT32 TAGS('a'='1') ATTRIBUTES('a'='1')", "Tag and attribute shouldn't have the same property key");
    }

    @Test
    public void sameMeasurementsInAlignedTest() {
        this.assertAnalyzeSemanticException("CREATE ALIGNED TIMESERIES root.ln.wf01.GPS(latitude FLOAT, latitude FLOAT)", "Measurement under an aligned device is not allowed to have the same measurement name");
    }

    private void assertAnalyzeSemanticException(String sql, String message) {
        try {
            Analyzer analyzer = new Analyzer(new MPPQueryContext(new QueryId("test_query")), (IPartitionFetcher)new FakePartitionFetcherImpl(), (ISchemaFetcher)new FakeSchemaFetcherImpl());
            analyzer.analyze(StatementGenerator.createStatement((String)sql, (ZoneId)ZonedDateTime.now().getOffset()));
            Assert.fail();
        }
        catch (SemanticException e) {
            Assert.assertTrue((boolean)e.getMessage().contains(message));
        }
    }
}

