/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.units.Duration;
import java.util.Comparator;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.driver.IDriver;
import org.apache.iotdb.db.mpp.execution.schedule.AbstractDriverThread;
import org.apache.iotdb.db.mpp.execution.schedule.DriverTaskThread;
import org.apache.iotdb.db.mpp.execution.schedule.ExecutionContext;
import org.apache.iotdb.db.mpp.execution.schedule.ITaskScheduler;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IDIndexedAccessible;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IndexedBlockingQueue;
import org.apache.iotdb.db.mpp.execution.schedule.queue.L1PriorityQueue;
import org.apache.iotdb.db.mpp.execution.schedule.queue.L2PriorityQueue;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTask;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTaskStatus;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.verification.VerificationMode;

public class DriverTaskTimeoutSentinelThreadTest {
    @Test
    public void testHandleInvalidStateTask() throws ExecutionException, InterruptedException {
        ITaskScheduler mockScheduler = (ITaskScheduler)Mockito.mock(ITaskScheduler.class);
        Mockito.when((Object)mockScheduler.readyToRunning((DriverTask)Mockito.any())).thenAnswer(ans -> {
            DriverTask task = (DriverTask)ans.getArgument(0);
            if (task.getStatus() != DriverTaskStatus.READY) {
                return false;
            }
            task.setStatus(DriverTaskStatus.RUNNING);
            return true;
        });
        QueryId queryId = new QueryId("test");
        PlanFragmentId fragmentId = new PlanFragmentId(queryId, 0);
        FragmentInstanceId instanceId = new FragmentInstanceId(fragmentId, "inst-0");
        L1PriorityQueue taskQueue = new L1PriorityQueue(100, (Comparator)new DriverTask.TimeoutComparator(), (IDIndexedAccessible)new DriverTask());
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        Mockito.when((Object)mockDriver.getInfo()).thenReturn((Object)instanceId);
        DriverTaskThread executor = new DriverTaskThread("0", new ThreadGroup("timeout-test"), (IndexedBlockingQueue)taskQueue, mockScheduler);
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.FINISHED);
        executor.execute(testTask);
        Assert.assertEquals((Object)DriverTaskStatus.FINISHED, (Object)testTask.getStatus());
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).processFor((Duration)Mockito.any());
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.ABORTED);
        executor.execute(testTask);
        Assert.assertEquals((Object)DriverTaskStatus.ABORTED, (Object)testTask.getStatus());
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).processFor((Duration)Mockito.any());
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.RUNNING);
        executor.execute(testTask);
        Assert.assertEquals((Object)DriverTaskStatus.RUNNING, (Object)testTask.getStatus());
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).processFor((Duration)Mockito.any());
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).failed((Throwable)Mockito.any());
        testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.BLOCKED);
        executor.execute(testTask);
        Assert.assertEquals((Object)DriverTaskStatus.BLOCKED, (Object)testTask.getStatus());
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.never())).processFor((Duration)Mockito.any());
        Assert.assertNull((Object)testTask.getAbortCause());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).toAborted((DriverTask)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).runningToBlocked((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).runningToFinished((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).blockedToReady((DriverTask)Mockito.any());
    }

    @Test
    public void testHandleTaskByCancelledInstance() throws ExecutionException, InterruptedException {
        ITaskScheduler mockScheduler = (ITaskScheduler)Mockito.mock(ITaskScheduler.class);
        Mockito.when((Object)mockScheduler.readyToRunning((DriverTask)Mockito.any())).thenAnswer(ans -> {
            DriverTask task = (DriverTask)ans.getArgument(0);
            if (task.getStatus() != DriverTaskStatus.READY) {
                return false;
            }
            task.setStatus(DriverTaskStatus.RUNNING);
            return true;
        });
        L1PriorityQueue taskQueue = new L1PriorityQueue(100, (Comparator)new DriverTask.TimeoutComparator(), (IDIndexedAccessible)new DriverTask());
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        QueryId queryId = new QueryId("test");
        PlanFragmentId fragmentId = new PlanFragmentId(queryId, 0);
        FragmentInstanceId instanceId = new FragmentInstanceId(fragmentId, "inst-0");
        Mockito.when((Object)mockDriver.getInfo()).thenReturn((Object)instanceId);
        Mockito.when((Object)mockDriver.processFor((Duration)Mockito.any())).thenReturn((Object)Futures.immediateCancelledFuture());
        DriverTaskThread executor = new DriverTaskThread("0", new ThreadGroup("timeout-test"), (IndexedBlockingQueue)taskQueue, mockScheduler);
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.READY);
        executor.execute(testTask);
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.times((int)1))).processFor((Duration)Mockito.any());
        Assert.assertEquals((Object)"already being cancelled", (Object)testTask.getAbortCause());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.times((int)1))).toAborted((DriverTask)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).runningToReady((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).runningToBlocked((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).runningToFinished((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).blockedToReady((DriverTask)Mockito.any());
    }

    @Test
    public void testHandleTaskByFinishedInstance() throws ExecutionException, InterruptedException {
        ITaskScheduler mockScheduler = (ITaskScheduler)Mockito.mock(ITaskScheduler.class);
        Mockito.when((Object)mockScheduler.readyToRunning((DriverTask)Mockito.any())).thenAnswer(ans -> {
            DriverTask task = (DriverTask)ans.getArgument(0);
            if (task.getStatus() != DriverTaskStatus.READY) {
                return false;
            }
            task.setStatus(DriverTaskStatus.RUNNING);
            return true;
        });
        L1PriorityQueue taskQueue = new L1PriorityQueue(100, (Comparator)new DriverTask.TimeoutComparator(), (IDIndexedAccessible)new DriverTask());
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        QueryId queryId = new QueryId("test");
        PlanFragmentId fragmentId = new PlanFragmentId(queryId, 0);
        FragmentInstanceId instanceId = new FragmentInstanceId(fragmentId, "inst-0");
        Mockito.when((Object)mockDriver.getInfo()).thenReturn((Object)instanceId);
        Mockito.when((Object)mockDriver.processFor((Duration)Mockito.any())).thenAnswer(ans -> Futures.immediateVoidFuture());
        Mockito.when((Object)mockDriver.isFinished()).thenReturn((Object)true);
        DriverTaskThread executor = new DriverTaskThread("0", new ThreadGroup("timeout-test"), (IndexedBlockingQueue)taskQueue, mockScheduler);
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.READY);
        executor.execute(testTask);
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.times((int)1))).processFor((Duration)Mockito.any());
        Assert.assertNull((Object)testTask.getAbortCause());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).toAborted((DriverTask)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).runningToReady((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).runningToBlocked((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.times((int)1))).runningToFinished((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).blockedToReady((DriverTask)Mockito.any());
    }

    @Test
    public void testHandleTaskByBlockedInstance() throws ExecutionException, InterruptedException {
        ITaskScheduler mockScheduler = (ITaskScheduler)Mockito.mock(ITaskScheduler.class);
        Mockito.when((Object)mockScheduler.readyToRunning((DriverTask)Mockito.any())).thenAnswer(ans -> {
            DriverTask task = (DriverTask)ans.getArgument(0);
            if (task.getStatus() != DriverTaskStatus.READY) {
                return false;
            }
            task.setStatus(DriverTaskStatus.RUNNING);
            return true;
        });
        L1PriorityQueue taskQueue = new L1PriorityQueue(100, (Comparator)new DriverTask.TimeoutComparator(), (IDIndexedAccessible)new DriverTask());
        ListenableFuture mockFuture = (ListenableFuture)Mockito.mock(ListenableFuture.class);
        Mockito.when((Object)mockFuture.isDone()).thenReturn((Object)false);
        ((ListenableFuture)Mockito.doAnswer(ans -> {
            Runnable listener = (Runnable)ans.getArgument(0);
            Executor executor = (Executor)ans.getArgument(1);
            executor.execute(listener);
            return null;
        }).when((Object)mockFuture)).addListener((Runnable)Mockito.any(), (Executor)Mockito.any());
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        QueryId queryId = new QueryId("test");
        PlanFragmentId fragmentId = new PlanFragmentId(queryId, 0);
        FragmentInstanceId instanceId = new FragmentInstanceId(fragmentId, "inst-0");
        Mockito.when((Object)mockDriver.getInfo()).thenReturn((Object)instanceId);
        Mockito.when((Object)mockDriver.processFor((Duration)Mockito.any())).thenAnswer(ans -> mockFuture);
        Mockito.when((Object)mockDriver.isFinished()).thenReturn((Object)false);
        DriverTaskThread executor = new DriverTaskThread("0", new ThreadGroup("timeout-test"), (IndexedBlockingQueue)taskQueue, mockScheduler);
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.READY);
        executor.execute(testTask);
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.times((int)1))).processFor((Duration)Mockito.any());
        Assert.assertNull((Object)testTask.getAbortCause());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).toAborted((DriverTask)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).runningToReady((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.times((int)1))).runningToBlocked((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).runningToFinished((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        TimeUnit.MILLISECONDS.sleep(500L);
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.times((int)1))).blockedToReady((DriverTask)Mockito.any());
    }

    @Test
    public void testHandleTaskByReadyInstance() throws ExecutionException, InterruptedException {
        ITaskScheduler mockScheduler = (ITaskScheduler)Mockito.mock(ITaskScheduler.class);
        Mockito.when((Object)mockScheduler.readyToRunning((DriverTask)Mockito.any())).thenAnswer(ans -> {
            DriverTask task = (DriverTask)ans.getArgument(0);
            if (task.getStatus() != DriverTaskStatus.READY) {
                return false;
            }
            task.setStatus(DriverTaskStatus.RUNNING);
            return true;
        });
        L1PriorityQueue taskQueue = new L1PriorityQueue(100, (Comparator)new DriverTask.TimeoutComparator(), (IDIndexedAccessible)new DriverTask());
        ListenableFuture mockFuture = (ListenableFuture)Mockito.mock(ListenableFuture.class);
        Mockito.when((Object)mockFuture.isDone()).thenReturn((Object)true);
        ((ListenableFuture)Mockito.doAnswer(ans -> {
            Runnable listener = (Runnable)ans.getArgument(0);
            Executor executor = (Executor)ans.getArgument(1);
            executor.execute(listener);
            return null;
        }).when((Object)mockFuture)).addListener((Runnable)Mockito.any(), (Executor)Mockito.any());
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        QueryId queryId = new QueryId("test");
        PlanFragmentId fragmentId = new PlanFragmentId(queryId, 0);
        FragmentInstanceId instanceId = new FragmentInstanceId(fragmentId, "inst-0");
        Mockito.when((Object)mockDriver.getInfo()).thenReturn((Object)instanceId);
        Mockito.when((Object)mockDriver.processFor((Duration)Mockito.any())).thenAnswer(ans -> mockFuture);
        Mockito.when((Object)mockDriver.isFinished()).thenReturn((Object)false);
        DriverTaskThread executor = new DriverTaskThread("0", new ThreadGroup("timeout-test"), (IndexedBlockingQueue)taskQueue, mockScheduler);
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.READY);
        executor.execute(testTask);
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.times((int)1))).processFor((Duration)Mockito.any());
        Assert.assertNull((Object)testTask.getAbortCause());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).toAborted((DriverTask)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.times((int)1))).runningToReady((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).runningToBlocked((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).runningToFinished((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).blockedToReady((DriverTask)Mockito.any());
    }

    @Test
    public void testHandleTaskWithInternalError() {
        ITaskScheduler mockScheduler = (ITaskScheduler)Mockito.mock(ITaskScheduler.class);
        Mockito.when((Object)mockScheduler.readyToRunning((DriverTask)Mockito.any())).thenAnswer(ans -> {
            DriverTask task = (DriverTask)ans.getArgument(0);
            if (task.getStatus() != DriverTaskStatus.READY) {
                return false;
            }
            task.setStatus(DriverTaskStatus.RUNNING);
            return true;
        });
        L2PriorityQueue taskQueue = new L2PriorityQueue(100, (Comparator)new DriverTask.SchedulePriorityComparator(), (IDIndexedAccessible)new DriverTask());
        IDriver mockDriver = (IDriver)Mockito.mock(IDriver.class);
        QueryId queryId = new QueryId("test");
        PlanFragmentId fragmentId = new PlanFragmentId(queryId, 0);
        FragmentInstanceId instanceId = new FragmentInstanceId(fragmentId, "inst-0");
        Mockito.when((Object)mockDriver.getInfo()).thenReturn((Object)instanceId);
        DriverTaskThread executor = new DriverTaskThread("0", new ThreadGroup("timeout-test"), (IndexedBlockingQueue)taskQueue, mockScheduler);
        Mockito.when((Object)mockDriver.processFor((Duration)Mockito.any())).thenAnswer(arg_0 -> DriverTaskTimeoutSentinelThreadTest.lambda$testHandleTaskWithInternalError$11((AbstractDriverThread)executor, arg_0));
        DriverTask testTask = new DriverTask(mockDriver, 100L, DriverTaskStatus.READY);
        taskQueue.push((IDIndexedAccessible)testTask);
        executor.run();
        ((IDriver)Mockito.verify((Object)mockDriver, (VerificationMode)Mockito.times((int)1))).processFor((Duration)Mockito.any());
        Assert.assertEquals((Object)"internal error scheduled", (Object)testTask.getAbortCause());
        Assert.assertEquals((long)0L, (long)taskQueue.size());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.times((int)1))).toAborted((DriverTask)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).runningToReady((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).runningToBlocked((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).runningToFinished((DriverTask)Mockito.any(), (ExecutionContext)Mockito.any());
        ((ITaskScheduler)Mockito.verify((Object)mockScheduler, (VerificationMode)Mockito.never())).blockedToReady((DriverTask)Mockito.any());
    }

    private static /* synthetic */ Object lambda$testHandleTaskWithInternalError$11(AbstractDriverThread executor, InvocationOnMock ans) throws Throwable {
        executor.close();
        throw new RuntimeException("mock exception");
    }
}

