/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.localconfignode.LocalConfigNode;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.driver.DriverContext;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.schema.DevicesSchemaScanOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.SchemaQueryScanOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.TimeSeriesSchemaScanOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.query.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.BinaryColumn;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaQueryScanOperatorTest {
    private static final String META_SCAN_OPERATOR_TEST_SG = "root.MetaScanOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, META_SCAN_OPERATOR_TEST_SG);
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeviceMetaScanOperator() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId = queryId.genPlanNodeId();
            OperatorContext operatorContext = fragmentInstanceContext.addOperatorContext(1, planNodeId, SchemaQueryScanOperator.class.getSimpleName());
            PartialPath partialPath = new PartialPath("root.MetaScanOperatorTest.device0");
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion(LocalConfigNode.getInstance().getBelongedSchemaRegionId(partialPath));
            operatorContext.getInstanceContext().setDriverContext((DriverContext)new SchemaDriverContext(fragmentInstanceContext, schemaRegion));
            List<String> columns = Arrays.asList("devices", "storage group", "isAligned");
            DevicesSchemaScanOperator deviceMetaScanOperator = new DevicesSchemaScanOperator(planNodeId, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), 10, 0, partialPath, false, true);
            while (deviceMetaScanOperator.hasNext()) {
                TsBlock tsBlock = deviceMetaScanOperator.next();
                Assert.assertEquals((long)3L, (long)tsBlock.getValueColumnCount());
                Assert.assertTrue((boolean)(tsBlock.getColumn(0) instanceof BinaryColumn));
                Assert.assertEquals((long)1L, (long)tsBlock.getPositionCount());
                for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                    Assert.assertEquals((long)0L, (long)tsBlock.getTimeByIndex(i));
                    block12: for (int j = 0; j < columns.size(); ++j) {
                        switch (j) {
                            case 0: {
                                Assert.assertEquals((Object)tsBlock.getColumn(j).getBinary(i).toString(), (Object)"root.MetaScanOperatorTest.device0");
                                continue block12;
                            }
                            case 1: {
                                Assert.assertEquals((Object)tsBlock.getColumn(j).getBinary(i).toString(), (Object)META_SCAN_OPERATOR_TEST_SG);
                                continue block12;
                            }
                            case 2: {
                                Assert.assertEquals((Object)"false", (Object)tsBlock.getColumn(j).getBinary(i).toString());
                                continue block12;
                            }
                        }
                    }
                }
            }
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTimeSeriesMetaScanOperator() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId = queryId.genPlanNodeId();
            OperatorContext operatorContext = fragmentInstanceContext.addOperatorContext(1, planNodeId, SchemaQueryScanOperator.class.getSimpleName());
            PartialPath partialPath = new PartialPath("root.MetaScanOperatorTest.device0.*");
            ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion(LocalConfigNode.getInstance().getBelongedSchemaRegionId(partialPath));
            operatorContext.getInstanceContext().setDriverContext((DriverContext)new SchemaDriverContext(fragmentInstanceContext, schemaRegion));
            List<String> columns = Arrays.asList("timeseries", "alias", "storage group", "dataType", "encoding", "compression", "tags", "attributes");
            TimeSeriesSchemaScanOperator timeSeriesMetaScanOperator = new TimeSeriesSchemaScanOperator(planNodeId, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), 10, 0, partialPath, null, null, false, false, false, Collections.emptyMap());
            while (timeSeriesMetaScanOperator.hasNext()) {
                TsBlock tsBlock = timeSeriesMetaScanOperator.next();
                Assert.assertEquals((long)8L, (long)tsBlock.getValueColumnCount());
                Assert.assertTrue((boolean)(tsBlock.getColumn(0) instanceof BinaryColumn));
                Assert.assertEquals((long)10L, (long)tsBlock.getPositionCount());
                for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                    Assert.assertEquals((long)0L, (long)tsBlock.getTimeByIndex(i));
                    block16: for (int j = 0; j < columns.size(); ++j) {
                        Binary binary = tsBlock.getColumn(j).isNull(i) ? null : tsBlock.getColumn(j).getBinary(i);
                        String value = binary == null ? "null" : binary.toString();
                        switch (j) {
                            case 0: {
                                Assert.assertTrue((boolean)value.startsWith("root.MetaScanOperatorTest.device0"));
                                continue block16;
                            }
                            case 1: {
                                Assert.assertEquals((Object)"null", (Object)value);
                                continue block16;
                            }
                            case 2: {
                                Assert.assertEquals((Object)META_SCAN_OPERATOR_TEST_SG, (Object)value);
                                continue block16;
                            }
                            case 3: {
                                Assert.assertEquals((Object)TSDataType.INT32.toString(), (Object)value);
                                continue block16;
                            }
                            case 4: {
                                Assert.assertEquals((Object)TSEncoding.PLAIN.toString(), (Object)value);
                                continue block16;
                            }
                            case 5: {
                                Assert.assertEquals((Object)CompressionType.UNCOMPRESSED.toString(), (Object)value);
                                continue block16;
                            }
                            case 6: 
                            case 7: {
                                Assert.assertEquals((Object)"null", (Object)value);
                            }
                        }
                    }
                }
            }
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }
}

