/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.mpp.execution.operator.AggregationOperatorTest;
import org.apache.iotdb.db.mpp.execution.operator.AggregationUtil;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.db.mpp.execution.operator.process.last.UpdateLastCacheOperator;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesAggregationScanOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.query.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;
import org.apache.iotdb.tsfile.read.filter.TimeFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UpdateLastCacheOperatorTest {
    private static final String SERIES_SCAN_OPERATOR_TEST_SG = "root.UpdateLastCacheOperator";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();
    private ExecutorService instanceNotificationExecutor;

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, SERIES_SCAN_OPERATOR_TEST_SG);
        this.instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
        this.instanceNotificationExecutor.shutdown();
    }

    @Test
    public void testUpdateLastCacheOperatorTestWithoutTimeFilter() {
        try {
            List aggregators = LastQueryUtil.createAggregators((TSDataType)TSDataType.INT32);
            UpdateLastCacheOperator updateLastCacheOperator = this.initUpdateLastCacheOperator(aggregators, null, false, null);
            Assert.assertTrue((boolean)updateLastCacheOperator.isBlocked().isDone());
            Assert.assertTrue((boolean)updateLastCacheOperator.hasNext());
            TsBlock result = updateLastCacheOperator.next();
            Assert.assertEquals((long)1L, (long)result.getPositionCount());
            Assert.assertEquals((long)3L, (long)result.getValueColumnCount());
            Assert.assertEquals((long)499L, (long)result.getTimeByIndex(0));
            Assert.assertEquals((Object)"root.UpdateLastCacheOperator.device0.sensor0", (Object)result.getColumn(0).getBinary(0).toString());
            Assert.assertEquals((Object)"10499", (Object)result.getColumn(1).getBinary(0).toString());
            Assert.assertEquals((Object)TSDataType.INT32.name(), (Object)result.getColumn(2).getBinary(0).toString());
            Assert.assertFalse((boolean)updateLastCacheOperator.hasNext());
            Assert.assertTrue((boolean)updateLastCacheOperator.isFinished());
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testUpdateLastCacheOperatorTestWithTimeFilter1() {
        try {
            List aggregators = LastQueryUtil.createAggregators((TSDataType)TSDataType.INT32);
            TimeFilter.TimeGtEq timeFilter = TimeFilter.gtEq((long)200L);
            UpdateLastCacheOperator updateLastCacheOperator = this.initUpdateLastCacheOperator(aggregators, (Filter)timeFilter, false, null);
            Assert.assertTrue((boolean)updateLastCacheOperator.isBlocked().isDone());
            Assert.assertTrue((boolean)updateLastCacheOperator.hasNext());
            TsBlock result = updateLastCacheOperator.next();
            Assert.assertEquals((long)1L, (long)result.getPositionCount());
            Assert.assertEquals((long)3L, (long)result.getValueColumnCount());
            Assert.assertEquals((long)499L, (long)result.getTimeByIndex(0));
            Assert.assertEquals((Object)"root.UpdateLastCacheOperator.device0.sensor0", (Object)result.getColumn(0).getBinary(0).toString());
            Assert.assertEquals((Object)"10499", (Object)result.getColumn(1).getBinary(0).toString());
            Assert.assertEquals((Object)TSDataType.INT32.name(), (Object)result.getColumn(2).getBinary(0).toString());
            Assert.assertFalse((boolean)updateLastCacheOperator.hasNext());
            Assert.assertTrue((boolean)updateLastCacheOperator.isFinished());
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testUpdateLastCacheOperatorTestWithTimeFilter2() {
        try {
            List aggregators = LastQueryUtil.createAggregators((TSDataType)TSDataType.INT32);
            TimeFilter.TimeLtEq timeFilter = TimeFilter.ltEq((long)120L);
            UpdateLastCacheOperator updateLastCacheOperator = this.initUpdateLastCacheOperator(aggregators, (Filter)timeFilter, false, null);
            Assert.assertTrue((boolean)updateLastCacheOperator.isBlocked().isDone());
            Assert.assertTrue((boolean)updateLastCacheOperator.hasNext());
            TsBlock result = updateLastCacheOperator.next();
            Assert.assertEquals((long)1L, (long)result.getPositionCount());
            Assert.assertEquals((long)3L, (long)result.getValueColumnCount());
            Assert.assertEquals((long)120L, (long)result.getTimeByIndex(0));
            Assert.assertEquals((Object)"root.UpdateLastCacheOperator.device0.sensor0", (Object)result.getColumn(0).getBinary(0).toString());
            Assert.assertEquals((Object)"20120", (Object)result.getColumn(1).getBinary(0).toString());
            Assert.assertEquals((Object)TSDataType.INT32.name(), (Object)result.getColumn(2).getBinary(0).toString());
            Assert.assertFalse((boolean)updateLastCacheOperator.hasNext());
            Assert.assertTrue((boolean)updateLastCacheOperator.isFinished());
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    public UpdateLastCacheOperator initUpdateLastCacheOperator(List<Aggregator> aggregators, Filter timeFilter, boolean ascending, GroupByTimeParameter groupByTimeParameter) throws IllegalPathException {
        MeasurementPath measurementPath = new MeasurementPath("root.UpdateLastCacheOperator.device0.sensor0", TSDataType.INT32);
        HashSet allSensors = Sets.newHashSet((Object[])new String[]{"sensor0"});
        QueryId queryId = new QueryId("stub_query");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)this.instanceNotificationExecutor);
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
        PlanNodeId planNodeId1 = new PlanNodeId("1");
        fragmentInstanceContext.addOperatorContext(1, planNodeId1, SeriesAggregationScanOperator.class.getSimpleName());
        PlanNodeId planNodeId2 = new PlanNodeId("2");
        fragmentInstanceContext.addOperatorContext(2, planNodeId2, UpdateLastCacheOperator.class.getSimpleName());
        fragmentInstanceContext.getOperatorContexts().forEach(operatorContext -> operatorContext.setMaxRunTime(AggregationOperatorTest.TEST_TIME_SLICE));
        SeriesAggregationScanOperator seriesAggregationScanOperator = new SeriesAggregationScanOperator(planNodeId1, (PartialPath)measurementPath, (Set)allSensors, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), aggregators, AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)ascending, (boolean)true), timeFilter, ascending, groupByTimeParameter, (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
        seriesAggregationScanOperator.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
        return new UpdateLastCacheOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(1), (Operator)seriesAggregationScanOperator, measurementPath, measurementPath.getSeriesType(), null, false);
    }
}

