/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.aggregation.AccumulatorFactory;
import org.apache.iotdb.db.mpp.aggregation.Aggregator;
import org.apache.iotdb.db.mpp.aggregation.timerangeiterator.ITimeRangeIterator;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.mpp.execution.operator.AggregationUtil;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.AggregationOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.DeviceMergeOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.DeviceViewOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.FillOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.FilterAndProjectOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.LimitOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.LinearFillOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.OffsetOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.RawDataAggregationOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.SlidingWindowAggregationOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.SortOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.fill.IFill;
import org.apache.iotdb.db.mpp.execution.operator.process.fill.ILinearFill;
import org.apache.iotdb.db.mpp.execution.operator.process.fill.linear.LinearFill;
import org.apache.iotdb.db.mpp.execution.operator.process.join.RowBasedTimeJoinOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.join.TimeJoinOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryCollectOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryMergeOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQuerySortOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.UpdateLastCacheOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.CountMergeOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.DevicesCountOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.DevicesSchemaScanOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.LevelTimeSeriesCountOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.NodeManageMemoryMergeOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.NodePathsConvertOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.NodePathsCountOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.NodePathsSchemaScanOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.PathsUsingTemplateScanOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.SchemaFetchMergeOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.SchemaFetchScanOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.SchemaQueryMergeOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.SchemaQueryOrderByHeatOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.TimeSeriesCountOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.TimeSeriesSchemaScanOperator;
import org.apache.iotdb.db.mpp.execution.operator.source.AlignedSeriesScanOperator;
import org.apache.iotdb.db.mpp.execution.operator.source.ExchangeOperator;
import org.apache.iotdb.db.mpp.execution.operator.source.LastCacheScanOperator;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesAggregationScanOperator;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationStep;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.mpp.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.column.binary.ArithmeticAdditionColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.column.binary.CompareLessEqualColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.column.leaf.ConstantColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.column.leaf.TimeColumnTransformer;
import org.apache.iotdb.db.query.aggregation.AggregationType;
import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.IntColumn;
import org.apache.iotdb.tsfile.read.common.type.BooleanType;
import org.apache.iotdb.tsfile.read.common.type.LongType;
import org.apache.iotdb.tsfile.read.common.type.Type;
import org.apache.iotdb.tsfile.read.common.type.TypeEnum;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class OperatorMemoryTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void seriesScanOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            MeasurementPath measurementPath = new MeasurementPath("root.SeriesScanOperatorTest.device0.sensor0", TSDataType.INT32);
            HashSet allSensors = Sets.newHashSet((Object[])new String[]{"sensor0"});
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
            SeriesScanOperator seriesScanOperator = new SeriesScanOperator(planNodeId, (PartialPath)measurementPath, (Set)allSensors, TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), null, null, true);
            Assert.assertEquals((long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte(), (long)seriesScanOperator.calculateMaxPeekMemory());
            Assert.assertEquals((long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte(), (long)seriesScanOperator.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)seriesScanOperator.calculateRetainedSizeAfterCallingNext());
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void alignedSeriesScanOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            AlignedPath alignedPath = new AlignedPath("root.AlignedSeriesScanOperatorTest.device0", Arrays.asList("sensor0", "sensor1", "sensor2"));
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId, AlignedSeriesScanOperator.class.getSimpleName());
            AlignedSeriesScanOperator seriesScanOperator = new AlignedSeriesScanOperator(planNodeId, alignedPath, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), null, null, true);
            Assert.assertEquals((long)(4 * TSFileDescriptor.getInstance().getConfig().getPageSizeInByte()), (long)seriesScanOperator.calculateMaxPeekMemory());
            Assert.assertEquals((long)(4 * TSFileDescriptor.getInstance().getConfig().getPageSizeInByte()), (long)seriesScanOperator.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)seriesScanOperator.calculateRetainedSizeAfterCallingNext());
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    @Test
    public void exchangeOperatorTest() {
        ExchangeOperator exchangeOperator = new ExchangeOperator(null, null, null);
        Assert.assertEquals((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)exchangeOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)exchangeOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)0L, (long)exchangeOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void lastCacheScanOperatorTest() {
        TsBlock tsBlock = (TsBlock)Mockito.mock(TsBlock.class);
        Mockito.when((Object)tsBlock.getRetainedSizeInBytes()).thenReturn((Object)1024L);
        LastCacheScanOperator lastCacheScanOperator = new LastCacheScanOperator(null, null, tsBlock);
        Assert.assertEquals((long)1024L, (long)lastCacheScanOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)1024L, (long)lastCacheScanOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)0L, (long)lastCacheScanOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void fillOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        FillOperator fillOperator = new FillOperator((OperatorContext)Mockito.mock(OperatorContext.class), new IFill[]{null, null}, child);
        Assert.assertEquals((long)4608L, (long)fillOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)1024L, (long)fillOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)512L, (long)fillOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void lastQueryCollectOperatorTest() {
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        Random random = new Random();
        long expectedMaxPeekMemory = 0L;
        long expectedMaxReturnSize = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            long currentMaxPeekMemory = random.nextInt(1024) + 1024;
            long currentMaxReturnSize = random.nextInt(1024);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)currentMaxPeekMemory);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)currentMaxReturnSize);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
            children.add(child);
            expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory, currentMaxPeekMemory);
            expectedMaxReturnSize = Math.max(expectedMaxReturnSize, currentMaxReturnSize);
        }
        LastQueryCollectOperator lastQueryCollectOperator = new LastQueryCollectOperator((OperatorContext)Mockito.mock(OperatorContext.class), children);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)lastQueryCollectOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)lastQueryCollectOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)2048L, (long)lastQueryCollectOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void lastQueryMergeOperatorTest() {
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        Random random = new Random();
        long expectedMaxPeekMemory = 0L;
        long temp = 0L;
        long expectedMaxReturnSize = 0L;
        long childSumReturnSize = 0L;
        long minReturnSize = Long.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            long currentMaxPeekMemory = random.nextInt(1024) + 1024;
            long currentMaxReturnSize = random.nextInt(1024);
            minReturnSize = Math.min(minReturnSize, currentMaxReturnSize);
            childSumReturnSize += currentMaxReturnSize;
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)currentMaxPeekMemory);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)currentMaxReturnSize);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
            children.add(child);
            expectedMaxReturnSize = Math.max(expectedMaxReturnSize, currentMaxReturnSize);
            expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory, temp + child.calculateMaxPeekMemory());
            temp += child.calculateMaxReturnSize() + child.calculateRetainedSizeAfterCallingNext();
        }
        expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory, temp + expectedMaxReturnSize + (long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber() * LastQueryMergeOperator.MAP_NODE_RETRAINED_SIZE);
        LastQueryMergeOperator lastQueryMergeOperator = new LastQueryMergeOperator((OperatorContext)Mockito.mock(OperatorContext.class), children, Comparator.naturalOrder());
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)lastQueryMergeOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)lastQueryMergeOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)(childSumReturnSize - minReturnSize + 2048L + (long)TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber() * LastQueryMergeOperator.MAP_NODE_RETRAINED_SIZE), (long)lastQueryMergeOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void lastQueryOperatorTest() {
        TsBlockBuilder builder = (TsBlockBuilder)Mockito.mock(TsBlockBuilder.class);
        Mockito.when((Object)builder.getRetainedSizeInBytes()).thenReturn((Object)1024L);
        ArrayList<UpdateLastCacheOperator> children = new ArrayList<UpdateLastCacheOperator>(4);
        long expectedMaxReturnSize = TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
        for (int i = 0; i < 4; ++i) {
            UpdateLastCacheOperator child = (UpdateLastCacheOperator)Mockito.mock(UpdateLastCacheOperator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)0x200000L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
            children.add(child);
            expectedMaxReturnSize = Math.max(expectedMaxReturnSize, 1024L);
        }
        LastQueryOperator lastQueryOperator = new LastQueryOperator((OperatorContext)Mockito.mock(OperatorContext.class), children, builder);
        Assert.assertEquals((long)((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES + 0x200000L), (long)lastQueryOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)lastQueryOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)2048L, (long)lastQueryOperator.calculateRetainedSizeAfterCallingNext());
        Mockito.when((Object)builder.getRetainedSizeInBytes()).thenReturn((Object)0x400000L);
        Assert.assertEquals((long)0x600000L, (long)lastQueryOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)0x400000L, (long)lastQueryOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)2048L, (long)lastQueryOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void lastQuerySortOperatorTest() {
        TsBlock tsBlock = (TsBlock)Mockito.mock(TsBlock.class);
        Mockito.when((Object)tsBlock.getRetainedSizeInBytes()).thenReturn((Object)16384L);
        Mockito.when((Object)tsBlock.getPositionCount()).thenReturn((Object)16);
        ArrayList<UpdateLastCacheOperator> children = new ArrayList<UpdateLastCacheOperator>(4);
        for (int i = 0; i < 4; ++i) {
            UpdateLastCacheOperator child = (UpdateLastCacheOperator)Mockito.mock(UpdateLastCacheOperator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
            children.add(child);
        }
        LastQuerySortOperator lastQuerySortOperator = new LastQuerySortOperator((OperatorContext)Mockito.mock(OperatorContext.class), tsBlock, children, Comparator.naturalOrder());
        Assert.assertEquals((long)((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES + tsBlock.getRetainedSizeInBytes() + 2048L), (long)lastQuerySortOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)lastQuerySortOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)19456L, (long)lastQuerySortOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void limitOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        LimitOperator limitOperator = new LimitOperator((OperatorContext)Mockito.mock(OperatorContext.class), 100L, child);
        Assert.assertEquals((long)2048L, (long)limitOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)1024L, (long)limitOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)512L, (long)limitOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void offsetOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        OffsetOperator offsetOperator = new OffsetOperator((OperatorContext)Mockito.mock(OperatorContext.class), 100L, child);
        Assert.assertEquals((long)2048L, (long)offsetOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)1024L, (long)offsetOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)512L, (long)offsetOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void rowBasedTimeJoinOperatorTest() {
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>(2);
        dataTypeList.add(TSDataType.INT32);
        dataTypeList.add(TSDataType.INT32);
        long expectedMaxReturnSize = 3L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        long expectedMaxPeekMemory = 0L;
        long childrenMaxPeekMemory = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, expectedMaxPeekMemory + child.calculateMaxPeekMemory());
            expectedMaxPeekMemory += 65536L;
            children.add(child);
        }
        expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory + expectedMaxReturnSize, childrenMaxPeekMemory);
        RowBasedTimeJoinOperator rowBasedTimeJoinOperator = new RowBasedTimeJoinOperator((OperatorContext)Mockito.mock(OperatorContext.class), children, Ordering.ASC, dataTypeList, null, null);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)rowBasedTimeJoinOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)rowBasedTimeJoinOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)196608L, (long)rowBasedTimeJoinOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void sortOperatorTest() {
        SortOperator sortOperator = new SortOperator();
        Assert.assertEquals((long)0L, (long)sortOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)0L, (long)sortOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)0L, (long)sortOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void timeJoinOperatorTest() {
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>(2);
        dataTypeList.add(TSDataType.INT32);
        dataTypeList.add(TSDataType.INT32);
        long expectedMaxReturnSize = 3L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        long expectedMaxPeekMemory = 0L;
        long childrenMaxPeekMemory = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, expectedMaxPeekMemory + child.calculateMaxPeekMemory());
            expectedMaxPeekMemory += 65536L;
            children.add(child);
        }
        expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory + expectedMaxReturnSize, childrenMaxPeekMemory);
        TimeJoinOperator timeJoinOperator = new TimeJoinOperator((OperatorContext)Mockito.mock(OperatorContext.class), children, Ordering.ASC, dataTypeList, null, null);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)timeJoinOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)timeJoinOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)196608L, (long)timeJoinOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void updateLastCacheOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        UpdateLastCacheOperator updateLastCacheOperator = new UpdateLastCacheOperator(null, child, null, TSDataType.BOOLEAN, null, true);
        Assert.assertEquals((long)2048L, (long)updateLastCacheOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)1024L, (long)updateLastCacheOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)512L, (long)updateLastCacheOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void linearFillOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        LinearFillOperator linearFillOperator = new LinearFillOperator((OperatorContext)Mockito.mock(OperatorContext.class), (ILinearFill[])new LinearFill[]{null, null}, child);
        Assert.assertEquals((long)6656L, (long)linearFillOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)1024L, (long)linearFillOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)512L, (long)linearFillOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void deviceMergeOperatorTest() {
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>(2);
        dataTypeList.add(TSDataType.INT32);
        dataTypeList.add(TSDataType.INT32);
        ArrayList<String> devices = new ArrayList<String>(4);
        devices.add("device1");
        devices.add("device2");
        devices.add("device3");
        devices.add("device4");
        long expectedMaxReturnSize = 3L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        long expectedMaxPeekMemory = TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        long expectedRetainedSizeAfterCallingNext = 0L;
        long childrenMaxPeekMemory = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)65536L);
            expectedMaxPeekMemory += 131072L;
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, child.calculateMaxPeekMemory());
            expectedRetainedSizeAfterCallingNext += 131072L;
            children.add(child);
        }
        expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory, childrenMaxPeekMemory);
        DeviceMergeOperator deviceMergeOperator = new DeviceMergeOperator((OperatorContext)Mockito.mock(OperatorContext.class), devices, children, dataTypeList, (TimeSelector)Mockito.mock(TimeSelector.class), (TimeComparator)Mockito.mock(TimeComparator.class));
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)deviceMergeOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)deviceMergeOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)(expectedRetainedSizeAfterCallingNext - 65536L), (long)deviceMergeOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void deviceViewOperatorTest() {
        long expectedMaxReturnSize;
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        ArrayList<TSDataType> dataTypeList = new ArrayList<TSDataType>(2);
        dataTypeList.add(TSDataType.INT32);
        dataTypeList.add(TSDataType.INT32);
        ArrayList<String> devices = new ArrayList<String>(4);
        devices.add("device1");
        devices.add("device2");
        devices.add("device3");
        devices.add("device4");
        long expectedMaxPeekMemory = expectedMaxReturnSize = 2L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
        long expectedRetainedSizeAfterCallingNext = 0L;
        long childrenMaxPeekMemory = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)1024L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)1024L);
            expectedMaxPeekMemory += 1024L;
            childrenMaxPeekMemory = Math.max(childrenMaxPeekMemory, child.calculateMaxPeekMemory());
            expectedRetainedSizeAfterCallingNext += 1024L;
            children.add(child);
        }
        expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory, childrenMaxPeekMemory);
        DeviceViewOperator deviceViewOperator = new DeviceViewOperator((OperatorContext)Mockito.mock(OperatorContext.class), devices, children, new ArrayList(), dataTypeList);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)deviceViewOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)deviceViewOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSizeAfterCallingNext, (long)deviceViewOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void filterAndProjectOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        BooleanType booleanType = (BooleanType)Mockito.mock(BooleanType.class);
        Mockito.when((Object)booleanType.getTypeEnum()).thenReturn((Object)TypeEnum.BOOLEAN);
        LongType longType = (LongType)Mockito.mock(LongType.class);
        Mockito.when((Object)longType.getTypeEnum()).thenReturn((Object)TypeEnum.INT64);
        CompareLessEqualColumnTransformer filterColumnTransformer = new CompareLessEqualColumnTransformer((Type)booleanType, (ColumnTransformer)new TimeColumnTransformer((Type)longType), (ColumnTransformer)new ConstantColumnTransformer((Type)longType, (Column)Mockito.mock(IntColumn.class)));
        ArrayList<TSDataType> filterOutputTypes = new ArrayList<TSDataType>();
        filterOutputTypes.add(TSDataType.INT32);
        filterOutputTypes.add(TSDataType.INT64);
        ArrayList<ArithmeticAdditionColumnTransformer> projectColumnTransformers = new ArrayList<ArithmeticAdditionColumnTransformer>();
        projectColumnTransformers.add(new ArithmeticAdditionColumnTransformer((Type)booleanType, (ColumnTransformer)new TimeColumnTransformer((Type)longType), (ColumnTransformer)new ConstantColumnTransformer((Type)longType, (Column)Mockito.mock(IntColumn.class))));
        FilterAndProjectOperator operator = new FilterAndProjectOperator((OperatorContext)Mockito.mock(OperatorContext.class), child, filterOutputTypes, new ArrayList(), (ColumnTransformer)filterColumnTransformer, new ArrayList(), new ArrayList(), projectColumnTransformers, false, true);
        Assert.assertEquals((long)(4L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte() + 512L), (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)(2 * TSFileDescriptor.getInstance().getConfig().getPageSizeInByte()), (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)512L, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TimeSeriesSchemaScanOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
            TimeSeriesSchemaScanOperator operator = new TimeSeriesSchemaScanOperator(planNodeId, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), 0, 0, null, null, null, false, false, false, null);
            Assert.assertEquals((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxPeekMemory());
            Assert.assertEquals((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)operator.calculateRetainedSizeAfterCallingNext());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void DeviceSchemaScanOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
            DevicesSchemaScanOperator operator = new DevicesSchemaScanOperator(planNodeId, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), 0, 0, null, false, false);
            Assert.assertEquals((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxPeekMemory());
            Assert.assertEquals((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)operator.calculateRetainedSizeAfterCallingNext());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void PathsUsingTemplateScanOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
            PathsUsingTemplateScanOperator operator = new PathsUsingTemplateScanOperator(planNodeId, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), 0);
            Assert.assertEquals((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxPeekMemory());
            Assert.assertEquals((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)operator.calculateRetainedSizeAfterCallingNext());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void TimeSeriesCountOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
            TimeSeriesCountOperator operator = new TimeSeriesCountOperator(planNodeId, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), null, false, null, null, false, Collections.emptyMap());
            Assert.assertEquals((long)4L, (long)operator.calculateMaxPeekMemory());
            Assert.assertEquals((long)4L, (long)operator.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)operator.calculateRetainedSizeAfterCallingNext());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void LevelTimeSeriesCountOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
            LevelTimeSeriesCountOperator operator = new LevelTimeSeriesCountOperator(planNodeId, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), null, false, 4, null, null, false);
            Assert.assertEquals((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxPeekMemory());
            Assert.assertEquals((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)operator.calculateRetainedSizeAfterCallingNext());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void DevicesCountOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
            DevicesCountOperator operator = new DevicesCountOperator(planNodeId, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), null, false);
            Assert.assertEquals((long)4L, (long)operator.calculateMaxPeekMemory());
            Assert.assertEquals((long)4L, (long)operator.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)operator.calculateRetainedSizeAfterCallingNext());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    @Test
    public void SchemaQueryMergeOperatorTest() {
        QueryId queryId = new QueryId("stub_query");
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        long expectedMaxReturnSize = 0L;
        long expectedMaxPeekMemory = 0L;
        long expectedRetainedSize = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
            expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory, child.calculateMaxPeekMemory());
            expectedMaxReturnSize = Math.max(expectedMaxReturnSize, child.calculateMaxReturnSize());
            expectedRetainedSize += child.calculateRetainedSizeAfterCallingNext();
            children.add(child);
        }
        SchemaQueryMergeOperator operator = new SchemaQueryMergeOperator(queryId.genPlanNodeId(), (OperatorContext)Mockito.mock(OperatorContext.class), children);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSize, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void CountMergeOperatorTest() {
        QueryId queryId = new QueryId("stub_query");
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        long expectedMaxReturnSize = 0L;
        long expectedMaxPeekMemory = 0L;
        long expectedRetainedSize = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
            expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory, child.calculateMaxPeekMemory());
            expectedMaxReturnSize = Math.max(expectedMaxReturnSize, child.calculateMaxReturnSize());
            expectedRetainedSize += child.calculateRetainedSizeAfterCallingNext();
            children.add(child);
        }
        CountMergeOperator operator = new CountMergeOperator(queryId.genPlanNodeId(), (OperatorContext)Mockito.mock(OperatorContext.class), children);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSize, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void SchemaFetchScanOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
            SchemaFetchScanOperator operator = new SchemaFetchScanOperator(planNodeId, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), null, null, null);
            Assert.assertEquals((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxPeekMemory());
            Assert.assertEquals((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)operator.calculateRetainedSizeAfterCallingNext());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    @Test
    public void SchemaFetchMergeOperatorTest() {
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        long expectedMaxReturnSize = 0L;
        long expectedMaxPeekMemory = 0L;
        long expectedRetainedSize = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
            expectedMaxPeekMemory = Math.max(expectedMaxPeekMemory, child.calculateMaxPeekMemory());
            expectedMaxReturnSize = Math.max(expectedMaxReturnSize, child.calculateMaxReturnSize());
            expectedRetainedSize += child.calculateRetainedSizeAfterCallingNext();
            children.add(child);
        }
        SchemaFetchMergeOperator operator = new SchemaFetchMergeOperator((OperatorContext)Mockito.mock(OperatorContext.class), children, null);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSize, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void SchemaQueryOrderByHeatOperatorTest() {
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        long expectedMaxReturnSize = 0L;
        long expectedMaxPeekMemory = 0L;
        long expectedRetainedSize = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
            expectedMaxPeekMemory += child.calculateMaxReturnSize();
            expectedMaxReturnSize += child.calculateMaxReturnSize();
            expectedRetainedSize += child.calculateRetainedSizeAfterCallingNext() + child.calculateMaxReturnSize();
            children.add(child);
        }
        SchemaQueryOrderByHeatOperator operator = new SchemaQueryOrderByHeatOperator((OperatorContext)Mockito.mock(OperatorContext.class), children);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSize, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void NodePathsSchemaScanOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
            NodePathsSchemaScanOperator operator = new NodePathsSchemaScanOperator(planNodeId, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), null, 4);
            Assert.assertEquals((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxPeekMemory());
            Assert.assertEquals((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, (long)operator.calculateMaxReturnSize());
            Assert.assertEquals((long)0L, (long)operator.calculateRetainedSizeAfterCallingNext());
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    @Test
    public void NodePathsConvertOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
        long expectedMaxPeekMemory = child.calculateMaxPeekMemory() + child.calculateMaxReturnSize();
        long expectedMaxReturnSize = child.calculateMaxReturnSize();
        long expectedRetainedSize = child.calculateRetainedSizeAfterCallingNext();
        NodePathsConvertOperator operator = new NodePathsConvertOperator((OperatorContext)Mockito.mock(OperatorContext.class), child);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSize, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void NodePathsCountOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
        long expectedMaxPeekMemory = Math.max(2L * (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, child.calculateMaxPeekMemory());
        long expectedMaxReturnSize = Math.max((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, child.calculateMaxReturnSize());
        long expectedRetainedSize = (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES + child.calculateRetainedSizeAfterCallingNext();
        NodePathsCountOperator operator = new NodePathsCountOperator((OperatorContext)Mockito.mock(OperatorContext.class), child);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSize, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void NodeManageMemoryMergeOperatorTest() {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)0L);
        long expectedMaxPeekMemory = Math.max(2L * (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, child.calculateMaxPeekMemory());
        long expectedMaxReturnSize = Math.max((long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES, child.calculateMaxReturnSize());
        long expectedRetainedSize = (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES + child.calculateRetainedSizeAfterCallingNext();
        NodeManageMemoryMergeOperator operator = new NodeManageMemoryMergeOperator((OperatorContext)Mockito.mock(OperatorContext.class), Collections.emptySet(), child);
        Assert.assertEquals((long)expectedMaxPeekMemory, (long)operator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)operator.calculateMaxReturnSize());
        Assert.assertEquals((long)expectedRetainedSize, (long)operator.calculateRetainedSizeAfterCallingNext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void seriesAggregationScanOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            MeasurementPath measurementPath = new MeasurementPath("root.sg.d1.s1", TSDataType.TEXT);
            TypeProvider typeProvider = new TypeProvider();
            typeProvider.setType("count(root.sg.d1.s1)", TSDataType.INT64);
            typeProvider.setType("min_time(root.sg.d1.s1)", TSDataType.INT64);
            typeProvider.setType("first_value(root.sg.d1.s1)", TSDataType.TEXT);
            List<AggregationDescriptor> aggregationDescriptors1 = Arrays.asList(new AggregationDescriptor(AggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
            SeriesAggregationScanOperator seriesAggregationScanOperator1 = this.createSeriesAggregationScanOperator(instanceNotificationExecutor, measurementPath, aggregationDescriptors1, null, typeProvider);
            long expectedMaxReturnSize = 529L;
            long expectedMaxRetainSize = 2L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
            Assert.assertEquals((long)(expectedMaxReturnSize + expectedMaxRetainSize), (long)seriesAggregationScanOperator1.calculateMaxPeekMemory());
            Assert.assertEquals((long)expectedMaxReturnSize, (long)seriesAggregationScanOperator1.calculateMaxReturnSize());
            Assert.assertEquals((long)expectedMaxRetainSize, (long)seriesAggregationScanOperator1.calculateRetainedSizeAfterCallingNext());
            List<AggregationDescriptor> aggregationDescriptors2 = Arrays.asList(new AggregationDescriptor(AggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.PARTIAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
            SeriesAggregationScanOperator seriesAggregationScanOperator2 = this.createSeriesAggregationScanOperator(instanceNotificationExecutor, measurementPath, aggregationDescriptors2, null, typeProvider);
            expectedMaxReturnSize = 538L;
            expectedMaxRetainSize = 2L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
            Assert.assertEquals((long)(expectedMaxReturnSize + expectedMaxRetainSize), (long)seriesAggregationScanOperator2.calculateMaxPeekMemory());
            Assert.assertEquals((long)expectedMaxReturnSize, (long)seriesAggregationScanOperator2.calculateMaxReturnSize());
            Assert.assertEquals((long)expectedMaxRetainSize, (long)seriesAggregationScanOperator2.calculateRetainedSizeAfterCallingNext());
            long maxTsBlockLineNumber = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockLineNumber();
            GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 2L * maxTsBlockLineNumber, maxTsBlockLineNumber / 100L, maxTsBlockLineNumber / 100L, true);
            List<AggregationDescriptor> aggregationDescriptors3 = Arrays.asList(new AggregationDescriptor(AggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
            SeriesAggregationScanOperator seriesAggregationScanOperator3 = this.createSeriesAggregationScanOperator(instanceNotificationExecutor, measurementPath, aggregationDescriptors3, groupByTimeParameter, typeProvider);
            expectedMaxReturnSize = 105800L;
            expectedMaxRetainSize = 2L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
            Assert.assertEquals((long)(expectedMaxReturnSize + expectedMaxRetainSize), (long)seriesAggregationScanOperator3.calculateMaxPeekMemory());
            Assert.assertEquals((long)expectedMaxReturnSize, (long)seriesAggregationScanOperator3.calculateMaxReturnSize());
            Assert.assertEquals((long)expectedMaxRetainSize, (long)seriesAggregationScanOperator3.calculateRetainedSizeAfterCallingNext());
            groupByTimeParameter = new GroupByTimeParameter(0L, 2L * maxTsBlockLineNumber, 1L, 1L, true);
            List<AggregationDescriptor> aggregationDescriptors4 = Arrays.asList(new AggregationDescriptor(AggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
            SeriesAggregationScanOperator seriesAggregationScanOperator4 = this.createSeriesAggregationScanOperator(instanceNotificationExecutor, measurementPath, aggregationDescriptors4, groupByTimeParameter, typeProvider);
            expectedMaxReturnSize = maxTsBlockLineNumber * 529L;
            expectedMaxRetainSize = 2L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
            Assert.assertEquals((long)(expectedMaxReturnSize + expectedMaxRetainSize), (long)seriesAggregationScanOperator4.calculateMaxPeekMemory());
            Assert.assertEquals((long)expectedMaxReturnSize, (long)seriesAggregationScanOperator4.calculateMaxReturnSize());
            Assert.assertEquals((long)expectedMaxRetainSize, (long)seriesAggregationScanOperator4.calculateRetainedSizeAfterCallingNext());
            groupByTimeParameter = new GroupByTimeParameter(0L, 2L * maxTsBlockLineNumber, 1L, 1L, true);
            List<AggregationDescriptor> aggregationDescriptors5 = Arrays.asList(new AggregationDescriptor(AggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(AggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(AggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.SINGLE, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
            SeriesAggregationScanOperator seriesAggregationScanOperator5 = this.createSeriesAggregationScanOperator(instanceNotificationExecutor, measurementPath, aggregationDescriptors5, groupByTimeParameter, typeProvider);
            expectedMaxReturnSize = TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
            expectedMaxRetainSize = 2L * (long)TSFileDescriptor.getInstance().getConfig().getPageSizeInByte();
            Assert.assertEquals((long)(expectedMaxReturnSize + expectedMaxRetainSize), (long)seriesAggregationScanOperator5.calculateMaxPeekMemory());
            Assert.assertEquals((long)expectedMaxReturnSize, (long)seriesAggregationScanOperator5.calculateMaxReturnSize());
            Assert.assertEquals((long)expectedMaxRetainSize, (long)seriesAggregationScanOperator5.calculateRetainedSizeAfterCallingNext());
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
        finally {
            instanceNotificationExecutor.shutdown();
        }
    }

    private SeriesAggregationScanOperator createSeriesAggregationScanOperator(ExecutorService instanceNotificationExecutor, MeasurementPath measurementPath, List<AggregationDescriptor> aggregationDescriptors, GroupByTimeParameter groupByTimeParameter, TypeProvider typeProvider) throws IllegalPathException {
        HashSet allSensors = Sets.newHashSet((Object[])new String[]{"s1"});
        QueryId queryId = new QueryId("stub_query");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
        PlanNodeId planNodeId = new PlanNodeId("1");
        fragmentInstanceContext.addOperatorContext(1, planNodeId, SeriesScanOperator.class.getSimpleName());
        ArrayList aggregators = new ArrayList();
        aggregationDescriptors.forEach(o -> aggregators.add(new Aggregator(AccumulatorFactory.createAccumulator((AggregationType)o.getAggregationType(), (TSDataType)measurementPath.getSeriesType(), (boolean)true), o.getStep())));
        ITimeRangeIterator timeRangeIterator = AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)true, (boolean)true);
        long maxReturnSize = AggregationUtil.calculateMaxAggregationResultSize(aggregationDescriptors, (ITimeRangeIterator)timeRangeIterator, (TypeProvider)typeProvider);
        return new SeriesAggregationScanOperator(planNodeId, (PartialPath)measurementPath, (Set)allSensors, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), aggregators, timeRangeIterator, null, true, groupByTimeParameter, maxReturnSize);
    }

    @Test
    public void rawDataAggregationOperatorTest() throws IllegalPathException {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        MeasurementPath measurementPath = new MeasurementPath("root.sg.d1.s1", TSDataType.TEXT);
        TypeProvider typeProvider = new TypeProvider();
        typeProvider.setType("count(root.sg.d1.s1)", TSDataType.INT64);
        typeProvider.setType("first_value(root.sg.d1.s1)", TSDataType.TEXT);
        List<AggregationDescriptor> aggregationDescriptors = Arrays.asList(new AggregationDescriptor(AggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
        ArrayList aggregators = new ArrayList();
        aggregationDescriptors.forEach(o -> aggregators.add(new Aggregator(AccumulatorFactory.createAccumulator((AggregationType)o.getAggregationType(), (TSDataType)measurementPath.getSeriesType(), (boolean)true), o.getStep())));
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 1000L, 10L, 10L, true);
        ITimeRangeIterator timeRangeIterator = AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)true, (boolean)false);
        long maxReturnSize = AggregationUtil.calculateMaxAggregationResultSize(aggregationDescriptors, (ITimeRangeIterator)timeRangeIterator, (TypeProvider)typeProvider);
        RawDataAggregationOperator rawDataAggregationOperator = new RawDataAggregationOperator((OperatorContext)Mockito.mock(OperatorContext.class), aggregators, timeRangeIterator, child, true, maxReturnSize);
        long expectedMaxReturnSize = 52900L;
        long expectedMaxRetainSize = child.calculateMaxReturnSize();
        Assert.assertEquals((long)(expectedMaxReturnSize + expectedMaxRetainSize + child.calculateRetainedSizeAfterCallingNext()), (long)rawDataAggregationOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)rawDataAggregationOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)(expectedMaxRetainSize + child.calculateRetainedSizeAfterCallingNext()), (long)rawDataAggregationOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void slidingWindowAggregationOperatorTest() throws IllegalPathException {
        Operator child = (Operator)Mockito.mock(Operator.class);
        Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)2048L);
        Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)1024L);
        Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)512L);
        MeasurementPath measurementPath = new MeasurementPath("root.sg.d1.s1", TSDataType.TEXT);
        TypeProvider typeProvider = new TypeProvider();
        typeProvider.setType("count(root.sg.d1.s1)", TSDataType.INT64);
        typeProvider.setType("first_value(root.sg.d1.s1)", TSDataType.TEXT);
        List<AggregationDescriptor> aggregationDescriptors = Arrays.asList(new AggregationDescriptor(AggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
        ArrayList aggregators = new ArrayList();
        aggregationDescriptors.forEach(o -> aggregators.add(new Aggregator(AccumulatorFactory.createAccumulator((AggregationType)o.getAggregationType(), (TSDataType)measurementPath.getSeriesType(), (boolean)true), o.getStep())));
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 1000L, 10L, 5L, true);
        ITimeRangeIterator timeRangeIterator = AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)true, (boolean)false);
        long maxReturnSize = AggregationUtil.calculateMaxAggregationResultSize(aggregationDescriptors, (ITimeRangeIterator)timeRangeIterator, (TypeProvider)typeProvider);
        SlidingWindowAggregationOperator slidingWindowAggregationOperator = new SlidingWindowAggregationOperator((OperatorContext)Mockito.mock(OperatorContext.class), aggregators, timeRangeIterator, child, true, groupByTimeParameter, maxReturnSize);
        long expectedMaxReturnSize = 105800L;
        long expectedMaxRetainSize = child.calculateMaxReturnSize();
        Assert.assertEquals((long)(expectedMaxReturnSize + expectedMaxRetainSize + child.calculateRetainedSizeAfterCallingNext()), (long)slidingWindowAggregationOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)slidingWindowAggregationOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)(expectedMaxRetainSize + child.calculateRetainedSizeAfterCallingNext()), (long)slidingWindowAggregationOperator.calculateRetainedSizeAfterCallingNext());
    }

    @Test
    public void aggregationOperatorTest() throws IllegalPathException {
        ArrayList<Operator> children = new ArrayList<Operator>(4);
        long expectedChildrenRetainedSize = 0L;
        long expectedMaxRetainSize = 0L;
        for (int i = 0; i < 4; ++i) {
            Operator child = (Operator)Mockito.mock(Operator.class);
            Mockito.when((Object)child.calculateMaxPeekMemory()).thenReturn((Object)131072L);
            Mockito.when((Object)child.calculateMaxReturnSize()).thenReturn((Object)65536L);
            Mockito.when((Object)child.calculateRetainedSizeAfterCallingNext()).thenReturn((Object)65536L);
            expectedChildrenRetainedSize += 65536L;
            expectedMaxRetainSize += 65536L;
            children.add(child);
        }
        MeasurementPath measurementPath = new MeasurementPath("root.sg.d1.s1", TSDataType.TEXT);
        TypeProvider typeProvider = new TypeProvider();
        typeProvider.setType("count(root.sg.d1.s1)", TSDataType.INT64);
        typeProvider.setType("first_value(root.sg.d1.s1)", TSDataType.TEXT);
        List<AggregationDescriptor> aggregationDescriptors = Arrays.asList(new AggregationDescriptor(AggregationType.FIRST_VALUE.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))), new AggregationDescriptor(AggregationType.COUNT.name().toLowerCase(), AggregationStep.FINAL, Collections.singletonList(new TimeSeriesOperand((PartialPath)measurementPath))));
        ArrayList aggregators = new ArrayList();
        aggregationDescriptors.forEach(o -> aggregators.add(new Aggregator(AccumulatorFactory.createAccumulator((AggregationType)o.getAggregationType(), (TSDataType)measurementPath.getSeriesType(), (boolean)true), o.getStep())));
        GroupByTimeParameter groupByTimeParameter = new GroupByTimeParameter(0L, 1000L, 10L, 10L, true);
        ITimeRangeIterator timeRangeIterator = AggregationUtil.initTimeRangeIterator((GroupByTimeParameter)groupByTimeParameter, (boolean)true, (boolean)false);
        long maxReturnSize = AggregationUtil.calculateMaxAggregationResultSize(aggregationDescriptors, (ITimeRangeIterator)timeRangeIterator, (TypeProvider)typeProvider);
        AggregationOperator aggregationOperator = new AggregationOperator((OperatorContext)Mockito.mock(OperatorContext.class), aggregators, timeRangeIterator, children, maxReturnSize);
        long expectedMaxReturnSize = 52900L;
        Assert.assertEquals((long)(expectedMaxReturnSize + expectedMaxRetainSize + expectedChildrenRetainedSize), (long)aggregationOperator.calculateMaxPeekMemory());
        Assert.assertEquals((long)expectedMaxReturnSize, (long)aggregationOperator.calculateMaxReturnSize());
        Assert.assertEquals((long)(expectedMaxRetainSize + expectedChildrenRetainedSize), (long)aggregationOperator.calculateRetainedSizeAfterCallingNext());
    }
}

