/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.MultiColumnMerger;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumnBuilder;
import org.junit.Assert;
import org.junit.Test;

public class MultiColumnMergerTest {
    @Test
    public void mergeTest1() {
        MultiColumnMerger merger = new MultiColumnMerger((List)ImmutableList.of((Object)new InputLocation(0, 0), (Object)new InputLocation(1, 0)));
        TsBlockBuilder inputBuilder1 = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        inputBuilder1.getTimeColumnBuilder().writeLong(2L);
        inputBuilder1.getColumnBuilder(0).writeInt(20);
        inputBuilder1.declarePosition();
        inputBuilder1.getTimeColumnBuilder().writeLong(4L);
        inputBuilder1.getColumnBuilder(0).writeInt(40);
        inputBuilder1.declarePosition();
        inputBuilder1.getTimeColumnBuilder().writeLong(5L);
        inputBuilder1.getColumnBuilder(0).appendNull();
        inputBuilder1.declarePosition();
        inputBuilder1.getTimeColumnBuilder().writeLong(6L);
        inputBuilder1.getColumnBuilder(0).writeInt(60);
        inputBuilder1.declarePosition();
        TsBlockBuilder inputBuilder2 = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        inputBuilder2.getTimeColumnBuilder().writeLong(8L);
        inputBuilder2.getColumnBuilder(0).writeInt(800);
        inputBuilder2.declarePosition();
        inputBuilder2.getTimeColumnBuilder().writeLong(10L);
        inputBuilder2.getColumnBuilder(0).writeInt(1000);
        inputBuilder2.declarePosition();
        TsBlock[] inputTsBlocks = new TsBlock[]{inputBuilder1.build(), inputBuilder2.build()};
        int[] inputIndex = new int[]{1, 0};
        int[] updatedInputIndex = new int[]{1, 0};
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        TimeColumnBuilder timeColumnBuilder = builder.getTimeColumnBuilder();
        timeColumnBuilder.writeLong(4L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(5L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(6L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(7L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(8L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(9L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(10L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(11L);
        builder.declarePosition();
        ColumnBuilder valueColumnBuilder = builder.getColumnBuilder(0);
        merger.mergeColumn(inputTsBlocks, inputIndex, updatedInputIndex, timeColumnBuilder, 11L, valueColumnBuilder);
        Assert.assertEquals((long)4L, (long)updatedInputIndex[0]);
        Assert.assertEquals((long)2L, (long)updatedInputIndex[1]);
        Column result = valueColumnBuilder.build();
        Assert.assertEquals((long)8L, (long)result.getPositionCount());
        Assert.assertFalse((boolean)result.isNull(0));
        Assert.assertEquals((long)40L, (long)result.getInt(0));
        Assert.assertTrue((boolean)result.isNull(1));
        Assert.assertFalse((boolean)result.isNull(2));
        Assert.assertEquals((long)60L, (long)result.getInt(2));
        Assert.assertTrue((boolean)result.isNull(3));
        Assert.assertFalse((boolean)result.isNull(4));
        Assert.assertEquals((long)800L, (long)result.getInt(4));
        Assert.assertTrue((boolean)result.isNull(5));
        Assert.assertFalse((boolean)result.isNull(6));
        Assert.assertEquals((long)1000L, (long)result.getInt(6));
        Assert.assertTrue((boolean)result.isNull(7));
    }

    @Test
    public void mergeTest2() {
        MultiColumnMerger merger = new MultiColumnMerger((List)ImmutableList.of((Object)new InputLocation(0, 0), (Object)new InputLocation(1, 0)));
        TsBlockBuilder inputBuilder1 = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        inputBuilder1.getTimeColumnBuilder().writeLong(2L);
        inputBuilder1.getColumnBuilder(0).writeInt(20);
        inputBuilder1.declarePosition();
        inputBuilder1.getTimeColumnBuilder().writeLong(4L);
        inputBuilder1.getColumnBuilder(0).writeInt(40);
        inputBuilder1.declarePosition();
        inputBuilder1.getTimeColumnBuilder().writeLong(5L);
        inputBuilder1.getColumnBuilder(0).appendNull();
        inputBuilder1.declarePosition();
        inputBuilder1.getTimeColumnBuilder().writeLong(6L);
        inputBuilder1.getColumnBuilder(0).appendNull();
        inputBuilder1.declarePosition();
        inputBuilder1.getTimeColumnBuilder().writeLong(7L);
        inputBuilder1.getColumnBuilder(0).appendNull();
        inputBuilder1.declarePosition();
        inputBuilder1.getTimeColumnBuilder().writeLong(8L);
        inputBuilder1.getColumnBuilder(0).appendNull();
        inputBuilder1.declarePosition();
        inputBuilder1.getTimeColumnBuilder().writeLong(9L);
        inputBuilder1.getColumnBuilder(0).appendNull();
        inputBuilder1.declarePosition();
        inputBuilder1.getTimeColumnBuilder().writeLong(10L);
        inputBuilder1.getColumnBuilder(0).writeInt(100);
        inputBuilder1.declarePosition();
        TsBlockBuilder inputBuilder2 = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        inputBuilder2.getTimeColumnBuilder().writeLong(6L);
        inputBuilder2.getColumnBuilder(0).writeInt(60);
        inputBuilder2.declarePosition();
        inputBuilder2.getTimeColumnBuilder().writeLong(7L);
        inputBuilder2.getColumnBuilder(0).writeInt(70);
        inputBuilder2.declarePosition();
        inputBuilder2.getTimeColumnBuilder().writeLong(8L);
        inputBuilder2.getColumnBuilder(0).writeInt(80);
        inputBuilder2.declarePosition();
        inputBuilder2.getTimeColumnBuilder().writeLong(9L);
        inputBuilder2.getColumnBuilder(0).writeInt(90);
        inputBuilder2.declarePosition();
        TsBlock[] inputTsBlocks = new TsBlock[]{inputBuilder1.build(), inputBuilder2.build()};
        int[] inputIndex = new int[]{1, 0};
        int[] updatedInputIndex = new int[]{1, 0};
        TsBlockBuilder builder = new TsBlockBuilder(Collections.singletonList(TSDataType.INT32));
        TimeColumnBuilder timeColumnBuilder = builder.getTimeColumnBuilder();
        timeColumnBuilder.writeLong(4L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(5L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(6L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(7L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(8L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(9L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(10L);
        builder.declarePosition();
        timeColumnBuilder.writeLong(11L);
        builder.declarePosition();
        ColumnBuilder valueColumnBuilder = builder.getColumnBuilder(0);
        merger.mergeColumn(inputTsBlocks, inputIndex, updatedInputIndex, timeColumnBuilder, 11L, valueColumnBuilder);
        Assert.assertEquals((long)8L, (long)updatedInputIndex[0]);
        Assert.assertEquals((long)4L, (long)updatedInputIndex[1]);
        Column result = valueColumnBuilder.build();
        Assert.assertEquals((long)8L, (long)result.getPositionCount());
        Assert.assertFalse((boolean)result.isNull(0));
        Assert.assertEquals((long)40L, (long)result.getInt(0));
        Assert.assertTrue((boolean)result.isNull(1));
        Assert.assertFalse((boolean)result.isNull(2));
        Assert.assertEquals((long)60L, (long)result.getInt(2));
        Assert.assertFalse((boolean)result.isNull(3));
        Assert.assertEquals((long)70L, (long)result.getInt(3));
        Assert.assertFalse((boolean)result.isNull(4));
        Assert.assertEquals((long)80L, (long)result.getInt(4));
        Assert.assertFalse((boolean)result.isNull(5));
        Assert.assertEquals((long)90L, (long)result.getInt(5));
        Assert.assertFalse((boolean)result.isNull(6));
        Assert.assertEquals((long)100L, (long)result.getInt(6));
        Assert.assertTrue((boolean)result.isNull(7));
    }
}

