/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.mpp.execution.operator.AggregationOperatorTest;
import org.apache.iotdb.db.mpp.execution.operator.AggregationUtil;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.db.mpp.execution.operator.process.last.UpdateLastCacheOperator;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesAggregationScanOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.query.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LastQueryOperatorTest {
    private static final String SERIES_SCAN_OPERATOR_TEST_SG = "root.LastQueryOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();
    private ExecutorService instanceNotificationExecutor;

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, SERIES_SCAN_OPERATOR_TEST_SG);
        this.instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
        this.instanceNotificationExecutor.shutdown();
    }

    @Test
    public void testLastQueryOperator1() {
        try {
            List aggregators1 = LastQueryUtil.createAggregators((TSDataType)TSDataType.INT32);
            MeasurementPath measurementPath1 = new MeasurementPath("root.LastQueryOperatorTest.device0.sensor0", TSDataType.INT32);
            List aggregators2 = LastQueryUtil.createAggregators((TSDataType)TSDataType.INT32);
            MeasurementPath measurementPath2 = new MeasurementPath("root.LastQueryOperatorTest.device0.sensor1", TSDataType.INT32);
            HashSet allSensors = Sets.newHashSet((Object[])new String[]{"sensor0", "sensor1"});
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)this.instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId1, SeriesAggregationScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            fragmentInstanceContext.addOperatorContext(2, planNodeId2, UpdateLastCacheOperator.class.getSimpleName());
            PlanNodeId planNodeId3 = new PlanNodeId("3");
            fragmentInstanceContext.addOperatorContext(3, planNodeId3, SeriesAggregationScanOperator.class.getSimpleName());
            PlanNodeId planNodeId4 = new PlanNodeId("4");
            fragmentInstanceContext.addOperatorContext(4, planNodeId4, UpdateLastCacheOperator.class.getSimpleName());
            PlanNodeId planNodeId5 = new PlanNodeId("5");
            fragmentInstanceContext.addOperatorContext(5, planNodeId5, LastQueryOperator.class.getSimpleName());
            fragmentInstanceContext.getOperatorContexts().forEach(operatorContext -> operatorContext.setMaxRunTime(AggregationOperatorTest.TEST_TIME_SLICE));
            SeriesAggregationScanOperator seriesAggregationScanOperator1 = new SeriesAggregationScanOperator(planNodeId1, (PartialPath)measurementPath1, (Set)allSensors, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), aggregators1, AggregationUtil.initTimeRangeIterator(null, (boolean)false, (boolean)true), null, false, null, (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
            seriesAggregationScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            UpdateLastCacheOperator updateLastCacheOperator1 = new UpdateLastCacheOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(1), (Operator)seriesAggregationScanOperator1, measurementPath1, measurementPath1.getSeriesType(), null, false);
            SeriesAggregationScanOperator seriesAggregationScanOperator2 = new SeriesAggregationScanOperator(planNodeId3, (PartialPath)measurementPath2, (Set)allSensors, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(2), aggregators2, AggregationUtil.initTimeRangeIterator(null, (boolean)false, (boolean)true), null, false, null, (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
            seriesAggregationScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            UpdateLastCacheOperator updateLastCacheOperator2 = new UpdateLastCacheOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(3), (Operator)seriesAggregationScanOperator2, measurementPath2, measurementPath2.getSeriesType(), null, false);
            LastQueryOperator lastQueryOperator = new LastQueryOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(4), (List)ImmutableList.of((Object)updateLastCacheOperator1, (Object)updateLastCacheOperator2), LastQueryUtil.createTsBlockBuilder());
            int count = 0;
            while (!lastQueryOperator.isFinished()) {
                Assert.assertTrue((boolean)lastQueryOperator.isBlocked().isDone());
                Assert.assertTrue((boolean)lastQueryOperator.hasNext());
                TsBlock result = lastQueryOperator.next();
                if (result == null) continue;
                Assert.assertEquals((long)3L, (long)result.getValueColumnCount());
                for (int i = 0; i < result.getPositionCount(); ++i) {
                    Assert.assertEquals((long)499L, (long)result.getTimeByIndex(i));
                    Assert.assertEquals((Object)("root.LastQueryOperatorTest.device0.sensor" + count), (Object)result.getColumn(0).getBinary(i).toString());
                    Assert.assertEquals((Object)"10499", (Object)result.getColumn(1).getBinary(i).toString());
                    Assert.assertEquals((Object)TSDataType.INT32.name(), (Object)result.getColumn(2).getBinary(i).toString());
                    ++count;
                }
            }
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void testLastQueryOperator2() {
        try {
            List aggregators1 = LastQueryUtil.createAggregators((TSDataType)TSDataType.INT32);
            MeasurementPath measurementPath1 = new MeasurementPath("root.LastQueryOperatorTest.device0.sensor0", TSDataType.INT32);
            List aggregators2 = LastQueryUtil.createAggregators((TSDataType)TSDataType.INT32);
            MeasurementPath measurementPath2 = new MeasurementPath("root.LastQueryOperatorTest.device0.sensor1", TSDataType.INT32);
            HashSet allSensors = Sets.newHashSet((Object[])new String[]{"sensor0", "sensor1"});
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)this.instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId1, SeriesAggregationScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            fragmentInstanceContext.addOperatorContext(2, planNodeId2, UpdateLastCacheOperator.class.getSimpleName());
            PlanNodeId planNodeId3 = new PlanNodeId("3");
            fragmentInstanceContext.addOperatorContext(3, planNodeId3, SeriesAggregationScanOperator.class.getSimpleName());
            PlanNodeId planNodeId4 = new PlanNodeId("4");
            fragmentInstanceContext.addOperatorContext(4, planNodeId4, UpdateLastCacheOperator.class.getSimpleName());
            PlanNodeId planNodeId5 = new PlanNodeId("5");
            fragmentInstanceContext.addOperatorContext(5, planNodeId4, LastQueryOperator.class.getSimpleName());
            fragmentInstanceContext.getOperatorContexts().forEach(operatorContext -> operatorContext.setMaxRunTime(AggregationOperatorTest.TEST_TIME_SLICE));
            SeriesAggregationScanOperator seriesAggregationScanOperator1 = new SeriesAggregationScanOperator(planNodeId1, (PartialPath)measurementPath1, (Set)allSensors, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), aggregators1, AggregationUtil.initTimeRangeIterator(null, (boolean)false, (boolean)true), null, false, null, (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
            seriesAggregationScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            UpdateLastCacheOperator updateLastCacheOperator1 = new UpdateLastCacheOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(1), (Operator)seriesAggregationScanOperator1, measurementPath1, measurementPath1.getSeriesType(), null, false);
            SeriesAggregationScanOperator seriesAggregationScanOperator2 = new SeriesAggregationScanOperator(planNodeId3, (PartialPath)measurementPath2, (Set)allSensors, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(2), aggregators2, AggregationUtil.initTimeRangeIterator(null, (boolean)false, (boolean)true), null, false, null, (long)TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES);
            seriesAggregationScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            UpdateLastCacheOperator updateLastCacheOperator2 = new UpdateLastCacheOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(3), (Operator)seriesAggregationScanOperator2, measurementPath2, measurementPath2.getSeriesType(), null, false);
            TsBlockBuilder builder = LastQueryUtil.createTsBlockBuilder((int)6);
            LastQueryUtil.appendLastValue((TsBlockBuilder)builder, (long)499L, (String)"root.LastQueryOperatorTest.device0.sensor2", (String)"10499", (String)"INT32");
            LastQueryUtil.appendLastValue((TsBlockBuilder)builder, (long)499L, (String)"root.LastQueryOperatorTest.device0.sensor3", (String)"10499", (String)"INT32");
            LastQueryUtil.appendLastValue((TsBlockBuilder)builder, (long)499L, (String)"root.LastQueryOperatorTest.device0.sensor4", (String)"10499", (String)"INT32");
            LastQueryOperator lastQueryOperator = new LastQueryOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(4), (List)ImmutableList.of((Object)updateLastCacheOperator1, (Object)updateLastCacheOperator2), builder);
            int count = 0;
            int[] suffix = new int[]{2, 3, 4, 0, 1};
            while (!lastQueryOperator.isFinished()) {
                Assert.assertTrue((boolean)lastQueryOperator.isBlocked().isDone());
                Assert.assertTrue((boolean)lastQueryOperator.hasNext());
                TsBlock result = lastQueryOperator.next();
                if (result == null) continue;
                Assert.assertEquals((long)3L, (long)result.getValueColumnCount());
                for (int i = 0; i < result.getPositionCount(); ++i) {
                    Assert.assertEquals((long)499L, (long)result.getTimeByIndex(i));
                    Assert.assertEquals((Object)("root.LastQueryOperatorTest.device0.sensor" + suffix[count]), (Object)result.getColumn(0).getBinary(i).toString());
                    Assert.assertEquals((Object)"10499", (Object)result.getColumn(1).getBinary(i).toString());
                    Assert.assertEquals((Object)TSDataType.INT32.name(), (Object)result.getColumn(2).getBinary(i).toString());
                    ++count;
                }
            }
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

