/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.mpp.execution.operator.AggregationOperatorTest;
import org.apache.iotdb.db.mpp.execution.operator.Operator;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryMergeOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LastQueryMergeOperatorTest {
    private ExecutorService instanceNotificationExecutor;

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        this.instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
    }

    @After
    public void tearDown() throws IOException {
        this.instanceNotificationExecutor.shutdown();
    }

    @Test
    public void testLastQueryMergeOperatorDesc() {
        QueryId queryId = new QueryId("stub_query");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)this.instanceNotificationExecutor);
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
        PlanNodeId planNodeId1 = new PlanNodeId("1");
        fragmentInstanceContext.addOperatorContext(1, planNodeId1, LastQueryMergeOperator.class.getSimpleName());
        fragmentInstanceContext.getOperatorContexts().forEach(operatorContext -> operatorContext.setMaxRunTime(AggregationOperatorTest.TEST_TIME_SLICE));
        Operator operator1 = new Operator(){
            private final long[][] timeArray = new long[][]{{3L, 4L, 5L, 3L}, {5L, 4L, 4L, 6L}};
            private final String[][] timeSeriesArray = new String[][]{{"root.sg.d1.s1", "root.sg.d1.s2", "root.sg.d1.s3", "root.sg.d1.s4"}, {"root.sg.d2.s1", "root.sg.d2.s2", "root.sg.d2.s3", "root.sg.d2.s4"}};
            private final String[][] valueArray = new String[][]{{"3", "4", "5", "3"}, {"5", "4", "4", "6"}};
            private final String[][] dataTypeArray = new String[][]{{"INT32", "INT32", "INT32", "INT32"}, {"INT32", "INT32", "INT32", "INT32"}};
            private int index = 1;

            public OperatorContext getOperatorContext() {
                return null;
            }

            public TsBlock next() {
                TsBlockBuilder builder = LastQueryUtil.createTsBlockBuilder((int)4);
                for (int i = this.timeArray[this.index].length - 1; i >= 0; --i) {
                    LastQueryUtil.appendLastValue((TsBlockBuilder)builder, (long)this.timeArray[this.index][i], (String)this.timeSeriesArray[this.index][i], (String)this.valueArray[this.index][i], (String)this.dataTypeArray[this.index][i]);
                }
                --this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index >= 0;
            }

            public boolean isFinished() {
                return !this.hasNext();
            }

            public long calculateMaxPeekMemory() {
                return 0L;
            }

            public long calculateMaxReturnSize() {
                return 0L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        Operator operator2 = new Operator(){
            private final long[][] timeArray = new long[][]{{2L, 3L, 3L, 2L}, {5L, 4L, 4L, 6L}};
            private final String[][] timeSeriesArray = new String[][]{{"root.sg.d2.s1", "root.sg.d2.s2", "root.sg.d2.s3", "root.sg.d2.s4"}, {"root.sg.d3.s1", "root.sg.d3.s2", "root.sg.d3.s3", "root.sg.d3.s4"}};
            private final String[][] valueArray = new String[][]{{"2", "3", "3", "2"}, {"5", "4", "4", "6"}};
            private final String[][] dataTypeArray = new String[][]{{"INT32", "INT32", "INT32", "INT32"}, {"INT32", "INT32", "INT32", "INT32"}};
            private int index = 1;

            public OperatorContext getOperatorContext() {
                return null;
            }

            public TsBlock next() {
                TsBlockBuilder builder = LastQueryUtil.createTsBlockBuilder((int)4);
                for (int i = this.timeArray[this.index].length - 1; i >= 0; --i) {
                    LastQueryUtil.appendLastValue((TsBlockBuilder)builder, (long)this.timeArray[this.index][i], (String)this.timeSeriesArray[this.index][i], (String)this.valueArray[this.index][i], (String)this.dataTypeArray[this.index][i]);
                }
                --this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index >= 0;
            }

            public boolean isFinished() {
                return !this.hasNext();
            }

            public long calculateMaxPeekMemory() {
                return 0L;
            }

            public long calculateMaxReturnSize() {
                return 0L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        LastQueryMergeOperator lastQueryMergeOperator = new LastQueryMergeOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), (List)ImmutableList.of((Object)operator1, (Object)operator2), Comparator.reverseOrder());
        long[] timeArray = new long[]{3L, 4L, 5L, 3L, 5L, 4L, 4L, 6L, 5L, 4L, 4L, 6L};
        String[] timeSeriesArray = new String[]{"root.sg.d1.s1", "root.sg.d1.s2", "root.sg.d1.s3", "root.sg.d1.s4", "root.sg.d2.s1", "root.sg.d2.s2", "root.sg.d2.s3", "root.sg.d2.s4", "root.sg.d3.s1", "root.sg.d3.s2", "root.sg.d3.s3", "root.sg.d3.s4"};
        String[] valueArray = new String[]{"3", "4", "5", "3", "5", "4", "4", "6", "5", "4", "4", "6"};
        String[] dataTypeArray = new String[]{"INT32", "INT32", "INT32", "INT32", "INT32", "INT32", "INT32", "INT32", "INT32", "INT32", "INT32", "INT32"};
        int count = timeArray.length - 1;
        while (!lastQueryMergeOperator.isFinished()) {
            Assert.assertTrue((boolean)lastQueryMergeOperator.isBlocked().isDone());
            TsBlock result = lastQueryMergeOperator.next();
            if (result == null) continue;
            Assert.assertEquals((long)3L, (long)result.getValueColumnCount());
            for (int i = 0; i < result.getPositionCount(); ++i) {
                Assert.assertEquals((long)timeArray[count], (long)result.getTimeByIndex(i));
                Assert.assertEquals((Object)timeSeriesArray[count], (Object)result.getColumn(0).getBinary(i).toString());
                Assert.assertEquals((Object)valueArray[count], (Object)result.getColumn(1).getBinary(i).toString());
                Assert.assertEquals((Object)dataTypeArray[count], (Object)result.getColumn(2).getBinary(i).toString());
                --count;
            }
        }
        Assert.assertEquals((long)-1L, (long)count);
    }

    @Test
    public void testLastQueryMergeOperatorAsc() {
        QueryId queryId = new QueryId("stub_query");
        FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
        FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)this.instanceNotificationExecutor);
        FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
        PlanNodeId planNodeId1 = new PlanNodeId("1");
        fragmentInstanceContext.addOperatorContext(1, planNodeId1, LastQueryMergeOperator.class.getSimpleName());
        fragmentInstanceContext.getOperatorContexts().forEach(operatorContext -> operatorContext.setMaxRunTime(AggregationOperatorTest.TEST_TIME_SLICE));
        Operator operator1 = new Operator(){
            private final long[][] timeArray = new long[][]{{3L, 4L, 5L, 3L}, {5L, 4L, 4L, 6L}};
            private final String[][] timeSeriesArray = new String[][]{{"root.sg.d1.s1", "root.sg.d1.s2", "root.sg.d1.s3", "root.sg.d1.s4"}, {"root.sg.d2.s1", "root.sg.d2.s2", "root.sg.d2.s3", "root.sg.d2.s4"}};
            private final String[][] valueArray = new String[][]{{"3", "4", "5", "3"}, {"5", "4", "4", "6"}};
            private final String[][] dataTypeArray = new String[][]{{"INT32", "INT32", "INT32", "INT32"}, {"INT32", "INT32", "INT32", "INT32"}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return null;
            }

            public TsBlock next() {
                TsBlockBuilder builder = LastQueryUtil.createTsBlockBuilder((int)4);
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    LastQueryUtil.appendLastValue((TsBlockBuilder)builder, (long)this.timeArray[this.index][i], (String)this.timeSeriesArray[this.index][i], (String)this.valueArray[this.index][i], (String)this.dataTypeArray[this.index][i]);
                }
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 2;
            }

            public boolean isFinished() {
                return !this.hasNext();
            }

            public long calculateMaxPeekMemory() {
                return 0L;
            }

            public long calculateMaxReturnSize() {
                return 0L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        Operator operator2 = new Operator(){
            private final long[][] timeArray = new long[][]{{2L, 3L, 3L, 2L}, {5L, 4L, 4L, 6L}};
            private final String[][] timeSeriesArray = new String[][]{{"root.sg.d2.s1", "root.sg.d2.s2", "root.sg.d2.s3", "root.sg.d2.s4"}, {"root.sg.d3.s1", "root.sg.d3.s2", "root.sg.d3.s3", "root.sg.d3.s4"}};
            private final String[][] valueArray = new String[][]{{"2", "3", "3", "2"}, {"5", "4", "4", "6"}};
            private final String[][] dataTypeArray = new String[][]{{"INT32", "INT32", "INT32", "INT32"}, {"INT32", "INT32", "INT32", "INT32"}};
            private int index = 0;

            public OperatorContext getOperatorContext() {
                return null;
            }

            public TsBlock next() {
                TsBlockBuilder builder = LastQueryUtil.createTsBlockBuilder((int)4);
                int size = this.timeArray[this.index].length;
                for (int i = 0; i < size; ++i) {
                    LastQueryUtil.appendLastValue((TsBlockBuilder)builder, (long)this.timeArray[this.index][i], (String)this.timeSeriesArray[this.index][i], (String)this.valueArray[this.index][i], (String)this.dataTypeArray[this.index][i]);
                }
                ++this.index;
                return builder.build();
            }

            public boolean hasNext() {
                return this.index < 2;
            }

            public boolean isFinished() {
                return !this.hasNext();
            }

            public long calculateMaxPeekMemory() {
                return 0L;
            }

            public long calculateMaxReturnSize() {
                return 0L;
            }

            public long calculateRetainedSizeAfterCallingNext() {
                return 0L;
            }
        };
        LastQueryMergeOperator lastQueryMergeOperator = new LastQueryMergeOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), (List)ImmutableList.of((Object)operator1, (Object)operator2), Comparator.naturalOrder());
        long[] timeArray = new long[]{3L, 4L, 5L, 3L, 5L, 4L, 4L, 6L, 5L, 4L, 4L, 6L};
        String[] timeSeriesArray = new String[]{"root.sg.d1.s1", "root.sg.d1.s2", "root.sg.d1.s3", "root.sg.d1.s4", "root.sg.d2.s1", "root.sg.d2.s2", "root.sg.d2.s3", "root.sg.d2.s4", "root.sg.d3.s1", "root.sg.d3.s2", "root.sg.d3.s3", "root.sg.d3.s4"};
        String[] valueArray = new String[]{"3", "4", "5", "3", "5", "4", "4", "6", "5", "4", "4", "6"};
        String[] dataTypeArray = new String[]{"INT32", "INT32", "INT32", "INT32", "INT32", "INT32", "INT32", "INT32", "INT32", "INT32", "INT32", "INT32"};
        int count = 0;
        while (!lastQueryMergeOperator.isFinished()) {
            Assert.assertTrue((boolean)lastQueryMergeOperator.isBlocked().isDone());
            TsBlock result = lastQueryMergeOperator.next();
            if (result == null) continue;
            Assert.assertEquals((long)3L, (long)result.getValueColumnCount());
            for (int i = 0; i < result.getPositionCount(); ++i) {
                Assert.assertEquals((long)timeArray[count], (long)result.getTimeByIndex(i));
                Assert.assertEquals((Object)timeSeriesArray[count], (Object)result.getColumn(0).getBinary(i).toString());
                Assert.assertEquals((Object)valueArray[count], (Object)result.getColumn(1).getBinary(i).toString());
                Assert.assertEquals((Object)dataTypeArray[count], (Object)result.getColumn(2).getBinary(i).toString());
                ++count;
            }
        }
        Assert.assertEquals((long)timeArray.length, (long)count);
    }
}

