/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.mpp.execution.operator.DeviceViewOperatorTest;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.process.DeviceMergeOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.DeviceViewOperator;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.AscTimeComparator;
import org.apache.iotdb.db.mpp.execution.operator.process.join.merge.TimeComparator;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesScanOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.query.reader.series.SeriesReaderTestUtil;
import org.apache.iotdb.db.utils.datastructure.TimeSelector;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeviceMergeOperatorTest {
    private static final String DEVICE_MERGE_OPERATOR_TEST_SG = "root.DeviceMergeOperatorTest";
    private final List<String> deviceIds = new ArrayList<String>();
    private final List<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
    private final List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private final List<TsFileResource> unSeqResources = new ArrayList<TsFileResource>();

    @Before
    public void setUp() throws MetadataException, IOException, WriteProcessException {
        SeriesReaderTestUtil.setUp(this.measurementSchemas, this.deviceIds, this.seqResources, this.unSeqResources, DEVICE_MERGE_OPERATOR_TEST_SG);
    }

    @After
    public void tearDown() throws IOException {
        SeriesReaderTestUtil.tearDown(this.seqResources, this.unSeqResources);
    }

    @Test
    public void deviceMergeOperatorTest() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            fragmentInstanceContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId3 = new PlanNodeId("3");
            fragmentInstanceContext.addOperatorContext(3, planNodeId3, DeviceViewOperatorTest.class.getSimpleName());
            PlanNodeId planNodeId4 = new PlanNodeId("4");
            fragmentInstanceContext.addOperatorContext(4, planNodeId4, DeviceViewOperatorTest.class.getSimpleName());
            PlanNodeId planNodeId5 = new PlanNodeId("5");
            fragmentInstanceContext.addOperatorContext(5, planNodeId5, DeviceMergeOperator.class.getSimpleName());
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            dataTypes.add(TSDataType.TEXT);
            dataTypes.add(TSDataType.INT32);
            dataTypes.add(TSDataType.INT32);
            MeasurementPath measurementPath1 = new MeasurementPath("root.DeviceMergeOperatorTest.device0.sensor0", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator(planNodeId1, (PartialPath)measurementPath1, Collections.singleton("sensor0"), TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), null, null, true);
            seriesScanOperator1.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            DeviceViewOperator deviceViewOperator1 = new DeviceViewOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(2), Collections.singletonList("root.DeviceMergeOperatorTest.device0"), Collections.singletonList(seriesScanOperator1), Collections.singletonList(Collections.singletonList(1)), dataTypes);
            MeasurementPath measurementPath2 = new MeasurementPath("root.DeviceMergeOperatorTest.device1.sensor1", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator(planNodeId2, (PartialPath)measurementPath2, Collections.singleton("sensor1"), TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(1), null, null, true);
            seriesScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            DeviceViewOperator deviceViewOperator2 = new DeviceViewOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(3), Collections.singletonList("root.DeviceMergeOperatorTest.device1"), Collections.singletonList(seriesScanOperator2), Collections.singletonList(Collections.singletonList(2)), dataTypes);
            ArrayList<String> devices = new ArrayList<String>();
            devices.add("root.DeviceMergeOperatorTest.device0");
            devices.add("root.DeviceMergeOperatorTest.device1");
            ArrayList<DeviceViewOperator> deviceOperators = new ArrayList<DeviceViewOperator>();
            deviceOperators.add(deviceViewOperator1);
            deviceOperators.add(deviceViewOperator2);
            DeviceMergeOperator deviceMergeOperator = new DeviceMergeOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(4), devices, deviceOperators, dataTypes, new TimeSelector(500, true), (TimeComparator)new AscTimeComparator());
            int count = 0;
            while (deviceMergeOperator.hasNext()) {
                TsBlock tsBlock = deviceMergeOperator.next();
                Assert.assertEquals((long)3L, (long)tsBlock.getValueColumnCount());
                Assert.assertEquals((long)20L, (long)tsBlock.getPositionCount());
                for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                    long expectedTime = (long)i + 20L * (long)(count % 25);
                    Assert.assertEquals((long)expectedTime, (long)tsBlock.getTimeByIndex(i));
                    Assert.assertEquals((Object)(count < 25 ? "root.DeviceMergeOperatorTest.device0" : "root.DeviceMergeOperatorTest.device1"), (Object)tsBlock.getColumn(0).getBinary(i).getStringValue());
                    if (expectedTime < 200L) {
                        if (!tsBlock.getColumn(1).isNull(i)) {
                            Assert.assertEquals((long)(20000L + expectedTime), (long)tsBlock.getColumn(1).getInt(i));
                            Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                            continue;
                        }
                        Assert.assertEquals((long)(20000L + expectedTime), (long)tsBlock.getColumn(2).getInt(i));
                        continue;
                    }
                    if (expectedTime < 260L || expectedTime >= 300L && expectedTime < 380L || expectedTime >= 400L) {
                        if (!tsBlock.getColumn(1).isNull(i)) {
                            Assert.assertEquals((long)(10000L + expectedTime), (long)tsBlock.getColumn(1).getInt(i));
                            Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                            continue;
                        }
                        Assert.assertEquals((long)(10000L + expectedTime), (long)tsBlock.getColumn(2).getInt(i));
                        continue;
                    }
                    if (!tsBlock.getColumn(1).isNull(i)) {
                        Assert.assertEquals((long)expectedTime, (long)tsBlock.getColumn(1).getInt(i));
                        Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                        continue;
                    }
                    Assert.assertEquals((long)expectedTime, (long)tsBlock.getColumn(2).getInt(i));
                }
                ++count;
            }
            Assert.assertEquals((long)50L, (long)count);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void deviceMergeOperatorTest2() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            fragmentInstanceContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId3 = new PlanNodeId("3");
            fragmentInstanceContext.addOperatorContext(3, planNodeId3, DeviceViewOperatorTest.class.getSimpleName());
            PlanNodeId planNodeId4 = new PlanNodeId("4");
            fragmentInstanceContext.addOperatorContext(4, planNodeId4, DeviceViewOperatorTest.class.getSimpleName());
            PlanNodeId planNodeId5 = new PlanNodeId("5");
            fragmentInstanceContext.addOperatorContext(5, planNodeId5, DeviceMergeOperator.class.getSimpleName());
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            dataTypes.add(TSDataType.TEXT);
            dataTypes.add(TSDataType.INT32);
            MeasurementPath measurementPath1 = new MeasurementPath("root.DeviceMergeOperatorTest.device0.sensor0", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator(planNodeId1, (PartialPath)measurementPath1, Collections.singleton("sensor0"), TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), null, null, true);
            ArrayList<TsFileResource> seqResources1 = new ArrayList<TsFileResource>();
            ArrayList<TsFileResource> unSeqResources1 = new ArrayList<TsFileResource>();
            seqResources1.add(this.seqResources.get(0));
            seqResources1.add(this.seqResources.get(1));
            seqResources1.add(this.seqResources.get(3));
            unSeqResources1.add(this.unSeqResources.get(0));
            unSeqResources1.add(this.unSeqResources.get(1));
            unSeqResources1.add(this.unSeqResources.get(3));
            unSeqResources1.add(this.unSeqResources.get(5));
            seriesScanOperator1.initQueryDataSource(new QueryDataSource(seqResources1, unSeqResources1));
            DeviceViewOperator deviceViewOperator1 = new DeviceViewOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(2), Collections.singletonList("root.DeviceMergeOperatorTest.device0"), Collections.singletonList(seriesScanOperator1), Collections.singletonList(Collections.singletonList(1)), dataTypes);
            SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator(planNodeId2, (PartialPath)measurementPath1, Collections.singleton("sensor0"), TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(1), null, null, true);
            ArrayList<TsFileResource> seqResources2 = new ArrayList<TsFileResource>();
            ArrayList<TsFileResource> unSeqResources2 = new ArrayList<TsFileResource>();
            seqResources2.add(this.seqResources.get(2));
            seqResources2.add(this.seqResources.get(4));
            unSeqResources2.add(this.unSeqResources.get(2));
            unSeqResources2.add(this.unSeqResources.get(4));
            seriesScanOperator2.initQueryDataSource(new QueryDataSource(seqResources2, unSeqResources2));
            DeviceViewOperator deviceViewOperator2 = new DeviceViewOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(3), Collections.singletonList("root.DeviceMergeOperatorTest.device0"), Collections.singletonList(seriesScanOperator2), Collections.singletonList(Collections.singletonList(1)), dataTypes);
            ArrayList<String> devices = new ArrayList<String>();
            devices.add("root.DeviceMergeOperatorTest.device0");
            ArrayList<DeviceViewOperator> deviceOperators = new ArrayList<DeviceViewOperator>();
            deviceOperators.add(deviceViewOperator1);
            deviceOperators.add(deviceViewOperator2);
            DeviceMergeOperator deviceMergeOperator = new DeviceMergeOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(4), devices, deviceOperators, dataTypes, new TimeSelector(500, true), (TimeComparator)new AscTimeComparator());
            int count = 0;
            while (deviceMergeOperator.hasNext()) {
                TsBlock tsBlock = deviceMergeOperator.next();
                Assert.assertEquals((long)2L, (long)tsBlock.getValueColumnCount());
                Assert.assertEquals((long)20L, (long)tsBlock.getPositionCount());
                for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                    long expectedTime = (long)i + 20L * (long)(count % 25);
                    Assert.assertEquals((long)expectedTime, (long)tsBlock.getTimeByIndex(i));
                    Assert.assertEquals((Object)"root.DeviceMergeOperatorTest.device0", (Object)tsBlock.getColumn(0).getBinary(i).getStringValue());
                    if (expectedTime < 200L) {
                        Assert.assertEquals((long)(20000L + expectedTime), (long)tsBlock.getColumn(1).getInt(i));
                        continue;
                    }
                    if (expectedTime < 260L || expectedTime >= 300L && expectedTime < 380L || expectedTime >= 400L) {
                        Assert.assertEquals((long)(10000L + expectedTime), (long)tsBlock.getColumn(1).getInt(i));
                        continue;
                    }
                    Assert.assertEquals((long)expectedTime, (long)tsBlock.getColumn(1).getInt(i));
                }
                ++count;
            }
            Assert.assertEquals((long)25L, (long)count);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    @Test
    public void deviceMergeOperatorTest3() {
        ExecutorService instanceNotificationExecutor = IoTDBThreadPoolFactory.newFixedThreadPool((int)1, (String)"test-instance-notification");
        try {
            QueryId queryId = new QueryId("stub_query");
            FragmentInstanceId instanceId = new FragmentInstanceId(new PlanFragmentId(queryId, 0), "stub-instance");
            FragmentInstanceStateMachine stateMachine = new FragmentInstanceStateMachine(instanceId, (Executor)instanceNotificationExecutor);
            FragmentInstanceContext fragmentInstanceContext = FragmentInstanceContext.createFragmentInstanceContext((FragmentInstanceId)instanceId, (FragmentInstanceStateMachine)stateMachine);
            PlanNodeId planNodeId1 = new PlanNodeId("1");
            fragmentInstanceContext.addOperatorContext(1, planNodeId1, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId2 = new PlanNodeId("2");
            fragmentInstanceContext.addOperatorContext(2, planNodeId2, SeriesScanOperator.class.getSimpleName());
            PlanNodeId planNodeId3 = new PlanNodeId("3");
            fragmentInstanceContext.addOperatorContext(3, planNodeId3, SeriesScanOperator.class.getSimpleName());
            fragmentInstanceContext.addOperatorContext(4, new PlanNodeId("4"), DeviceViewOperatorTest.class.getSimpleName());
            fragmentInstanceContext.addOperatorContext(5, new PlanNodeId("5"), DeviceViewOperatorTest.class.getSimpleName());
            fragmentInstanceContext.addOperatorContext(6, new PlanNodeId("6"), DeviceMergeOperator.class.getSimpleName());
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            dataTypes.add(TSDataType.TEXT);
            dataTypes.add(TSDataType.INT32);
            dataTypes.add(TSDataType.INT32);
            MeasurementPath measurementPath1 = new MeasurementPath("root.DeviceMergeOperatorTest.device0.sensor0", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator1 = new SeriesScanOperator(planNodeId1, (PartialPath)measurementPath1, Collections.singleton("sensor0"), TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(0), null, null, true);
            ArrayList<TsFileResource> seqResources1 = new ArrayList<TsFileResource>();
            ArrayList<TsFileResource> unSeqResources1 = new ArrayList<TsFileResource>();
            seqResources1.add(this.seqResources.get(0));
            seqResources1.add(this.seqResources.get(1));
            seqResources1.add(this.seqResources.get(3));
            unSeqResources1.add(this.unSeqResources.get(0));
            unSeqResources1.add(this.unSeqResources.get(1));
            unSeqResources1.add(this.unSeqResources.get(3));
            unSeqResources1.add(this.unSeqResources.get(5));
            seriesScanOperator1.initQueryDataSource(new QueryDataSource(seqResources1, unSeqResources1));
            MeasurementPath measurementPath2 = new MeasurementPath("root.DeviceMergeOperatorTest.device1.sensor1", TSDataType.INT32);
            SeriesScanOperator seriesScanOperator2 = new SeriesScanOperator(planNodeId2, (PartialPath)measurementPath2, Collections.singleton("sensor1"), TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(1), null, null, true);
            seriesScanOperator2.initQueryDataSource(new QueryDataSource(this.seqResources, this.unSeqResources));
            ArrayList<String> devices = new ArrayList<String>();
            devices.add("root.DeviceMergeOperatorTest.device0");
            devices.add("root.DeviceMergeOperatorTest.device1");
            ArrayList<SeriesScanOperator> deviceOperators = new ArrayList<SeriesScanOperator>();
            deviceOperators.add(seriesScanOperator1);
            deviceOperators.add(seriesScanOperator2);
            ArrayList<List<Integer>> deviceColumnIndex = new ArrayList<List<Integer>>();
            deviceColumnIndex.add(Collections.singletonList(1));
            deviceColumnIndex.add(Collections.singletonList(2));
            DeviceViewOperator deviceViewOperator1 = new DeviceViewOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(3), devices, deviceOperators, deviceColumnIndex, dataTypes);
            SeriesScanOperator seriesScanOperator3 = new SeriesScanOperator(planNodeId3, (PartialPath)measurementPath1, Collections.singleton("sensor0"), TSDataType.INT32, (OperatorContext)fragmentInstanceContext.getOperatorContexts().get(2), null, null, true);
            ArrayList<TsFileResource> seqResources2 = new ArrayList<TsFileResource>();
            ArrayList<TsFileResource> unSeqResources2 = new ArrayList<TsFileResource>();
            seqResources2.add(this.seqResources.get(2));
            seqResources2.add(this.seqResources.get(4));
            unSeqResources2.add(this.unSeqResources.get(2));
            unSeqResources2.add(this.unSeqResources.get(4));
            seriesScanOperator3.initQueryDataSource(new QueryDataSource(seqResources2, unSeqResources2));
            DeviceViewOperator deviceViewOperator2 = new DeviceViewOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(4), Collections.singletonList("root.DeviceMergeOperatorTest.device0"), Collections.singletonList(seriesScanOperator3), Collections.singletonList(Collections.singletonList(1)), dataTypes);
            ArrayList<DeviceViewOperator> deviceViewOperators = new ArrayList<DeviceViewOperator>();
            deviceViewOperators.add(deviceViewOperator1);
            deviceViewOperators.add(deviceViewOperator2);
            DeviceMergeOperator deviceMergeOperator = new DeviceMergeOperator((OperatorContext)fragmentInstanceContext.getOperatorContexts().get(5), devices, deviceViewOperators, dataTypes, new TimeSelector(500, true), (TimeComparator)new AscTimeComparator());
            int count = 0;
            while (deviceMergeOperator.hasNext()) {
                TsBlock tsBlock = deviceMergeOperator.next();
                Assert.assertEquals((long)3L, (long)tsBlock.getValueColumnCount());
                Assert.assertEquals((long)20L, (long)tsBlock.getPositionCount());
                for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
                    long expectedTime = (long)i + 20L * (long)(count % 25);
                    Assert.assertEquals((long)expectedTime, (long)tsBlock.getTimeByIndex(i));
                    Assert.assertEquals((Object)(count < 25 ? "root.DeviceMergeOperatorTest.device0" : "root.DeviceMergeOperatorTest.device1"), (Object)tsBlock.getColumn(0).getBinary(i).getStringValue());
                    if (expectedTime < 200L) {
                        if (!tsBlock.getColumn(1).isNull(i)) {
                            Assert.assertEquals((long)(20000L + expectedTime), (long)tsBlock.getColumn(1).getInt(i));
                            Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                            continue;
                        }
                        Assert.assertEquals((long)(20000L + expectedTime), (long)tsBlock.getColumn(2).getInt(i));
                        continue;
                    }
                    if (expectedTime < 260L || expectedTime >= 300L && expectedTime < 380L || expectedTime >= 400L) {
                        if (!tsBlock.getColumn(1).isNull(i)) {
                            Assert.assertEquals((long)(10000L + expectedTime), (long)tsBlock.getColumn(1).getInt(i));
                            Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                            continue;
                        }
                        Assert.assertEquals((long)(10000L + expectedTime), (long)tsBlock.getColumn(2).getInt(i));
                        continue;
                    }
                    if (!tsBlock.getColumn(1).isNull(i)) {
                        Assert.assertEquals((long)expectedTime, (long)tsBlock.getColumn(1).getInt(i));
                        Assert.assertTrue((boolean)tsBlock.getColumn(2).isNull(i));
                        continue;
                    }
                    Assert.assertEquals((long)expectedTime, (long)tsBlock.getColumn(2).getInt(i));
                }
                ++count;
            }
            Assert.assertEquals((long)50L, (long)count);
        }
        catch (IllegalPathException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

