/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;

public class AlignedSeriesTestUtil {
    public static void setUp(List<MeasurementSchema> measurementSchemas, List<TsFileResource> seqResources, List<TsFileResource> unseqResources, String sgName) throws MetadataException, IOException, WriteProcessException {
        IoTDB.configManager.init();
        AlignedSeriesTestUtil.prepareSeries(measurementSchemas, sgName);
        AlignedSeriesTestUtil.prepareFiles(seqResources, unseqResources, measurementSchemas, sgName);
    }

    public static void tearDown(List<TsFileResource> seqResources, List<TsFileResource> unseqResources) throws IOException {
        AlignedSeriesTestUtil.removeFiles(seqResources, unseqResources);
        seqResources.clear();
        unseqResources.clear();
        ChunkCache.getInstance().clear();
        TimeSeriesMetadataCache.getInstance().clear();
        IoTDB.configManager.clear();
        EnvironmentUtils.cleanAllDir();
    }

    private static void prepareFiles(List<TsFileResource> seqResources, List<TsFileResource> unseqResources, List<MeasurementSchema> measurementSchemas, String sgName) throws IOException, WriteProcessException {
        TsFileResource tsFileResource;
        int seqFileNum = 5;
        long ptNum = 100L;
        for (int i = 0; i < seqFileNum; ++i) {
            File file = new File(TestConstant.getTestTsFilePath((String)sgName, (long)0L, (long)0L, (long)i));
            tsFileResource = new TsFileResource(file);
            tsFileResource.setStatus(TsFileResourceStatus.CLOSED);
            tsFileResource.setMinPlanIndex((long)i);
            tsFileResource.setMaxPlanIndex((long)i);
            tsFileResource.setVersion((long)i);
            seqResources.add(tsFileResource);
            AlignedSeriesTestUtil.prepareFile(sgName, tsFileResource, (long)i * ptNum, ptNum, 0L, measurementSchemas);
        }
        int unseqFileNum = 5;
        for (int i = 0; i < unseqFileNum; ++i) {
            File file = new File(TestConstant.getTestTsFilePath((String)sgName, (long)0L, (long)0L, (long)(i + seqFileNum)));
            TsFileResource tsFileResource2 = new TsFileResource(file);
            tsFileResource2.setStatus(TsFileResourceStatus.CLOSED);
            tsFileResource2.setMinPlanIndex((long)(i + seqFileNum));
            tsFileResource2.setMaxPlanIndex((long)(i + seqFileNum));
            tsFileResource2.setVersion((long)(i + seqFileNum));
            unseqResources.add(tsFileResource2);
            AlignedSeriesTestUtil.prepareFile(sgName, tsFileResource2, (long)i * ptNum, ptNum * (long)(i + 1) / (long)unseqFileNum, 10000L, measurementSchemas);
        }
        File file = new File(TestConstant.getTestTsFilePath((String)sgName, (long)0L, (long)0L, (long)(seqFileNum + unseqFileNum)));
        tsFileResource = new TsFileResource(file);
        tsFileResource.setStatus(TsFileResourceStatus.CLOSED);
        tsFileResource.setMinPlanIndex((long)(seqFileNum + unseqFileNum));
        tsFileResource.setMaxPlanIndex((long)(seqFileNum + unseqFileNum));
        tsFileResource.setVersion((long)(seqFileNum + unseqFileNum));
        unseqResources.add(tsFileResource);
        AlignedSeriesTestUtil.prepareFile(sgName, tsFileResource, 0L, ptNum * 2L, 20000L, measurementSchemas);
    }

    private static void prepareFile(String sgName, TsFileResource tsFileResource, long timeOffset, long ptNum, long valueOffset, List<MeasurementSchema> measurementSchemas) throws IOException, WriteProcessException {
        File file = tsFileResource.getTsFile();
        if (!file.getParentFile().exists()) {
            Assert.assertTrue((boolean)file.getParentFile().mkdirs());
        }
        TsFileWriter fileWriter = new TsFileWriter(file);
        String device0 = sgName + '.' + "device0";
        String device1 = sgName + '.' + "device1";
        String device2 = sgName + '.' + "device2";
        fileWriter.registerAlignedTimeseries(new Path(device0), measurementSchemas);
        fileWriter.registerAlignedTimeseries(new Path(device1), measurementSchemas);
        fileWriter.registerTimeseries(new Path(device2), measurementSchemas);
        for (long i = timeOffset; i < timeOffset + ptNum; ++i) {
            TSRecord record = new TSRecord(i, device0);
            int index = 0;
            for (MeasurementSchema measurementSchema : measurementSchemas) {
                record.addTuple(DataPoint.getDataPoint((TSDataType)measurementSchema.getType(), (String)measurementSchema.getMeasurementId(), (String)(index == 0 ? String.valueOf((i + valueOffset) % 2L == 0L) : String.valueOf(i + valueOffset))));
                ++index;
            }
            fileWriter.writeAligned(record);
            tsFileResource.updateStartTime(device0, i);
            tsFileResource.updateEndTime(device0, i);
            record.deviceId = device1;
            fileWriter.writeAligned(record);
            tsFileResource.updateStartTime(device1, i);
            tsFileResource.updateEndTime(device1, i);
            record.deviceId = device2;
            fileWriter.write(record);
            tsFileResource.updateStartTime(device2, i);
            tsFileResource.updateEndTime(device2, i);
            long flushInterval = 20L;
            if ((i + 1L) % flushInterval != 0L) continue;
            fileWriter.flushAllChunkGroups();
        }
        fileWriter.close();
    }

    private static void prepareSeries(List<MeasurementSchema> measurementSchemas, String sgName) throws MetadataException {
        measurementSchemas.add(new MeasurementSchema("sensor0", TSDataType.BOOLEAN, TSEncoding.PLAIN, CompressionType.SNAPPY));
        measurementSchemas.add(new MeasurementSchema("sensor1", TSDataType.INT32, TSEncoding.RLE, CompressionType.SNAPPY));
        measurementSchemas.add(new MeasurementSchema("sensor2", TSDataType.INT64, TSEncoding.TS_2DIFF, CompressionType.SNAPPY));
        measurementSchemas.add(new MeasurementSchema("sensor3", TSDataType.FLOAT, TSEncoding.GORILLA, CompressionType.SNAPPY));
        measurementSchemas.add(new MeasurementSchema("sensor4", TSDataType.DOUBLE, TSEncoding.GORILLA, CompressionType.SNAPPY));
        measurementSchemas.add(new MeasurementSchema("sensor5", TSDataType.TEXT, TSEncoding.PLAIN, CompressionType.SNAPPY));
        IoTDB.schemaProcessor.setStorageGroup(new PartialPath(sgName));
        IoTDB.schemaProcessor.createAlignedTimeSeries(new PartialPath(sgName + '.' + "device0"), measurementSchemas.stream().map(MeasurementSchema::getMeasurementId).collect(Collectors.toList()), measurementSchemas.stream().map(MeasurementSchema::getType).collect(Collectors.toList()), measurementSchemas.stream().map(MeasurementSchema::getEncodingType).collect(Collectors.toList()), measurementSchemas.stream().map(MeasurementSchema::getCompressor).collect(Collectors.toList()));
        IoTDB.schemaProcessor.createAlignedTimeSeries(new PartialPath(sgName + '.' + "device1"), measurementSchemas.stream().map(MeasurementSchema::getMeasurementId).collect(Collectors.toList()), measurementSchemas.stream().map(MeasurementSchema::getType).collect(Collectors.toList()), measurementSchemas.stream().map(MeasurementSchema::getEncodingType).collect(Collectors.toList()), measurementSchemas.stream().map(MeasurementSchema::getCompressor).collect(Collectors.toList()));
        for (MeasurementSchema measurementSchema : measurementSchemas) {
            IoTDB.schemaProcessor.createTimeseries(new PartialPath(sgName + '.' + "device2" + '.' + measurementSchema.getMeasurementId()), measurementSchema.getType(), measurementSchema.getEncodingType(), measurementSchema.getCompressor(), Collections.emptyMap());
        }
    }

    private static void removeFiles(List<TsFileResource> seqResources, List<TsFileResource> unseqResources) throws IOException {
        for (TsFileResource tsFileResource : seqResources) {
            tsFileResource.remove();
        }
        for (TsFileResource tsFileResource : unseqResources) {
            tsFileResource.remove();
        }
        FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
    }
}

