/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.memory;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.iotdb.db.mpp.execution.memory.MemoryPool;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemoryPoolTest {
    MemoryPool pool;

    @Before
    public void before() {
        this.pool = new MemoryPool("test", 1024L, 512L);
    }

    @Test
    public void testTryReserve() {
        String queryId = "q0";
        Assert.assertTrue((boolean)this.pool.tryReserve(queryId, 256L));
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testTryReserveZero() {
        String queryId = "q0";
        try {
            this.pool.tryReserve(queryId, 0L);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTryReserveNegative() {
        String queryId = "q0";
        try {
            this.pool.tryReserve(queryId, -1L);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTryReserveAll() {
        String queryId = "q0";
        Assert.assertTrue((boolean)this.pool.tryReserve(queryId, 512L));
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testOverTryReserve() {
        String queryId = "q0";
        Assert.assertTrue((boolean)this.pool.tryReserve(queryId, 256L));
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
        Assert.assertFalse((boolean)this.pool.tryReserve(queryId, 512L));
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testReserve() {
        String queryId = "q0";
        ListenableFuture future = (ListenableFuture)this.pool.reserve((String)queryId, (long)256L).left;
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void tesReserveZero() {
        String queryId = "q0";
        try {
            this.pool.reserve(queryId, 0L);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReserveNegative() {
        String queryId = "q0";
        try {
            this.pool.reserve(queryId, -1L);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testReserveAll() {
        String queryId = "q0";
        ListenableFuture future = (ListenableFuture)this.pool.reserve((String)queryId, (long)512L).left;
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testOverReserve() {
        String queryId = "q0";
        ListenableFuture future = (ListenableFuture)this.pool.reserve((String)queryId, (long)256L).left;
        Assert.assertTrue((boolean)future.isDone());
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
        future = (ListenableFuture)this.pool.reserve((String)queryId, (long)512L).left;
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testReserveAndFree() {
        String queryId = "q0";
        Assert.assertTrue((boolean)((ListenableFuture)this.pool.reserve((String)queryId, (long)512L).left).isDone());
        ListenableFuture future = (ListenableFuture)this.pool.reserve((String)queryId, (long)512L).left;
        Assert.assertFalse((boolean)future.isDone());
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        this.pool.free(queryId, 512L);
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        Assert.assertTrue((boolean)future.isDone());
    }

    @Test
    public void testMultiReserveAndFree() {
        String queryId = "q0";
        Assert.assertTrue((boolean)((ListenableFuture)this.pool.reserve((String)queryId, (long)256L).left).isDone());
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
        ListenableFuture future1 = (ListenableFuture)this.pool.reserve((String)queryId, (long)512L).left;
        ListenableFuture future2 = (ListenableFuture)this.pool.reserve((String)queryId, (long)512L).left;
        ListenableFuture future3 = (ListenableFuture)this.pool.reserve((String)queryId, (long)512L).left;
        Assert.assertFalse((boolean)future1.isDone());
        Assert.assertFalse((boolean)future2.isDone());
        Assert.assertFalse((boolean)future3.isDone());
        this.pool.free(queryId, 256L);
        Assert.assertTrue((boolean)future1.isDone());
        Assert.assertFalse((boolean)future2.isDone());
        Assert.assertFalse((boolean)future3.isDone());
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        this.pool.free(queryId, 512L);
        Assert.assertTrue((boolean)future2.isDone());
        Assert.assertFalse((boolean)future3.isDone());
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        this.pool.free(queryId, 512L);
        Assert.assertTrue((boolean)future3.isDone());
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        this.pool.free(queryId, 512L);
        Assert.assertEquals((long)0L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)0L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testFree() {
        String queryId = "q0";
        Assert.assertTrue((boolean)this.pool.tryReserve(queryId, 512L));
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        this.pool.free(queryId, 256L);
        Assert.assertEquals((long)256L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)256L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testFreeAll() {
        String queryId = "q0";
        Assert.assertTrue((boolean)this.pool.tryReserve(queryId, 512L));
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        this.pool.free(queryId, 512L);
        Assert.assertEquals((long)0L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)0L, (long)this.pool.getReservedBytes());
    }

    @Test
    public void testFreeZero() {
        String queryId = "q0";
        Assert.assertTrue((boolean)this.pool.tryReserve(queryId, 512L));
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        try {
            this.pool.free(queryId, 0L);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testFreeNegative() {
        String queryId = "q0";
        Assert.assertTrue((boolean)this.pool.tryReserve(queryId, 512L));
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        try {
            this.pool.free(queryId, -1L);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testOverFree() {
        String queryId = "q0";
        Assert.assertTrue((boolean)this.pool.tryReserve(queryId, 512L));
        Assert.assertEquals((long)512L, (long)this.pool.getQueryMemoryReservedBytes(queryId));
        Assert.assertEquals((long)512L, (long)this.pool.getReservedBytes());
        try {
            this.pool.free(queryId, 513L);
            Assert.fail((String)"Expect IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testTryCancelBlockedReservation() {
        String queryId = "q0";
        Assert.assertTrue((boolean)this.pool.tryReserve(queryId, 512L));
        ListenableFuture f = (ListenableFuture)this.pool.reserve((String)queryId, (long)256L).left;
        Assert.assertFalse((boolean)f.isDone());
        Assert.assertEquals((long)256L, (long)this.pool.tryCancel(f));
        Assert.assertTrue((boolean)f.isDone());
        Assert.assertTrue((boolean)f.isCancelled());
    }

    @Test
    public void testTryCancelCompletedReservation() {
        String queryId = "q0";
        ListenableFuture f = (ListenableFuture)this.pool.reserve((String)queryId, (long)256L).left;
        Assert.assertTrue((boolean)f.isDone());
        Assert.assertEquals((long)0L, (long)this.pool.tryCancel(f));
        Assert.assertTrue((boolean)f.isDone());
        Assert.assertFalse((boolean)f.isCancelled());
    }
}

