/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.exchange;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.db.mpp.execution.memory.MemoryPool;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.column.TsBlockSerde;
import org.apache.iotdb.tsfile.utils.Pair;
import org.mockito.Mockito;

public class Utils {
    public static List<TsBlock> createMockTsBlocks(int numOfTsBlocks, long mockTsBlockSize) {
        ArrayList<TsBlock> mockTsBlocks = new ArrayList<TsBlock>(numOfTsBlocks);
        for (int i = 0; i < numOfTsBlocks; ++i) {
            TsBlock mockTsBlock = (TsBlock)Mockito.mock(TsBlock.class);
            Mockito.when((Object)mockTsBlock.getRetainedSizeInBytes()).thenReturn((Object)mockTsBlockSize);
            mockTsBlocks.add(mockTsBlock);
        }
        return mockTsBlocks;
    }

    public static TsBlock createMockTsBlock(long mockTsBlockSize) {
        TsBlock mockTsBlock = (TsBlock)Mockito.mock(TsBlock.class);
        Mockito.when((Object)mockTsBlock.getRetainedSizeInBytes()).thenReturn((Object)mockTsBlockSize);
        return mockTsBlock;
    }

    public static MemoryPool createMockBlockedMemoryPool(String queryId, int numOfMockTsBlock, long mockTsBlockSize) {
        long capacityInBytes = (long)numOfMockTsBlock * mockTsBlockSize;
        MemoryPool mockMemoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        AtomicReference<SettableFuture> settableFuture = new AtomicReference<SettableFuture>();
        settableFuture.set(SettableFuture.create());
        ((SettableFuture)settableFuture.get()).set(null);
        AtomicReference<Long> reservedBytes = new AtomicReference<Long>(0L);
        Mockito.when((Object)mockMemoryPool.reserve((String)Mockito.eq((Object)queryId), Mockito.anyLong())).thenAnswer(invocation -> {
            long bytesToReserve = (Long)invocation.getArgument(1);
            if ((Long)reservedBytes.get() + bytesToReserve <= capacityInBytes) {
                reservedBytes.updateAndGet(v -> v + (Long)invocation.getArgument(1));
                return new Pair((Object)((SettableFuture)settableFuture.get()), (Object)true);
            }
            settableFuture.set(SettableFuture.create());
            return new Pair((Object)((SettableFuture)settableFuture.get()), (Object)false);
        });
        ((MemoryPool)Mockito.doAnswer(invocation -> {
            reservedBytes.updateAndGet(v -> v - (Long)invocation.getArgument(1));
            if ((Long)reservedBytes.get() <= 0L) {
                ((SettableFuture)settableFuture.get()).set(null);
                reservedBytes.updateAndGet(v -> v + mockTsBlockSize);
            }
            return null;
        }).when((Object)mockMemoryPool)).free((String)Mockito.eq((Object)queryId), Mockito.anyLong());
        Mockito.when((Object)mockMemoryPool.tryReserve((String)Mockito.eq((Object)queryId), Mockito.anyLong())).thenAnswer(invocation -> {
            long bytesToReserve = (Long)invocation.getArgument(1);
            if ((Long)reservedBytes.get() + bytesToReserve > capacityInBytes) {
                return false;
            }
            reservedBytes.updateAndGet(v -> v + bytesToReserve);
            return true;
        });
        return mockMemoryPool;
    }

    public static MemoryPool createMockNonBlockedMemoryPool() {
        MemoryPool mockMemoryPool = (MemoryPool)Mockito.mock(MemoryPool.class);
        Mockito.when((Object)mockMemoryPool.reserve(Mockito.anyString(), Mockito.anyLong())).thenReturn((Object)new Pair((Object)Futures.immediateFuture(null), (Object)true));
        Mockito.when((Object)mockMemoryPool.tryReserve(Mockito.anyString(), Mockito.anyLong())).thenReturn((Object)true);
        return mockMemoryPool;
    }

    public static TsBlockSerde createMockTsBlockSerde(long mockTsBlockSize) {
        TsBlockSerde mockTsBlockSerde = (TsBlockSerde)Mockito.mock(TsBlockSerde.class);
        TsBlock mockTsBlock = (TsBlock)Mockito.mock(TsBlock.class);
        Mockito.when((Object)mockTsBlock.getRetainedSizeInBytes()).thenReturn((Object)mockTsBlockSize);
        Mockito.when((Object)mockTsBlockSerde.deserialize((ByteBuffer)Mockito.any(ByteBuffer.class))).thenReturn((Object)mockTsBlock);
        return mockTsBlockSerde;
    }
}

