/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.db.mpp.common.FragmentInstanceId;
import org.apache.iotdb.db.mpp.common.PlanFragmentId;
import org.apache.iotdb.db.mpp.common.QueryId;
import org.apache.iotdb.db.mpp.execution.QueryState;
import org.apache.iotdb.db.mpp.execution.QueryStateMachine;
import org.junit.Assert;
import org.junit.Test;

public class QueryStateMachineTest {
    @Test
    public void TestBasicTransition() {
        QueryStateMachine stateMachine = this.genQueryStateMachine();
        Assert.assertEquals((Object)stateMachine.getState(), (Object)QueryState.QUEUED);
        stateMachine.transitionToDispatching();
        Assert.assertEquals((Object)stateMachine.getState(), (Object)QueryState.DISPATCHING);
        stateMachine.transitionToRunning();
        Assert.assertEquals((Object)stateMachine.getState(), (Object)QueryState.RUNNING);
        stateMachine.transitionToAborted();
        Assert.assertEquals((Object)stateMachine.getState(), (Object)QueryState.ABORTED);
        stateMachine = this.genQueryStateMachine();
        stateMachine.transitionToCanceled();
        Assert.assertEquals((Object)stateMachine.getState(), (Object)QueryState.CANCELED);
        stateMachine = this.genQueryStateMachine();
        stateMachine.transitionToFinished();
        Assert.assertEquals((Object)stateMachine.getState(), (Object)QueryState.FINISHED);
    }

    @Test
    public void TestListener() throws ExecutionException, InterruptedException {
        AtomicInteger stateChangeCounter = new AtomicInteger(0);
        QueryStateMachine stateMachine = this.genQueryStateMachine();
        stateMachine.addStateChangeListener(state -> stateChangeCounter.getAndIncrement());
        stateMachine.transitionToFinished();
        SettableFuture future = SettableFuture.create();
        stateMachine.addStateChangeListener(state -> {
            if (state == QueryState.FINISHED) {
                future.set((Object)QueryState.FINISHED);
            }
        });
        future.get();
        Assert.assertEquals((long)stateChangeCounter.get(), (long)2L);
    }

    @Test
    public void TestGetStateChange() throws ExecutionException, InterruptedException {
        AtomicInteger stateChangeCounter = new AtomicInteger(0);
        QueryStateMachine stateMachine = this.genQueryStateMachine();
        SettableFuture callbackFuture = SettableFuture.create();
        ListenableFuture future = stateMachine.getStateChange(QueryState.QUEUED);
        future.addListener(() -> {
            stateChangeCounter.getAndIncrement();
            callbackFuture.set(null);
        }, MoreExecutors.directExecutor());
        Assert.assertEquals((long)stateChangeCounter.get(), (long)0L);
        stateMachine.transitionToRunning();
        future.get();
        callbackFuture.get();
        Assert.assertEquals((long)stateChangeCounter.get(), (long)1L);
    }

    private QueryStateMachine genQueryStateMachine() {
        return new QueryStateMachine(this.genQueryId(), IoTDBThreadPoolFactory.newSingleThreadExecutor((String)"TestQueryStateMachine"));
    }

    private List<FragmentInstanceId> genFragmentInstanceIdList() {
        return Arrays.asList(new FragmentInstanceId(new PlanFragmentId(this.genQueryId(), 1), "1"), new FragmentInstanceId(new PlanFragmentId(this.genQueryId(), 2), "1"), new FragmentInstanceId(new PlanFragmentId(this.genQueryId(), 3), "1"), new FragmentInstanceId(new PlanFragmentId(this.genQueryId(), 4), "1"), new FragmentInstanceId(new PlanFragmentId(this.genQueryId(), 4), "2"));
    }

    private QueryId genQueryId() {
        return new QueryId("test_query");
    }
}

