/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.schematree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.db.mpp.common.schematree.node.SchemaEntityNode;
import org.apache.iotdb.db.mpp.common.schematree.node.SchemaInternalNode;
import org.apache.iotdb.db.mpp.common.schematree.node.SchemaMeasurementNode;
import org.apache.iotdb.db.mpp.common.schematree.node.SchemaNode;
import org.apache.iotdb.db.mpp.common.schematree.visitor.SchemaTreeMeasurementVisitor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.internal.util.collections.Sets;

public class ClusterSchemaTreeTest {
    @Test
    public void testSchemaTreeVisitor() throws Exception {
        SchemaNode root = this.generateSchemaTree();
        this.testSchemaTree(root);
    }

    @Test
    public void testMultiWildcard() throws IllegalPathException {
        SchemaNode root = this.generateSchemaTreeWithInternalRepeatedName();
        SchemaTreeMeasurementVisitor visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.**.**.s"), 0, 0, false);
        this.checkVisitorResult(visitor, 4, new String[]{"root.a.a.a.a.a.s", "root.a.a.a.a.s", "root.a.a.a.s", "root.a.a.s"}, null, new boolean[]{false, false, false, false});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.*.**.s"), 0, 0, false);
        this.checkVisitorResult(visitor, 4, new String[]{"root.a.a.a.a.a.s", "root.a.a.a.a.s", "root.a.a.a.s", "root.a.a.s"}, null, new boolean[]{false, false, false, false});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.**.a.**.s"), 0, 0, false);
        this.checkVisitorResult(visitor, 3, new String[]{"root.a.a.a.a.a.s", "root.a.a.a.a.s", "root.a.a.a.s"}, null, new boolean[]{false, false, false});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.**.a.**.*.s"), 0, 0, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.a.a.a.a.a.s", "root.a.a.a.a.s"}, null, new boolean[]{false, false, false});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.a.**.a.*.s"), 0, 0, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.a.a.a.a.a.s", "root.a.a.a.a.s"}, null, new boolean[]{false, false, false});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.**.c.s1"), 0, 0, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.c.c.c.d.c.c.s1", "root.c.c.c.d.c.s1"}, null, new boolean[]{false, false});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.**.c.d.c.s1"), 0, 0, false);
        this.checkVisitorResult(visitor, 1, new String[]{"root.c.c.c.d.c.s1"}, null, new boolean[]{false});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.**.d.**.c.s1"), 0, 0, false);
        this.checkVisitorResult(visitor, 1, new String[]{"root.c.c.c.d.c.c.s1"}, null, new boolean[]{false});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.**.d.*.*"), 0, 0, false);
        this.checkVisitorResult(visitor, 1, new String[]{"root.c.c.c.d.c.s1"}, null, new boolean[]{false});
    }

    private void testSchemaTree(SchemaNode root) throws Exception {
        SchemaTreeMeasurementVisitor visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.sg.d2.a.s1"), 0, 0, false);
        this.checkVisitorResult(visitor, 1, new String[]{"root.sg.d2.a.s1"}, null, new boolean[]{true});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.sg.*.s2"), 0, 0, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d1.s2", "root.sg.d2.s2"}, new String[]{"", ""}, null);
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.sg.*.status"), 0, 0, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d1.s2", "root.sg.d2.s2"}, new String[]{"status", "status"}, null);
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.sg.d2.*.*"), 0, 0, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d2.a.s1", "root.sg.d2.a.s2"}, new String[]{"", ""}, new boolean[]{true, true});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.sg.d1"), 0, 0, true);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d1.s1", "root.sg.d1.s2"}, new String[]{"", ""}, new boolean[]{false, false});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.sg.*.a"), 0, 0, true);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d2.a.s1", "root.sg.d2.a.s2"}, new String[]{"", ""}, new boolean[]{true, true}, new int[]{0, 0});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.sg.*.*"), 2, 2, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d2.s1", "root.sg.d2.s2"}, new String[]{"", ""}, new boolean[]{false, false}, new int[]{3, 4});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.sg.*"), 2, 3, true);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d2.a.s2", "root.sg.d2.s1"}, new String[]{"", ""}, new boolean[]{true, false}, new int[]{4, 5});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.sg.d1.**"), 0, 0, false);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d1.s1", "root.sg.d1.s2"}, new String[]{"", ""}, new boolean[]{false, false});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.sg.d2.**"), 3, 1, true);
        this.checkVisitorResult(visitor, 3, new String[]{"root.sg.d2.a.s2", "root.sg.d2.s1", "root.sg.d2.s2"}, new String[]{"", "", ""}, new boolean[]{true, false, false}, new int[]{2, 3, 4});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.sg.**.status"), 2, 1, true);
        this.checkVisitorResult(visitor, 2, new String[]{"root.sg.d2.a.s2", "root.sg.d2.s2"}, new String[]{"status", "status"}, new boolean[]{true, false}, new int[]{2, 3});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.**.*"), 10, 0, false);
        this.checkVisitorResult(visitor, 6, new String[]{"root.sg.d1.s1", "root.sg.d1.s2", "root.sg.d2.a.s1", "root.sg.d2.a.s2", "root.sg.d2.s1", "root.sg.d2.s2"}, new String[]{"", "", "", "", "", ""}, new boolean[]{false, false, true, true, false, false}, new int[]{1, 2, 3, 4, 5, 6});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.**.*.**"), 10, 0, false);
        this.checkVisitorResult(visitor, 6, new String[]{"root.sg.d1.s1", "root.sg.d1.s2", "root.sg.d2.a.s1", "root.sg.d2.a.s2", "root.sg.d2.s1", "root.sg.d2.s2"}, new String[]{"", "", "", "", "", ""}, new boolean[]{false, false, true, true, false, false}, new int[]{1, 2, 3, 4, 5, 6});
        visitor = new SchemaTreeMeasurementVisitor(root, new PartialPath("root.*.**.**"), 10, 0, false);
        this.checkVisitorResult(visitor, 6, new String[]{"root.sg.d1.s1", "root.sg.d1.s2", "root.sg.d2.a.s1", "root.sg.d2.a.s2", "root.sg.d2.s1", "root.sg.d2.s2"}, new String[]{"", "", "", "", "", ""}, new boolean[]{false, false, true, true, false, false}, new int[]{1, 2, 3, 4, 5, 6});
    }

    private SchemaNode generateSchemaTree() {
        SchemaInternalNode root = new SchemaInternalNode("root");
        SchemaInternalNode sg = new SchemaInternalNode("sg");
        root.addChild("sg", (SchemaNode)sg);
        SchemaEntityNode d1 = new SchemaEntityNode("d1");
        sg.addChild("d1", (SchemaNode)d1);
        MeasurementSchema schema1 = new MeasurementSchema("s1", TSDataType.INT32);
        MeasurementSchema schema2 = new MeasurementSchema("s2", TSDataType.INT64);
        SchemaMeasurementNode s1 = new SchemaMeasurementNode("s1", schema1);
        d1.addChild("s1", (SchemaNode)s1);
        SchemaMeasurementNode s2 = new SchemaMeasurementNode("s2", schema2);
        s2.setAlias("status");
        d1.addChild("s2", (SchemaNode)s2);
        d1.addAliasChild("status", s2);
        SchemaEntityNode d2 = new SchemaEntityNode("d2");
        sg.addChild("d2", (SchemaNode)d2);
        d2.addChild("s1", (SchemaNode)s1);
        d2.addChild("s2", (SchemaNode)s2);
        d2.addAliasChild("status", s2);
        SchemaEntityNode a = new SchemaEntityNode("a");
        a.setAligned(true);
        d2.addChild("a", (SchemaNode)a);
        a.addChild("s1", (SchemaNode)s1);
        a.addChild("s2", (SchemaNode)s2);
        a.addAliasChild("status", s2);
        return root;
    }

    private SchemaNode generateSchemaTreeWithInternalRepeatedName() {
        SchemaInternalNode root;
        SchemaInternalNode parent = root = new SchemaInternalNode("root");
        MeasurementSchema schema = new MeasurementSchema("s", TSDataType.INT32);
        for (int i = 0; i < 5; ++i) {
            SchemaEntityNode a = new SchemaEntityNode("a");
            SchemaMeasurementNode s = new SchemaMeasurementNode("s", schema);
            a.addChild("s", (SchemaNode)s);
            parent.addChild("a", (SchemaNode)a);
            parent = a;
        }
        parent = root;
        for (int i = 0; i < 3; ++i) {
            SchemaInternalNode c = new SchemaInternalNode("c");
            parent.addChild("c", (SchemaNode)c);
            parent = c;
        }
        SchemaInternalNode d = new SchemaInternalNode("d");
        parent.addChild("d", (SchemaNode)d);
        parent = d;
        for (int i = 0; i < 2; ++i) {
            SchemaEntityNode c = new SchemaEntityNode("c");
            c.addChild("s1", (SchemaNode)new SchemaMeasurementNode("s1", schema));
            parent.addChild("c", (SchemaNode)c);
            parent = c;
        }
        return root;
    }

    private void checkVisitorResult(SchemaTreeMeasurementVisitor visitor, int expectedNum, String[] expectedPath, String[] expectedAlias, boolean[] expectedAligned) {
        int i;
        List result = visitor.getAllResult();
        Assert.assertEquals((long)expectedNum, (long)result.size());
        for (i = 0; i < expectedNum; ++i) {
            Assert.assertEquals((Object)expectedPath[i], (Object)((MeasurementPath)result.get(i)).getFullPath());
        }
        if (expectedAlias != null) {
            for (i = 0; i < expectedNum; ++i) {
                Assert.assertEquals((Object)expectedAlias[i], (Object)((MeasurementPath)result.get(i)).getMeasurementAlias());
            }
        }
        if (expectedAligned != null) {
            for (i = 0; i < expectedNum; ++i) {
                Assert.assertEquals((Object)expectedAligned[i], (Object)((MeasurementPath)result.get(i)).isUnderAlignedEntity());
            }
        }
    }

    private void checkVisitorResult(SchemaTreeMeasurementVisitor visitor, int expectedNum, String[] expectedPath, String[] expectedAlias, boolean[] expectedAligned, int[] expectedOffset) {
        this.checkVisitorResult(visitor, expectedNum, expectedPath, expectedAlias, expectedAligned);
        visitor.reset();
        int i = 0;
        while (visitor.hasNext()) {
            MeasurementPath result = (MeasurementPath)visitor.next();
            Assert.assertEquals((Object)expectedPath[i], (Object)result.getFullPath());
            Assert.assertEquals((Object)expectedAlias[i], (Object)result.getMeasurementAlias());
            Assert.assertEquals((Object)expectedAligned[i], (Object)result.isUnderAlignedEntity());
            Assert.assertEquals((long)expectedOffset[i], (long)visitor.getNextOffset());
            ++i;
        }
        Assert.assertEquals((long)expectedNum, (long)i);
    }

    @Test
    public void testSearchDeviceInfo() throws Exception {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree(this.generateSchemaTree());
        this.testSearchDeviceInfo((ISchemaTree)schemaTree);
    }

    private void testSearchDeviceInfo(ISchemaTree schemaTree) throws Exception {
        PartialPath devicePath = new PartialPath("root.sg.d1");
        ArrayList<String> measurements = new ArrayList<String>();
        measurements.add("s1");
        measurements.add("s2");
        DeviceSchemaInfo deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(devicePath, measurements);
        Assert.assertEquals(measurements, deviceSchemaInfo.getMeasurementSchemaList().stream().map(MeasurementSchema::getMeasurementId).collect(Collectors.toList()));
        devicePath = new PartialPath("root.sg.d2.a");
        measurements.remove(1);
        measurements.add("status");
        deviceSchemaInfo = schemaTree.searchDeviceSchemaInfo(devicePath, measurements);
        Assert.assertTrue((boolean)deviceSchemaInfo.isAligned());
        measurements.remove(1);
        measurements.add("s2");
        Assert.assertEquals(measurements, deviceSchemaInfo.getMeasurementSchemaList().stream().map(MeasurementSchema::getMeasurementId).collect(Collectors.toList()));
    }

    @Test
    public void testGetMatchedDevices() throws Exception {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree(this.generateSchemaTree());
        List deviceSchemaInfoList = schemaTree.getMatchedDevices(new PartialPath("root.sg.d2.a"), false);
        Assert.assertEquals((long)1L, (long)deviceSchemaInfoList.size());
        DeviceSchemaInfo deviceSchemaInfo = (DeviceSchemaInfo)deviceSchemaInfoList.get(0);
        Assert.assertEquals((Object)new PartialPath("root.sg.d2.a"), (Object)deviceSchemaInfo.getDevicePath());
        Assert.assertTrue((boolean)deviceSchemaInfo.isAligned());
        Assert.assertEquals((long)2L, (long)deviceSchemaInfo.getMeasurements(Sets.newSet((Object[])new String[]{"*"})).size());
        deviceSchemaInfoList = schemaTree.getMatchedDevices(new PartialPath("root.sg.*"), false);
        deviceSchemaInfoList.sort(Comparator.comparing(DeviceSchemaInfo::getDevicePath));
        Assert.assertEquals((long)2L, (long)deviceSchemaInfoList.size());
        Assert.assertEquals((Object)new PartialPath("root.sg.d1"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(0)).getDevicePath());
        Assert.assertEquals((Object)new PartialPath("root.sg.d2"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(1)).getDevicePath());
        deviceSchemaInfoList = schemaTree.getMatchedDevices(new PartialPath("root.sg.**"), false);
        deviceSchemaInfoList.sort(Comparator.comparing(DeviceSchemaInfo::getDevicePath));
        Assert.assertEquals((long)3L, (long)deviceSchemaInfoList.size());
        Assert.assertEquals((Object)new PartialPath("root.sg.d1"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(0)).getDevicePath());
        Assert.assertEquals((Object)new PartialPath("root.sg.d2"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(1)).getDevicePath());
        Assert.assertEquals((Object)new PartialPath("root.sg.d2.a"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(2)).getDevicePath());
        deviceSchemaInfoList = schemaTree.getMatchedDevices(new PartialPath("root.**"), false);
        deviceSchemaInfoList.sort(Comparator.comparing(DeviceSchemaInfo::getDevicePath));
        Assert.assertEquals((long)3L, (long)deviceSchemaInfoList.size());
        Assert.assertEquals((Object)new PartialPath("root.sg.d1"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(0)).getDevicePath());
        Assert.assertEquals((Object)new PartialPath("root.sg.d2"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(1)).getDevicePath());
        Assert.assertEquals((Object)new PartialPath("root.sg.d2.a"), (Object)((DeviceSchemaInfo)deviceSchemaInfoList.get(2)).getDevicePath());
    }

    @Test
    public void testSerialization() throws Exception {
        SchemaNode root = this.generateSchemaTree();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        root.serialize((OutputStream)outputStream);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        ClusterSchemaTree schemaTree = ClusterSchemaTree.deserialize((InputStream)inputStream);
        Pair visitResult = schemaTree.searchMeasurementPaths(new PartialPath("root.sg.**.status"), 2, 1, true);
        Assert.assertEquals((long)2L, (long)((List)visitResult.left).size());
        Assert.assertEquals((long)3L, (long)((Integer)visitResult.right).intValue());
        this.testSearchDeviceInfo((ISchemaTree)schemaTree);
    }

    @Test
    public void testAppendMeasurementPath() throws Exception {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        List<MeasurementPath> measurementPathList = this.generateMeasurementPathList();
        schemaTree.appendMeasurementPaths(measurementPathList);
        this.testSchemaTree(schemaTree.getRoot());
    }

    private List<MeasurementPath> generateMeasurementPathList() throws Exception {
        ArrayList<MeasurementPath> measurementPathList = new ArrayList<MeasurementPath>();
        MeasurementSchema schema1 = new MeasurementSchema("s1", TSDataType.INT32);
        MeasurementSchema schema2 = new MeasurementSchema("s2", TSDataType.INT64);
        MeasurementPath measurementPath = new MeasurementPath("root.sg.d1.s1");
        measurementPath.setMeasurementSchema((IMeasurementSchema)schema1);
        measurementPathList.add(measurementPath);
        measurementPath = new MeasurementPath("root.sg.d1.s2");
        measurementPath.setMeasurementSchema((IMeasurementSchema)schema2);
        measurementPath.setMeasurementAlias("status");
        measurementPathList.add(measurementPath);
        measurementPath = new MeasurementPath("root.sg.d2.a.s1");
        measurementPath.setMeasurementSchema((IMeasurementSchema)schema1);
        measurementPath.setUnderAlignedEntity(true);
        measurementPathList.add(measurementPath);
        measurementPath = new MeasurementPath("root.sg.d2.a.s2");
        measurementPath.setMeasurementSchema((IMeasurementSchema)schema2);
        measurementPath.setMeasurementAlias("status");
        measurementPath.setUnderAlignedEntity(true);
        measurementPathList.add(measurementPath);
        measurementPath = new MeasurementPath("root.sg.d2.s1");
        measurementPath.setMeasurementSchema((IMeasurementSchema)schema1);
        measurementPathList.add(measurementPath);
        measurementPath = new MeasurementPath("root.sg.d2.s2");
        measurementPath.setMeasurementSchema((IMeasurementSchema)schema2);
        measurementPath.setMeasurementAlias("status");
        measurementPathList.add(measurementPath);
        return measurementPathList;
    }

    @Test
    public void testMergeSchemaTree() throws Exception {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        for (ClusterSchemaTree tree : this.generateSchemaTrees()) {
            schemaTree.mergeSchemaTree(tree);
        }
        this.testSchemaTree(schemaTree.getRoot());
    }

    @Test
    public void testMergeSchemaTreeAndSearchDeviceSchemaInfo() throws Exception {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        for (ClusterSchemaTree tree : this.generateSchemaTrees()) {
            schemaTree.mergeSchemaTree(tree);
        }
        PartialPath devicePath = new PartialPath("root.sg.d99999");
        ArrayList<String> measurements = new ArrayList<String>();
        measurements.add("s1");
        measurements.add("s2");
        schemaTree.searchDeviceSchemaInfo(devicePath, measurements);
    }

    private List<ClusterSchemaTree> generateSchemaTrees() throws Exception {
        ArrayList<ClusterSchemaTree> schemaTreeList = new ArrayList<ClusterSchemaTree>();
        List<MeasurementPath> measurementPathList = this.generateMeasurementPathList();
        for (int i = 0; i < 6; i += 2) {
            ArrayList<MeasurementPath> list = new ArrayList<MeasurementPath>();
            list.add(measurementPathList.get(i));
            list.add(measurementPathList.get(i + 1));
            ClusterSchemaTree schemaTree = new ClusterSchemaTree();
            schemaTree.appendMeasurementPaths(list);
            schemaTreeList.add(schemaTree);
        }
        return schemaTreeList;
    }
}

