/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.upgrade;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.logfile.MLogWriter;
import org.apache.iotdb.db.metadata.mnode.EntityMNode;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.metadata.tag.TagLogFile;
import org.apache.iotdb.db.metadata.upgrade.MetadataUpgrader;
import org.apache.iotdb.db.qp.physical.sys.AutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.query.dataset.ShowResult;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.writelog.LogWriter;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MetadataUpgradeTest {
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private String schemaDirPath = this.config.getSchemaDir();

    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testMetadataUpgrade() throws Exception {
        this.prepareSnapshot();
        this.prepareTagFile();
        this.prepareMLog();
        IoTDB.configManager.clear();
        MetadataUpgrader.upgrade();
        IoTDB.configManager.init();
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        Assert.assertEquals((long)8L, (long)schemaProcessor.getStorageGroupNum(new PartialPath("root.**"), false));
        Assert.assertEquals((long)10L, (long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.**")));
        ShowTimeSeriesPlan showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.**"), false, "t-k-0", "t-k-0-v-0", 0, 0, false);
        List resultList = schemaProcessor.showTimeseries(showTimeSeriesPlan, null);
        Assert.assertEquals((long)1L, (long)resultList.size());
        ShowTimeSeriesResult result = (ShowTimeSeriesResult)resultList.get(0);
        Assert.assertEquals((Object)"root.test.sg1.d1.s1", (Object)result.getName());
        showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.**"), false, "t-k-1", "t-k-1-v-1", 0, 0, false);
        resultList = schemaProcessor.showTimeseries(showTimeSeriesPlan, null);
        resultList = resultList.stream().sorted(Comparator.comparing(ShowResult::getName)).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)resultList.size());
        result = (ShowTimeSeriesResult)resultList.get(0);
        Assert.assertEquals((Object)"root.test.sg1.d2.s1", (Object)result.getName());
        result = (ShowTimeSeriesResult)resultList.get(1);
        Assert.assertEquals((Object)"root.test.sg2.d1.s1", (Object)result.getName());
        Assert.assertEquals((long)4L, (long)schemaProcessor.getPathsSetTemplate("template").size());
        Assert.assertEquals((long)0L, (long)schemaProcessor.getPathsSetTemplate("unsetTemplate").size());
        Assert.assertEquals((Object)"root.test.sg3.d3", new ArrayList(schemaProcessor.getPathsUsingTemplate("template")).get(0));
        Assert.assertTrue((boolean)new File(this.schemaDirPath + File.separator + "mlog.bin" + ".bak").exists());
        Assert.assertTrue((boolean)new File(this.schemaDirPath + File.separator + "tlog.txt" + ".bak").exists());
        Assert.assertTrue((boolean)new File(this.schemaDirPath + File.separator + "mtree-1.snapshot.bin" + ".bak").exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareMLog() throws Exception {
        try (MLogWriter logWriter = new MLogWriter(this.schemaDirPath + File.separator + "mlog.bin");){
            CreateTimeSeriesPlan createTimeSeriesPlan = new CreateTimeSeriesPlan(new PartialPath("root.test.sg1.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null, null, null);
            createTimeSeriesPlan.setTagOffset(-1L);
            logWriter.createTimeseries(createTimeSeriesPlan);
            createTimeSeriesPlan = new CreateTimeSeriesPlan(new PartialPath("root.test.sg1.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null, null, null);
            logWriter.createTimeseries(createTimeSeriesPlan);
            logWriter.setStorageGroup(new PartialPath("root.test.sg2"));
            HashMap<String, String> tags = new HashMap<String, String>();
            tags.put("t-k-1", "t-k-1-v-1");
            createTimeSeriesPlan = new CreateTimeSeriesPlan(new PartialPath("root.test.sg2.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, tags, null, null);
            createTimeSeriesPlan.setTagOffset((long)this.config.getTagAttributeTotalSize());
            logWriter.createTimeseries(createTimeSeriesPlan);
            logWriter.changeOffset(new PartialPath("root.test.sg1.d2.s1"), 2L * (long)this.config.getTagAttributeTotalSize());
            CreateTemplatePlan createTemplatePlan = this.getCreateTemplatePlan("template", "s3");
            logWriter.createSchemaTemplate(createTemplatePlan);
            SetTemplatePlan setTemplatePlan = new SetTemplatePlan("template", "root.test");
            logWriter.setSchemaTemplate(setTemplatePlan);
            logWriter.setStorageGroup(new PartialPath("root.test.sg3"));
            logWriter.autoCreateDeviceMNode(new AutoCreateDeviceMNodePlan(new PartialPath("root.test.sg3.d3")));
            logWriter.setUsingSchemaTemplate(new PartialPath("root.test.sg3.d3"));
            logWriter.setStorageGroup(new PartialPath("root.unsetTemplate1.sg1"));
            logWriter.createSchemaTemplate(this.getCreateTemplatePlan("unsetTemplate", "s1"));
            logWriter.setSchemaTemplate(new SetTemplatePlan("unsetTemplate", "root.unsetTemplate1"));
            logWriter.setStorageGroup(new PartialPath("root.unsetTemplate1.sg2"));
            logWriter.unsetSchemaTemplate(new UnsetTemplatePlan("root.unsetTemplate1", "unsetTemplate"));
            logWriter.setStorageGroup(new PartialPath("root.unsetTemplate2.sg1"));
            logWriter.setSchemaTemplate(new SetTemplatePlan("unsetTemplate", "root.unsetTemplate2"));
            logWriter.unsetSchemaTemplate(new UnsetTemplatePlan("root.unsetTemplate2", "unsetTemplate"));
            logWriter.setStorageGroup(new PartialPath("root.test.sg4"));
            logWriter.setStorageGroup(new PartialPath("root.unsetTemplate2.sg2"));
            logWriter.force();
        }
        CreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan = this.getCreateAlignedTimeseriesPlan();
        try (LogWriter rawLogWriter = new LogWriter(this.schemaDirPath + File.separator + "mlog.bin", true);){
            ByteBuffer byteBuffer = ByteBuffer.allocate(0x100000);
            createAlignedTimeSeriesPlan.formerSerialize(byteBuffer);
            rawLogWriter.write(byteBuffer);
            rawLogWriter.force();
        }
    }

    private CreateTemplatePlan getCreateTemplatePlan(String templateName, String measurementName) {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList(measurementName));
        ArrayList<List<TSDataType>> dataTypeList = new ArrayList<List<TSDataType>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add(measurementName);
        return new CreateTemplatePlan(templateName, schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
    }

    private CreateAlignedTimeSeriesPlan getCreateAlignedTimeseriesPlan() throws IllegalPathException {
        PartialPath devicePath = new PartialPath("root.unsetTemplate1.sg1.device0");
        List<String> measurements = Arrays.asList("s1", "s2", "s3", "s4", "s5");
        List<TSDataType> tsDataTypes = Arrays.asList(TSDataType.DOUBLE, TSDataType.TEXT, TSDataType.FLOAT, TSDataType.BOOLEAN, TSDataType.INT32);
        List<TSEncoding> tsEncodings = Arrays.asList(TSEncoding.PLAIN, TSEncoding.PLAIN, TSEncoding.PLAIN, TSEncoding.PLAIN, TSEncoding.PLAIN);
        List<CompressionType> compressionTypes = Arrays.asList(CompressionType.UNCOMPRESSED, CompressionType.UNCOMPRESSED, CompressionType.UNCOMPRESSED, CompressionType.UNCOMPRESSED, CompressionType.UNCOMPRESSED);
        return new CreateAlignedTimeSeriesPlan(devicePath, measurements, tsDataTypes, tsEncodings, compressionTypes, null, null, null);
    }

    private void prepareTagFile() throws Exception {
        try (TagLogFile tagLogFile = new TagLogFile(this.schemaDirPath, "tlog.txt");){
            HashMap<String, String> tags = new HashMap<String, String>();
            HashMap attributes = new HashMap();
            tags.put("t-k-0", "t-k-0-v-0");
            tagLogFile.write(tags, attributes);
            tags.clear();
            tags.put("t-k-1", "t-k-1-v-1");
            tagLogFile.write(tags, attributes);
            tags.clear();
            tags.put("t-k-1", "t-k-1-v-1");
            tagLogFile.write(tags, attributes);
        }
    }

    private void prepareSnapshot() throws Exception {
        InternalMNode root = new InternalMNode(null, "root");
        InternalMNode test = new InternalMNode((IMNode)root, "test");
        root.addChild((IMNode)test);
        StorageGroupMNode storageGroupMNode = new StorageGroupMNode((IMNode)test, "sg1", 10000L);
        test.addChild((IMNode)storageGroupMNode);
        EntityMNode entityMNode = new EntityMNode((IMNode)storageGroupMNode, "d1");
        storageGroupMNode.addChild((IMNode)entityMNode);
        MeasurementSchema schema = new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
        IMeasurementMNode measurementMNode = MeasurementMNode.getMeasurementMNode((IEntityMNode)entityMNode, (String)"s1", (IMeasurementSchema)schema, (String)"first");
        measurementMNode.setOffset(0L);
        entityMNode.addChild((IMNode)measurementMNode);
        entityMNode.addAlias("first", measurementMNode);
        try (MLogWriter mLogWriter = new MLogWriter(this.schemaDirPath + File.separator + "mtree-1.snapshot.bin");){
            root.serializeTo(mLogWriter);
        }
    }
}

