/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaRegion;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class SchemaRegionTest {
    SchemaEngine schemaEngine = SchemaEngine.getInstance();
    IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    boolean isMppMode;
    boolean isClusterMode;
    String schemaRegionConsensusProtocolClass;
    long schemaMemory;

    @Before
    public void setUp() {
        this.isMppMode = this.config.isMppMode();
        this.isClusterMode = this.config.isClusterMode();
        this.schemaRegionConsensusProtocolClass = this.config.getSchemaRegionConsensusProtocolClass();
        this.schemaMemory = this.config.getAllocateMemoryForSchemaRegion();
        this.config.setMppMode(true);
        this.config.setClusterMode(true);
        this.config.setSchemaRegionConsensusProtocolClass("org.apache.iotdb.consensus.ratis.RatisConsensus");
        this.config.setAllocateMemoryForSchemaRegion(0x40000000L);
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        this.config.setMppMode(this.isMppMode);
        this.config.setClusterMode(this.isClusterMode);
        this.config.setSchemaRegionConsensusProtocolClass(this.schemaRegionConsensusProtocolClass);
        this.config.setAllocateMemoryForSchemaRegion(this.schemaMemory);
    }

    @Test
    public void testRatisModeSnapshot() throws Exception {
        PartialPath storageGroup = new PartialPath("root.sg");
        SchemaRegionId schemaRegionId = new SchemaRegionId(0);
        this.schemaEngine.createSchemaRegion(storageGroup, schemaRegionId);
        ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion(schemaRegionId);
        File mLogFile = SystemFileFactory.INSTANCE.getFile(schemaRegion.getStorageGroupFullPath() + File.separator + schemaRegion.getSchemaRegionId().getId(), "mlog.bin");
        Assert.assertFalse((boolean)mLogFile.exists());
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("tag-key", "tag-value");
        schemaRegion.createTimeseries(new CreateTimeSeriesPlan(new PartialPath("root.sg.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null, tags, null, null), -1L);
        File snapshotDir = new File(this.config.getSchemaDir() + File.separator + "snapshot");
        snapshotDir.mkdir();
        schemaRegion.createSnapshot(snapshotDir);
        schemaRegion.loadSnapshot(snapshotDir);
        Pair result = schemaRegion.showTimeseries(new ShowTimeSeriesPlan(new PartialPath("root.sg.**"), false, "tag-key", "tag-value", 0, 0, false), null);
        ShowTimeSeriesResult seriesResult = (ShowTimeSeriesResult)((List)result.left).get(0);
        Assert.assertEquals((Object)new PartialPath("root.sg.d1.s1").getFullPath(), (Object)seriesResult.getName());
        Map resultTagMap = seriesResult.getTag();
        Assert.assertEquals((long)1L, (long)resultTagMap.size());
        Assert.assertEquals((Object)"tag-value", resultTagMap.get("tag-key"));
    }

    @Test
    @Ignore
    public void testSnapshotPerformance() throws Exception {
        PartialPath storageGroup = new PartialPath("root.sg");
        SchemaRegionId schemaRegionId = new SchemaRegionId(0);
        this.schemaEngine.createSchemaRegion(storageGroup, schemaRegionId);
        ISchemaRegion schemaRegion = SchemaEngine.getInstance().getSchemaRegion(schemaRegionId);
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("tag-key", "tag-value");
        long time = System.currentTimeMillis();
        for (int i = 0; i < 1000; ++i) {
            for (int j = 0; j < 1000; ++j) {
                schemaRegion.createTimeseries(new CreateTimeSeriesPlan(new PartialPath("root.sg.d" + i + ".s" + j), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, null, tags, null, null), -1L);
            }
        }
        System.out.println("Timeseries creation costs " + (System.currentTimeMillis() - time) + "ms.");
        File snapshotDir = new File(this.config.getSchemaDir() + File.separator + "snapshot");
        snapshotDir.mkdir();
        schemaRegion.createSnapshot(snapshotDir);
        schemaRegion.loadSnapshot(snapshotDir);
    }
}

