/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.schemafile;

import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.metadata.mnode.EntityMNode;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISegment;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.RecordUtils;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.Segment;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngineMode;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SegmentTest {
    @Before
    public void setUp() {
        IoTDBDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.Schema_File.toString());
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        IoTDBDescriptor.getInstance().getConfig().setSchemaEngineMode(SchemaEngineMode.Memory.toString());
    }

    @Test
    public void flatTreeInsert() throws MetadataException {
        Segment sf = new Segment(500);
        IMNode rNode = this.virtualFlatMTree(10);
        for (IMNode node : rNode.getChildren().values()) {
            int n = sf.insertRecord(node.getName(), RecordUtils.node2Buffer((IMNode)node));
        }
        sf.syncBuffer();
        ByteBuffer recMid01 = sf.getRecord("mid1");
        Assert.assertEquals((Object)"[measurementNode, alias: mid1als, type: FLOAT, encoding: PLAIN, compressor: SNAPPY]", (Object)RecordUtils.buffer2String((ByteBuffer)recMid01));
        int resInsertNode = sf.insertRecord(rNode.getName(), RecordUtils.node2Buffer((IMNode)rNode));
        System.out.println(resInsertNode);
        System.out.println(sf);
        Assert.assertEquals((Object)"[entityNode, not aligned, not using template.]", (Object)RecordUtils.buffer2String((ByteBuffer)sf.getRecord("vRoot1")));
        Segment nsf = new Segment(sf.getBufferCopy(), false);
        System.out.println(nsf);
        this.printBuffer(nsf.getBufferCopy());
        ByteBuffer nrec = nsf.getRecord("mid1");
        Assert.assertEquals((Object)"[measurementNode, alias: mid1als, type: FLOAT, encoding: PLAIN, compressor: SNAPPY]", (Object)RecordUtils.buffer2String((ByteBuffer)nsf.getRecord("mid1")));
        Assert.assertEquals((Object)"[entityNode, not aligned, not using template.]", (Object)RecordUtils.buffer2String((ByteBuffer)nsf.getRecord("vRoot1")));
        ByteBuffer newBuffer = ByteBuffer.allocate(1500);
        sf.extendsTo(newBuffer);
        ISegment newSeg = Segment.loadAsSegment((ByteBuffer)newBuffer);
        System.out.println(newSeg);
        Assert.assertEquals((Object)RecordUtils.buffer2String((ByteBuffer)sf.getRecord("mid4")), (Object)RecordUtils.buffer2String((ByteBuffer)((Segment)newSeg).getRecord("mid4")));
        Assert.assertEquals((Object)sf.getRecord("aaa"), (Object)nsf.getRecord("aaa"));
    }

    private IMNode virtualFlatMTree(int childSize) {
        EntityMNode internalNode = new EntityMNode(null, "vRoot1");
        for (int idx = 0; idx < childSize; ++idx) {
            String measurementId = "mid" + idx;
            MeasurementSchema schema = new MeasurementSchema(measurementId, TSDataType.FLOAT);
            IMeasurementMNode mNode = MeasurementMNode.getMeasurementMNode((IEntityMNode)internalNode.getAsEntityMNode(), (String)measurementId, (IMeasurementSchema)schema, (String)(measurementId + "als"));
            internalNode.addChild((IMNode)mNode);
        }
        return internalNode;
    }

    @Test
    public void bufferTest() {
        byte[] a;
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        ByteBuffer buffer2 = buffer1.slice();
        buffer1.put("12346".getBytes());
        buffer1.clear();
        buffer2.position(10);
        buffer2.put("091234".getBytes());
        buffer2.clear();
        this.printBuffer(buffer1);
        this.printBuffer(buffer2);
        byte[] b = a = new byte[10];
        a[0] = 7;
        System.out.println(a[0]);
        System.out.println(b[0]);
    }

    private void printBuffer(ByteBuffer buf) {
        int lim = buf.limit();
        ByteBuffer bufRep = buf.slice();
        for (int pos = buf.position(); pos < lim; ++pos) {
            System.out.print(buf.get(pos));
            System.out.print(" ");
        }
        System.out.println("");
    }
}

