/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.schemafile;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.db.exception.metadata.schemafile.RecordDuplicatedException;
import org.apache.iotdb.db.exception.metadata.schemafile.SchemaPageOverflowException;
import org.apache.iotdb.db.exception.metadata.schemafile.SegmentNotFoundException;
import org.apache.iotdb.db.metadata.mnode.EntityMNode;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.ISchemaPage;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.RecordUtils;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaFile;
import org.apache.iotdb.db.metadata.mtree.store.disk.schemafile.SchemaPage;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class SchemaPageTest {
    @Before
    public void setUp() {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void flatTreeInsert() throws SchemaPageOverflowException, IOException, SegmentNotFoundException, RecordDuplicatedException {
        ISchemaPage page = SchemaPage.initPage((ByteBuffer)ByteBuffer.allocate(SchemaFile.PAGE_LENGTH), (int)0);
        IMNode root = this.virtualFlatMTree(15);
        block2: for (int i = 0; i < 7; ++i) {
            page.allocNewSegment(SchemaFile.SEG_SIZE_LST[0]);
            int cnt = 0;
            for (IMNode child : root.getChildren().values()) {
                ++cnt;
                try {
                    page.write((short)i, child.getName(), RecordUtils.node2Buffer((IMNode)child));
                }
                catch (MetadataException e) {
                    e.printStackTrace();
                }
                if (cnt <= i) continue;
                continue block2;
            }
        }
        ByteBuffer newBuf = ByteBuffer.allocate(SchemaFile.PAGE_LENGTH);
        page.syncPageBuffer();
        page.getPageBuffer(newBuf);
        ISchemaPage newPage = SchemaPage.loadPage((ByteBuffer)newBuf, (int)0);
        System.out.println(newPage.inspect());
    }

    private IMNode virtualFlatMTree(int childSize) {
        EntityMNode internalNode = new EntityMNode(null, "vRoot1");
        for (int idx = 0; idx < childSize; ++idx) {
            String measurementId = "mid" + idx;
            MeasurementSchema schema = new MeasurementSchema(measurementId, TSDataType.FLOAT);
            IMeasurementMNode mNode = MeasurementMNode.getMeasurementMNode((IEntityMNode)internalNode.getAsEntityMNode(), (String)measurementId, (IMeasurementSchema)schema, (String)(measurementId + "als"));
            internalNode.addChild((IMNode)mNode);
        }
        return internalNode;
    }

    @Test
    public void bufferTest() {
        byte[] a;
        ByteBuffer buffer1 = ByteBuffer.allocate(100);
        ByteBuffer buffer2 = buffer1.slice();
        buffer1.put("12346".getBytes());
        buffer1.clear();
        buffer2.position(10);
        buffer2.put("091234".getBytes());
        buffer2.clear();
        this.printBuffer(buffer1);
        this.printBuffer(buffer2);
        byte[] b = a = new byte[10];
        a[0] = 7;
        System.out.println(a[0]);
        System.out.println(b[0]);
    }

    private void printBuffer(ByteBuffer buf) {
        int lim = buf.limit();
        ByteBuffer bufRep = buf.slice();
        for (int pos = buf.position(); pos < lim; ++pos) {
            System.out.print(buf.get(pos));
            System.out.print(" ");
        }
        System.out.println("");
    }
}

