/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mtree.ConfigMTree;
import org.apache.iotdb.db.metadata.mtree.IMTreeBelowSG;
import org.apache.iotdb.db.metadata.mtree.MTreeBelowSGCachedImpl;
import org.apache.iotdb.db.metadata.mtree.MTreeBelowSGMemoryImpl;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngineMode;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class MTreeBelowSGTest {
    ConfigMTree root;
    IMTreeBelowSG storageGroup;
    Set<IMTreeBelowSG> usedMTree = new HashSet<IMTreeBelowSG>();

    protected abstract void setConfig();

    protected abstract void rollBackConfig();

    @Before
    public void setUp() throws Exception {
        this.setConfig();
        EnvironmentUtils.envSetUp();
        this.root = new ConfigMTree();
    }

    @After
    public void tearDown() throws Exception {
        this.root.clear();
        this.root = null;
        for (IMTreeBelowSG mtree : this.usedMTree) {
            mtree.clear();
        }
        this.usedMTree.clear();
        this.storageGroup = null;
        EnvironmentUtils.cleanEnv();
        this.rollBackConfig();
    }

    private IMTreeBelowSG getStorageGroup(PartialPath path) throws MetadataException {
        try {
            this.root.setStorageGroup(path);
            Object mtree = SchemaEngineMode.valueOf((String)IoTDBDescriptor.getInstance().getConfig().getSchemaEngineMode()).equals((Object)SchemaEngineMode.Schema_File) ? new MTreeBelowSGCachedImpl(this.root.getStorageGroupNodeByStorageGroupPath(path), 0) : new MTreeBelowSGMemoryImpl(this.root.getStorageGroupNodeByStorageGroupPath(path), 0);
            this.usedMTree.add((IMTreeBelowSG)mtree);
            return mtree;
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Test
    public void testAddLeftNodePathWithAlias() throws MetadataException {
        this.storageGroup = this.getStorageGroup(new PartialPath("root.laptop"));
        try {
            this.storageGroup.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), "status");
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            this.storageGroup.createTimeseries(new PartialPath("root.laptop.d1.s2"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), "status");
        }
        catch (MetadataException e) {
            Assert.assertTrue((boolean)(e instanceof AliasAlreadyExistException));
        }
    }

    @Test
    public void testAddAndPathExist() throws MetadataException {
        this.storageGroup = this.getStorageGroup(new PartialPath("root.laptop"));
        Assert.assertFalse((boolean)this.storageGroup.isPathExist(new PartialPath("root.laptop.d1")));
        try {
            this.storageGroup.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        }
        catch (MetadataException e1) {
            Assert.fail((String)e1.getMessage());
        }
        Assert.assertTrue((boolean)this.storageGroup.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)this.storageGroup.isPathExist(new PartialPath("root.laptop")));
        Assert.assertFalse((boolean)this.storageGroup.isPathExist(new PartialPath("root.laptop.d1.s2")));
    }

    @Test
    public void testAddAndQueryPath() {
        try {
            Assert.assertFalse((boolean)this.root.isStorageGroupAlreadySet(new PartialPath("root.a")));
            Assert.assertFalse((boolean)this.root.checkStorageGroupByPath(new PartialPath("root.a")));
            this.storageGroup = this.getStorageGroup(new PartialPath("root.a"));
            this.storageGroup.createTimeseries(new PartialPath("root.a.d0.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            this.storageGroup.createTimeseries(new PartialPath("root.a.d0.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            this.storageGroup.createTimeseries(new PartialPath("root.a.d1.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            this.storageGroup.createTimeseries(new PartialPath("root.a.d1.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            this.storageGroup.createTimeseries(new PartialPath("root.a.b.d0.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
        }
        try {
            Assert.assertNotNull((Object)this.storageGroup);
            List result = this.storageGroup.getMeasurementPaths(new PartialPath("root.a.*.s0"));
            result.sort(Comparator.comparing(PartialPath::getFullPath));
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertEquals((Object)"root.a.d0.s0", (Object)((MeasurementPath)result.get(0)).getFullPath());
            Assert.assertEquals((Object)"root.a.d1.s0", (Object)((MeasurementPath)result.get(1)).getFullPath());
            result = this.storageGroup.getMeasurementPaths(new PartialPath("root.a.*.*.s0"));
            Assert.assertEquals((Object)"root.a.b.d0.s0", (Object)((MeasurementPath)result.get(0)).getFullPath());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAddAndQueryPathWithAlias() {
        try {
            Assert.assertFalse((boolean)this.root.isStorageGroupAlreadySet(new PartialPath("root.a")));
            Assert.assertFalse((boolean)this.root.checkStorageGroupByPath(new PartialPath("root.a")));
            this.storageGroup = this.getStorageGroup(new PartialPath("root.a"));
            this.storageGroup.createTimeseries(new PartialPath("root.a.d0.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), "temperature");
            this.storageGroup.createTimeseries(new PartialPath("root.a.d0.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), "status");
            this.storageGroup.createTimeseries(new PartialPath("root.a.d1.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), "temperature");
            this.storageGroup.createTimeseries(new PartialPath("root.a.d1.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            this.storageGroup.createTimeseries(new PartialPath("root.a.b.d0.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
        }
        try {
            Assert.assertNotNull((Object)this.storageGroup);
            List result = this.storageGroup.getMeasurementPaths(new PartialPath("root.a.*.s0"));
            result.sort(Comparator.comparing(PartialPath::getFullPath));
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertEquals((Object)"root.a.d0.s0", (Object)((MeasurementPath)result.get(0)).getFullPath());
            Assert.assertEquals((Object)"root.a.d1.s0", (Object)((MeasurementPath)result.get(1)).getFullPath());
            result = this.storageGroup.getMeasurementPaths(new PartialPath("root.a.*.temperature"));
            result.sort(Comparator.comparing(PartialPath::getFullPath));
            Assert.assertEquals((long)2L, (long)result.size());
            Assert.assertEquals((Object)"root.a.d0.s0", (Object)((MeasurementPath)result.get(0)).getFullPath());
            Assert.assertEquals((Object)"root.a.d1.s0", (Object)((MeasurementPath)result.get(1)).getFullPath());
            List result2 = (List)this.storageGroup.getMeasurementPathsWithAlias((PartialPath)new PartialPath((String)"root.a.*.s0"), (int)0, (int)0, (boolean)false).left;
            result2.sort(Comparator.comparing(PartialPath::getFullPath));
            Assert.assertEquals((long)2L, (long)result2.size());
            Assert.assertEquals((Object)"root.a.d0.s0", (Object)((MeasurementPath)result2.get(0)).getFullPath());
            Assert.assertFalse((boolean)((MeasurementPath)result2.get(0)).isMeasurementAliasExists());
            Assert.assertEquals((Object)"root.a.d1.s0", (Object)((MeasurementPath)result2.get(1)).getFullPath());
            Assert.assertFalse((boolean)((MeasurementPath)result2.get(1)).isMeasurementAliasExists());
            result2 = (List)this.storageGroup.getMeasurementPathsWithAlias((PartialPath)new PartialPath((String)"root.a.*.temperature"), (int)0, (int)0, (boolean)false).left;
            result2.sort(Comparator.comparing(PartialPath::getFullPath));
            Assert.assertEquals((long)2L, (long)result2.size());
            Assert.assertEquals((Object)"root.a.d0.temperature", (Object)((MeasurementPath)result2.get(0)).getFullPathWithAlias());
            Assert.assertEquals((Object)"root.a.d1.temperature", (Object)((MeasurementPath)result2.get(1)).getFullPathWithAlias());
            Pair result3 = this.storageGroup.getMeasurementPathsWithAlias(new PartialPath("root.a.**"), 2, 0, false);
            Assert.assertEquals((long)2L, (long)((List)result3.left).size());
            Assert.assertEquals((long)2L, (long)((Integer)result3.right).intValue());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetAllChildNodeNamesByPath() {
        try {
            this.storageGroup = this.getStorageGroup(new PartialPath("root.a"));
            this.storageGroup.createTimeseries(new PartialPath("root.a.d0.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            this.storageGroup.createTimeseries(new PartialPath("root.a.d0.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            this.storageGroup.createTimeseries(new PartialPath("root.a.d5"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            Set result1 = this.storageGroup.getChildNodeNameInNextLevel(new PartialPath("root.a.d0"));
            Set result2 = this.storageGroup.getChildNodeNameInNextLevel(new PartialPath("root.a"));
            Assert.assertEquals(new HashSet<String>(Arrays.asList("s0", "s1")), (Object)result1);
            Assert.assertEquals(new HashSet<String>(Arrays.asList("d0", "d5")), (Object)result2);
            Set result3 = this.storageGroup.getChildNodeNameInNextLevel(new PartialPath("root.a.d5"));
            Assert.assertEquals((Object)result3, new HashSet(Collections.emptyList()));
            Set result4 = this.storageGroup.getChildNodeNameInNextLevel(new PartialPath("root"));
            Assert.assertEquals(new HashSet<String>(Collections.singletonList("a")), (Object)result4);
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
        }
    }

    @Test
    public void testSetStorageGroup() throws MetadataException {
        try {
            this.storageGroup = this.getStorageGroup(new PartialPath("root.laptop.d1"));
            Assert.assertTrue((boolean)this.root.isStorageGroupAlreadySet(new PartialPath("root.laptop.d1")));
            Assert.assertTrue((boolean)this.root.checkStorageGroupByPath(new PartialPath("root.laptop.d1")));
            Assert.assertEquals((Object)"root.laptop.d1", (Object)this.root.getBelongedStorageGroup(new PartialPath("root.laptop.d1")).getFullPath());
            Assert.assertTrue((boolean)this.root.checkStorageGroupByPath(new PartialPath("root.laptop.d1.s1")));
            Assert.assertEquals((Object)"root.laptop.d1", (Object)this.root.getBelongedStorageGroup(new PartialPath("root.laptop.d1.s1")).getFullPath());
            Assert.assertFalse((boolean)this.storageGroup.isPathExist(new PartialPath("root.laptop.d1.s1")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            this.root.setStorageGroup(new PartialPath("root.laptop"));
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"some children of root.laptop have already been set to storage group", (Object)e.getMessage());
        }
        Assert.assertFalse((boolean)this.storageGroup.isPathExist(new PartialPath("root.laptop.d1.s0")));
        Assert.assertFalse((boolean)this.storageGroup.isPathExist(new PartialPath("root.laptop.d1.s1")));
        try {
            Assert.assertEquals((Object)"root.laptop.d1", (Object)this.root.getBelongedStorageGroup(new PartialPath("root.laptop.d1.s0")).getFullPath());
            this.storageGroup.createTimeseries(new PartialPath("root.laptop.d1.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            Assert.assertEquals((Object)"root.laptop.d1", (Object)this.root.getBelongedStorageGroup(new PartialPath("root.laptop.d1.s1")).getFullPath());
            this.storageGroup.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            this.storageGroup.deleteTimeseriesAndReturnEmptyStorageGroup(new PartialPath("root.laptop.d1.s0"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)this.storageGroup.isPathExist(new PartialPath("root.laptop.d1.s0")));
        try {
            this.root.deleteStorageGroup(new PartialPath("root.laptop.d1"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)this.root.isStorageGroupAlreadySet(new PartialPath("root.laptop.d1.s1")));
        Assert.assertFalse((boolean)this.root.isStorageGroupAlreadySet(new PartialPath("root.laptop.d1")));
        Assert.assertFalse((boolean)this.root.isStorageGroupAlreadySet(new PartialPath("root.laptop")));
    }

    @Test
    public void testGetAllTimeseriesCount() {
        try {
            this.storageGroup = this.getStorageGroup(new PartialPath("root.laptop"));
            this.storageGroup.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
            this.storageGroup.createTimeseries(new PartialPath("root.laptop.d1.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
            this.storageGroup.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
            this.storageGroup.createTimeseries(new PartialPath("root.laptop.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
            Assert.assertEquals((long)4L, (long)this.storageGroup.getAllTimeseriesCount(new PartialPath("root.laptop.**")));
            Assert.assertEquals((long)2L, (long)this.storageGroup.getAllTimeseriesCount(new PartialPath("root.laptop.*.s1")));
            Assert.assertEquals((long)0L, (long)this.storageGroup.getAllTimeseriesCount(new PartialPath("root.laptop.d1.s3")));
            Assert.assertEquals((long)1L, (long)this.storageGroup.getNodesCountInGivenLevel(new PartialPath("root.laptop.**.s1"), 1, false));
            Assert.assertEquals((long)1L, (long)this.storageGroup.getNodesCountInGivenLevel(new PartialPath("root.laptop.*.*"), 1, false));
            Assert.assertEquals((long)2L, (long)this.storageGroup.getNodesCountInGivenLevel(new PartialPath("root.laptop.*.*"), 2, false));
            Assert.assertEquals((long)2L, (long)this.storageGroup.getNodesCountInGivenLevel(new PartialPath("root.laptop.*"), 2, false));
            Assert.assertEquals((long)4L, (long)this.storageGroup.getNodesCountInGivenLevel(new PartialPath("root.laptop.*.*"), 3, false));
            Assert.assertEquals((long)2L, (long)this.storageGroup.getNodesCountInGivenLevel(new PartialPath("root.laptop.**"), 2, false));
            Assert.assertEquals((long)4L, (long)this.storageGroup.getNodesCountInGivenLevel(new PartialPath("root.laptop.**"), 3, false));
            Assert.assertEquals((long)2L, (long)this.storageGroup.getNodesCountInGivenLevel(new PartialPath("root.laptop.d1.*"), 3, false));
            Assert.assertEquals((long)0L, (long)this.storageGroup.getNodesCountInGivenLevel(new PartialPath("root.laptop.d1.**"), 4, false));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testAddSubDevice() throws MetadataException {
        this.storageGroup = this.getStorageGroup(new PartialPath("root.laptop"));
        this.storageGroup.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        this.storageGroup.createTimeseries(new PartialPath("root.laptop.d1.s2.b"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        Assert.assertEquals((long)2L, (long)this.storageGroup.getDevices(new PartialPath("root"), true).size());
        Assert.assertEquals((long)2L, (long)this.storageGroup.getDevices(new PartialPath("root.**"), false).size());
        Assert.assertEquals((long)2L, (long)this.storageGroup.getAllTimeseriesCount(new PartialPath("root.**")));
        Assert.assertEquals((long)2L, (long)this.storageGroup.getMeasurementPaths(new PartialPath("root.**")).size());
        Assert.assertEquals((long)2L, (long)((List)this.storageGroup.getMeasurementPathsWithAlias((PartialPath)new PartialPath((String)"root.**"), (int)0, (int)0, (boolean)false).left).size());
    }

    @Test
    public void testSearchStorageGroup() throws MetadataException {
        String path1 = "root";
        String sgPath1 = "root.vehicle";
        this.storageGroup = this.getStorageGroup(new PartialPath(sgPath1));
        Assert.assertTrue((boolean)this.root.isStorageGroupAlreadySet(new PartialPath(path1)));
        try {
            this.storageGroup.createTimeseries(new PartialPath("root.vehicle.d1.s1"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
            this.storageGroup.createTimeseries(new PartialPath("root.vehicle.d1.s2"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        }
        catch (MetadataException e1) {
            Assert.fail((String)e1.getMessage());
        }
        Assert.assertEquals((Object)this.root.getBelongedStorageGroups(new PartialPath("root.vehicle.d1.s1")), Collections.singletonList(new PartialPath(sgPath1)));
    }

    @Test
    public void testCreateTimeseries() throws MetadataException {
        String sgPath = "root.sg1";
        this.storageGroup = this.getStorageGroup(new PartialPath(sgPath));
        this.storageGroup.createTimeseries(new PartialPath("root.sg1.a.b.c"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        try {
            this.storageGroup.createTimeseries(new PartialPath("root.sg1.a.b"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap(), null);
        }
        catch (PathAlreadyExistException e) {
            Assert.assertEquals((Object)"Path [root.sg1.a.b] already exist", (Object)e.getMessage());
        }
        IMNode node = this.storageGroup.getNodeByPath(new PartialPath("root.sg1.a.b"));
        Assert.assertFalse((boolean)(node instanceof MeasurementMNode));
    }

    @Test
    public void testCountEntity() throws MetadataException {
        this.storageGroup = this.getStorageGroup(new PartialPath("root.laptop"));
        this.storageGroup.createTimeseries(new PartialPath("root.laptop.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        this.storageGroup.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        this.storageGroup.createTimeseries(new PartialPath("root.laptop.d2.s1.t1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        this.storageGroup.createTimeseries(new PartialPath("root.laptop.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        this.storageGroup.createTimeseries(new PartialPath("root.laptop.a.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        Assert.assertEquals((long)0L, (long)this.storageGroup.getDevicesNum(new PartialPath("root")));
        Assert.assertEquals((long)1L, (long)this.storageGroup.getDevicesNum(new PartialPath("root.laptop")));
        Assert.assertEquals((long)0L, (long)this.storageGroup.getDevicesNum(new PartialPath("root.laptop.s1")));
        Assert.assertEquals((long)1L, (long)this.storageGroup.getDevicesNum(new PartialPath("root.laptop.d1")));
        Assert.assertEquals((long)2L, (long)this.storageGroup.getDevicesNum(new PartialPath("root.laptop.*")));
        Assert.assertEquals((long)2L, (long)this.storageGroup.getDevicesNum(new PartialPath("root.laptop.*.*")));
        Assert.assertEquals((long)0L, (long)this.storageGroup.getDevicesNum(new PartialPath("root.laptop.*.*.*")));
        Assert.assertEquals((long)4L, (long)this.storageGroup.getDevicesNum(new PartialPath("root.laptop.**")));
        Assert.assertEquals((long)5L, (long)this.storageGroup.getDevicesNum(new PartialPath("root.**")));
        Assert.assertEquals((long)4L, (long)this.storageGroup.getDevicesNum(new PartialPath("root.**.*")));
        Assert.assertEquals((long)4L, (long)this.storageGroup.getDevicesNum(new PartialPath("root.*.**")));
        Assert.assertEquals((long)2L, (long)this.storageGroup.getDevicesNum(new PartialPath("root.**.d1")));
        Assert.assertEquals((long)1L, (long)this.storageGroup.getDevicesNum(new PartialPath("root.laptop.*.d1")));
        Assert.assertEquals((long)3L, (long)this.storageGroup.getDevicesNum(new PartialPath("root.**.d*")));
        Assert.assertEquals((long)1L, (long)this.storageGroup.getDevicesNum(new PartialPath("root.laptop.**.s1")));
        Assert.assertEquals((long)1L, (long)this.storageGroup.getDevicesNum(new PartialPath("root.*.d2.*")));
    }

    @Test
    public void testGetNodeListInLevel() throws MetadataException {
        LocalSchemaProcessor.StorageGroupFilter filter = sg -> sg.equals("root.sg1");
        this.storageGroup = this.getStorageGroup(new PartialPath("root.sg1"));
        this.storageGroup.createTimeseries(new PartialPath("root.sg1.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        this.storageGroup.createTimeseries(new PartialPath("root.sg1.d1.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        Assert.assertEquals((long)2L, (long)this.storageGroup.getNodesListInGivenLevel(new PartialPath("root.**"), 3, false, null).size());
        Assert.assertEquals((long)1L, (long)this.storageGroup.getNodesListInGivenLevel(new PartialPath("root.*.*"), 2, false, null).size());
        Assert.assertEquals((long)1L, (long)this.storageGroup.getNodesListInGivenLevel(new PartialPath("root.*.*"), 1, false, null).size());
        Assert.assertEquals((long)1L, (long)this.storageGroup.getNodesListInGivenLevel(new PartialPath("root.*.*.s1"), 2, false, null).size());
        Assert.assertEquals((long)2L, (long)this.storageGroup.getNodesListInGivenLevel(new PartialPath("root.**"), 3, false, filter).size());
        Assert.assertEquals((long)1L, (long)this.storageGroup.getNodesListInGivenLevel(new PartialPath("root.*.**"), 2, false, filter).size());
        this.storageGroup = this.getStorageGroup(new PartialPath("root.sg2"));
        this.storageGroup.createTimeseries(new PartialPath("root.sg2.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        this.storageGroup.createTimeseries(new PartialPath("root.sg2.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        Assert.assertEquals((long)2L, (long)this.storageGroup.getNodesListInGivenLevel(new PartialPath("root.**"), 3, false, null).size());
        Assert.assertEquals((long)2L, (long)this.storageGroup.getNodesListInGivenLevel(new PartialPath("root.*.*"), 2, false, null).size());
        Assert.assertEquals((long)1L, (long)this.storageGroup.getNodesListInGivenLevel(new PartialPath("root.*.*"), 1, false, null).size());
        Assert.assertEquals((long)2L, (long)this.storageGroup.getNodesListInGivenLevel(new PartialPath("root.*.*.s1"), 2, false, null).size());
        Assert.assertEquals((long)0L, (long)this.storageGroup.getNodesListInGivenLevel(new PartialPath("root.**"), 3, false, filter).size());
        Assert.assertEquals((long)0L, (long)this.storageGroup.getNodesListInGivenLevel(new PartialPath("root.*.**"), 2, false, filter).size());
    }

    @Test
    public void testGetDeviceForTimeseries() throws MetadataException {
        this.storageGroup = this.getStorageGroup(new PartialPath("root.sg"));
        this.storageGroup.createTimeseries(new PartialPath("root.sg.a1.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        this.storageGroup.createTimeseries(new PartialPath("root.sg.a1.d1.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        this.storageGroup.createTimeseries(new PartialPath("root.sg.a2.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        this.storageGroup.createTimeseries(new PartialPath("root.sg.a2.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        Assert.assertEquals((long)2L, (long)this.storageGroup.getDevicesByTimeseries(new PartialPath("root.**")).size());
        Assert.assertEquals((long)1L, (long)this.storageGroup.getDevicesByTimeseries(new PartialPath("root.*.*.d1.*")).size());
        Assert.assertEquals((long)2L, (long)this.storageGroup.getDevicesByTimeseries(new PartialPath("root.*.*.d*.*")).size());
    }

    @Test
    public void testGetMeasurementCountGroupByLevel() throws Exception {
        this.storageGroup = this.getStorageGroup(new PartialPath("root.sg"));
        this.storageGroup.createTimeseries(new PartialPath("root.sg.a1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        this.storageGroup.createTimeseries(new PartialPath("root.sg.a1.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        this.storageGroup.createTimeseries(new PartialPath("root.sg.a1.d1.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        this.storageGroup.createTimeseries(new PartialPath("root.sg.a2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        this.storageGroup.createTimeseries(new PartialPath("root.sg.a2.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null);
        PartialPath pattern = new PartialPath("root.sg.**");
        Map result = this.storageGroup.getMeasurementCountGroupByLevel(pattern, 2, false);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)3L, (long)((Integer)result.get(new PartialPath("root.sg.a1"))).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)result.get(new PartialPath("root.sg.a2"))).intValue());
        result = this.storageGroup.getMeasurementCountGroupByLevel(pattern, 3, false);
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((long)1L, (long)((Integer)result.get(new PartialPath("root.sg.a1.s1"))).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)result.get(new PartialPath("root.sg.a1.d1"))).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)result.get(new PartialPath("root.sg.a2.s1"))).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)result.get(new PartialPath("root.sg.a2.d1"))).intValue());
        result = this.storageGroup.getMeasurementCountGroupByLevel(pattern, 5, false);
        Assert.assertEquals((long)0L, (long)result.size());
        pattern = new PartialPath("root.**.s1");
        result = this.storageGroup.getMeasurementCountGroupByLevel(pattern, 2, false);
        Assert.assertEquals((long)2L, (long)result.size());
        Assert.assertEquals((long)2L, (long)((Integer)result.get(new PartialPath("root.sg.a1"))).intValue());
        Assert.assertEquals((long)2L, (long)((Integer)result.get(new PartialPath("root.sg.a2"))).intValue());
        result = this.storageGroup.getMeasurementCountGroupByLevel(pattern, 3, false);
        Assert.assertEquals((long)4L, (long)result.size());
        Assert.assertEquals((long)1L, (long)((Integer)result.get(new PartialPath("root.sg.a1.s1"))).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)result.get(new PartialPath("root.sg.a1.d1"))).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)result.get(new PartialPath("root.sg.a2.s1"))).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)result.get(new PartialPath("root.sg.a2.d1"))).intValue());
    }
}

