/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mtree.ConfigMTree;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.utils.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConfigMTreeTest {
    private ConfigMTree root;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        this.root = new ConfigMTree();
    }

    @After
    public void tearDown() throws Exception {
        this.root.clear();
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testSetStorageGroupExceptionMessage() {
        try {
            this.root.setStorageGroup(new PartialPath("root.edge1.access"));
            this.root.setStorageGroup(new PartialPath("root.edge1"));
            Assert.fail((String)"Expected exception");
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"some children of root.edge1 have already been set to storage group", (Object)e.getMessage());
        }
        try {
            this.root.setStorageGroup(new PartialPath("root.edge2"));
            this.root.setStorageGroup(new PartialPath("root.edge2.access"));
            Assert.fail((String)"Expected exception");
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"root.edge2 has already been set to storage group", (Object)e.getMessage());
        }
        try {
            this.root.setStorageGroup(new PartialPath("root.edge1.access"));
            Assert.fail((String)"Expected exception");
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"root.edge1.access has already been set to storage group", (Object)e.getMessage());
        }
    }

    @Test
    public void testAddAndPathExist() throws MetadataException {
        String path1 = "root";
        this.root.setStorageGroup(new PartialPath("root.laptop"));
        Assert.assertTrue((boolean)this.root.isStorageGroupAlreadySet(new PartialPath(path1)));
        Assert.assertTrue((boolean)this.root.isStorageGroupAlreadySet(new PartialPath("root.laptop")));
        Assert.assertTrue((boolean)this.root.isStorageGroupAlreadySet(new PartialPath("root.laptop.d1")));
    }

    @Test
    public void testGetAllChildNodeNamesByPath() {
        try {
            this.root.setStorageGroup(new PartialPath("root.a.d0"));
            this.root.setStorageGroup(new PartialPath("root.a.d5"));
            Set result1 = (Set)this.root.getChildNodeNameInNextLevel((PartialPath)new PartialPath((String)"root.a.d0")).left;
            Set result2 = (Set)this.root.getChildNodeNameInNextLevel((PartialPath)new PartialPath((String)"root.a")).left;
            Set result3 = (Set)this.root.getChildNodeNameInNextLevel((PartialPath)new PartialPath((String)"root")).left;
            Assert.assertEquals(new HashSet(), (Object)result1);
            Assert.assertEquals(new HashSet<String>(Arrays.asList("d0", "d5")), (Object)result2);
            Assert.assertEquals(new HashSet<String>(Collections.singletonList("a")), (Object)result3);
            Set result4 = (Set)this.root.getChildNodeNameInNextLevel((PartialPath)new PartialPath((String)"root.a.d5")).left;
            Assert.assertEquals((Object)result4, new HashSet(Collections.emptyList()));
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
        }
    }

    @Test
    public void testSetStorageGroup() throws IllegalPathException {
        try {
            this.root.setStorageGroup(new PartialPath("root.laptop.d1"));
            Assert.assertTrue((boolean)this.root.isStorageGroupAlreadySet(new PartialPath("root.laptop.d1")));
            Assert.assertTrue((boolean)this.root.checkStorageGroupByPath(new PartialPath("root.laptop.d1")));
            Assert.assertEquals((Object)"root.laptop.d1", (Object)this.root.getBelongedStorageGroup(new PartialPath("root.laptop.d1")).getFullPath());
            Assert.assertTrue((boolean)this.root.isStorageGroupAlreadySet(new PartialPath("root.laptop.d1.s1")));
            Assert.assertTrue((boolean)this.root.checkStorageGroupByPath(new PartialPath("root.laptop.d1.s1")));
            Assert.assertEquals((Object)"root.laptop.d1", (Object)this.root.getBelongedStorageGroup(new PartialPath("root.laptop.d1.s1")).getFullPath());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            this.root.setStorageGroup(new PartialPath("root.laptop.d2"));
        }
        catch (MetadataException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            this.root.setStorageGroup(new PartialPath("root.laptop"));
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"some children of root.laptop have already been set to storage group", (Object)e.getMessage());
        }
        try {
            this.root.deleteStorageGroup(new PartialPath("root.laptop.d1"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)this.root.isStorageGroupAlreadySet(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)this.root.isStorageGroupAlreadySet(new PartialPath("root.laptop")));
        Assert.assertTrue((boolean)this.root.isStorageGroupAlreadySet(new PartialPath("root.laptop.d2")));
    }

    @Test
    public void testCheckStorageGroup() {
        try {
            Assert.assertFalse((boolean)this.root.isStorageGroup(new PartialPath("root")));
            Assert.assertFalse((boolean)this.root.isStorageGroup(new PartialPath("root1.laptop.d2")));
            this.root.setStorageGroup(new PartialPath("root.laptop.d1"));
            Assert.assertTrue((boolean)this.root.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertFalse((boolean)this.root.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)this.root.isStorageGroup(new PartialPath("root.laptop")));
            Assert.assertFalse((boolean)this.root.isStorageGroup(new PartialPath("root.laptop.d1.s1")));
            this.root.setStorageGroup(new PartialPath("root.laptop.d2"));
            Assert.assertTrue((boolean)this.root.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertTrue((boolean)this.root.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)this.root.isStorageGroup(new PartialPath("root.laptop.d3")));
            this.root.setStorageGroup(new PartialPath("root.`1`"));
            Assert.assertTrue((boolean)this.root.isStorageGroup(new PartialPath("root.`1`")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetAllFileNamesByPath() {
        try {
            this.root.setStorageGroup(new PartialPath("root.laptop.d1"));
            this.root.setStorageGroup(new PartialPath("root.laptop.d2"));
            ArrayList<PartialPath> list = new ArrayList<PartialPath>();
            list.add(new PartialPath("root.laptop.d1"));
            Assert.assertEquals(list, (Object)this.root.getBelongedStorageGroups(new PartialPath("root.laptop.d1.s1")));
            Assert.assertEquals(list, (Object)this.root.getBelongedStorageGroups(new PartialPath("root.laptop.d1")));
            list.add(new PartialPath("root.laptop.d2"));
            Assert.assertEquals(list, (Object)this.root.getBelongedStorageGroups(new PartialPath("root.laptop.**")));
            Assert.assertEquals(list, (Object)this.root.getBelongedStorageGroups(new PartialPath("root.**")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCheckStorageExistOfPath() {
        try {
            Assert.assertTrue((boolean)this.root.getBelongedStorageGroups(new PartialPath("root")).isEmpty());
            Assert.assertTrue((boolean)this.root.getBelongedStorageGroups(new PartialPath("root.vehicle")).isEmpty());
            Assert.assertTrue((boolean)this.root.getBelongedStorageGroups(new PartialPath("root.vehicle.device0")).isEmpty());
            Assert.assertTrue((boolean)this.root.getBelongedStorageGroups(new PartialPath("root.vehicle.device0.sensor")).isEmpty());
            this.root.setStorageGroup(new PartialPath("root.vehicle"));
            Assert.assertFalse((boolean)this.root.getBelongedStorageGroups(new PartialPath("root.vehicle")).isEmpty());
            Assert.assertFalse((boolean)this.root.getBelongedStorageGroups(new PartialPath("root.vehicle.device0")).isEmpty());
            Assert.assertFalse((boolean)this.root.getBelongedStorageGroups(new PartialPath("root.vehicle.device0.sensor")).isEmpty());
            Assert.assertTrue((boolean)this.root.getBelongedStorageGroups(new PartialPath("root.vehicle1")).isEmpty());
            Assert.assertTrue((boolean)this.root.getBelongedStorageGroups(new PartialPath("root.vehicle1.device0")).isEmpty());
            this.root.setStorageGroup(new PartialPath("root.vehicle1.device0"));
            Assert.assertTrue((boolean)this.root.getBelongedStorageGroups(new PartialPath("root.vehicle1.device1")).isEmpty());
            Assert.assertTrue((boolean)this.root.getBelongedStorageGroups(new PartialPath("root.vehicle1.device2")).isEmpty());
            Assert.assertTrue((boolean)this.root.getBelongedStorageGroups(new PartialPath("root.vehicle1.device3")).isEmpty());
            Assert.assertFalse((boolean)this.root.getBelongedStorageGroups(new PartialPath("root.vehicle1.device0")).isEmpty());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testIllegalStorageGroup() {
        try {
            this.root.setStorageGroup(new PartialPath("root.\"sg.ln\""));
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"root.\"sg.ln\" is not a legal path", (Object)e.getMessage());
        }
    }

    @Test
    public void testCountStorageGroup() throws MetadataException {
        this.root.setStorageGroup(new PartialPath("root.sg1"));
        this.root.setStorageGroup(new PartialPath("root.a.sg1"));
        this.root.setStorageGroup(new PartialPath("root.a.b.sg1"));
        this.root.setStorageGroup(new PartialPath("root.sg2"));
        this.root.setStorageGroup(new PartialPath("root.a.sg2"));
        this.root.setStorageGroup(new PartialPath("root.sg3"));
        this.root.setStorageGroup(new PartialPath("root.a.b.sg3"));
        Assert.assertEquals((long)7L, (long)this.root.getStorageGroupNum(new PartialPath("root.**"), false));
        Assert.assertEquals((long)3L, (long)this.root.getStorageGroupNum(new PartialPath("root.*"), false));
        Assert.assertEquals((long)2L, (long)this.root.getStorageGroupNum(new PartialPath("root.*.*"), false));
        Assert.assertEquals((long)2L, (long)this.root.getStorageGroupNum(new PartialPath("root.*.*.*"), false));
        Assert.assertEquals((long)1L, (long)this.root.getStorageGroupNum(new PartialPath("root.*.sg1"), false));
        Assert.assertEquals((long)2L, (long)this.root.getStorageGroupNum(new PartialPath("root.**.sg1"), false));
        Assert.assertEquals((long)1L, (long)this.root.getStorageGroupNum(new PartialPath("root.sg3"), false));
        Assert.assertEquals((long)2L, (long)this.root.getStorageGroupNum(new PartialPath("root.*.b.*"), false));
    }

    @Test
    public void testGetNodeListInLevel() throws MetadataException {
        this.root.setStorageGroup(new PartialPath("root.sg1"));
        this.root.setStorageGroup(new PartialPath("root.sg2"));
        LocalSchemaProcessor.StorageGroupFilter filter = storageGroup -> storageGroup.equals("root.sg1");
        Pair result = this.root.getNodesListInGivenLevel(new PartialPath("root.**"), 3, false, null);
        Assert.assertEquals((long)0L, (long)((List)result.left).size());
        Assert.assertEquals((long)2L, (long)((Set)result.right).size());
        result = this.root.getNodesListInGivenLevel(new PartialPath("root.**"), 1, false, null);
        Assert.assertEquals((long)2L, (long)((List)result.left).size());
        Assert.assertEquals((long)2L, (long)((Set)result.right).size());
        result = this.root.getNodesListInGivenLevel(new PartialPath("root.*.*"), 2, false, null);
        Assert.assertEquals((long)0L, (long)((List)result.left).size());
        Assert.assertEquals((long)2L, (long)((Set)result.right).size());
        result = this.root.getNodesListInGivenLevel(new PartialPath("root.*.*"), 1, false, null);
        Assert.assertEquals((long)0L, (long)((List)result.left).size());
        Assert.assertEquals((long)2L, (long)((Set)result.right).size());
        result = this.root.getNodesListInGivenLevel(new PartialPath("root.**"), 3, false, filter);
        Assert.assertEquals((long)0L, (long)((List)result.left).size());
        Assert.assertEquals((long)1L, (long)((Set)result.right).size());
        result = this.root.getNodesListInGivenLevel(new PartialPath("root.*.**"), 2, false, filter);
        Assert.assertEquals((long)0L, (long)((List)result.left).size());
        Assert.assertEquals((long)1L, (long)((Set)result.right).size());
    }

    @Test
    public void testSerialization() throws Exception {
        PartialPath[] pathList = new PartialPath[]{new PartialPath("root.sg"), new PartialPath("root.a.sg"), new PartialPath("root.a.b.sg"), new PartialPath("root.a.a.b.sg")};
        for (int i = 0; i < pathList.length; ++i) {
            this.root.setStorageGroup(pathList[i]);
            IStorageGroupMNode storageGroupMNode = this.root.getStorageGroupNodeByStorageGroupPath(pathList[i]);
            storageGroupMNode.setDataTTL((long)i);
            storageGroupMNode.setDataReplicationFactor(i);
            storageGroupMNode.setSchemaReplicationFactor(i);
            storageGroupMNode.setTimePartitionInterval((long)i);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        this.root.serialize((OutputStream)outputStream);
        ConfigMTree newTree = new ConfigMTree();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        newTree.deserialize((InputStream)inputStream);
        for (int i = 0; i < pathList.length; ++i) {
            newTree.isStorageGroup(pathList[i]);
            TStorageGroupSchema storageGroupSchema = newTree.getStorageGroupNodeByStorageGroupPath(pathList[i]).getStorageGroupSchema();
            Assert.assertEquals((long)i, (long)storageGroupSchema.getTTL());
            Assert.assertEquals((long)i, (long)storageGroupSchema.getSchemaReplicationFactor());
            Assert.assertEquals((long)i, (long)storageGroupSchema.getDataReplicationFactor());
            Assert.assertEquals((long)i, (long)storageGroupSchema.getTimePartitionInterval());
        }
        Assert.assertEquals((long)3L, (long)newTree.getMatchedStorageGroups(new PartialPath("root.**.sg"), false).size());
        Assert.assertEquals((long)2L, (long)newTree.getMatchedStorageGroups(new PartialPath("root.**.b.sg"), false).size());
        Assert.assertEquals((long)1L, (long)newTree.getMatchedStorageGroups(new PartialPath("root.*.*.sg"), false).size());
    }

    @Test
    public void testSetTemplate() throws MetadataException {
        this.root.setStorageGroup(new PartialPath("root.a"));
        PartialPath path = new PartialPath("root.a.template0");
        try {
            this.root.checkTemplateOnPath(path);
        }
        catch (MetadataException e) {
            Assert.fail();
        }
        IMNode node = this.root.getNodeWithAutoCreate(path);
        node.setSchemaTemplateId(0);
        try {
            this.root.checkTemplateOnPath(path);
            Assert.fail();
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        path = new PartialPath("root.a.b.template0");
        node = this.root.getNodeWithAutoCreate(path);
        node.setSchemaTemplateId(0);
        try {
            this.root.checkTemplateOnPath(path);
            Assert.fail();
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        try {
            List pathList = this.root.getPathsSetOnTemplate(0);
            Assert.assertTrue((boolean)pathList.contains("root.a.template0"));
            Assert.assertTrue((boolean)pathList.contains("root.a.b.template0"));
        }
        catch (MetadataException e) {
            Assert.fail();
        }
    }
}

