/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.IDTableManager;
import org.apache.iotdb.db.metadata.idtable.entry.TimeseriesID;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LastQueryWithIDTable {
    private final Planner processor = new Planner();
    private boolean isEnableIDTable = false;
    private boolean originalEnableCache = false;
    private String originalDeviceIDTransformationMethod = null;
    Set<String> retSet = new HashSet<String>(Arrays.asList("113\troot.isp.d1.s3\t100003\tINT64", "113\troot.isp.d1.s4\t1003\tINT32", "113\troot.isp.d1.s5\tfalse\tBOOLEAN", "113\troot.isp.d1.s6\tmm3\tTEXT", "113\troot.isp.d1.s1\t13.0\tDOUBLE", "113\troot.isp.d1.s2\t23.0\tFLOAT"));

    @Before
    public void before() {
        IoTDBDescriptor.getInstance().getConfig().setAutoCreateSchemaEnabled(true);
        this.isEnableIDTable = IoTDBDescriptor.getInstance().getConfig().isEnableIDTable();
        this.originalDeviceIDTransformationMethod = IoTDBDescriptor.getInstance().getConfig().getDeviceIDTransformationMethod();
        this.originalEnableCache = IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled();
        IoTDBDescriptor.getInstance().getConfig().setEnableLastCache(false);
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTable(true);
        IoTDBDescriptor.getInstance().getConfig().setDeviceIDTransformationMethod("SHA256");
        EnvironmentUtils.envSetUp();
    }

    @After
    public void clean() throws IOException, StorageEngineException {
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTable(this.isEnableIDTable);
        IoTDBDescriptor.getInstance().getConfig().setDeviceIDTransformationMethod(this.originalDeviceIDTransformationMethod);
        IoTDBDescriptor.getInstance().getConfig().setEnableLastCache(this.originalEnableCache);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testLastCacheQueryWithoutCache() throws QueryProcessException, MetadataException, InterruptedException, QueryFilterOptimizationException, StorageEngineException, IOException {
        this.insertDataInMemory();
        PlanExecutor executor = new PlanExecutor();
        QueryPlan queryPlan = (QueryPlan)this.processor.parseSQLToPhysicalPlan("select last * from root.isp.d1");
        QueryDataSet dataSet = executor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertEquals((long)3L, (long)dataSet.getPaths().size());
        int count = 0;
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            Assert.assertTrue((boolean)this.retSet.contains(record.toString()));
            ++count;
        }
        Assert.assertEquals((long)this.retSet.size(), (long)count);
        PhysicalPlan flushPlan = this.processor.parseSQLToPhysicalPlan("flush");
        executor.processNonQuery(flushPlan);
        dataSet = executor.processQuery((PhysicalPlan)queryPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertEquals((long)3L, (long)dataSet.getPaths().size());
        count = 0;
        while (dataSet.hasNext()) {
            RowRecord record = dataSet.next();
            Assert.assertTrue((boolean)this.retSet.contains(record.toString()));
            ++count;
        }
        Assert.assertEquals((long)this.retSet.size(), (long)count);
        Assert.assertNull((Object)IDTableManager.getInstance().getIDTable(new PartialPath("root.isp.d1")).getLastCache(new TimeseriesID(new PartialPath("root.isp.d1.s1"))));
    }

    private void insertDataInMemory() throws IllegalPathException, QueryProcessException {
        long[] times = new long[]{110L, 111L, 112L, 113L};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.DOUBLE.ordinal());
        dataTypes.add(TSDataType.FLOAT.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        dataTypes.add(TSDataType.INT32.ordinal());
        dataTypes.add(TSDataType.BOOLEAN.ordinal());
        dataTypes.add(TSDataType.TEXT.ordinal());
        Object[] columns = new Object[]{new double[4], new float[4], new long[4], new int[4], new boolean[4], new Binary[4]};
        for (int r = 0; r < 4; ++r) {
            ((double[])columns[0])[r] = 10.0 + (double)r;
            ((float[])columns[1])[r] = 20 + r;
            ((long[])columns[2])[r] = 100000 + r;
            ((int[])columns[3])[r] = 1000 + r;
            ((boolean[])columns[4])[r] = false;
            ((Binary[])columns[5])[r] = new Binary("mm" + r);
        }
        InsertTabletPlan tabletPlan = new InsertTabletPlan(new PartialPath("root.isp.d1"), new String[]{"s1", "s2", "s3", "s4", "s5", "s6"}, dataTypes);
        tabletPlan.setTimes(times);
        tabletPlan.setColumns(columns);
        tabletPlan.setRowCount(times.length);
        PlanExecutor executor = new PlanExecutor();
        executor.insertTablet(tabletPlan);
    }
}

