/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.idtable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.trigger.service.TriggerRegistrationService;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.IDTableManager;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.idtable.entry.DiskSchemaEntry;
import org.apache.iotdb.db.metadata.idtable.entry.IDeviceID;
import org.apache.iotdb.db.metadata.idtable.entry.SchemaEntry;
import org.apache.iotdb.db.metadata.lastCache.container.ILastCacheContainer;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTriggerPlan;
import org.apache.iotdb.db.qp.physical.sys.DropTriggerPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IDTableTest {
    private CompressionType compressionType;
    private boolean isEnableIDTable = false;
    private String originalDeviceIDTransformationMethod = null;
    private boolean isEnableIDTableLogFile = false;

    @Before
    public void before() {
        this.compressionType = TSFileDescriptor.getInstance().getConfig().getCompressor();
        IoTDBDescriptor.getInstance().getConfig().setAutoCreateSchemaEnabled(true);
        this.isEnableIDTable = IoTDBDescriptor.getInstance().getConfig().isEnableIDTable();
        this.originalDeviceIDTransformationMethod = IoTDBDescriptor.getInstance().getConfig().getDeviceIDTransformationMethod();
        this.isEnableIDTableLogFile = IoTDBDescriptor.getInstance().getConfig().isEnableIDTableLogFile();
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTable(true);
        IoTDBDescriptor.getInstance().getConfig().setDeviceIDTransformationMethod("SHA256");
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTableLogFile(true);
        EnvironmentUtils.envSetUp();
    }

    @After
    public void clean() throws IOException, StorageEngineException {
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTable(this.isEnableIDTable);
        IoTDBDescriptor.getInstance().getConfig().setDeviceIDTransformationMethod(this.originalDeviceIDTransformationMethod);
        IoTDBDescriptor.getInstance().getConfig().setEnableIDTableLogFile(this.isEnableIDTableLogFile);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testCreateAlignedTimeseriesAndInsert() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            CreateAlignedTimeSeriesPlan plan = new CreateAlignedTimeSeriesPlan(new PartialPath("root.laptop.d1.aligned_device"), Arrays.asList("s1", "s2", "s3"), Arrays.asList(TSDataType.valueOf((String)"FLOAT"), TSDataType.valueOf((String)"INT64"), TSDataType.valueOf((String)"INT32")), Arrays.asList(TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE")), Arrays.asList(this.compressionType, this.compressionType, this.compressionType), null, null, null);
            schemaProcessor.createAlignedTimeSeries(plan);
            IDTable idTable = IDTableManager.getInstance().getIDTable(new PartialPath("root.laptop"));
            long time = 1L;
            TSDataType[] dataTypes = new TSDataType[]{TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32};
            String[] columns = new String[]{"2.0", "10000", "100"};
            InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.laptop.d1.aligned_device"), time, new String[]{"s1", "s2", "s3"}, dataTypes, columns, true);
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            idTable.getSeriesSchemas((InsertPlan)insertRowPlan);
            dataTypes = new TSDataType[]{TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.INT32};
            InsertRowPlan insertRowPlan2 = new InsertRowPlan(new PartialPath("root.laptop.d1.aligned_device"), time, new String[]{"s1", "s2", "s3"}, dataTypes, columns, true);
            insertRowPlan2.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            try {
                IoTDBDescriptor.getInstance().getConfig().setEnablePartialInsert(false);
                idTable.getSeriesSchemas((InsertPlan)insertRowPlan2);
                Assert.fail((String)"should throw exception");
            }
            catch (DataTypeMismatchException e) {
                Assert.assertEquals((Object)"data type of root.laptop.d1.aligned_device.s2 is not consistent, registered type INT64, inserting type DOUBLE, timestamp 1, value 10000.0", (Object)e.getMessage());
            }
            catch (Exception e2) {
                Assert.fail((String)"throw wrong exception");
            }
            IoTDBDescriptor.getInstance().getConfig().setEnablePartialInsert(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateAlignedTimeseriesAndInsertNotAlignedData() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            CreateAlignedTimeSeriesPlan plan = new CreateAlignedTimeSeriesPlan(new PartialPath("root.laptop.d1.aligned_device"), Arrays.asList("s1", "s2", "s3"), Arrays.asList(TSDataType.valueOf((String)"FLOAT"), TSDataType.valueOf((String)"INT64"), TSDataType.valueOf((String)"INT32")), Arrays.asList(TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE")), Arrays.asList(this.compressionType, this.compressionType, this.compressionType), null, null, null);
            schemaProcessor.createAlignedTimeSeries(plan);
            IDTable idTable = IDTableManager.getInstance().getIDTable(new PartialPath("root.laptop"));
            long time = 1L;
            TSDataType[] dataTypes = new TSDataType[]{TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32};
            String[] columns = new String[]{"2.0", "10000", "100"};
            InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.laptop.d1.aligned_device"), time, new String[]{"s1", "s2", "s3"}, dataTypes, columns, false);
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            try {
                idTable.getSeriesSchemas((InsertPlan)insertRowPlan);
                Assert.fail((String)"should throw exception");
            }
            catch (MetadataException e) {
                Assert.assertEquals((Object)"Timeseries under path [root.laptop.d1.aligned_device]'s align value is [true], which is not consistent with insert plan", (Object)e.getMessage());
            }
            catch (Exception e2) {
                Assert.fail((String)"throw wrong exception");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateTimeseriesAndInsert() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            IDTable idTable = IDTableManager.getInstance().getIDTable(new PartialPath("root.laptop"));
            long time = 1L;
            String[] columns = new String[]{"2"};
            InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.laptop.d1"), time, new String[]{"s0"}, new TSDataType[]{TSDataType.INT32}, columns);
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            idTable.getSeriesSchemas((InsertPlan)insertRowPlan);
            Assert.assertEquals((Object)insertRowPlan.getMeasurementMNodes()[0].getSchema().getType(), (Object)TSDataType.INT32);
            Assert.assertEquals((long)0L, (long)insertRowPlan.getFailedMeasurementNumber());
            InsertRowPlan insertRowPlan2 = new InsertRowPlan(new PartialPath("root.laptop.d1"), time, new String[]{"s0"}, new TSDataType[]{TSDataType.FLOAT}, columns);
            insertRowPlan2.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            idTable.getSeriesSchemas((InsertPlan)insertRowPlan2);
            Assert.assertNull((Object)insertRowPlan2.getMeasurementMNodes()[0]);
            Assert.assertEquals((long)1L, (long)insertRowPlan2.getFailedMeasurementNumber());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateTimeseriesAndInsertWithAlignedData() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.non_aligned_device.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.non_aligned_device.s2"), TSDataType.valueOf((String)"INT64"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            long time = 1L;
            TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64};
            String[] columns = new String[]{"1", "2"};
            InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.laptop.d1.non_aligned_device"), time, new String[]{"s1", "s2"}, dataTypes, columns, true);
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            IDTable idTable = IDTableManager.getInstance().getIDTable(new PartialPath("root.laptop"));
            try {
                idTable.getSeriesSchemas((InsertPlan)insertRowPlan);
                Assert.fail((String)"should throw exception");
            }
            catch (MetadataException e) {
                Assert.assertEquals((Object)"Timeseries under path [root.laptop.d1.non_aligned_device]'s align value is [false], which is not consistent with insert plan", (Object)e.getMessage());
            }
        }
        catch (Exception e) {
            Assert.fail((String)"throw wrong exception");
        }
    }

    @Test
    public void testInsertAndAutoCreate() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            long time = 1L;
            TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64};
            String[] columns = new String[]{"1", "2"};
            InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.laptop.d1.non_aligned_device"), time, new String[]{"s1", "s2"}, dataTypes, columns, false);
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            IDTable idTable = IDTableManager.getInstance().getIDTable(new PartialPath("root.laptop"));
            idTable.getSeriesSchemas((InsertPlan)insertRowPlan);
            IMeasurementMNode s1Node = schemaProcessor.getMeasurementMNode(new PartialPath("root.laptop.d1.non_aligned_device.s1"));
            Assert.assertEquals((Object)"s1", (Object)s1Node.getName());
            Assert.assertEquals((Object)TSDataType.INT32, (Object)s1Node.getSchema().getType());
            IMeasurementMNode s2Node = schemaProcessor.getMeasurementMNode(new PartialPath("root.laptop.d1.non_aligned_device.s2"));
            Assert.assertEquals((Object)"s2", (Object)s2Node.getName());
            Assert.assertEquals((Object)TSDataType.INT64, (Object)s2Node.getSchema().getType());
            InsertRowPlan insertRowPlan2 = new InsertRowPlan(new PartialPath("root.laptop.d1.non_aligned_device"), time, new String[]{"s1", "s2"}, new TSDataType[]{TSDataType.INT64, TSDataType.INT64}, columns, false);
            insertRowPlan2.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            idTable.getSeriesSchemas((InsertPlan)insertRowPlan2);
            Assert.assertNull((Object)insertRowPlan2.getMeasurementMNodes()[0]);
            Assert.assertEquals((Object)insertRowPlan.getMeasurementMNodes()[1].getSchema().getType(), (Object)TSDataType.INT64);
            Assert.assertEquals((long)1L, (long)insertRowPlan2.getFailedMeasurementNumber());
            InsertRowPlan insertRowPlan3 = new InsertRowPlan(new PartialPath("root.laptop.d1.non_aligned_device"), time, new String[]{"s1", "s2"}, new TSDataType[]{TSDataType.INT64, TSDataType.INT64}, columns, true);
            insertRowPlan3.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            try {
                idTable.getSeriesSchemas((InsertPlan)insertRowPlan3);
                Assert.fail((String)"should throw exception");
            }
            catch (MetadataException e) {
                Assert.assertEquals((Object)"Timeseries under path [root.laptop.d1.non_aligned_device]'s align value is [false], which is not consistent with insert plan", (Object)e.getMessage());
            }
            catch (Exception e) {
                Assert.fail((String)"throw wrong exception");
            }
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)"throw exception");
        }
    }

    @Test
    public void testAlignedInsertAndAutoCreate() {
        LocalSchemaProcessor processor = IoTDB.schemaProcessor;
        try {
            long time = 1L;
            TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64};
            String[] columns = new String[]{"1", "2"};
            InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.laptop.d1.aligned_device"), time, new String[]{"s1", "s2"}, dataTypes, columns, true);
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            IDTable idTable = IDTableManager.getInstance().getIDTable(new PartialPath("root.laptop"));
            idTable.getSeriesSchemas((InsertPlan)insertRowPlan);
            IMeasurementMNode s1Node = processor.getMeasurementMNode(new PartialPath("root.laptop.d1.aligned_device.s1"));
            Assert.assertEquals((Object)"s1", (Object)s1Node.getName());
            Assert.assertEquals((Object)TSDataType.INT32, (Object)s1Node.getSchema().getType());
            IMeasurementMNode s2Node = processor.getMeasurementMNode(new PartialPath("root.laptop.d1.aligned_device.s2"));
            Assert.assertEquals((Object)"s2", (Object)s2Node.getName());
            Assert.assertEquals((Object)TSDataType.INT64, (Object)s2Node.getSchema().getType());
            Assert.assertTrue((boolean)s2Node.getParent().isAligned());
            InsertRowPlan insertRowPlan2 = new InsertRowPlan(new PartialPath("root.laptop.d1.aligned_device"), time, new String[]{"s1", "s2"}, new TSDataType[]{TSDataType.INT64, TSDataType.INT64}, columns, true);
            insertRowPlan2.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            idTable.getSeriesSchemas((InsertPlan)insertRowPlan2);
            Assert.assertNull((Object)insertRowPlan2.getMeasurementMNodes()[0]);
            Assert.assertEquals((Object)insertRowPlan.getMeasurementMNodes()[1].getSchema().getType(), (Object)TSDataType.INT64);
            Assert.assertEquals((long)1L, (long)insertRowPlan2.getFailedMeasurementNumber());
            InsertRowPlan insertRowPlan3 = new InsertRowPlan(new PartialPath("root.laptop.d1.aligned_device"), time, new String[]{"s1", "s2"}, new TSDataType[]{TSDataType.INT64, TSDataType.INT64}, columns, false);
            insertRowPlan3.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            try {
                idTable.getSeriesSchemas((InsertPlan)insertRowPlan3);
                Assert.fail((String)"should throw exception");
            }
            catch (MetadataException e) {
                Assert.assertEquals((Object)"Timeseries under path [root.laptop.d1.aligned_device]'s align value is [true], which is not consistent with insert plan", (Object)e.getMessage());
            }
            catch (Exception e) {
                Assert.fail((String)"throw wrong exception");
            }
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)"throw exception");
        }
    }

    @Test
    public void testTriggerAndInsert() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            long time = 1L;
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.non_aligned_device.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.non_aligned_device.s2"), TSDataType.valueOf((String)"INT64"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            Planner processor = new Planner();
            String sql = "CREATE TRIGGER trigger1 BEFORE INSERT ON root.laptop.d1.non_aligned_device.s1 AS 'org.apache.iotdb.db.metadata.idtable.trigger_example.Counter'";
            CreateTriggerPlan plan = (CreateTriggerPlan)processor.parseSQLToPhysicalPlan(sql);
            TriggerRegistrationService.getInstance().register(plan);
            TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64};
            String[] columns = new String[]{"1", "2"};
            InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.laptop.d1.non_aligned_device"), time, new String[]{"s1", "s2"}, dataTypes, columns, false);
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            IDTable idTable = IDTableManager.getInstance().getIDTable(new PartialPath("root.laptop"));
            idTable.getSeriesSchemas((InsertPlan)insertRowPlan);
            IMeasurementMNode s1Node = schemaProcessor.getMeasurementMNode(new PartialPath("root.laptop.d1.non_aligned_device.s1"));
            Assert.assertEquals((Object)"s1", (Object)s1Node.getName());
            Assert.assertEquals((Object)TSDataType.INT32, (Object)s1Node.getSchema().getType());
            Assert.assertNotNull((Object)s1Node.getTriggerExecutor());
            IMeasurementMNode s2Node = schemaProcessor.getMeasurementMNode(new PartialPath("root.laptop.d1.non_aligned_device.s2"));
            Assert.assertEquals((Object)"s2", (Object)s2Node.getName());
            Assert.assertEquals((Object)TSDataType.INT64, (Object)s2Node.getSchema().getType());
            Assert.assertNull((Object)s2Node.getTriggerExecutor());
            String sql2 = "Drop trigger trigger1";
            DropTriggerPlan plan2 = (DropTriggerPlan)processor.parseSQLToPhysicalPlan(sql2);
            TriggerRegistrationService.getInstance().deregister(plan2);
            idTable.getSeriesSchemas((InsertPlan)insertRowPlan);
            Assert.assertNull((Object)s1Node.getTriggerExecutor());
        }
        catch (MetadataException | StorageEngineException | QueryProcessException e) {
            e.printStackTrace();
            Assert.fail((String)"throw exception");
        }
    }

    @Test
    public void testGetDiskSchemaEntries() {
        try {
            IDTable idTable = IDTableManager.getInstance().getIDTable(new PartialPath("root.laptop"));
            String sgPath = "root.laptop";
            for (int i = 0; i < 10; ++i) {
                String devicePath = sgPath + ".d" + i;
                IDeviceID iDeviceID = DeviceIDFactory.getInstance().getDeviceID(devicePath);
                String measurement = "s" + i;
                idTable.putSchemaEntry(devicePath, measurement, new SchemaEntry(TSDataType.BOOLEAN, TSEncoding.BITMAP, CompressionType.UNCOMPRESSED, iDeviceID, new PartialPath(devicePath + "." + measurement), false, idTable.getIDiskSchemaManager()), false);
                SchemaEntry schemaEntry = idTable.getDeviceEntry(iDeviceID.toStringID()).getSchemaEntry(measurement);
                ArrayList<SchemaEntry> schemaEntries = new ArrayList<SchemaEntry>();
                schemaEntries.add(schemaEntry);
                List diskSchemaEntries = idTable.getDiskSchemaEntries(schemaEntries);
                Assert.assertNotNull((Object)diskSchemaEntries);
                Assert.assertEquals((long)diskSchemaEntries.size(), (long)1L);
                Assert.assertEquals((Object)((DiskSchemaEntry)diskSchemaEntries.get((int)0)).seriesKey, (Object)(devicePath + "." + measurement));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"throw exception");
        }
    }

    @Test
    public void testDeleteTimeseries() {
        try {
            IDTable idTable = IDTableManager.getInstance().getIDTable(new PartialPath("root.laptop"));
            String sgPath = "root.laptop";
            for (int i = 0; i < 10; ++i) {
                String devicePath = sgPath + ".d" + i;
                IDeviceID iDeviceID = DeviceIDFactory.getInstance().getDeviceID(devicePath);
                String measurement = "s" + i;
                SchemaEntry schemaEntry = new SchemaEntry(TSDataType.BOOLEAN, TSEncoding.BITMAP, CompressionType.UNCOMPRESSED, iDeviceID, new PartialPath(devicePath + "." + measurement), false, idTable.getIDiskSchemaManager());
                idTable.putSchemaEntry(devicePath, measurement, schemaEntry, false);
            }
            ArrayList<PartialPath> partialPaths = new ArrayList<PartialPath>();
            partialPaths.add(new PartialPath("root.laptop.d0.s0"));
            partialPaths.add(new PartialPath("root.laptop.d8.s8"));
            partialPaths.add(new PartialPath("root.laptop.d2.s3"));
            Pair pairs = idTable.deleteTimeseries(partialPaths);
            Assert.assertNotNull((Object)pairs);
            Assert.assertEquals((long)((Integer)pairs.left).intValue(), (long)2L);
            Assert.assertTrue((boolean)((Set)pairs.right).contains("root.laptop.d2.s3"));
            Assert.assertFalse((boolean)((Set)pairs.right).contains("root.laptop.d0.s0"));
            Assert.assertFalse((boolean)((Set)pairs.right).contains("root.laptop.d8.s8"));
            Collection diskSchemaEntries = idTable.getIDiskSchemaManager().getAllSchemaEntry();
            for (DiskSchemaEntry diskSchemaEntry : diskSchemaEntries) {
                Assert.assertNotEquals((Object)"root.laptop.d0.s0", (Object)diskSchemaEntry.seriesKey);
                Assert.assertNotEquals((Object)"root.laptop.d8.s8", (Object)diskSchemaEntry.seriesKey);
            }
            Assert.assertNull(idTable.getDeviceEntry("root.laptop.d0").getMeasurementMap().get("s0"));
            Assert.assertNull(idTable.getDeviceEntry("root.laptop.d8").getMeasurementMap().get("s1"));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"throw exception");
        }
    }

    @Test
    public void testFlushTimeAndLastCache() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            long time = 1L;
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.non_aligned_device.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.non_aligned_device.s2"), TSDataType.valueOf((String)"INT64"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64};
            String[] columns = new String[]{"1", "2"};
            InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.laptop.d1.non_aligned_device"), time, new String[]{"s1", "s2"}, dataTypes, columns, false);
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            IDTable idTable = IDTableManager.getInstance().getIDTable(new PartialPath("root.laptop"));
            idTable.getSeriesSchemas((InsertPlan)insertRowPlan);
            IMeasurementMNode s2Node = insertRowPlan.getMeasurementMNodes()[1];
            ILastCacheContainer cacheContainer = s2Node.getLastCacheContainer();
            cacheContainer.updateCachedLast(new TimeValuePair(100L, (TsPrimitiveType)new TsPrimitiveType.TsLong(1L)), false, Long.valueOf(0L));
            Assert.assertEquals((Object)new TsPrimitiveType.TsLong(1L), (Object)cacheContainer.getCachedLast().getValue());
            Assert.assertEquals((long)100L, (long)cacheContainer.getCachedLast().getTimestamp());
            cacheContainer.updateCachedLast(new TimeValuePair(90L, (TsPrimitiveType)new TsPrimitiveType.TsLong(2L)), false, Long.valueOf(0L));
            Assert.assertEquals((Object)new TsPrimitiveType.TsLong(1L), (Object)cacheContainer.getCachedLast().getValue());
            Assert.assertEquals((long)100L, (long)cacheContainer.getCachedLast().getTimestamp());
            cacheContainer.updateCachedLast(new TimeValuePair(110L, (TsPrimitiveType)new TsPrimitiveType.TsLong(2L)), false, Long.valueOf(0L));
            Assert.assertEquals((Object)new TsPrimitiveType.TsLong(2L), (Object)cacheContainer.getCachedLast().getValue());
            Assert.assertEquals((long)110L, (long)cacheContainer.getCachedLast().getTimestamp());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)"throw exception");
        }
    }
}

