/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.cache;

import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.cache.DataNodeSchemaCache;
import org.apache.iotdb.db.metadata.cache.SchemaCacheEntry;
import org.apache.iotdb.db.mpp.common.schematree.ClusterSchemaTree;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataNodeSchemaCacheTest {
    DataNodeSchemaCache dataNodeSchemaCache;

    @Before
    public void setUp() throws Exception {
        this.dataNodeSchemaCache = DataNodeSchemaCache.getInstance();
    }

    @After
    public void tearDown() throws Exception {
        this.dataNodeSchemaCache.cleanUp();
    }

    @Test
    public void testGetSchemaEntity() throws IllegalPathException {
        PartialPath device1 = new PartialPath("root.sg1.d1");
        String[] measurements = new String[]{"s1", "s2", "s3"};
        this.dataNodeSchemaCache.put(this.generateSchemaTree1());
        Map<PartialPath, SchemaCacheEntry> schemaCacheEntryMap = this.dataNodeSchemaCache.get(device1, measurements).getAllMeasurement().stream().collect(Collectors.toMap(o -> new PartialPath(o.getNodes()), o -> new SchemaCacheEntry((MeasurementSchema)o.getMeasurementSchema(), o.isUnderAlignedEntity())));
        Assert.assertEquals((Object)TSDataType.INT32, (Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s1")).getTsDataType());
        Assert.assertEquals((Object)TSDataType.FLOAT, (Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s2")).getTsDataType());
        Assert.assertEquals((Object)TSDataType.BOOLEAN, (Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s3")).getTsDataType());
        Assert.assertEquals((long)3L, (long)this.dataNodeSchemaCache.estimatedSize());
        String[] otherMeasurements = new String[]{"s3", "s4", "s5"};
        this.dataNodeSchemaCache.put(this.generateSchemaTree2());
        schemaCacheEntryMap = this.dataNodeSchemaCache.get(device1, otherMeasurements).getAllMeasurement().stream().collect(Collectors.toMap(o -> new PartialPath(o.getNodes()), o -> new SchemaCacheEntry((MeasurementSchema)o.getMeasurementSchema(), o.isUnderAlignedEntity())));
        Assert.assertEquals((Object)TSDataType.BOOLEAN, (Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s3")).getTsDataType());
        Assert.assertEquals((Object)TSDataType.TEXT, (Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s4")).getTsDataType());
        Assert.assertEquals((Object)TSDataType.INT64, (Object)schemaCacheEntryMap.get(new PartialPath("root.sg1.d1.s5")).getTsDataType());
        Assert.assertEquals((long)5L, (long)this.dataNodeSchemaCache.estimatedSize());
    }

    @Test
    public void testLastCache() throws IllegalPathException {
        PartialPath seriesPath1 = new PartialPath("root.sg1.d1.s1");
        PartialPath seriesPath2 = new PartialPath("root.sg1.d1.s2");
        PartialPath seriesPath3 = new PartialPath("root.sg1.d1.s3");
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath1));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath2));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath3));
        this.dataNodeSchemaCache.put(this.generateSchemaTree1());
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath1));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath2));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath3));
        long timestamp = 100L;
        long timestamp2 = 101L;
        TsPrimitiveType value = TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)101);
        TsPrimitiveType value2 = TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)100);
        TsPrimitiveType value3 = TsPrimitiveType.getByType((TSDataType)TSDataType.INT32, (Object)99);
        TimeValuePair timeValuePair = new TimeValuePair(timestamp, value);
        this.dataNodeSchemaCache.updateLastCache(seriesPath1, timeValuePair, false, Long.valueOf(99L));
        TimeValuePair cachedTimeValuePair = this.dataNodeSchemaCache.getLastCache(seriesPath1);
        Assert.assertNotNull((Object)cachedTimeValuePair);
        Assert.assertEquals((long)timestamp, (long)cachedTimeValuePair.getTimestamp());
        Assert.assertEquals((Object)value, (Object)cachedTimeValuePair.getValue());
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath2));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath3));
        TimeValuePair timeValuePair2 = new TimeValuePair(timestamp, value2);
        this.dataNodeSchemaCache.updateLastCache(seriesPath1, timeValuePair2, false, Long.valueOf(100L));
        TimeValuePair cachedTimeValuePair2 = this.dataNodeSchemaCache.getLastCache(seriesPath1);
        Assert.assertNotNull((Object)cachedTimeValuePair2);
        Assert.assertEquals((long)timestamp, (long)cachedTimeValuePair2.getTimestamp());
        Assert.assertEquals((Object)value, (Object)cachedTimeValuePair2.getValue());
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath2));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath3));
        this.dataNodeSchemaCache.updateLastCache(seriesPath1, timeValuePair2, true, Long.valueOf(100L));
        cachedTimeValuePair2 = this.dataNodeSchemaCache.getLastCache(seriesPath1);
        Assert.assertNotNull((Object)cachedTimeValuePair2);
        Assert.assertEquals((long)timestamp, (long)cachedTimeValuePair2.getTimestamp());
        Assert.assertEquals((Object)value2, (Object)cachedTimeValuePair2.getValue());
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath2));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath3));
        TimeValuePair timeValuePair3 = new TimeValuePair(timestamp2, value3);
        this.dataNodeSchemaCache.updateLastCache(seriesPath1, timeValuePair3, false, Long.valueOf(100L));
        TimeValuePair cachedTimeValuePair3 = this.dataNodeSchemaCache.getLastCache(seriesPath1);
        Assert.assertNotNull((Object)cachedTimeValuePair3);
        Assert.assertEquals((long)timestamp2, (long)cachedTimeValuePair3.getTimestamp());
        Assert.assertEquals((Object)value3, (Object)cachedTimeValuePair3.getValue());
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath2));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath3));
        this.dataNodeSchemaCache.invalidate(seriesPath1);
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath1));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath2));
        Assert.assertNull((Object)this.dataNodeSchemaCache.getLastCache(seriesPath3));
    }

    private ISchemaTree generateSchemaTree1() throws IllegalPathException {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        schemaTree.appendSingleMeasurement(new PartialPath("root.sg1.d1.s1"), new MeasurementSchema("s1", TSDataType.INT32), null, false);
        schemaTree.appendSingleMeasurement(new PartialPath("root.sg1.d1.s2"), new MeasurementSchema("s2", TSDataType.FLOAT), null, false);
        schemaTree.appendSingleMeasurement(new PartialPath("root.sg1.d1.s3"), new MeasurementSchema("s3", TSDataType.BOOLEAN), null, false);
        return schemaTree;
    }

    private ISchemaTree generateSchemaTree2() throws IllegalPathException {
        ClusterSchemaTree schemaTree = new ClusterSchemaTree();
        schemaTree.appendSingleMeasurement(new PartialPath("root.sg1.d1.s3"), new MeasurementSchema("s3", TSDataType.BOOLEAN), null, false);
        schemaTree.appendSingleMeasurement(new PartialPath("root.sg1.d1.s4"), new MeasurementSchema("s4", TSDataType.TEXT), null, false);
        schemaTree.appendSingleMeasurement(new PartialPath("root.sg1.d1.s5"), new MeasurementSchema("s5", TSDataType.INT64), null, false);
        return schemaTree;
    }
}

