/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.DropTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TemplateTest {
    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testTemplate() throws MetadataException {
        CreateTemplatePlan plan = this.getCreateTemplatePlan();
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.createSchemaTemplate(plan);
        SetTemplatePlan setTemplatePlan = new SetTemplatePlan("template1", "root.sg1.d1");
        schemaProcessor.setSchemaTemplate(setTemplatePlan);
        schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.sg1.d1")));
        IMNode node = schemaProcessor.getDeviceNode(new PartialPath("root.sg1.d1"));
        MeasurementSchema s11 = new MeasurementSchema("s11", TSDataType.INT64, TSEncoding.RLE, CompressionType.SNAPPY);
        Assert.assertNotNull((Object)node.getSchemaTemplate());
        HashSet allSchema = new HashSet(node.getSchemaTemplate().getSchemaMap().values());
        schemaProcessor.getAllMeasurementByDevicePath(new PartialPath("root.sg1.d1")).stream().map(MeasurementPath::getMeasurementSchema).forEach(allSchema::remove);
        Assert.assertTrue((boolean)allSchema.isEmpty());
        IMeasurementMNode mNode = schemaProcessor.getMeasurementMNode(new PartialPath("root.sg1.d1.s11"));
        IMeasurementMNode mNode2 = schemaProcessor.getMeasurementMNode(new PartialPath("root.sg1.d1.vector.s2"));
        Assert.assertNotNull((Object)mNode);
        Assert.assertEquals((Object)mNode.getSchema(), (Object)s11);
        Assert.assertNotNull((Object)mNode2);
        Assert.assertEquals((Object)mNode2.getSchema(), schemaProcessor.getTemplate("template1").getSchemaMap().get("vector.s2"));
        try {
            schemaProcessor.getMeasurementMNode(new PartialPath("root.sg1.d1.s100"));
            Assert.fail();
        }
        catch (PathNotExistException e) {
            Assert.assertEquals((Object)"Path [root.sg1.d1.s100] does not exist", (Object)e.getMessage());
        }
    }

    @Test
    public void testTemplateInnerTree() {
        CreateTemplatePlan plan = this.getTreeTemplatePlan();
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.createSchemaTemplate(plan);
            Template template = schemaProcessor.getTemplate("treeTemplate");
            Assert.assertEquals((long)4L, (long)template.getMeasurementsCount());
            Assert.assertEquals((Object)"d1", (Object)template.getPathNodeInTemplate("d1").getName());
            Assert.assertEquals(null, (Object)template.getPathNodeInTemplate("notExists"));
            Assert.assertEquals((Object)"[GPS]", (Object)template.getAllAlignedPrefix().toString());
            String[] alignedMeasurements = new String[]{"to.be.prefix.s1", "to.be.prefix.s2"};
            TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT32};
            TSEncoding[] encodings = new TSEncoding[]{TSEncoding.RLE, TSEncoding.RLE};
            CompressionType[] compressionTypes = new CompressionType[]{CompressionType.SNAPPY, CompressionType.SNAPPY};
            template.addAlignedMeasurements(alignedMeasurements, dataTypes, encodings, compressionTypes);
            Assert.assertEquals((Object)"[to.be.prefix, GPS]", (Object)template.getAllAlignedPrefix().toString());
            Assert.assertEquals((Object)"[s1, s2]", (Object)template.getAlignedMeasurements("to.be.prefix").toString());
            template.deleteAlignedPrefix("to.be.prefix");
            Assert.assertEquals((Object)"[GPS]", (Object)template.getAllAlignedPrefix().toString());
            Assert.assertEquals(null, (Object)template.getDirectNode("prefix"));
            Assert.assertEquals((Object)"to", (Object)template.getDirectNode("to").getName());
            try {
                template.deleteMeasurements("a.single");
                Assert.fail();
            }
            catch (MetadataException e) {
                Assert.assertEquals((Object)"Path [a.single] does not exist", (Object)e.getMessage());
            }
            Assert.assertEquals((Object)"[d1.s1, GPS.x, to.be.prefix.s2, GPS.y, to.be.prefix.s1, s2]", (Object)template.getAllMeasurementsPaths().toString());
            template.deleteSeriesCascade("to");
            Assert.assertEquals((Object)"[d1.s1, GPS.x, GPS.y, s2]", (Object)template.getAllMeasurementsPaths().toString());
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testCreateSchemaTemplateSerialization() throws IOException {
        CreateTemplatePlan plan = this.getTreeTemplatePlan();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        plan.serialize(dos);
        byte[] byteArray = baos.toByteArray();
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        Assert.assertEquals((long)PhysicalPlan.PhysicalPlanType.CREATE_TEMPLATE.ordinal(), (long)buffer.get());
        CreateTemplatePlan deserializedPlan = new CreateTemplatePlan();
        deserializedPlan.deserialize(buffer);
        Assert.assertEquals(((List)plan.getCompressors().get(0)).get(0), ((List)deserializedPlan.getCompressors().get(0)).get(0));
        Assert.assertEquals((long)plan.getMeasurements().size(), (long)deserializedPlan.getMeasurements().size());
        Assert.assertEquals((Object)plan.getName(), (Object)deserializedPlan.getName());
    }

    private CreateTemplatePlan getTreeTemplatePlan() {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("d1.s1"));
        measurementList.add(Collections.singletonList("s2"));
        measurementList.add(Arrays.asList("GPS.x", "GPS.y"));
        ArrayList<List<TSDataType>> dataTypeList = new ArrayList<List<TSDataType>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        dataTypeList.add(Arrays.asList(TSDataType.FLOAT, TSDataType.FLOAT));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        encodingList.add(Collections.singletonList(TSEncoding.GORILLA));
        encodingList.add(Collections.singletonList(TSEncoding.GORILLA));
        encodingList.add(Arrays.asList(TSEncoding.RLE, TSEncoding.RLE));
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        compressionTypes.add(Collections.singletonList(CompressionType.UNCOMPRESSED));
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        compressionTypes.add(Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        return new CreateTemplatePlan("treeTemplate", measurementList, dataTypeList, encodingList, compressionTypes);
    }

    private CreateTemplatePlan getCreateTemplatePlan() {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("s11"));
        ArrayList<String> measurements = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            measurements.add("vector.s" + i);
        }
        measurementList.add(measurements);
        ArrayList<List<Object>> dataTypeList = new ArrayList<List<Object>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < 10; ++i) {
            dataTypes.add(TSDataType.INT64);
        }
        dataTypeList.add(dataTypes);
        ArrayList<List<Object>> encodingList = new ArrayList<List<Object>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        for (int i = 0; i < 10; ++i) {
            encodings.add(TSEncoding.RLE);
        }
        encodingList.add(encodings);
        ArrayList<List<Object>> compressionTypes = new ArrayList<List<Object>>();
        ArrayList<CompressionType> compressorList = new ArrayList<CompressionType>();
        for (int i = 0; i < 10; ++i) {
            compressorList.add(CompressionType.SNAPPY);
        }
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        compressionTypes.add(compressorList);
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("s21");
        schemaNames.add("vector");
        return new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
    }

    private CreateTemplatePlan getDirectAlignedTemplate() {
        ArrayList measurementList = new ArrayList();
        ArrayList<String> measurements = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            measurements.add("vs" + i);
        }
        measurementList.add(measurements);
        ArrayList dataTypeList = new ArrayList();
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < 10; ++i) {
            dataTypes.add(TSDataType.INT64);
        }
        dataTypeList.add(dataTypes);
        ArrayList encodingList = new ArrayList();
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        for (int i = 0; i < 10; ++i) {
            encodings.add(TSEncoding.RLE);
        }
        encodingList.add(encodings);
        ArrayList compressionTypes = new ArrayList();
        ArrayList<CompressionType> compressorList = new ArrayList<CompressionType>();
        for (int i = 0; i < 10; ++i) {
            compressorList.add(CompressionType.SNAPPY);
        }
        compressionTypes.add(compressorList);
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("vector");
        return new CreateTemplatePlan("templateDA", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
    }

    @Test
    public void testShowTemplates() throws MetadataException, QueryProcessException {
        SetTemplatePlan setTemplatePlan;
        int i;
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        Assert.assertEquals((long)0L, (long)schemaProcessor.getAllTemplates().size());
        CreateTemplatePlan plan1 = this.getTreeTemplatePlan();
        CreateTemplatePlan plan2 = this.getCreateTemplatePlan();
        schemaProcessor.createSchemaTemplate(plan1);
        schemaProcessor.createSchemaTemplate(plan2);
        Assert.assertEquals((Object)"[template1, treeTemplate]", (Object)schemaProcessor.getAllTemplates().toString());
        for (i = 0; i < 3; ++i) {
            setTemplatePlan = new SetTemplatePlan("template1", String.format("root.sg%d.d%d", i, i + 1));
            schemaProcessor.setSchemaTemplate(setTemplatePlan);
        }
        Assert.assertEquals(new HashSet<String>(Arrays.asList("root.sg1.d2", "root.sg0.d1", "root.sg2.d3")), (Object)schemaProcessor.getPathsSetTemplate("*"));
        Assert.assertEquals(new HashSet<Object>(Arrays.asList(new Object[0])), (Object)schemaProcessor.getPathsSetTemplate("treeTemplate"));
        for (i = 0; i < 3; ++i) {
            setTemplatePlan = new SetTemplatePlan("treeTemplate", String.format("root.tsg%d.d%d", i + 9, i + 10));
            schemaProcessor.setSchemaTemplate(setTemplatePlan);
        }
        Assert.assertEquals(new HashSet<String>(Arrays.asList("root.tsg10.d11", "root.tsg11.d12", "root.tsg9.d10")), (Object)schemaProcessor.getPathsSetTemplate("treeTemplate"));
        Assert.assertEquals(new HashSet<String>(Arrays.asList("root.tsg10.d11", "root.tsg11.d12", "root.tsg9.d10", "root.sg1.d2", "root.sg0.d1", "root.sg2.d3")), (Object)schemaProcessor.getPathsSetTemplate("*"));
        PlanExecutor exe1 = new PlanExecutor();
        exe1.insert(this.getInsertRowPlan("root.sg0.d1", "s11"));
        exe1.insert(this.getInsertRowPlan("root.sg1.d2", "s11"));
        exe1.insert(this.getInsertRowPlan("root.tsg10.d11.d1", "s1"));
        Assert.assertEquals(new HashSet<String>(Arrays.asList("root.tsg10.d11", "root.sg1.d2", "root.sg0.d1")), (Object)schemaProcessor.getPathsUsingTemplate("*"));
        try {
            schemaProcessor.createSchemaTemplate(plan1);
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"Duplicated template name: treeTemplate", (Object)e.getMessage());
        }
        try {
            schemaProcessor.dropSchemaTemplate(new DropTemplatePlan("treeTemplate"));
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"Template [treeTemplate] has been set on MTree, cannot be dropped now.", (Object)e.getMessage());
        }
    }

    @Test
    public void testShowAllSchemas() throws MetadataException {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        CreateTemplatePlan plan1 = this.getTreeTemplatePlan();
        CreateTemplatePlan plan2 = this.getCreateTemplatePlan();
        schemaProcessor.createSchemaTemplate(plan1);
        schemaProcessor.createSchemaTemplate(plan2);
        Assert.assertEquals((long)4L, (long)schemaProcessor.getSchemasInTemplate("treeTemplate", "").size());
        Assert.assertEquals((long)2L, (long)schemaProcessor.getSchemasInTemplate("treeTemplate", "GPS").size());
        Assert.assertEquals((long)11L, (long)schemaProcessor.getSchemasInTemplate("template1", "").size());
        Assert.assertEquals((long)10L, (long)schemaProcessor.getSchemasInTemplate("template1", "vector").size());
    }

    @Test
    public void testDropTemplate() throws MetadataException {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        CreateTemplatePlan plan1 = this.getTreeTemplatePlan();
        CreateTemplatePlan plan2 = this.getCreateTemplatePlan();
        schemaProcessor.createSchemaTemplate(plan1);
        schemaProcessor.createSchemaTemplate(plan2);
        Assert.assertEquals((Object)"[template1, treeTemplate]", (Object)schemaProcessor.getAllTemplates().toString());
        try {
            schemaProcessor.createSchemaTemplate(plan2);
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"Duplicated template name: template1", (Object)e.getMessage());
        }
        SetTemplatePlan setTemplatePlan = new SetTemplatePlan("template1", "root.sg.d0");
        schemaProcessor.setSchemaTemplate(setTemplatePlan);
        try {
            schemaProcessor.dropSchemaTemplate(new DropTemplatePlan("template1"));
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"Template [template1] has been set on MTree, cannot be dropped now.", (Object)e.getMessage());
        }
        UnsetTemplatePlan unsetPlan = new UnsetTemplatePlan("root.sg.d0", "template1");
        schemaProcessor.unsetSchemaTemplate(unsetPlan);
        schemaProcessor.dropSchemaTemplate(new DropTemplatePlan("template1"));
        Assert.assertEquals((Object)"[treeTemplate]", (Object)schemaProcessor.getAllTemplates().toString());
        schemaProcessor.createSchemaTemplate(plan2);
        Assert.assertEquals((Object)"[template1, treeTemplate]", (Object)schemaProcessor.getAllTemplates().toString());
        schemaProcessor.dropSchemaTemplate(new DropTemplatePlan("template1"));
        schemaProcessor.dropSchemaTemplate(new DropTemplatePlan("treeTemplate"));
    }

    @Test
    public void testDropTemplateWithStorageGroupDeleted() throws MetadataException {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.createSchemaTemplate(this.getTreeTemplatePlan());
        schemaProcessor.setSchemaTemplate(new SetTemplatePlan("treeTemplate", "root.sg1.d1"));
        try {
            schemaProcessor.dropSchemaTemplate(new DropTemplatePlan("treeTemplate"));
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"Template [treeTemplate] has been set on MTree, cannot be dropped now.", (Object)e.getMessage());
        }
        schemaProcessor.deleteStorageGroups(Arrays.asList(new PartialPath("root.sg1")));
        schemaProcessor.dropSchemaTemplate(new DropTemplatePlan("treeTemplate"));
        Assert.assertEquals((long)0L, (long)schemaProcessor.getAllTemplates().size());
    }

    @Test
    public void testTemplateAlignment() throws MetadataException {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.createTimeseries(new PartialPath("root.laptop.d0"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
        schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
        schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
        schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.ss.t1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
        schemaProcessor.createSchemaTemplate(this.getDirectAlignedTemplate());
        try {
            schemaProcessor.setSchemaTemplate(new SetTemplatePlan("templateDA", "root.laptop.d1"));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Template[templateDA] and mounted node[root.laptop.d1.vs0] has different alignment.", (Object)e.getMessage());
        }
    }

    private InsertRowPlan getInsertRowPlan(String prefixPath, String measurement) throws IllegalPathException {
        long time = 110L;
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT64};
        String[] columns = new String[]{"1"};
        return new InsertRowPlan(new PartialPath(prefixPath), time, new String[]{measurement}, dataTypes, columns);
    }
}

