/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.StorageGroupAlreadySetException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AppendTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowResult;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class SchemaBasicTest {
    private CompressionType compressionType;

    @Before
    public void setUp() {
        this.compressionType = TSFileDescriptor.getInstance().getConfig().getCompressor();
        this.setConfig();
        EnvironmentUtils.envSetUp();
    }

    protected abstract void setConfig();

    protected abstract void rollBackConfig();

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        this.rollBackConfig();
    }

    @Test
    public void testAddPathAndExist() throws IllegalPathException {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop")));
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop.d1"));
            schemaProcessor.setStorageGroup(new PartialPath("root.`1`"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.`1`")));
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"some children of root.laptop have already been set to storage group", (Object)e.getMessage());
        }
        try {
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s0")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s1")));
        try {
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.1_2"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.`\"1.2.3\"`"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            schemaProcessor.createTimeseries(new PartialPath("root.`1`.`2`.`3`"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s1")));
            Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.1_2")));
            Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.`\"1.2.3\"`")));
            Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.`1`.`2`")));
            Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.`1`.`2`.`3`")));
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
            Assert.fail((String)e1.getMessage());
        }
        try {
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.s1"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s1")));
        try {
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.s0"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s0")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root")));
        try {
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
            Assert.fail((String)e1.getMessage());
        }
        try {
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        }
        catch (MetadataException e1) {
            e1.printStackTrace();
            Assert.fail((String)e1.getMessage());
        }
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d2")));
        Assert.assertFalse((boolean)schemaProcessor.checkStorageGroupByPath(new PartialPath("root.laptop.d2")));
        try {
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.s0"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.s1"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop1"));
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)String.format("The seriesPath of %s already exist, it can't be set to the storage group", "root.laptop1"), (Object)e.getMessage());
        }
        try {
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.1_2"));
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.`\"1.2.3\"`"));
            schemaProcessor.deleteTimeseries(new PartialPath("root.`1`.`2`.`3`"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.1_2")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.`\"1.2.3\"`")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.`1`.`2`.`3`")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.`1`.`2`")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.`1`")));
        try {
            schemaProcessor.deleteStorageGroups(Collections.singletonList(new PartialPath("root.`1`")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.`1`")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.template0")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.template0.d1")));
        try {
            schemaProcessor.createTimeseries(new PartialPath("root.template0.d2"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            schemaProcessor.createSchemaTemplate(this.getCreateTemplatePlan());
            schemaProcessor.setSchemaTemplate(new SetTemplatePlan("template1", "root.template0"));
            schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.template0.d1")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.template0.d1")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.template0.d1.s11")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.template0.d2.s11")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.template0.d1.vector")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.template0.d1.vector.s0")));
    }

    @Test
    public void testDeleteNonExistentTimeseries() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.deleteTimeseries(new PartialPath("root.non.existent"));
            Assert.fail();
        }
        catch (PathNotExistException e) {
            Assert.assertEquals((Object)"Path [root.non.existent] does not exist", (Object)e.getMessage());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateAlignedTimeseries() throws MetadataException {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            schemaProcessor.createAlignedTimeSeries(new PartialPath("root.laptop.d1.aligned_device"), Arrays.asList("s1", "s2", "s3"), Arrays.asList(TSDataType.valueOf((String)"INT32"), TSDataType.valueOf((String)"FLOAT"), TSDataType.valueOf((String)"INT32")), Arrays.asList(TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE")), Arrays.asList(this.compressionType, this.compressionType, this.compressionType));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s0")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s1")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s2")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s3")));
        schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.aligned_device.*"));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s0")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s1")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s2")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s3")));
        try {
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.s0"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.s0")));
        try {
            schemaProcessor.createAlignedTimeSeries(new PartialPath("root.laptop.d1.aligned_device"), Arrays.asList("s0", "s2", "s4"), Arrays.asList(TSDataType.valueOf((String)"INT32"), TSDataType.valueOf((String)"FLOAT"), TSDataType.valueOf((String)"INT32")), Arrays.asList(TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE")), Arrays.asList(this.compressionType, this.compressionType, this.compressionType));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s0")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s2")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s4")));
    }

    @Test
    public void testGetAllTimeseriesCount() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d0"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s2.t1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s3"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.**")), (long)6L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.**")), (long)6L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.*")), (long)1L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.*.*")), (long)4L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.*.**")), (long)5L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.*.*.t1")), (long)1L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.*.s1")), (long)2L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.d1.**")), (long)3L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.d1.*")), (long)2L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.d2.s1")), (long)1L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.d2.**")), (long)2L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop")), (long)0L);
            Assert.assertEquals((long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.d3.s1")), (long)0L);
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSetStorageGroupAndExist() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root1.laptop.d2")));
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop.d1"));
            Assert.assertTrue((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d1.s1")));
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop.d2"));
            Assert.assertTrue((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertTrue((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d3")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testRecover() throws Exception {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop.d1"));
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop.d2"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            Assert.assertTrue((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertTrue((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d3")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop")));
            TreeSet<String> devices = new TreeSet<String>(){
                {
                    this.add("root.laptop.d1");
                    this.add("root.laptop.d2");
                }
            };
            Assert.assertEquals((Object)devices, schemaProcessor.getMatchedDevices(new PartialPath("root.**"), false).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
            schemaProcessor.deleteStorageGroups(Collections.singletonList(new PartialPath("root.laptop.d2")));
            Assert.assertTrue((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d3")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop")));
            devices.remove("root.laptop.d2");
            Assert.assertEquals((Object)devices, schemaProcessor.getMatchedDevices(new PartialPath("root.**"), false).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
            EnvironmentUtils.restartDaemon();
            Assert.assertTrue((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d1")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d2")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop.d3")));
            Assert.assertFalse((boolean)schemaProcessor.isStorageGroup(new PartialPath("root.laptop")));
            Assert.assertEquals((Object)devices, schemaProcessor.getMatchedDevices(new PartialPath("root.**"), false).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetAllFileNamesByPath() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop.d1"));
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop.d2"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            ArrayList<PartialPath> list = new ArrayList<PartialPath>();
            list.add(new PartialPath("root.laptop.d1"));
            Assert.assertEquals(list, (Object)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.laptop.d1.s1")));
            Assert.assertEquals(list, (Object)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.laptop.d1")));
            list.add(new PartialPath("root.laptop.d2"));
            Assert.assertEquals(list, (Object)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.laptop.**")));
            Assert.assertEquals(list, (Object)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.**")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCheckStorageExistOfPath() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            Assert.assertTrue((boolean)schemaProcessor.getMeasurementPaths(new PartialPath("root")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle.device0")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle.device0.sensor")).isEmpty());
            schemaProcessor.setStorageGroup(new PartialPath("root.vehicle"));
            Assert.assertFalse((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle")).isEmpty());
            Assert.assertFalse((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle.device0")).isEmpty());
            Assert.assertFalse((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle.device0.sensor")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle1")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle1.device0")).isEmpty());
            schemaProcessor.setStorageGroup(new PartialPath("root.vehicle1.device0"));
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle1.device1")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle1.device2")).isEmpty());
            Assert.assertTrue((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle1.device3")).isEmpty());
            Assert.assertFalse((boolean)schemaProcessor.getBelongedStorageGroups(new PartialPath("root.vehicle1.device0")).isEmpty());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testShowChildNodesWithGivenPrefix() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            HashSet<String> nodes = new HashSet<String>(Arrays.asList("s1", "s2"));
            HashSet<String> nodes2 = new HashSet<String>(Arrays.asList("laptop"));
            HashSet<String> nodes3 = new HashSet<String>(Arrays.asList("d1", "d2"));
            Set nexLevelNodes1 = schemaProcessor.getChildNodeNameInNextLevel(new PartialPath("root.laptop.d1"));
            Set nexLevelNodes2 = schemaProcessor.getChildNodeNameInNextLevel(new PartialPath("root"));
            Set nexLevelNodes3 = schemaProcessor.getChildNodeNameInNextLevel(new PartialPath("root.laptop"));
            Assert.assertEquals(nodes, (Object)nexLevelNodes1);
            Assert.assertEquals(nodes2, (Object)nexLevelNodes2);
            Assert.assertEquals(nodes3, (Object)nexLevelNodes3);
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetStorageGroupNameByAutoLevel() {
        int level = IoTDBDescriptor.getInstance().getConfig().getDefaultStorageGroupLevel();
        try {
            Assert.assertEquals((Object)"root.laptop", (Object)MetaUtils.getStorageGroupPathByLevel((PartialPath)new PartialPath("root.laptop.d1.s1"), (int)level).getFullPath());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        boolean caughtException = false;
        try {
            MetaUtils.getStorageGroupPathByLevel((PartialPath)new PartialPath("root1.laptop.d1.s1"), (int)level);
        }
        catch (MetadataException e) {
            caughtException = true;
            Assert.assertEquals((Object)"root1.laptop.d1.s1 is not a legal path", (Object)e.getMessage());
        }
        Assert.assertTrue((boolean)caughtException);
        caughtException = false;
        try {
            MetaUtils.getStorageGroupPathByLevel((PartialPath)new PartialPath("root"), (int)level);
        }
        catch (MetadataException e) {
            caughtException = true;
            Assert.assertEquals((Object)"root is not a legal path", (Object)e.getMessage());
        }
        Assert.assertTrue((boolean)caughtException);
    }

    @Test
    public void testGetDevicesWithGivenPrefix() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            TreeSet<String> devices = new TreeSet<String>();
            devices.add("root.laptop.d1");
            devices.add("root.laptop.d2");
            Assert.assertEquals(devices, schemaProcessor.getMatchedDevices(new PartialPath("root.laptop.**"), false).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
            schemaProcessor.setStorageGroup(new PartialPath("root.vehicle"));
            schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            devices.add("root.vehicle.d1");
            Assert.assertEquals(devices, schemaProcessor.getMatchedDevices(new PartialPath("root.**"), false).stream().map(PartialPath::getFullPath).collect(Collectors.toSet()));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGetChildNodePathInNextLevel() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        String[] res = new String[]{"[TSchemaNode(nodeName:root.laptop, nodeType:2), TSchemaNode(nodeName:root.vehicle, nodeType:2)]", "[TSchemaNode(nodeName:root.laptop.b1, nodeType:3), TSchemaNode(nodeName:root.laptop.b2, nodeType:3)]", "[TSchemaNode(nodeName:root.laptop.b1.d1, nodeType:4), TSchemaNode(nodeName:root.laptop.b1.d2, nodeType:4)]", "[TSchemaNode(nodeName:root.laptop.b1, nodeType:3), TSchemaNode(nodeName:root.laptop.b2, nodeType:3), TSchemaNode(nodeName:root.vehicle.b1, nodeType:3), TSchemaNode(nodeName:root.vehicle.b2, nodeType:3)]", "[TSchemaNode(nodeName:root.laptop.b1.d1, nodeType:4), TSchemaNode(nodeName:root.laptop.b1.d2, nodeType:4), TSchemaNode(nodeName:root.vehicle.b1.d0, nodeType:4), TSchemaNode(nodeName:root.vehicle.b1.d2, nodeType:4), TSchemaNode(nodeName:root.vehicle.b1.d3, nodeType:4)]", "[TSchemaNode(nodeName:root.laptop.b1.d1, nodeType:4), TSchemaNode(nodeName:root.laptop.b1.d2, nodeType:4)]", "[TSchemaNode(nodeName:root.vehicle.b1.d0, nodeType:4), TSchemaNode(nodeName:root.vehicle.b1.d2, nodeType:4), TSchemaNode(nodeName:root.vehicle.b1.d3, nodeType:4), TSchemaNode(nodeName:root.vehicle.b2.d0, nodeType:4)]", "[TSchemaNode(nodeName:root.laptop.b1.d1.s0, nodeType:5), TSchemaNode(nodeName:root.laptop.b1.d1.s1, nodeType:5), TSchemaNode(nodeName:root.laptop.b1.d2.s0, nodeType:5), TSchemaNode(nodeName:root.laptop.b2.d1.s1, nodeType:5), TSchemaNode(nodeName:root.laptop.b2.d1.s3, nodeType:5), TSchemaNode(nodeName:root.laptop.b2.d2.s2, nodeType:5)]", "[]"};
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.setStorageGroup(new PartialPath("root.vehicle"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.b1.d1.s0"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.b1.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.b1.d2.s0"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.b2.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.b2.d1.s3"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.b2.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.vehicle.b1.d0.s0"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.vehicle.b1.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.vehicle.b1.d3.s3"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.vehicle.b2.d0.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            Assert.assertEquals((Object)res[0], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root")).toString());
            Assert.assertEquals((Object)res[1], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.laptop")).toString());
            Assert.assertEquals((Object)res[2], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.laptop.b1")).toString());
            Assert.assertEquals((Object)res[3], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.*")).toString());
            Assert.assertEquals((Object)res[4], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.*.b1")).toString());
            Assert.assertEquals((Object)res[5], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.l*.b1")).toString());
            Assert.assertEquals((Object)res[6], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.v*.*")).toString());
            Assert.assertEquals((Object)res[7], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.l*.b*.*")).toString());
            Assert.assertEquals((Object)res[8], (Object)schemaProcessor.getChildNodePathInNextLevel(new PartialPath("root.laptopp")).toString());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTemplate() throws MetadataException {
        CreateTemplatePlan plan = this.getCreateTemplatePlan();
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.createSchemaTemplate(plan);
        SetTemplatePlan setTemplatePlan = new SetTemplatePlan("template1", "root.sg1.d1");
        schemaProcessor.setSchemaTemplate(setTemplatePlan);
        schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.sg1.d1")));
        IMNode node = schemaProcessor.getDeviceNode(new PartialPath("root.sg1.d1"));
        MeasurementSchema s11 = new MeasurementSchema("s11", TSDataType.INT64, TSEncoding.RLE, CompressionType.SNAPPY);
        Assert.assertNotNull((Object)node.getSchemaTemplate());
        HashSet<String> allSchema = new HashSet<String>();
        for (IMeasurementSchema schema : node.getSchemaTemplate().getSchemaMap().values()) {
            allSchema.add("root.sg1.d1.vector." + schema.getMeasurementId());
        }
        for (MeasurementPath measurementPath : schemaProcessor.getMeasurementPaths(new PartialPath("root.sg1.**"))) {
            allSchema.remove(measurementPath.toString());
        }
        allSchema.remove("root.sg1.d1.vector.s11");
        Assert.assertTrue((boolean)allSchema.isEmpty());
        IMeasurementMNode mNode = schemaProcessor.getMeasurementMNode(new PartialPath("root.sg1.d1.s11"));
        IMeasurementMNode mNode2 = schemaProcessor.getMeasurementMNode(new PartialPath("root.sg1.d1.vector.s2"));
        Assert.assertNotNull((Object)mNode);
        Assert.assertEquals((Object)mNode.getSchema(), (Object)s11);
        Assert.assertNotNull((Object)mNode2);
        Assert.assertEquals((Object)mNode2.getSchema(), schemaProcessor.getTemplate("template1").getSchemaMap().get("vector.s2"));
        try {
            schemaProcessor.getMeasurementMNode(new PartialPath("root.sg1.d1.s100"));
            Assert.fail();
        }
        catch (PathNotExistException e) {
            Assert.assertEquals((Object)"Path [root.sg1.d1.s100] does not exist", (Object)e.getMessage());
        }
    }

    @Test
    public void testTemplateWithUnsupportedTypeEncoding() throws MetadataException {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("d1.s1"));
        measurementList.add(Collections.singletonList("s2"));
        measurementList.add(Arrays.asList("GPS.x", "GPS.y"));
        ArrayList<List<TSDataType>> dataTypeList = new ArrayList<List<TSDataType>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT32));
        dataTypeList.add(Collections.singletonList(TSDataType.INT32));
        dataTypeList.add(Arrays.asList(TSDataType.TEXT, TSDataType.FLOAT));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        encodingList.add(Collections.singletonList(TSEncoding.GORILLA));
        encodingList.add(Collections.singletonList(TSEncoding.GORILLA));
        encodingList.add(Arrays.asList(TSEncoding.RLE, TSEncoding.RLE));
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        compressionTypes.add(Collections.singletonList(CompressionType.SDT));
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        compressionTypes.add(Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        try {
            CreateTemplatePlan plan = new CreateTemplatePlan("treeTemplate", measurementList, dataTypeList, encodingList, compressionTypes);
            IoTDB.schemaProcessor.createSchemaTemplate(plan);
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"encoding RLE does not support TEXT", (Object)e.getMessage());
        }
        ((List)dataTypeList.get(2)).set(0, TSDataType.FLOAT);
        CreateTemplatePlan planb = new CreateTemplatePlan("treeTemplate", measurementList, dataTypeList, encodingList, compressionTypes);
        IoTDB.schemaProcessor.createSchemaTemplate(planb);
        Template template = IoTDB.schemaProcessor.getTemplate("treeTemplate");
        Assert.assertEquals((Object)"[d1.s1, GPS.x, GPS.y, s2]", (Object)template.getAllMeasurementsPaths().toString());
        List<String> appendMeasurements = Arrays.asList("a1", "a2");
        List<TSDataType> appendDataTypes = Arrays.asList(TSDataType.TEXT, TSDataType.FLOAT);
        List<TSEncoding> appendEncodings = Arrays.asList(TSEncoding.RLE, TSEncoding.RLE);
        List<CompressionType> appendCompressor = Arrays.asList(CompressionType.SNAPPY, CompressionType.LZ4);
        AppendTemplatePlan plana = new AppendTemplatePlan("treeTemplate", false, appendMeasurements, appendDataTypes, appendEncodings, appendCompressor);
        try {
            IoTDB.schemaProcessor.appendSchemaTemplate(plana);
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"encoding RLE does not support TEXT", (Object)e.getMessage());
        }
        appendDataTypes.set(0, TSDataType.FLOAT);
        AppendTemplatePlan planab = new AppendTemplatePlan("treeTemplate", false, appendMeasurements, appendDataTypes, appendEncodings, appendCompressor);
        IoTDB.schemaProcessor.appendSchemaTemplate(planab);
        Assert.assertEquals((Object)"[a1, a2, d1.s1, GPS.x, GPS.y, s2]", (Object)template.getAllMeasurementsPaths().toString());
    }

    @Test
    public void testTemplateInnerTree() throws MetadataException {
        CreateTemplatePlan plan = this.getTreeTemplatePlan();
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.createSchemaTemplate(plan);
        Template template = schemaProcessor.getTemplate("treeTemplate");
        Assert.assertEquals((long)4L, (long)template.getMeasurementsCount());
        Assert.assertEquals((Object)"d1", (Object)template.getPathNodeInTemplate("d1").getName());
        Assert.assertNull((Object)template.getPathNodeInTemplate("notExists"));
        Assert.assertEquals((Object)"[GPS]", (Object)template.getAllAlignedPrefix().toString());
        String[] alignedMeasurements = new String[]{"`to`.be.prefix.s1", "`to`.be.prefix.s2"};
        TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT32};
        TSEncoding[] encodings = new TSEncoding[]{TSEncoding.RLE, TSEncoding.RLE};
        CompressionType[] compressionTypes = new CompressionType[]{CompressionType.SNAPPY, CompressionType.SNAPPY};
        template.addAlignedMeasurements(alignedMeasurements, dataTypes, encodings, compressionTypes);
        Assert.assertEquals((Object)"[to.be.prefix, GPS]", (Object)template.getAllAlignedPrefix().toString());
        Assert.assertEquals((Object)"[s1, s2]", (Object)template.getAlignedMeasurements("`to`.be.prefix").toString());
        template.deleteAlignedPrefix("`to`.be.prefix");
        Assert.assertEquals((Object)"[GPS]", (Object)template.getAllAlignedPrefix().toString());
        Assert.assertEquals(null, (Object)template.getDirectNode("prefix"));
        Assert.assertEquals((Object)"to", (Object)template.getDirectNode("to").getName());
        Assert.assertFalse((boolean)template.isDirectAligned());
        try {
            template.addAlignedMeasurements(new String[]{"speed", "temperature"}, dataTypes, encodings, compressionTypes);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)e.getMessage(), (Object)" is not a legal path, because path already exists but not aligned");
        }
        Assert.assertFalse((boolean)template.isDirectAligned());
        try {
            template.deleteMeasurements("a.single");
            Assert.fail();
        }
        catch (PathNotExistException e) {
            Assert.assertEquals((Object)"Path [a.single] does not exist", (Object)e.getMessage());
        }
        Assert.assertEquals((Object)"[d1.s1, GPS.x, to.be.prefix.s2, GPS.y, to.be.prefix.s1, s2]", (Object)template.getAllMeasurementsPaths().toString());
        template.deleteSeriesCascade("`to`");
        Assert.assertEquals((Object)"[d1.s1, GPS.x, GPS.y, s2]", (Object)template.getAllMeasurementsPaths().toString());
    }

    private CreateTemplatePlan getTreeTemplatePlan() {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("d1.s1"));
        measurementList.add(Collections.singletonList("s2"));
        measurementList.add(Arrays.asList("GPS.x", "GPS.y"));
        ArrayList<List<TSDataType>> dataTypeList = new ArrayList<List<TSDataType>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT32));
        dataTypeList.add(Collections.singletonList(TSDataType.INT32));
        dataTypeList.add(Arrays.asList(TSDataType.FLOAT, TSDataType.FLOAT));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        encodingList.add(Collections.singletonList(TSEncoding.GORILLA));
        encodingList.add(Collections.singletonList(TSEncoding.GORILLA));
        encodingList.add(Arrays.asList(TSEncoding.RLE, TSEncoding.RLE));
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        compressionTypes.add(Collections.singletonList(CompressionType.SDT));
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        compressionTypes.add(Arrays.asList(CompressionType.SNAPPY, CompressionType.SNAPPY));
        return new CreateTemplatePlan("treeTemplate", measurementList, dataTypeList, encodingList, compressionTypes);
    }

    private CreateTemplatePlan getCreateTemplatePlan() {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("s11"));
        ArrayList<String> measurements = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            measurements.add("vector.s" + i);
        }
        measurementList.add(measurements);
        ArrayList<List<Object>> dataTypeList = new ArrayList<List<Object>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < 10; ++i) {
            dataTypes.add(TSDataType.INT64);
        }
        dataTypeList.add(dataTypes);
        ArrayList<List<Object>> encodingList = new ArrayList<List<Object>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        for (int i = 0; i < 10; ++i) {
            encodings.add(TSEncoding.RLE);
        }
        encodingList.add(encodings);
        ArrayList<List<Object>> compressionTypes = new ArrayList<List<Object>>();
        ArrayList<CompressionType> compressorList = new ArrayList<CompressionType>();
        for (int i = 0; i < 10; ++i) {
            compressorList.add(CompressionType.SNAPPY);
        }
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        compressionTypes.add(compressorList);
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("s21");
        schemaNames.add("vector");
        return new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
    }

    @Test
    public void testUnsetSchemaTemplate() throws MetadataException {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("s1"));
        measurementList.add(Collections.singletonList("s2"));
        measurementList.add(Collections.singletonList("s3"));
        ArrayList<List<TSDataType>> dataTypeList = new ArrayList<List<TSDataType>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        for (int i = 0; i < 3; ++i) {
            compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        }
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("s1");
        schemaNames.add("s2");
        schemaNames.add("s3");
        CreateTemplatePlan createTemplatePlan = new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
        SetTemplatePlan setTemplatePlan = new SetTemplatePlan("template1", "root.sg.`1`");
        UnsetTemplatePlan unsetTemplatePlan = new UnsetTemplatePlan("root.sg.`1`", "template1");
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.createSchemaTemplate(createTemplatePlan);
        try {
            schemaProcessor.unsetSchemaTemplate(unsetTemplatePlan);
            Assert.fail((String)"No exception thrown.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Path [root.sg.`1`] does not exist", (Object)e.getMessage());
        }
        schemaProcessor.setSchemaTemplate(setTemplatePlan);
        schemaProcessor.unsetSchemaTemplate(unsetTemplatePlan);
        schemaProcessor.setSchemaTemplate(setTemplatePlan);
        schemaProcessor.unsetSchemaTemplate(unsetTemplatePlan);
        try {
            schemaProcessor.unsetSchemaTemplate(unsetTemplatePlan);
            Assert.fail((String)"No exception thrown.");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"NO template on root.sg.`1`", (Object)e.getMessage());
        }
    }

    @Test
    public void testTemplateAndTimeSeriesCompatibility() throws MetadataException {
        CreateTemplatePlan plan = this.getCreateTemplatePlan();
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.createSchemaTemplate(plan);
        schemaProcessor.createSchemaTemplate(this.getTreeTemplatePlan());
        SetTemplatePlan setTemplatePlan = new SetTemplatePlan("template1", "root.sg1.d1");
        schemaProcessor.setSchemaTemplate(setTemplatePlan);
        schemaProcessor.setSchemaTemplate(new SetTemplatePlan("treeTemplate", "root.tree.sg0"));
        CreateTimeSeriesPlan createTimeSeriesPlan = new CreateTimeSeriesPlan(new PartialPath("root.sg1.d1.s20"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null, null, null);
        schemaProcessor.createTimeseries(createTimeSeriesPlan);
        CreateTimeSeriesPlan createTimeSeriesPlan2 = new CreateTimeSeriesPlan(new PartialPath("root.sg1.d1.s11"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null, null, null);
        try {
            schemaProcessor.createTimeseries(createTimeSeriesPlan2);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Path [root.sg1.d1.s11] already exists in [template1]", (Object)e.getMessage());
        }
        CreateTimeSeriesPlan createTimeSeriesPlan3 = new CreateTimeSeriesPlan(new PartialPath("root.tree.sg0.GPS.s9"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null, null, null);
        try {
            schemaProcessor.createTimeseries(createTimeSeriesPlan3);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Path [root.tree.sg0.GPS] overlaps with [treeTemplate] on [GPS]", (Object)e.getMessage());
        }
        CreateTimeSeriesPlan createTimeSeriesPlan4 = new CreateTimeSeriesPlan(new PartialPath("root.tree.sg0.s3"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null, null, null);
        schemaProcessor.createTimeseries(createTimeSeriesPlan4);
    }

    @Test
    public void testTemplateAndNodePathCompatibility() throws MetadataException {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        CreateTemplatePlan plan = this.getCreateTemplatePlan();
        schemaProcessor.createSchemaTemplate(plan);
        schemaProcessor.createSchemaTemplate(this.getTreeTemplatePlan());
        SetTemplatePlan setTemplatePlan = new SetTemplatePlan("template1", "root.sg1.d1");
        SetTemplatePlan setSchemaTemplatePlan2 = new SetTemplatePlan("treeTemplate", "root.tree.sg0");
        CreateTimeSeriesPlan createTimeSeriesPlan = new CreateTimeSeriesPlan(new PartialPath("root.sg1.d1.s11"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null, null, null);
        schemaProcessor.createTimeseries(createTimeSeriesPlan);
        schemaProcessor.createTimeseries(new CreateTimeSeriesPlan(new PartialPath("root.tree.sg0.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null, null, null));
        schemaProcessor.createTimeseries(new CreateTimeSeriesPlan(new PartialPath("root.tree.sg1.dn.sn"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null, null, null));
        schemaProcessor.createTimeseries(new CreateTimeSeriesPlan(new PartialPath("root.tree.sg2.dn.sn"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null, null, null));
        schemaProcessor.createTimeseries(new CreateTimeSeriesPlan(new PartialPath("root.tree.sg3.dn.sn"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null, null, null));
        try {
            SetTemplatePlan planErr = new SetTemplatePlan("treeTemplate", "root.tree.*");
            Assert.fail();
        }
        catch (IllegalPathException e) {
            Assert.assertEquals((Object)"root.tree.* is not a legal path, because template cannot be set on a path with wildcard.", (Object)e.getMessage());
        }
        SetTemplatePlan planEx1 = new SetTemplatePlan("treeTemplate", "root.tree.sg1");
        SetTemplatePlan planEx2 = new SetTemplatePlan("treeTemplate", "root.tree.sg2");
        SetTemplatePlan planEx3 = new SetTemplatePlan("treeTemplate", "root.tree.sg3");
        schemaProcessor.setSchemaTemplate(planEx1);
        schemaProcessor.setSchemaTemplate(planEx2);
        schemaProcessor.setSchemaTemplate(planEx3);
        try {
            schemaProcessor.unsetSchemaTemplate(new UnsetTemplatePlan("root.tree.*", "treeTemplate"));
            Assert.fail();
        }
        catch (IllegalPathException e) {
            Assert.assertEquals((Object)"root.tree.* is not a legal path, because template cannot be unset on a path with wildcard.", (Object)e.getMessage());
        }
        schemaProcessor.setSchemaTemplate(setSchemaTemplatePlan2);
        schemaProcessor.unsetSchemaTemplate(new UnsetTemplatePlan("root.tree.sg0", "treeTemplate"));
        try {
            schemaProcessor.setSchemaTemplate(setTemplatePlan);
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"Node name s11 in template has conflict with node's child root.sg1.d1.s11", (Object)e.getMessage());
        }
        schemaProcessor.createTimeseries(new CreateTimeSeriesPlan(new PartialPath("root.tree.sg0.GPS.speed"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null, null, null, null));
        try {
            schemaProcessor.setSchemaTemplate(setSchemaTemplatePlan2);
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"Node name GPS in template has conflict with node's child root.tree.sg0.GPS", (Object)e.getMessage());
        }
        schemaProcessor.deleteTimeseries(new PartialPath("root.sg1.d1.s11"));
    }

    @Test
    public void testSetDeviceTemplate() throws MetadataException {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("s11"));
        ArrayList<String> measurements = new ArrayList<String>();
        for (int i = 0; i < 10; ++i) {
            measurements.add("s" + i);
        }
        measurementList.add(measurements);
        ArrayList<List<Object>> dataTypeList = new ArrayList<List<Object>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < 10; ++i) {
            dataTypes.add(TSDataType.INT64);
        }
        dataTypeList.add(dataTypes);
        ArrayList<List<Object>> encodingList = new ArrayList<List<Object>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        for (int i = 0; i < 10; ++i) {
            encodings.add(TSEncoding.RLE);
        }
        encodingList.add(encodings);
        ArrayList<List<Object>> compressionTypes = new ArrayList<List<Object>>();
        ArrayList<CompressionType> compressionTypeList = new ArrayList<CompressionType>();
        for (int i = 0; i < 10; ++i) {
            compressionTypeList.add(CompressionType.SNAPPY);
        }
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        compressionTypes.add(compressionTypeList);
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("s11");
        schemaNames.add("test_aligned_device");
        CreateTemplatePlan plan1 = new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
        measurementList.add(Collections.singletonList("s12"));
        schemaNames.add("s12");
        dataTypeList.add(Collections.singletonList(TSDataType.INT64));
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        CreateTemplatePlan plan2 = new CreateTemplatePlan("template2", new ArrayList(schemaNames), new ArrayList(measurementList), new ArrayList(dataTypeList), new ArrayList(encodingList), new ArrayList(compressionTypes));
        ((List)measurementList.get(1)).add("s13");
        ((List)dataTypeList.get(1)).add(TSDataType.INT64);
        ((List)encodingList.get(1)).add(TSEncoding.RLE);
        ((List)compressionTypes.get(1)).add(CompressionType.SNAPPY);
        SetTemplatePlan setPlan1 = new SetTemplatePlan("template1", "root.sg1");
        SetTemplatePlan setPlan2 = new SetTemplatePlan("template2", "root.sg2.d1");
        SetTemplatePlan setPlan3 = new SetTemplatePlan("template1", "root.sg1.d1");
        SetTemplatePlan setPlan4 = new SetTemplatePlan("template2", "root.sg2");
        SetTemplatePlan setPlan5 = new SetTemplatePlan("template2", "root.sg1.d1");
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.createSchemaTemplate(plan1);
        schemaProcessor.createSchemaTemplate(plan2);
        schemaProcessor.setStorageGroup(new PartialPath("root.sg1"));
        schemaProcessor.setStorageGroup(new PartialPath("root.sg2"));
        schemaProcessor.setStorageGroup(new PartialPath("root.sg3"));
        try {
            schemaProcessor.setSchemaTemplate(setPlan1);
            schemaProcessor.setSchemaTemplate(setPlan2);
        }
        catch (MetadataException e) {
            Assert.fail();
        }
        try {
            schemaProcessor.setSchemaTemplate(setPlan3);
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"Template already exists on root.sg1", (Object)e.getMessage());
        }
        try {
            schemaProcessor.setSchemaTemplate(setPlan4);
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"Template already exists on root.sg2.d1", (Object)e.getMessage());
        }
        try {
            schemaProcessor.setSchemaTemplate(setPlan5);
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"Template already exists on root.sg1", (Object)e.getMessage());
        }
    }

    @Test
    public void testShowTimeseries() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            ShowTimeSeriesPlan showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.laptop.d1.s0"), false, null, null, 0, 0, false);
            List result = schemaProcessor.showTimeseries(showTimeSeriesPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"root.laptop.d1.s0", (Object)((ShowTimeSeriesResult)result.get(0)).getName());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testShowTimeseriesWithTemplate() {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("s0"));
        ArrayList<String> measurements = new ArrayList<String>();
        for (int i = 1; i <= 3; ++i) {
            measurements.add("vector.s" + i);
        }
        measurementList.add(measurements);
        ArrayList<List<Object>> dataTypeList = new ArrayList<List<Object>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT32));
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        dataTypes.add(TSDataType.INT32);
        dataTypes.add(TSDataType.FLOAT);
        dataTypes.add(TSDataType.INT32);
        dataTypeList.add(dataTypes);
        ArrayList<List<Object>> encodingList = new ArrayList<List<Object>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        for (int i = 1; i <= 3; ++i) {
            encodings.add(TSEncoding.RLE);
        }
        encodingList.add(encodings);
        ArrayList<List<Object>> compressionTypes = new ArrayList<List<Object>>();
        compressionTypes.add(Collections.singletonList(CompressionType.SNAPPY));
        ArrayList<CompressionType> compressorList = new ArrayList<CompressionType>();
        for (int i = 0; i <= 2; ++i) {
            compressorList.add(this.compressionType);
        }
        compressionTypes.add(compressorList);
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("s0");
        schemaNames.add("vector");
        CreateTemplatePlan plan = new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
        CreateTemplatePlan treePlan = this.getTreeTemplatePlan();
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            int i;
            schemaProcessor.createSchemaTemplate(plan);
            schemaProcessor.createSchemaTemplate(treePlan);
            SetTemplatePlan setSchemaTemplatePlan = new SetTemplatePlan("template1", "root.laptop.d1");
            SetTemplatePlan setSchemaTemplatePlan1 = new SetTemplatePlan("treeTemplate", "root.tree.d0");
            schemaProcessor.setSchemaTemplate(setSchemaTemplatePlan);
            schemaProcessor.setSchemaTemplate(setSchemaTemplatePlan1);
            schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.laptop.d1")));
            schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.tree.d0")));
            ShowTimeSeriesPlan showTreeTSPlan = new ShowTimeSeriesPlan(new PartialPath("root.tree.d0.**"), false, null, null, 0, 0, false);
            List treeShowResult = schemaProcessor.showTimeseries(showTreeTSPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
            Assert.assertEquals((long)4L, (long)treeShowResult.size());
            HashSet<String> checkSet = new HashSet<String>();
            checkSet.add("root.tree.d0.d1.s1");
            checkSet.add("root.tree.d0.s2");
            checkSet.add("root.tree.d0.GPS.x");
            checkSet.add("root.tree.d0.GPS.y");
            for (ShowTimeSeriesResult res : treeShowResult) {
                checkSet.remove(res.getName());
            }
            Assert.assertTrue((boolean)checkSet.isEmpty());
            ShowTimeSeriesPlan showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.laptop.d1.s0"), false, null, null, 0, 0, false);
            List result = schemaProcessor.showTimeseries(showTimeSeriesPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"root.laptop.d1.s0", (Object)((ShowTimeSeriesResult)result.get(0)).getName());
            showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.laptop.d1.vector.s1"), false, null, null, 0, 0, false);
            result = schemaProcessor.showTimeseries(showTimeSeriesPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
            Assert.assertEquals((long)1L, (long)result.size());
            Assert.assertEquals((Object)"root.laptop.d1.vector.s1", (Object)((ShowTimeSeriesResult)result.get(0)).getName());
            showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.laptop.**"), false, null, null, 0, 0, false);
            result = schemaProcessor.showTimeseries(showTimeSeriesPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
            Assert.assertEquals((long)4L, (long)result.size());
            HashSet<String> set = new HashSet<String>();
            for (i = 1; i < result.size(); ++i) {
                set.add("root.laptop.d1.vector.s" + i);
            }
            set.add("root.laptop.d1.s0");
            for (i = 0; i < result.size(); ++i) {
                set.remove(((ShowTimeSeriesResult)result.get(i)).getName());
            }
            Assert.assertTrue((boolean)set.isEmpty());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void minimumTestForWildcardInTemplate() throws MetadataException {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        CreateTemplatePlan treePlan = this.getTreeTemplatePlan();
        schemaProcessor.createSchemaTemplate(treePlan);
        SetTemplatePlan setSchemaTemplatePlan1 = new SetTemplatePlan("treeTemplate", "root.tree.d0");
        schemaProcessor.setSchemaTemplate(setSchemaTemplatePlan1);
        schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.tree.d0")));
        ShowTimeSeriesPlan showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.tree.**.s1"), false, null, null, 0, 0, false);
        List result = schemaProcessor.showTimeseries(showTimeSeriesPlan, EnvironmentUtils.TEST_QUERY_CONTEXT);
        Assert.assertEquals((long)1L, (long)result.size());
    }

    @Test
    public void testCountTimeseriesWithTemplate() throws IOException {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("s0"));
        measurementList.add(Collections.singletonList("s1"));
        ArrayList<List<TSDataType>> dataTypeList = new ArrayList<List<TSDataType>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT32));
        dataTypeList.add(Collections.singletonList(TSDataType.FLOAT));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        for (int i = 0; i < 2; ++i) {
            compressionTypes.add(Collections.singletonList(this.compressionType));
        }
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("s0");
        schemaNames.add("s1");
        CreateTemplatePlan plan = new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.createSchemaTemplate(plan);
            schemaProcessor.createSchemaTemplate(this.getTreeTemplatePlan());
            SetTemplatePlan setSchemaTemplatePlan = new SetTemplatePlan("template1", "root.laptop.d1");
            schemaProcessor.setSchemaTemplate(setSchemaTemplatePlan);
            schemaProcessor.setSchemaTemplate(new SetTemplatePlan("treeTemplate", "root.tree.d0"));
            schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.laptop.d1")));
            schemaProcessor.createTimeseries(new PartialPath("root.computer.d1.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            SetTemplatePlan setTemplatePlan = new SetTemplatePlan("template1", "root.computer");
            schemaProcessor.setSchemaTemplate(setTemplatePlan);
            schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.computer.d1")));
            schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.tree.d0")));
            schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.tree.d0.v0")));
            schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.tree.d0.v1")));
            Assert.assertEquals((long)2L, (long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.d1.**")));
            Assert.assertEquals((long)1L, (long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.d1.s1")));
            Assert.assertEquals((long)1L, (long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.computer.d1.s1")));
            Assert.assertEquals((long)1L, (long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.computer.d1.s2")));
            Assert.assertEquals((long)3L, (long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.computer.d1.**")));
            Assert.assertEquals((long)3L, (long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.computer.**")));
            Assert.assertEquals((long)12L, (long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.tree.**")));
            Assert.assertEquals((long)17L, (long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.**")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCountDeviceWithTemplate() {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("s0"));
        measurementList.add(Collections.singletonList("s1"));
        ArrayList<List<TSDataType>> dataTypeList = new ArrayList<List<TSDataType>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT32));
        dataTypeList.add(Collections.singletonList(TSDataType.FLOAT));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        for (int i = 0; i < 2; ++i) {
            compressionTypes.add(Collections.singletonList(this.compressionType));
        }
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add("s0");
        schemaNames.add("s1");
        CreateTemplatePlan plan = new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.createSchemaTemplate(plan);
            schemaProcessor.createSchemaTemplate(this.getTreeTemplatePlan());
            SetTemplatePlan setSchemaTemplatePlan = new SetTemplatePlan("template1", "root.laptop.d1");
            schemaProcessor.setSchemaTemplate(setSchemaTemplatePlan);
            schemaProcessor.setSchemaTemplate(new SetTemplatePlan("treeTemplate", "root.tree.d0"));
            schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.laptop.d1")));
            schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.tree.d0")));
            try {
                schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.non.existed.path")));
                Assert.fail();
            }
            catch (MetadataException e) {
                Assert.assertEquals((Object)"Path [root.non.existed.path] has not been set any template.", (Object)e.getMessage());
            }
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            Assert.assertEquals((long)1L, (long)schemaProcessor.getDevicesNum(new PartialPath("root.laptop.d1")));
            Assert.assertEquals((long)1L, (long)schemaProcessor.getDevicesNum(new PartialPath("root.laptop.d2")));
            Assert.assertEquals((long)2L, (long)schemaProcessor.getDevicesNum(new PartialPath("root.laptop.*")));
            Assert.assertEquals((long)2L, (long)schemaProcessor.getDevicesNum(new PartialPath("root.laptop.**")));
            Assert.assertEquals((long)1L, (long)schemaProcessor.getDevicesNum(new PartialPath("root.tree.**")));
            Assert.assertEquals((long)3L, (long)schemaProcessor.getDevicesNum(new PartialPath("root.**")));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.a.s3"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.a.s3"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            Assert.assertEquals((long)4L, (long)schemaProcessor.getDevicesNum(new PartialPath("root.laptop.**")));
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d2.s1"));
            Assert.assertEquals((long)3L, (long)schemaProcessor.getDevicesNum(new PartialPath("root.laptop.**")));
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d2.a.s3"));
            Assert.assertEquals((long)2L, (long)schemaProcessor.getDevicesNum(new PartialPath("root.laptop.**")));
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d1.a.s3"));
            Assert.assertEquals((long)1L, (long)schemaProcessor.getDevicesNum(new PartialPath("root.laptop.**")));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testTotalSeriesNumber() throws Exception {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d0"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s2.t1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s3"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s1"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d2.s2"), TSDataType.INT32, TSEncoding.PLAIN, CompressionType.GZIP, null);
            Assert.assertEquals((long)6L, (long)schemaProcessor.getTotalSeriesNumber());
            EnvironmentUtils.restartDaemon();
            Assert.assertEquals((long)6L, (long)schemaProcessor.getTotalSeriesNumber());
            schemaProcessor.deleteTimeseries(new PartialPath("root.laptop.d2.s1"));
            Assert.assertEquals((long)5L, (long)schemaProcessor.getTotalSeriesNumber());
            schemaProcessor.deleteStorageGroups(Collections.singletonList(new PartialPath("root.laptop")));
            Assert.assertEquals((long)0L, (long)schemaProcessor.getTotalSeriesNumber());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testStorageGroupNameWithHyphen() throws IllegalPathException {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root")));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.group_with_hyphen")));
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.group_with_hyphen"));
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.group_with_hyphen")));
    }

    @Test
    public void testCreateAlignedTimeseriesAndInsertWithMismatchDataType() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createAlignedTimeSeries(new PartialPath("root.laptop.d1.aligned_device"), Arrays.asList("s1", "s2", "s3"), Arrays.asList(TSDataType.valueOf((String)"FLOAT"), TSDataType.valueOf((String)"INT64"), TSDataType.valueOf((String)"INT32")), Arrays.asList(TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE")), Arrays.asList(this.compressionType, this.compressionType, this.compressionType));
            long time = 1L;
            TSDataType[] dataTypes = new TSDataType[]{TSDataType.FLOAT, TSDataType.DOUBLE, TSDataType.INT32};
            String[] columns = new String[]{"2.0", "10000", "100"};
            InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.laptop.d1.aligned_device"), time, new String[]{"s1", "s2", "s3"}, dataTypes, columns, true);
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            IMNode node = schemaProcessor.getSeriesSchemasAndReadLockDevice((InsertPlan)insertRowPlan);
            Assert.assertEquals((long)3L, (long)schemaProcessor.getAllTimeseriesCount(node.getPartialPath().concatNode("**")));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateAlignedTimeseriesAndInsertWithNotAlignedData() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createAlignedTimeSeries(new PartialPath("root.laptop.d1.aligned_device"), Arrays.asList("s1", "s2", "s3"), Arrays.asList(TSDataType.valueOf((String)"FLOAT"), TSDataType.valueOf((String)"INT64"), TSDataType.valueOf((String)"INT32")), Arrays.asList(TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE")), Arrays.asList(this.compressionType, this.compressionType, this.compressionType));
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            schemaProcessor.createTimeseries(new CreateTimeSeriesPlan(new PartialPath("root.laptop.d1.aligned_device.s4"), TSDataType.valueOf((String)"FLOAT"), TSEncoding.valueOf((String)"RLE"), this.compressionType, null, null, null, null));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Timeseries under this entity is aligned, please use createAlignedTimeseries or change entity. (Path: root.laptop.d1.aligned_device)", (Object)e.getMessage());
        }
        try {
            long time = 1L;
            TSDataType[] dataTypes = new TSDataType[]{TSDataType.FLOAT, TSDataType.INT64, TSDataType.INT32};
            String[] columns = new String[]{"1.0", "2", "3"};
            InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.laptop.d1.aligned_device"), time, new String[]{"s1", "s2", "s3"}, dataTypes, columns, false);
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            schemaProcessor.getSeriesSchemasAndReadLockDevice((InsertPlan)insertRowPlan);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Timeseries under path [root.laptop.d1.aligned_device] is aligned , please set InsertPlan.isAligned() = true", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateTimeseriesAndInsertWithMismatchDataType() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.s0"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            long time = 1L;
            TSDataType[] dataTypes = new TSDataType[]{TSDataType.FLOAT};
            String[] columns = new String[]{"2.0"};
            InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.laptop.d1"), time, new String[]{"s0"}, dataTypes, columns);
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            IMNode node = schemaProcessor.getSeriesSchemasAndReadLockDevice((InsertPlan)insertRowPlan);
            Assert.assertEquals((long)1L, (long)schemaProcessor.getAllTimeseriesCount(node.getPartialPath().concatNode("**")));
            Assert.assertNull((Object)insertRowPlan.getMeasurementMNodes()[0]);
            Assert.assertEquals((long)1L, (long)insertRowPlan.getFailedMeasurementNumber());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCreateTimeseriesAndInsertWithAlignedData() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.aligned_device.s1"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
            schemaProcessor.createTimeseries(new PartialPath("root.laptop.d1.aligned_device.s2"), TSDataType.valueOf((String)"INT64"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        }
        catch (Exception e) {
            Assert.fail();
        }
        try {
            schemaProcessor.createAlignedTimeSeries(new PartialPath("root.laptop.d1.aligned_device"), Arrays.asList("s3", "s4", "s5"), Arrays.asList(TSDataType.valueOf((String)"FLOAT"), TSDataType.valueOf((String)"INT64"), TSDataType.valueOf((String)"INT32")), Arrays.asList(TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE")), Arrays.asList(this.compressionType, this.compressionType, this.compressionType));
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Timeseries under this entity is not aligned, please use createTimeseries or change entity. (Path: root.laptop.d1.aligned_device)", (Object)e.getMessage());
        }
        try {
            long time = 1L;
            TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT64};
            String[] columns = new String[]{"1", "2"};
            InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.laptop.d1.aligned_device"), time, new String[]{"s1", "s2"}, dataTypes, columns, true);
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            schemaProcessor.getSeriesSchemasAndReadLockDevice((InsertPlan)insertRowPlan);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertEquals((Object)"Timeseries under path [root.laptop.d1.aligned_device] is not aligned , please set InsertPlan.isAligned() = false", (Object)e.getMessage());
        }
    }

    @Test
    public void testCreateAlignedTimeseriesWithIllegalNames() throws Exception {
        String[] measurementIds;
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
        PartialPath deviceId = new PartialPath("root.laptop.d1");
        for (String measurementId : measurementIds = new String[]{"time", "timestamp", "TIME", "TIMESTAMP"}) {
            PartialPath path = deviceId.concatNode(measurementId);
            try {
                schemaProcessor.createAlignedTimeSeries(path, Arrays.asList("s1", "s2", "s3"), Arrays.asList(TSDataType.valueOf((String)"FLOAT"), TSDataType.valueOf((String)"INT64"), TSDataType.valueOf((String)"INT32")), Arrays.asList(TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE")), Arrays.asList(this.compressionType, this.compressionType, this.compressionType));
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertEquals((Object)String.format("%s is not a legal path, because %s", path.getFullPath(), String.format("%s is an illegal name.", measurementId)), (Object)e.getMessage());
            }
        }
        PartialPath path = deviceId.concatNode("t1");
        for (String measurementId : measurementIds) {
            try {
                schemaProcessor.createAlignedTimeSeries(path, Arrays.asList(measurementId, "s2", "s3"), Arrays.asList(TSDataType.valueOf((String)"FLOAT"), TSDataType.valueOf((String)"INT64"), TSDataType.valueOf((String)"INT32")), Arrays.asList(TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE"), TSEncoding.valueOf((String)"RLE")), Arrays.asList(this.compressionType, this.compressionType, this.compressionType));
                Assert.fail();
            }
            catch (Exception e) {
                Assert.assertEquals((Object)String.format("%s is an illegal name.", measurementId), (Object)e.getMessage());
            }
        }
    }

    @Test
    public void testCreateAlignedTimeseriesWithAliasAndTags() throws Exception {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.setStorageGroup(new PartialPath("root.laptop"));
        PartialPath devicePath = new PartialPath("root.laptop.device0");
        List<String> measurements = Arrays.asList("s1", "s2", "s3", "s4", "s5");
        List<TSDataType> tsDataTypes = Arrays.asList(TSDataType.DOUBLE, TSDataType.TEXT, TSDataType.FLOAT, TSDataType.BOOLEAN, TSDataType.INT32);
        List<TSEncoding> tsEncodings = Arrays.asList(TSEncoding.PLAIN, TSEncoding.PLAIN, TSEncoding.PLAIN, TSEncoding.PLAIN, TSEncoding.PLAIN);
        List<CompressionType> compressionTypes = Arrays.asList(CompressionType.UNCOMPRESSED, CompressionType.UNCOMPRESSED, CompressionType.UNCOMPRESSED, CompressionType.UNCOMPRESSED, CompressionType.UNCOMPRESSED);
        List<String> aliasList = Arrays.asList("alias1", null, "alias2", null, null);
        ArrayList tagList = new ArrayList();
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("key", "value");
        tagList.add(tags);
        tagList.add(null);
        tagList.add(null);
        tagList.add(tags);
        tagList.add(null);
        CreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan = new CreateAlignedTimeSeriesPlan(devicePath, measurements, tsDataTypes, tsEncodings, compressionTypes, aliasList, tagList, null);
        schemaProcessor.createAlignedTimeSeries(createAlignedTimeSeriesPlan);
        Assert.assertEquals((long)5L, (long)schemaProcessor.getAllTimeseriesCount(new PartialPath("root.laptop.device0.*")));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.device0.alias2")));
        ShowTimeSeriesPlan showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.**"), false, "key", "value", 0, 0, false);
        List showTimeSeriesResults = schemaProcessor.showTimeseries(showTimeSeriesPlan, null);
        Assert.assertEquals((long)2L, (long)showTimeSeriesResults.size());
        showTimeSeriesResults = showTimeSeriesResults.stream().sorted(Comparator.comparing(ShowResult::getName)).collect(Collectors.toList());
        ShowTimeSeriesResult result = (ShowTimeSeriesResult)showTimeSeriesResults.get(0);
        Assert.assertEquals((Object)"root.laptop.device0.s1", (Object)result.getName());
        Assert.assertEquals((Object)"alias1", (Object)result.getAlias());
        Assert.assertEquals(tags, (Object)result.getTag());
        result = (ShowTimeSeriesResult)showTimeSeriesResults.get(1);
        Assert.assertEquals((Object)"root.laptop.device0.s4", (Object)result.getName());
        Assert.assertEquals(tags, (Object)result.getTag());
    }

    @Test
    public void testAutoCreateAlignedTimeseriesWhileInsert() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        try {
            long time = 1L;
            TSDataType[] dataTypes = new TSDataType[]{TSDataType.INT32, TSDataType.INT32};
            String[] columns = new String[]{"1", "2"};
            InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.laptop.d1.aligned_device"), time, new String[]{"s1", "s2"}, dataTypes, columns, true);
            insertRowPlan.setMeasurementMNodes(new IMeasurementMNode[insertRowPlan.getMeasurements().length]);
            schemaProcessor.getSeriesSchemasAndReadLockDevice((InsertPlan)insertRowPlan);
            Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s1")));
            Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s2")));
            insertRowPlan.setMeasurements(new String[]{"s3", "s4"});
            schemaProcessor.getSeriesSchemasAndReadLockDevice((InsertPlan)insertRowPlan);
            Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s3")));
            Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s4")));
            insertRowPlan.setMeasurements(new String[]{"s2", "s5"});
            schemaProcessor.getSeriesSchemasAndReadLockDevice((InsertPlan)insertRowPlan);
            Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.laptop.d1.aligned_device.s5")));
            insertRowPlan.setMeasurements(new String[]{"s2", "s3"});
            schemaProcessor.getSeriesSchemasAndReadLockDevice((InsertPlan)insertRowPlan);
        }
        catch (IOException | MetadataException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGetStorageGroupNodeByPath() {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        PartialPath partialPath = null;
        try {
            partialPath = new PartialPath("root.ln.sg1");
        }
        catch (IllegalPathException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            schemaProcessor.setStorageGroup(partialPath);
        }
        catch (MetadataException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            partialPath = new PartialPath("root.ln.sg2.device1.sensor1");
        }
        catch (IllegalPathException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            schemaProcessor.getStorageGroupNodeByPath(partialPath);
        }
        catch (StorageGroupNotSetException e) {
            Assert.assertEquals((Object)"Storage group is not set for current seriesPath: [root.ln.sg2.device1.sensor1]", (Object)e.getMessage());
        }
        catch (StorageGroupAlreadySetException e) {
            Assert.assertEquals((Object)"some children of root.ln have already been set to storage group", (Object)e.getMessage());
        }
        catch (MetadataException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testMeasurementIdWhileInsert() throws Exception {
        String[] illegalMeasurementIds;
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        PartialPath deviceId = new PartialPath("root.sg.d");
        InsertPlan insertPlan = this.getInsertPlan("`\"a+b\"`");
        schemaProcessor.getSeriesSchemasAndReadLockDevice(insertPlan);
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(deviceId.concatNode("`\"a+b\"`")));
        insertPlan = this.getInsertPlan("`\"a.b\"`");
        schemaProcessor.getSeriesSchemasAndReadLockDevice(insertPlan);
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(deviceId.concatNode("`\"a.b\"`")));
        insertPlan = this.getInsertPlan("`\"a\u201c\uff08\u03a6\uff09\u201db\"`");
        schemaProcessor.getSeriesSchemasAndReadLockDevice(insertPlan);
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(deviceId.concatNode("`\"a\u201c\uff08\u03a6\uff09\u201db\"`")));
        for (String measurementId : illegalMeasurementIds = new String[]{"time", "timestamp", "TIME", "TIMESTAMP"}) {
            insertPlan = this.getInsertPlan(measurementId);
            try {
                schemaProcessor.getSeriesSchemasAndReadLockDevice(insertPlan);
                Assert.assertFalse((boolean)schemaProcessor.isPathExist(deviceId.concatNode(measurementId)));
            }
            catch (MetadataException e) {
                e.printStackTrace();
            }
        }
    }

    private InsertPlan getInsertPlan(String measurementId) throws MetadataException {
        PartialPath deviceId = new PartialPath("root.sg.d");
        String[] measurementList = new String[]{measurementId};
        String[] values = new String[]{"1"};
        IMeasurementMNode[] measurementMNodes = new IMeasurementMNode[1];
        InsertRowPlan insertPlan = new InsertRowPlan(deviceId, 1L, measurementList, values);
        insertPlan.setMeasurementMNodes(measurementMNodes);
        insertPlan.getDataTypes()[0] = TSDataType.INT32;
        return insertPlan;
    }

    @Test
    public void testTemplateSchemaNameCheckWhileCreate() {
        String[] illegalSchemaNames;
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        for (String schemaName : illegalSchemaNames = new String[]{"a+b", "time", "timestamp", "TIME", "TIMESTAMP"}) {
            CreateTemplatePlan plan = this.getCreateTemplatePlan(schemaName);
            try {
                schemaProcessor.createSchemaTemplate(plan);
            }
            catch (MetadataException e) {
                Assert.assertEquals((Object)String.format("%s is an illegal name.", schemaName), (Object)e.getMessage());
            }
        }
    }

    private CreateTemplatePlan getCreateTemplatePlan(String schemaName) {
        ArrayList<List<String>> measurementList = new ArrayList<List<String>>();
        measurementList.add(Collections.singletonList("s0"));
        ArrayList<List<TSDataType>> dataTypeList = new ArrayList<List<TSDataType>>();
        dataTypeList.add(Collections.singletonList(TSDataType.INT32));
        ArrayList<List<TSEncoding>> encodingList = new ArrayList<List<TSEncoding>>();
        encodingList.add(Collections.singletonList(TSEncoding.RLE));
        ArrayList<List<CompressionType>> compressionTypes = new ArrayList<List<CompressionType>>();
        compressionTypes.add(Collections.singletonList(this.compressionType));
        ArrayList<String> schemaNames = new ArrayList<String>();
        schemaNames.add(schemaName);
        return new CreateTemplatePlan("template1", schemaNames, measurementList, dataTypeList, encodingList, compressionTypes);
    }

    @Test
    public void testDeviceNodeAfterAutoCreateTimeseriesFailure() throws Exception {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        PartialPath sg1 = new PartialPath("root.a.sg");
        schemaProcessor.setStorageGroup(sg1);
        PartialPath deviceId = new PartialPath("root.a.d");
        String[] measurementList = new String[]{"s"};
        String[] values = new String[]{"1"};
        IMeasurementMNode[] measurementMNodes = new IMeasurementMNode[1];
        InsertRowPlan insertPlan = new InsertRowPlan(deviceId, 1L, measurementList, values);
        insertPlan.setMeasurementMNodes(measurementMNodes);
        insertPlan.getDataTypes()[0] = TSDataType.INT32;
        try {
            schemaProcessor.getSeriesSchemasAndReadLockDevice((InsertPlan)insertPlan);
            Assert.fail();
        }
        catch (MetadataException e) {
            Assert.assertEquals((Object)"some children of root.a have already been set to storage group", (Object)e.getMessage());
            Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.a.d")));
        }
    }

    @Test
    public void testTimeseriesDeletionWithEntityUsingTemplate() throws MetadataException {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.setStorageGroup(new PartialPath("root.sg"));
        CreateTemplatePlan plan = this.getCreateTemplatePlan("s1");
        schemaProcessor.createSchemaTemplate(plan);
        SetTemplatePlan setPlan = new SetTemplatePlan("template1", "root.sg.d1");
        schemaProcessor.setSchemaTemplate(setPlan);
        schemaProcessor.createTimeseries(new PartialPath("root.sg.d1.s2"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        schemaProcessor.setUsingSchemaTemplate(new ActivateTemplatePlan(new PartialPath("root.sg.d1")));
        schemaProcessor.deleteTimeseries(new PartialPath("root.sg.d1.s2"));
        Assert.assertTrue((boolean)schemaProcessor.isPathExist(new PartialPath("root.sg.d1")));
        schemaProcessor.createTimeseries(new PartialPath("root.sg.d2.s2"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        schemaProcessor.deleteTimeseries(new PartialPath("root.sg.d2.s2"));
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.sg.d2")));
    }

    @Test
    public void testTagIndexRecovery() throws Exception {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        PartialPath path = new PartialPath("root.sg.d.s");
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("description", "oldValue");
        schemaProcessor.createTimeseries(new CreateTimeSeriesPlan(path, TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, null, tags, null, null));
        ShowTimeSeriesPlan showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.sg.d.s"), true, "description", "Value", 0, 0, false);
        List results = schemaProcessor.showTimeseries(showTimeSeriesPlan, new QueryContext());
        Assert.assertEquals((long)1L, (long)results.size());
        Map resultTag = ((ShowTimeSeriesResult)results.get(0)).getTag();
        Assert.assertEquals((Object)"oldValue", resultTag.get("description"));
        tags.put("description", "newValue");
        schemaProcessor.upsertTagsAndAttributes(null, tags, null, path);
        showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.sg.d.s"), true, "description", "Value", 0, 0, false);
        results = schemaProcessor.showTimeseries(showTimeSeriesPlan, new QueryContext());
        Assert.assertEquals((long)1L, (long)results.size());
        resultTag = ((ShowTimeSeriesResult)results.get(0)).getTag();
        Assert.assertEquals((Object)"newValue", resultTag.get("description"));
        EnvironmentUtils.restartDaemon();
        showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.sg.d.s"), true, "description", "oldValue", 0, 0, false);
        results = schemaProcessor.showTimeseries(showTimeSeriesPlan, new QueryContext());
        Assert.assertEquals((long)0L, (long)results.size());
        showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.sg.d.s"), true, "description", "Value", 0, 0, false);
        results = schemaProcessor.showTimeseries(showTimeSeriesPlan, new QueryContext());
        Assert.assertEquals((long)1L, (long)results.size());
        resultTag = ((ShowTimeSeriesResult)results.get(0)).getTag();
        Assert.assertEquals((Object)"newValue", resultTag.get("description"));
    }

    @Test
    public void testTagCreationViaMLogPlanDuringMetadataSync() throws Exception {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        PartialPath path = new PartialPath("root.sg.d.s");
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put("type", "test");
        CreateTimeSeriesPlan plan = new CreateTimeSeriesPlan(path, TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, null, tags, null, null);
        plan.setTagOffset(10L);
        schemaProcessor.operation((PhysicalPlan)plan);
        ShowTimeSeriesPlan showTimeSeriesPlan = new ShowTimeSeriesPlan(new PartialPath("root.sg.d.s"), true, "type", "test", 0, 0, false);
        List results = schemaProcessor.showTimeseries(showTimeSeriesPlan, new QueryContext());
        Assert.assertEquals((long)1L, (long)results.size());
        Map resultTag = ((ShowTimeSeriesResult)results.get(0)).getTag();
        Assert.assertEquals((Object)"test", resultTag.get("type"));
        Assert.assertEquals((long)0L, (long)schemaProcessor.getMeasurementMNode(path).getOffset());
    }

    @Test
    public void testCountNodesWithLevel() throws Exception {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.createTimeseries(new PartialPath("root.sgcc.wf03.wt01.temperature"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.sgcc.wf03.t01.status"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.ln.wf01.wt01.temperature"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.ln.wf01.wt01.status"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.ln.wf02.wt02.status"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.ln.wf02.wt02.hardware"), TSDataType.valueOf((String)"INT32"), TSEncoding.valueOf((String)"RLE"), this.compressionType, Collections.emptyMap());
        Assert.assertEquals((long)2L, (long)schemaProcessor.getNodesCountInGivenLevel(new PartialPath("root.**.temperature"), 3));
    }
}

