/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.lastCache.LastCacheManager;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.utils.TsPrimitiveType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SchemaAdvancedTest {
    private static LocalSchemaProcessor schemaProcessor = null;

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.setStorageGroup(new PartialPath("root.vehicle.d0"));
        schemaProcessor.setStorageGroup(new PartialPath("root.vehicle.d1"));
        schemaProcessor.setStorageGroup(new PartialPath("root.vehicle.d2"));
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d0.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d0.s1"), TSDataType.INT64, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d0.s2"), TSDataType.FLOAT, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d0.s3"), TSDataType.DOUBLE, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d0.s4"), TSDataType.BOOLEAN, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d0.s5"), TSDataType.TEXT, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d1.s0"), TSDataType.INT32, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d1.s1"), TSDataType.INT64, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d1.s2"), TSDataType.FLOAT, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d1.s3"), TSDataType.DOUBLE, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d1.s4"), TSDataType.BOOLEAN, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d1.s5"), TSDataType.TEXT, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void test() {
        try {
            List fileNames = schemaProcessor.getAllStorageGroupPaths();
            Assert.assertEquals((long)3L, (long)fileNames.size());
            if (((PartialPath)fileNames.get(0)).equals((Object)new PartialPath("root.vehicle.d0"))) {
                Assert.assertEquals((Object)new PartialPath("root.vehicle.d1"), fileNames.get(1));
            } else {
                Assert.assertEquals((Object)new PartialPath("root.vehicle.d0"), fileNames.get(1));
            }
            Assert.assertEquals((Object)new PartialPath("root.vehicle.d0"), (Object)schemaProcessor.getBelongedStorageGroup(new PartialPath("root.vehicle.d0.s1")));
            List pathList = schemaProcessor.getMeasurementPaths(new PartialPath("root.vehicle.d1.**"));
            Assert.assertEquals((long)6L, (long)pathList.size());
            pathList = schemaProcessor.getMeasurementPaths(new PartialPath("root.vehicle.d0.**"));
            Assert.assertEquals((long)6L, (long)pathList.size());
            pathList = schemaProcessor.getMeasurementPaths(new PartialPath("root.vehicle.d*.**"));
            Assert.assertEquals((long)12L, (long)pathList.size());
            pathList = schemaProcessor.getMeasurementPaths(new PartialPath("root.ve*.**"));
            Assert.assertEquals((long)12L, (long)pathList.size());
            pathList = schemaProcessor.getMeasurementPaths(new PartialPath("root.vehicle*.d*.s1"));
            Assert.assertEquals((long)2L, (long)pathList.size());
            pathList = schemaProcessor.getMeasurementPaths(new PartialPath("root.vehicle.d2.**"));
            Assert.assertEquals((long)0L, (long)pathList.size());
        }
        catch (MetadataException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCache() throws MetadataException {
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d2.s0"), TSDataType.DOUBLE, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d2.s1"), TSDataType.BOOLEAN, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d2.s2.g0"), TSDataType.TEXT, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d2.s3"), TSDataType.TEXT, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        IMNode node = schemaProcessor.getDeviceNode(new PartialPath("root.vehicle.d0"));
        Assert.assertEquals((Object)TSDataType.INT32, (Object)node.getChild("s0").getAsMeasurementMNode().getSchema().getType());
        Assert.assertFalse((boolean)schemaProcessor.isPathExist(new PartialPath("root.vehicle.d100")));
    }

    @Test
    public void testCachedLastTimeValue() throws MetadataException {
        schemaProcessor.createTimeseries(new PartialPath("root.vehicle.d2.s0"), TSDataType.DOUBLE, TSEncoding.RLE, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        TimeValuePair tv1 = new TimeValuePair(1000L, TsPrimitiveType.getByType((TSDataType)TSDataType.DOUBLE, (Object)1.0));
        TimeValuePair tv2 = new TimeValuePair(2000L, TsPrimitiveType.getByType((TSDataType)TSDataType.DOUBLE, (Object)3.0));
        TimeValuePair tv3 = new TimeValuePair(1500L, TsPrimitiveType.getByType((TSDataType)TSDataType.DOUBLE, (Object)2.5));
        PartialPath path = new PartialPath("root.vehicle.d2.s0");
        IMeasurementMNode node = schemaProcessor.getMeasurementMNode(path);
        LastCacheManager.updateLastCache((IMeasurementMNode)node, (TimeValuePair)tv1, (boolean)true, (Long)Long.MIN_VALUE);
        LastCacheManager.updateLastCache((IMeasurementMNode)node, (TimeValuePair)tv2, (boolean)true, (Long)Long.MIN_VALUE);
        Assert.assertEquals((long)tv2.getTimestamp(), (long)schemaProcessor.getLastCache(node).getTimestamp());
        LastCacheManager.updateLastCache((IMeasurementMNode)node, (TimeValuePair)tv3, (boolean)true, (Long)Long.MIN_VALUE);
        Assert.assertEquals((long)tv2.getTimestamp(), (long)schemaProcessor.getLastCache(node).getTimestamp());
    }
}

