/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.junit.Assert;
import org.junit.Test;

public class MetaUtilsTest {
    @Test
    public void testGetMultiFullPaths() {
        InternalMNode rootNode = new InternalMNode(null, "root");
        InternalMNode aNode = new InternalMNode((IMNode)rootNode, "a");
        rootNode.addChild(aNode.getName(), (IMNode)aNode);
        InternalMNode aaNode = new InternalMNode((IMNode)rootNode, "aa");
        rootNode.addChild(aaNode.getName(), (IMNode)aaNode);
        InternalMNode bNode = new InternalMNode((IMNode)aNode, "b");
        aNode.addChild(bNode.getName(), (IMNode)bNode);
        InternalMNode bbNode = new InternalMNode((IMNode)aaNode, "bb");
        aaNode.addChild(bbNode.getName(), (IMNode)bbNode);
        InternalMNode ccNode = new InternalMNode((IMNode)bbNode, "cc");
        bbNode.addChild(ccNode.getName(), (IMNode)ccNode);
        List multiFullPaths = MetaUtils.getMultiFullPaths((IMNode)rootNode);
        Assert.assertSame((Object)2, (Object)multiFullPaths.size());
        multiFullPaths.forEach(fullPath -> {
            if (fullPath.contains("aa")) {
                Assert.assertEquals((Object)"root.aa.bb.cc", (Object)fullPath);
            } else {
                Assert.assertEquals((Object)"root.a.b", (Object)fullPath);
            }
        });
    }

    @Test
    public void testGroupAlignedPath() throws MetadataException {
        ArrayList<MeasurementPath> pathList = new ArrayList<MeasurementPath>();
        MeasurementPath path1 = new MeasurementPath(new PartialPath("root.sg.device1.s1"), null);
        pathList.add(path1);
        MeasurementPath path2 = new MeasurementPath(new PartialPath("root.sg.device1.s2"), null);
        pathList.add(path2);
        MeasurementPath path3 = new MeasurementPath(new PartialPath("root.sg.aligned_device.s1"), null);
        path3.setUnderAlignedEntity(true);
        pathList.add(path3);
        MeasurementPath path4 = new MeasurementPath(new PartialPath("root.sg.aligned_device.s2"), null);
        path4.setUnderAlignedEntity(true);
        pathList.add(path4);
        AlignedPath alignedPath = new AlignedPath(path3);
        alignedPath.addMeasurement(path4);
        List result = MetaUtils.groupAlignedPaths(pathList);
        Assert.assertTrue((boolean)result.contains(path1));
        Assert.assertTrue((boolean)result.contains(path2));
        Assert.assertTrue((boolean)result.contains(alignedPath));
    }
}

