/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.version;

import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.version.SimpleFileVersionController;
import org.junit.Assert;
import org.junit.Test;

public class SimpleFileVersionControllerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws IOException {
        String tempFilePath = TestConstant.BASE_OUTPUT_PATH.concat("version.tmp");
        try {
            if (!new File(tempFilePath).mkdir()) {
                Assert.fail((String)"can not create version.tmp folder");
            }
            SimpleFileVersionController versionController = new SimpleFileVersionController(tempFilePath, 1L);
            Assert.assertEquals((long)SimpleFileVersionController.getSaveInterval(), (long)versionController.currVersion());
            for (int i = 0; i < 150; ++i) {
                versionController.nextVersion();
            }
            Assert.assertEquals((long)(SimpleFileVersionController.getSaveInterval() + 150L), (long)versionController.currVersion());
            versionController = new SimpleFileVersionController(tempFilePath, 1L);
            Assert.assertEquals((long)(SimpleFileVersionController.getSaveInterval() + 200L), (long)versionController.currVersion());
        }
        finally {
            FileUtils.deleteDirectory((File)new File(tempFilePath));
        }
    }
}

