/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup.dataregion;

import java.util.HashMap;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.dataregion.HashVirtualPartitioner;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class HashVirtualPartitionerTest {
    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
        StorageEngine.getInstance();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void basicTest() throws IllegalPathException {
        HashVirtualPartitioner hashVirtualPartitioner = HashVirtualPartitioner.getInstance();
        HashMap realMap = new HashMap();
        PartialPath d1 = new PartialPath("root.sg1.d1");
        PartialPath d2 = new PartialPath("root.sg1.d2");
        int sg1 = hashVirtualPartitioner.deviceToDataRegionId(d1);
        int sg2 = hashVirtualPartitioner.deviceToDataRegionId(d2);
        Assert.assertEquals((long)sg1, (long)Math.abs(d1.hashCode() % hashVirtualPartitioner.getPartitionCount()));
        Assert.assertEquals((long)sg2, (long)Math.abs(d2.hashCode() % hashVirtualPartitioner.getPartitionCount()));
    }
}

