/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.MetadataManagerHelper;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.engine.storagegroup.DataRegionTest;
import org.apache.iotdb.db.engine.storagegroup.StorageGroupInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessorInfo;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessException;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsFileProcessorTest {
    private TsFileProcessor processor;
    private String storageGroup = "root.vehicle";
    private final String systemDir = TestConstant.OUTPUT_DATA_DIR.concat("info");
    private StorageGroupInfo sgInfo;
    private String filePath = TestConstant.getTestTsFilePath((String)"root.vehicle", (long)0L, (long)0L, (long)0L);
    private String deviceId = "root.vehicle.d0";
    private String measurementId = "s0";
    private TSDataType dataType = TSDataType.INT32;
    private TSEncoding encoding = TSEncoding.RLE;
    private Map<String, String> props = Collections.emptyMap();
    private QueryContext context;
    private static Logger logger = LoggerFactory.getLogger(TsFileProcessorTest.class);

    @Before
    public void setUp() throws Exception {
        File file = new File(this.filePath);
        if (!file.getParentFile().exists()) {
            Assert.assertTrue((boolean)file.getParentFile().mkdirs());
        }
        EnvironmentUtils.envSetUp();
        this.sgInfo = new StorageGroupInfo((DataRegion)new DataRegionTest.DummyDataRegion(this.systemDir, this.storageGroup));
        MetadataManagerHelper.initMetadata();
        this.context = EnvironmentUtils.TEST_QUERY_CONTEXT;
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        EnvironmentUtils.cleanDir(TestConstant.OUTPUT_DATA_DIR);
    }

    @Test
    public void testWriteAndFlush() throws IOException, WriteProcessException, MetadataException {
        logger.info("testWriteAndFlush begin..");
        this.processor = new TsFileProcessor(this.storageGroup, SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, tsFileProcessor -> true, true);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        ArrayList tsfileResourcesForQuery = new ArrayList();
        MeasurementPath fullPath = new MeasurementPath(this.deviceId, this.measurementId, (IMeasurementSchema)new MeasurementSchema(this.measurementId, this.dataType, this.encoding, CompressionType.UNCOMPRESSED, this.props));
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)tsfileResourcesForQuery.isEmpty());
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)this.measurementId, (String)String.valueOf(i)));
            this.processor.insert(new InsertRowPlan(record));
        }
        tsfileResourcesForQuery.clear();
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        TsFileResource tsFileResource = (TsFileResource)tsfileResourcesForQuery.get(0);
        Assert.assertFalse((boolean)tsFileResource.getReadOnlyMemChunk((PartialPath)fullPath).isEmpty());
        List memChunks = tsFileResource.getReadOnlyMemChunk((PartialPath)fullPath);
        for (ReadOnlyMemChunk chunk : memChunks) {
            IPointReader iterator = chunk.getPointReader();
            for (int num = 1; num <= 100; ++num) {
                iterator.hasNextTimeValuePair();
                TimeValuePair timeValuePair = iterator.nextTimeValuePair();
                Assert.assertEquals((long)num, (long)timeValuePair.getTimestamp());
                Assert.assertEquals((long)num, (long)timeValuePair.getValue().getInt());
            }
        }
        this.processor.syncFlush();
        tsfileResourcesForQuery.clear();
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath).isEmpty());
        this.processor.syncClose();
    }

    @Test
    public void testWriteAndRestoreMetadata() throws IOException, WriteProcessException, MetadataException {
        logger.info("testWriteAndRestoreMetadata begin..");
        this.processor = new TsFileProcessor(this.storageGroup, SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, tsFileProcessor -> true, true);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        ArrayList tsfileResourcesForQuery = new ArrayList();
        MeasurementPath fullPath = new MeasurementPath(this.deviceId, this.measurementId, (IMeasurementSchema)new MeasurementSchema(this.measurementId, this.dataType, this.encoding, CompressionType.UNCOMPRESSED, this.props));
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)tsfileResourcesForQuery.isEmpty());
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)this.measurementId, (String)String.valueOf(i)));
            this.processor.insert(new InsertRowPlan(record));
        }
        tsfileResourcesForQuery.clear();
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        Assert.assertFalse((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath).isEmpty());
        int num = 1;
        List memChunks = ((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath);
        for (ReadOnlyMemChunk chunk : memChunks) {
            IPointReader iterator = chunk.getPointReader();
            while (num <= 100) {
                iterator.hasNextTimeValuePair();
                TimeValuePair timeValuePair = iterator.nextTimeValuePair();
                Assert.assertEquals((long)num, (long)timeValuePair.getTimestamp());
                Assert.assertEquals((long)num, (long)timeValuePair.getValue().getInt());
                ++num;
            }
        }
        logger.info("syncFlush..");
        this.processor.syncFlush();
        tsfileResourcesForQuery.clear();
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath).isEmpty());
        RestorableTsFileIOWriter tsFileIOWriter = this.processor.getWriter();
        Map chunkMetaDataListInChunkGroups = tsFileIOWriter.getDeviceChunkMetadataMap();
        RestorableTsFileIOWriter restorableTsFileIOWriter = new RestorableTsFileIOWriter(SystemFileFactory.INSTANCE.getFile(this.filePath));
        Map restoredChunkMetaDataListInChunkGroups = restorableTsFileIOWriter.getDeviceChunkMetadataMap();
        Assert.assertEquals((long)chunkMetaDataListInChunkGroups.size(), (long)restoredChunkMetaDataListInChunkGroups.size());
        for (Map.Entry entry1 : chunkMetaDataListInChunkGroups.entrySet()) {
            for (Map.Entry entry2 : restoredChunkMetaDataListInChunkGroups.entrySet()) {
                Assert.assertEquals(entry1.getKey(), entry2.getKey());
                Assert.assertEquals((long)((List)entry1.getValue()).size(), (long)((List)entry2.getValue()).size());
                for (int i = 0; i < ((List)entry1.getValue()).size(); ++i) {
                    ChunkMetadata chunkMetaData = (ChunkMetadata)((List)entry1.getValue()).get(i);
                    chunkMetaData.setFilePath(this.filePath);
                    ChunkMetadata chunkMetadataRestore = (ChunkMetadata)((List)entry2.getValue()).get(i);
                    chunkMetadataRestore.setFilePath(this.filePath);
                    Assert.assertEquals((Object)chunkMetaData, (Object)chunkMetadataRestore);
                }
            }
        }
        restorableTsFileIOWriter.close();
        logger.info("syncClose..");
        this.processor.syncClose();
    }

    @Test
    public void testMultiFlush() throws IOException, WriteProcessException, MetadataException {
        logger.info("testWriteAndRestoreMetadata begin..");
        this.processor = new TsFileProcessor(this.storageGroup, SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, tsFileProcessor -> true, true);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        ArrayList tsfileResourcesForQuery = new ArrayList();
        MeasurementPath fullPath = new MeasurementPath(this.deviceId, this.measurementId, (IMeasurementSchema)new MeasurementSchema(this.measurementId, this.dataType, this.encoding, CompressionType.UNCOMPRESSED, this.props));
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)tsfileResourcesForQuery.isEmpty());
        for (int flushId = 0; flushId < 10; ++flushId) {
            for (int i = 1; i <= 10; ++i) {
                TSRecord record = new TSRecord((long)i, this.deviceId);
                record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)this.measurementId, (String)String.valueOf(i)));
                this.processor.insert(new InsertRowPlan(record));
            }
            this.processor.asyncFlush();
        }
        this.processor.syncFlush();
        tsfileResourcesForQuery.clear();
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        Assert.assertFalse((boolean)tsfileResourcesForQuery.isEmpty());
        TestCase.assertTrue((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath).isEmpty());
        this.processor.syncClose();
    }

    @Test
    public void alignedTvListRamCostTest() throws MetadataException, WriteProcessException, IOException {
        this.processor = new TsFileProcessor(this.storageGroup, SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, tsFileProcessor -> true, true);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        this.processor.insertTablet(this.genInsertTablePlan(0L, true), 0, 10, new TSStatus[10]);
        IMemTable memTable = this.processor.getWorkMemTable();
        Assert.assertEquals((long)828424L, (long)memTable.getTVListsRamCost());
        this.processor.insertTablet(this.genInsertTablePlan(100L, true), 0, 10, new TSStatus[10]);
        Assert.assertEquals((long)828424L, (long)memTable.getTVListsRamCost());
        this.processor.insertTablet(this.genInsertTablePlan(200L, true), 0, 10, new TSStatus[10]);
        Assert.assertEquals((long)828424L, (long)memTable.getTVListsRamCost());
        Assert.assertEquals((long)90000L, (long)memTable.getTotalPointsNum());
        Assert.assertEquals((long)720360L, (long)memTable.memSize());
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)this.measurementId, (String)String.valueOf(i)));
            this.processor.insert(new InsertRowPlan(record));
        }
        Assert.assertEquals((long)830120L, (long)memTable.getTVListsRamCost());
        Assert.assertEquals((long)90100L, (long)memTable.getTotalPointsNum());
        Assert.assertEquals((long)721560L, (long)memTable.memSize());
    }

    @Test
    public void nonAlignedTvListRamCostTest() throws MetadataException, WriteProcessException, IOException {
        this.processor = new TsFileProcessor(this.storageGroup, SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, tsFileProcessor -> true, true);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        this.processor.insertTablet(this.genInsertTablePlan(0L, false), 0, 10, new TSStatus[10]);
        IMemTable memTable = this.processor.getWorkMemTable();
        Assert.assertEquals((long)1656000L, (long)memTable.getTVListsRamCost());
        this.processor.insertTablet(this.genInsertTablePlan(100L, false), 0, 10, new TSStatus[10]);
        Assert.assertEquals((long)1656000L, (long)memTable.getTVListsRamCost());
        this.processor.insertTablet(this.genInsertTablePlan(200L, false), 0, 10, new TSStatus[10]);
        Assert.assertEquals((long)1656000L, (long)memTable.getTVListsRamCost());
        Assert.assertEquals((long)90000L, (long)memTable.getTotalPointsNum());
        Assert.assertEquals((long)1440000L, (long)memTable.memSize());
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)this.measurementId, (String)String.valueOf(i)));
            this.processor.insert(new InsertRowPlan(record));
        }
        Assert.assertEquals((long)1657696L, (long)memTable.getTVListsRamCost());
        Assert.assertEquals((long)90100L, (long)memTable.getTotalPointsNum());
        Assert.assertEquals((long)1441200L, (long)memTable.memSize());
    }

    @Test
    public void testWriteAndClose() throws IOException, WriteProcessException, MetadataException {
        logger.info("testWriteAndRestoreMetadata begin..");
        this.processor = new TsFileProcessor(this.storageGroup, SystemFileFactory.INSTANCE.getFile(this.filePath), this.sgInfo, this::closeTsFileProcessor, tsFileProcessor -> true, true);
        TsFileProcessorInfo tsFileProcessorInfo = new TsFileProcessorInfo(this.sgInfo);
        this.processor.setTsFileProcessorInfo(tsFileProcessorInfo);
        this.sgInfo.initTsFileProcessorInfo(this.processor);
        SystemInfo.getInstance().reportStorageGroupStatus(this.sgInfo, this.processor);
        ArrayList tsfileResourcesForQuery = new ArrayList();
        MeasurementPath fullPath = new MeasurementPath(this.deviceId, this.measurementId, (IMeasurementSchema)new MeasurementSchema(this.measurementId, this.dataType, this.encoding, CompressionType.UNCOMPRESSED, this.props));
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        TestCase.assertTrue((boolean)tsfileResourcesForQuery.isEmpty());
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, this.deviceId);
            record.addTuple(DataPoint.getDataPoint((TSDataType)this.dataType, (String)this.measurementId, (String)String.valueOf(i)));
            this.processor.insert(new InsertRowPlan(record));
        }
        tsfileResourcesForQuery.clear();
        this.processor.query(Collections.singletonList(fullPath), this.context, tsfileResourcesForQuery);
        Assert.assertFalse((boolean)tsfileResourcesForQuery.isEmpty());
        Assert.assertFalse((boolean)((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath).isEmpty());
        List memChunks = ((TsFileResource)tsfileResourcesForQuery.get(0)).getReadOnlyMemChunk((PartialPath)fullPath);
        for (ReadOnlyMemChunk chunk : memChunks) {
            IPointReader iterator = chunk.getPointReader();
            for (int num = 1; num <= 100; ++num) {
                iterator.hasNextTimeValuePair();
                TimeValuePair timeValuePair = iterator.nextTimeValuePair();
                Assert.assertEquals((long)num, (long)timeValuePair.getTimestamp());
                Assert.assertEquals((long)num, (long)timeValuePair.getValue().getInt());
            }
        }
        this.processor.syncClose();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        TestCase.assertTrue((boolean)this.processor.getTsFileResource().isClosed());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTsFileProcessor(TsFileProcessor unsealedTsFileProcessor) throws TsFileProcessorException {
        TsFileResource resource;
        TsFileResource tsFileResource = resource = unsealedTsFileProcessor.getTsFileResource();
        synchronized (tsFileResource) {
            for (String deviceId : resource.getDevices()) {
                resource.updateEndTime(deviceId, resource.getStartTime(deviceId));
            }
            try {
                resource.close();
            }
            catch (IOException e) {
                throw new TsFileProcessorException((Exception)e);
            }
        }
    }

    private InsertTabletPlan genInsertTablePlan(long startTime, boolean isAligned) throws IllegalPathException {
        String deviceId = "root.sg.device5";
        String[] measurements = new String[3000];
        ArrayList<Integer> dataTypesList = new ArrayList<Integer>();
        TSDataType[] dataTypes = new TSDataType[3000];
        TSEncoding[] encodings = new TSEncoding[3000];
        IMeasurementMNode[] mNodes = new IMeasurementMNode[3000];
        for (int i = 0; i < 3000; ++i) {
            measurements[i] = "s" + i;
            dataTypesList.add(TSDataType.INT64.ordinal());
            dataTypes[i] = TSDataType.INT64;
            encodings[i] = TSEncoding.PLAIN;
            MeasurementSchema schema = new MeasurementSchema(measurements[i], dataTypes[i], encodings[i]);
            mNodes[i] = MeasurementMNode.getMeasurementMNode(null, (String)measurements[i], (IMeasurementSchema)schema, null);
        }
        InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath(deviceId), measurements, dataTypesList);
        long[] times = new long[10];
        Object[] columns = new Object[3000];
        for (int i = 0; i < 3000; ++i) {
            columns[i] = new long[10];
        }
        for (long r = 0L; r < 10L; ++r) {
            times[(int)r] = r + startTime;
            for (int i = 0; i < 3000; ++i) {
                ((long[])columns[i])[(int)r] = r;
            }
        }
        insertTabletPlan.setTimes(times);
        insertTabletPlan.setColumns(columns);
        insertTabletPlan.setRowCount(times.length);
        insertTabletPlan.setMeasurementMNodes(mNodes);
        insertTabletPlan.setAligned(isAligned);
        return insertTabletPlan;
    }
}

