/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.RandomNum;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;

public class FileNodeManagerBenchmark {
    private static int numOfWorker;
    private static int numOfDevice;
    private static int numOfMeasurement;
    private static long numOfTotalLine;
    private static CountDownLatch latch;
    private static AtomicLong atomicLong;
    private static String[] devices;
    private static String prefix;
    private static String[] measurements;

    private static void prepare() throws MetadataException {
        LocalSchemaProcessor schemaProcessor = IoTDB.schemaProcessor;
        schemaProcessor.setStorageGroup(new PartialPath(prefix));
        for (String device : devices) {
            for (String measurement : measurements) {
                schemaProcessor.createTimeseries(new PartialPath(device + "." + measurement), TSDataType.INT64, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
        }
    }

    private static void tearDown() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
    }

    public static void main(String[] args) throws InterruptedException, IOException, MetadataException, StorageEngineException {
        FileNodeManagerBenchmark.tearDown();
        FileNodeManagerBenchmark.prepare();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < numOfWorker; ++i) {
            Worker worker = new Worker();
            worker.start();
        }
        latch.await();
        long endTime = System.currentTimeMillis();
        System.out.println("Elapsed time: " + (endTime - startTime) + "ms");
        FileNodeManagerBenchmark.tearDown();
    }

    private static TSRecord getRecord(String deltaObjectId, long timestamp) {
        TSRecord tsRecord = new TSRecord(timestamp, deltaObjectId);
        for (String measurement : measurements) {
            tsRecord.addTuple((DataPoint)new LongDataPoint(measurement, timestamp));
        }
        return tsRecord;
    }

    static {
        int i;
        numOfWorker = 10;
        numOfDevice = 10;
        numOfMeasurement = 10;
        numOfTotalLine = 10000000L;
        latch = new CountDownLatch(numOfWorker);
        atomicLong = new AtomicLong();
        devices = new String[numOfDevice];
        prefix = "root.bench";
        measurements = new String[numOfMeasurement];
        for (i = 0; i < numOfDevice; ++i) {
            FileNodeManagerBenchmark.devices[i] = prefix + "." + "device_" + i;
        }
        for (i = 0; i < numOfMeasurement; ++i) {
            FileNodeManagerBenchmark.measurements[i] = "measurement_" + i;
        }
    }

    private static class Worker
    extends Thread {
        private Worker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long seed;
                while ((seed = atomicLong.addAndGet(1L)) <= numOfTotalLine) {
                    long time = RandomNum.getRandomLong(1L, seed);
                    String deltaObject = devices[(int)(time % (long)numOfDevice)];
                    TSRecord tsRecord = FileNodeManagerBenchmark.getRecord(deltaObject, time);
                    StorageEngine.getInstance().insert(new InsertRowPlan(tsRecord));
                }
            }
            catch (MetadataException | StorageEngineException e) {
                e.printStackTrace();
            }
            finally {
                latch.countDown();
            }
        }
    }
}

