/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.modification;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.junit.Assert;
import org.junit.Test;

public class ModificationFileTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void readMyWrite() {
        String tempFileName = TestConstant.BASE_OUTPUT_PATH.concat("mod.temp");
        Modification[] modifications = new Modification[]{new Deletion(new PartialPath(new String[]{"d1", "s1"}), 1L, 1L), new Deletion(new PartialPath(new String[]{"d1", "s2"}), 2L, 2L), new Deletion(new PartialPath(new String[]{"d1", "s3"}), 3L, 3L, 4L), new Deletion(new PartialPath(new String[]{"d1", "s41"}), 4L, 4L, 5L)};
        try (ModificationFile mFile = new ModificationFile(tempFileName);){
            int i;
            for (int i2 = 0; i2 < 2; ++i2) {
                mFile.write(modifications[i2]);
            }
            List modificationList = (List)mFile.getModifications();
            for (i = 0; i < 2; ++i) {
                Assert.assertEquals((Object)modifications[i], modificationList.get(i));
            }
            for (i = 2; i < 4; ++i) {
                mFile.write(modifications[i]);
            }
            modificationList = (List)mFile.getModifications();
            for (i = 0; i < 4; ++i) {
                Assert.assertEquals((Object)modifications[i], modificationList.get(i));
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            new File(tempFileName).delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAbort() {
        String tempFileName = TestConstant.BASE_OUTPUT_PATH.concat("mod.temp");
        Modification[] modifications = new Modification[]{new Deletion(new PartialPath(new String[]{"d1", "s1"}), 1L, 1L), new Deletion(new PartialPath(new String[]{"d1", "s2"}), 2L, 2L), new Deletion(new PartialPath(new String[]{"d1", "s3"}), 3L, 3L, 4L), new Deletion(new PartialPath(new String[]{"d1", "s4"}), 4L, 4L, 5L)};
        try (ModificationFile mFile = new ModificationFile(tempFileName);){
            int i;
            for (int i2 = 0; i2 < 2; ++i2) {
                mFile.write(modifications[i2]);
            }
            List modificationList = (List)mFile.getModifications();
            for (i = 0; i < 2; ++i) {
                Assert.assertEquals((Object)modifications[i], modificationList.get(i));
            }
            for (i = 2; i < 4; ++i) {
                mFile.write(modifications[i]);
            }
            modificationList = (List)mFile.getModifications();
            mFile.abort();
            for (i = 0; i < 3; ++i) {
                Assert.assertEquals((Object)modifications[i], modificationList.get(i));
            }
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        finally {
            new File(tempFileName).delete();
        }
    }
}

