/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.modification;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.directories.DirectoryManager;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.io.LocalTextModificationAccessor;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.SchemaTestUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.expression.impl.SingleSeriesExpression;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.DoubleDataPoint;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DeletionFileNodeTest {
    private static String[] measurements = new String[10];
    private String processorName = "root.test";
    private TSDataType dataType = TSDataType.DOUBLE;
    private TSEncoding encoding = TSEncoding.PLAIN;

    @Before
    public void setup() throws MetadataException {
        EnvironmentUtils.envSetUp();
        IoTDB.schemaProcessor.setStorageGroup(new PartialPath(this.processorName));
        for (int i = 0; i < 10; ++i) {
            IoTDB.schemaProcessor.createTimeseries(new PartialPath(this.processorName + "." + measurements[i]), this.dataType, this.encoding, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        }
    }

    @After
    public void teardown() throws IOException, StorageEngineException {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testDeleteInBufferWriteCache() throws StorageEngineException, QueryProcessException, IOException, MetadataException {
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, this.processorName);
            for (int j = 0; j < 10; ++j) {
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[j], (double)i * 1.0));
            }
            StorageEngine.getInstance().insert(new InsertRowPlan(record));
        }
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[3]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[4]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 0L, 30L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 30L, 50L, -1L, null);
        this.checkSeriesPointCount(5, 50);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteWithTimePartitionFilter() throws StorageEngineException, QueryProcessException, IOException {
        boolean prevEnablePartition = StorageEngine.isEnablePartition();
        long prevPartitionInterval = StorageEngine.getTimePartitionInterval();
        int prevConcurrentTimePartition = IoTDBDescriptor.getInstance().getConfig().getConcurrentWritingTimePartition();
        int prevWalBufferSize = IoTDBDescriptor.getInstance().getConfig().getWalBufferSize();
        try {
            StorageEngine.setEnablePartition((boolean)true);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentWritingTimePartition(10);
            IoTDBDescriptor.getInstance().getConfig().setWalBufferSize(16384);
            long newPartitionInterval = 100L;
            StorageEngine.setTimePartitionInterval((long)newPartitionInterval);
            for (int i = 0; i < 10; ++i) {
                TSRecord record = new TSRecord((long)i * newPartitionInterval, this.processorName);
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[0], (double)i * 1.0));
                StorageEngine.getInstance().insert(new InsertRowPlan(record));
            }
            StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[0]), 0L, Long.MAX_VALUE, -1L, (storageGroupName, timePartitionId) -> timePartitionId < 5L);
            this.checkSeriesPointCount(0, 5);
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
        finally {
            StorageEngine.setEnablePartition((boolean)prevEnablePartition);
            StorageEngine.setTimePartitionInterval((long)prevPartitionInterval);
            IoTDBDescriptor.getInstance().getConfig().setConcurrentWritingTimePartition(prevConcurrentTimePartition);
            IoTDBDescriptor.getInstance().getConfig().setWalBufferSize(prevWalBufferSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSeriesPointCount(int measurementIdx, int expectedCount) throws MetadataException, StorageEngineException, QueryProcessException, IOException {
        SingleSeriesExpression expression = new SingleSeriesExpression((Path)SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[measurementIdx]), null);
        Pair lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(Collections.singletonList((PartialPath)expression.getSeriesPath()));
        List lockList = (List)lockListAndProcessorToSeriesMapPair.left;
        Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
        try {
            QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, EnvironmentUtils.TEST_QUERY_CONTEXT, null);
            QueryDataSource dataSource = QueryResourceManager.getInstance().getQueryDataSource((PartialPath)expression.getSeriesPath(), EnvironmentUtils.TEST_QUERY_CONTEXT, null, true);
            int count = 0;
            for (TsFileResource seqResource : dataSource.getSeqResources()) {
                List timeValuePairs = seqResource.getReadOnlyMemChunk((PartialPath)expression.getSeriesPath());
                if (timeValuePairs == null) continue;
                for (ReadOnlyMemChunk chunk : timeValuePairs) {
                    IPointReader iterator = chunk.getPointReader();
                    while (iterator.hasNextTimeValuePair()) {
                        iterator.nextTimeValuePair();
                        ++count;
                    }
                }
            }
            Assert.assertEquals((long)expectedCount, (long)count);
            QueryResourceManager.getInstance().endQuery(EnvironmentUtils.TEST_QUERY_JOB_ID);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(lockList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteInBufferWriteFile() throws StorageEngineException, IOException, MetadataException {
        for (int i = 1; i <= 100; ++i) {
            TSRecord record = new TSRecord((long)i, this.processorName);
            for (int j = 0; j < 10; ++j) {
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[j], (double)i * 1.0));
            }
            StorageEngine.getInstance().insert(new InsertRowPlan(record));
        }
        StorageEngine.getInstance().syncCloseAllProcessor();
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[4]), 0L, 40L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[3]), 0L, 30L, -1L, null);
        Modification[] realModifications = new Modification[]{new Deletion(new PartialPath(this.processorName + "." + measurements[5]), 201L, 50L), new Deletion(new PartialPath(this.processorName + "." + measurements[4]), 202L, 40L), new Deletion(new PartialPath(this.processorName + "." + measurements[3]), 203L, 30L)};
        File fileNodeDir = new File(DirectoryManager.getInstance().getNextFolderForSequenceFile(), this.processorName);
        ArrayList<File> modFiles = new ArrayList<File>();
        for (File directory : fileNodeDir.listFiles()) {
            Assert.assertTrue((boolean)directory.isDirectory());
            if (!directory.isDirectory()) continue;
            for (File file : directory.listFiles()) {
                if (!file.isDirectory()) continue;
                for (File tsfile : file.listFiles()) {
                    if (!tsfile.getPath().endsWith(".mods")) continue;
                    modFiles.add(tsfile);
                }
            }
        }
        Assert.assertEquals((long)1L, (long)modFiles.size());
        try (LocalTextModificationAccessor accessor = new LocalTextModificationAccessor(((File)modFiles.get(0)).getPath());){
            Collection modifications = accessor.read();
            Assert.assertEquals((long)3L, (long)modifications.size());
            int i = 0;
            for (Modification modification : modifications) {
                Assert.assertEquals((Object)modification.path, (Object)realModifications[i].path);
                Assert.assertEquals((Object)modification.type, (Object)realModifications[i].type);
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteInOverflowCache() throws StorageEngineException, QueryProcessException, IOException, MetadataException {
        int j;
        TSRecord record;
        int i;
        for (i = 101; i <= 200; ++i) {
            record = new TSRecord((long)i, this.processorName);
            for (j = 0; j < 10; ++j) {
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[j], (double)i * 1.0));
            }
            StorageEngine.getInstance().insert(new InsertRowPlan(record));
        }
        StorageEngine.getInstance().syncCloseAllProcessor();
        for (i = 1; i <= 100; ++i) {
            record = new TSRecord((long)i, this.processorName);
            for (j = 0; j < 10; ++j) {
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[j], (double)i * 1.0));
            }
            StorageEngine.getInstance().insert(new InsertRowPlan(record));
        }
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[3]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[4]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 0L, 30L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 30L, 50L, -1L, null);
        SingleSeriesExpression expression = new SingleSeriesExpression((Path)SchemaTestUtils.getMeasurementPath(this.processorName + "." + measurements[5]), null);
        Pair lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(Collections.singletonList((PartialPath)expression.getSeriesPath()));
        List lockList = (List)lockListAndProcessorToSeriesMapPair.left;
        Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
        try {
            QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, EnvironmentUtils.TEST_QUERY_CONTEXT, null);
            QueryDataSource dataSource = QueryResourceManager.getInstance().getQueryDataSource((PartialPath)expression.getSeriesPath(), EnvironmentUtils.TEST_QUERY_CONTEXT, null, true);
            List timeValuePairs = ((TsFileResource)dataSource.getUnseqResources().get(0)).getReadOnlyMemChunk((PartialPath)expression.getSeriesPath());
            int count = 0;
            for (ReadOnlyMemChunk chunk : timeValuePairs) {
                IPointReader iterator = chunk.getPointReader();
                while (iterator.hasNextTimeValuePair()) {
                    iterator.nextTimeValuePair();
                    ++count;
                }
            }
            Assert.assertEquals((long)50L, (long)count);
            QueryResourceManager.getInstance().endQuery(EnvironmentUtils.TEST_QUERY_JOB_ID);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(lockList);
        }
    }

    @Test
    public void testDeleteInOverflowFile() throws StorageEngineException, MetadataException {
        int j;
        TSRecord record;
        int i;
        for (i = 101; i <= 200; ++i) {
            record = new TSRecord((long)i, this.processorName);
            for (j = 0; j < 10; ++j) {
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[j], (double)i * 1.0));
            }
            StorageEngine.getInstance().insert(new InsertRowPlan(record));
        }
        StorageEngine.getInstance().syncCloseAllProcessor();
        for (i = 1; i <= 100; ++i) {
            record = new TSRecord((long)i, this.processorName);
            for (j = 0; j < 10; ++j) {
                record.addTuple((DataPoint)new DoubleDataPoint(measurements[j], (double)i * 1.0));
            }
            StorageEngine.getInstance().insert(new InsertRowPlan(record));
        }
        StorageEngine.getInstance().syncCloseAllProcessor();
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[5]), 0L, 50L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[4]), 0L, 40L, -1L, null);
        StorageEngine.getInstance().delete(new PartialPath(this.processorName, measurements[3]), 0L, 30L, -1L, null);
        Modification[] realModifications = new Modification[]{new Deletion(new PartialPath(this.processorName + "." + measurements[5]), 301L, 50L), new Deletion(new PartialPath(this.processorName + "." + measurements[4]), 302L, 40L), new Deletion(new PartialPath(this.processorName + "." + measurements[3]), 303L, 30L)};
        File fileNodeDir = new File(DirectoryManager.getInstance().getNextFolderForUnSequenceFile(), this.processorName);
        ArrayList<File> modFiles = new ArrayList<File>();
        for (File directory : fileNodeDir.listFiles()) {
            Assert.assertTrue((boolean)directory.isDirectory());
            if (!directory.isDirectory()) continue;
            for (File file : directory.listFiles()) {
                if (!file.isDirectory()) continue;
                for (File tsfile : file.listFiles()) {
                    if (!tsfile.getPath().endsWith(".mods")) continue;
                    modFiles.add(tsfile);
                }
            }
        }
        Assert.assertEquals((long)1L, (long)modFiles.size());
        LocalTextModificationAccessor accessor = new LocalTextModificationAccessor(((File)modFiles.get(0)).getPath());
        Collection modifications = accessor.read();
        Assert.assertEquals((long)3L, (long)modifications.size());
        int i2 = 0;
        for (Modification modification : modifications) {
            Assert.assertEquals((Object)modification.path, (Object)realModifications[i2].path);
            Assert.assertEquals((Object)modification.type, (Object)realModifications[i2].type);
            ++i2;
        }
    }

    static {
        for (int i = 0; i < 10; ++i) {
            DeletionFileNodeTest.measurements[i] = "m" + i;
        }
    }
}

