/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.memtable;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.metadata.idtable.entry.DeviceIDFactory;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;

public class MemTableTestUtils {
    public static String deviceId0 = "d0";
    public static String measurementId0 = "s0";
    public static TSDataType dataType0 = TSDataType.INT32;
    private static Schema schema = new Schema();

    public static void produceData(IMemTable iMemTable, long startTime, long endTime, String deviceId, String measurementId, TSDataType dataType) throws IllegalPathException {
        if (startTime > endTime) {
            throw new RuntimeException(String.format("start time %d > end time %d", startTime, endTime));
        }
        for (long l = startTime; l <= endTime; ++l) {
            iMemTable.write(DeviceIDFactory.getInstance().getDeviceID(new PartialPath(deviceId)), Collections.singletonList(new MeasurementSchema(measurementId, dataType, TSEncoding.PLAIN)), l, new Object[]{(int)l});
        }
    }

    public static void produceVectorData(IMemTable iMemTable) throws IllegalPathException {
        iMemTable.write(MemTableTestUtils.genInsertTablePlan(), 1, 101);
    }

    private static InsertTabletPlan genInsertTablePlan() throws IllegalPathException {
        String[] measurements = new String[]{"sensor0", "sensor1"};
        ArrayList<Integer> dataTypesList = new ArrayList<Integer>();
        TSDataType[] dataTypes = new TSDataType[2];
        dataTypesList.add(TSDataType.BOOLEAN.ordinal());
        dataTypesList.add(TSDataType.INT64.ordinal());
        dataTypes[0] = TSDataType.BOOLEAN;
        dataTypes[1] = TSDataType.INT64;
        TSEncoding[] encodings = new TSEncoding[]{TSEncoding.PLAIN, TSEncoding.GORILLA};
        IMeasurementMNode[] mNodes = new IMeasurementMNode[2];
        MeasurementSchema schema0 = new MeasurementSchema(measurements[0], dataTypes[0], encodings[0]);
        MeasurementSchema schema1 = new MeasurementSchema(measurements[1], dataTypes[1], encodings[1]);
        mNodes[0] = MeasurementMNode.getMeasurementMNode(null, (String)"sensor0", (IMeasurementSchema)schema0, null);
        mNodes[1] = MeasurementMNode.getMeasurementMNode(null, (String)"sensor1", (IMeasurementSchema)schema1, null);
        InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath(deviceId0), measurements, dataTypesList);
        insertTabletPlan.setAligned(true);
        long[] times = new long[101];
        Object[] columns = new Object[]{new boolean[101], new long[101]};
        for (long r = 0L; r < 101L; ++r) {
            times[(int)r] = r;
            ((boolean[])columns[0])[(int)r] = false;
            ((long[])columns[1])[(int)r] = r;
        }
        insertTabletPlan.setTimes(times);
        insertTabletPlan.setColumns(columns);
        insertTabletPlan.setRowCount(times.length);
        insertTabletPlan.setMeasurementMNodes(mNodes);
        return insertTabletPlan;
    }

    public static void produceNullableVectorData(IMemTable iMemTable) throws IllegalPathException {
        InsertTabletPlan plan = MemTableTestUtils.genInsertTablePlan();
        BitMap[] bitMaps = new BitMap[2];
        bitMaps[1] = new BitMap(101);
        for (int r = 0; r < 101; ++r) {
            if (r % 2 != 1) continue;
            bitMaps[1].mark(r);
        }
        plan.setBitMaps(bitMaps);
        iMemTable.write(plan, 1, 101);
    }

    public static Schema getSchema() {
        return schema;
    }

    static {
        schema.registerTimeseries(new Path(deviceId0), new MeasurementSchema(measurementId0, dataType0, TSEncoding.PLAIN));
    }
}

