/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner.sizetiered;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.compaction.inner.sizetiered.SizeTieredCompactionSelector;
import org.apache.iotdb.db.engine.storagegroup.FakedTsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.junit.Assert;
import org.junit.Test;

public class SizeTieredCompactionSelectorTest {
    @Test
    public void testSubmitWhenNextTimePartitionExists() {
        long originPartitionInterval = IoTDBDescriptor.getInstance().getConfig().getPartitionInterval();
        IoTDBDescriptor.getInstance().getConfig().setPartitionInterval(1000L);
        ArrayList<FakedTsFileResource> resources = new ArrayList<FakedTsFileResource>();
        for (int i = 0; i < 100; ++i) {
            FakedTsFileResource resource = new FakedTsFileResource(1024L, String.format("%d-%d-0-0.tsfile", i + 1, i + 1));
            resource.timeIndex.updateStartTime("root.test.d", (long)(i * 100));
            resource.timeIndex.updateEndTime("root.test.d", (long)((i + 1) * 100));
            resource.timePartition = i / 10;
            resources.add(resource);
        }
        TsFileManager manager = new TsFileManager("root.test", "0", "");
        manager.addAll(resources, true);
        for (long i = 0L; i < 9L; ++i) {
            Assert.assertEquals((long)1L, (long)new SizeTieredCompactionSelector("root.test", "0", i, true, manager).selectInnerSpaceTask((List)manager.getSequenceListByTimePartition(i)).size());
        }
        Assert.assertEquals((long)0L, (long)new SizeTieredCompactionSelector("root.test", "0", 9L, true, manager).selectInnerSpaceTask((List)manager.getSequenceListByTimePartition(9L)).size());
    }
}

