/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.inner.sizetiered;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.cache.ChunkCache;
import org.apache.iotdb.db.engine.cache.TimeSeriesMetadataCache;
import org.apache.iotdb.db.engine.compaction.CompactionUtils;
import org.apache.iotdb.db.engine.compaction.inner.AbstractInnerSpaceCompactionTest;
import org.apache.iotdb.db.engine.compaction.log.CompactionLogger;
import org.apache.iotdb.db.engine.compaction.performer.impl.ReadChunkCompactionPerformer;
import org.apache.iotdb.db.engine.compaction.task.CompactionRecoverTask;
import org.apache.iotdb.db.engine.compaction.task.CompactionTaskSummary;
import org.apache.iotdb.db.engine.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.engine.compaction.utils.CompactionFileGeneratorUtils;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.db.query.reader.series.SeriesRawDataBatchReader;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.SchemaTestUtils;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.writer.TsFileOutput;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SizeTieredCompactionRecoverTest
extends AbstractInnerSpaceCompactionTest {
    @Override
    @Before
    public void setUp() throws IOException, WriteProcessException, MetadataException {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws IOException, StorageEngineException {
        new CompactionConfigRestorer().restoreCompactionConfig();
        super.tearDown();
    }

    @Test
    public void testCompactionRecoverWithUncompletedTargetFileAndLog() throws Exception {
        String line;
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
        TsFileResource targetTsFileResource = new TsFileResource(new File(SEQ_DIRS + File.separator.concat("0-0-1-0.inner")));
        File compactionLogFile = new File(((TsFileResource)this.seqResources.get(0)).getTsFile().getParent() + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        compactionLogger.logFiles(tmpSeqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        this.deleteFileIfExists(targetTsFileResource.getTsFile());
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(new ArrayList(this.seqResources.subList(0, 3)), targetTsFileResource);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        compactionLogger.close();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetTsFileResource), (boolean)true, (String)"root.compactionTest");
        BufferedReader logReader = new BufferedReader(new FileReader(compactionLogFile));
        ArrayList<String> logs = new ArrayList<String>();
        while ((line = logReader.readLine()) != null) {
            logs.add(line);
        }
        logReader.close();
        BufferedWriter logStream = new BufferedWriter(new FileWriter(SystemFileFactory.INSTANCE.getFile(this.tempSGDir.getPath(), "root.compactionTest.inner-compaction.log"), false));
        for (int i = 0; i < logs.size() - 1; ++i) {
            logStream.write((String)logs.get(i));
            logStream.newLine();
        }
        logStream.close();
        TsFileOutput out = FSFactoryProducer.getFileOutputFactory().getTsFileOutput(targetTsFileResource.getTsFile().getPath(), true);
        out.truncate((long)((double)targetTsFileResource.getTsFileSize() * 0.9));
        out.close();
        tsFileManager.addForRecover(targetTsFileResource, true);
        new CompactionRecoverTask("root.compactionTest", "0", tsFileManager, compactionLogFile, true).doCompaction();
        path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testRecoverWithAllSourceFilesExisted() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
        TsFileResource targetTsFileResource = new TsFileResource(new File(SEQ_DIRS + File.separator.concat("0-0-1-0.inner")));
        File compactionLogFile = new File(((TsFileResource)this.seqResources.get(0)).getTsFile().getParent() + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        compactionLogger.logFiles(tmpSeqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        this.deleteFileIfExists(targetTsFileResource.getTsFile());
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(new ArrayList(this.seqResources.subList(0, 3)), targetTsFileResource);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        compactionLogger.close();
        new CompactionRecoverTask("root.compactionTest", "0", tsFileManager, compactionLogFile, true).doCompaction();
        Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(0)).getTsFile().exists());
        Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(1)).getTsFile().exists());
        Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(2)).getTsFile().exists());
        Assert.assertFalse((boolean)targetTsFileResource.getTsFile().exists());
        Assert.assertFalse((boolean)new File(targetTsFileResource.getTsFilePath().replace(".inner", ".tsfile")).exists());
        Assert.assertFalse((boolean)new File(targetTsFileResource.getTsFilePath() + ".resource").exists());
        path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testRecoverWithAllSourceFilesExistedAndTargetFileNotExist() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
        TsFileResource targetTsFileResource = new TsFileResource(new File(SEQ_DIRS + File.separator.concat("0-0-1-0.inner")));
        File compactionLogFile = new File(((TsFileResource)this.seqResources.get(0)).getTsFile().getParent() + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        compactionLogger.logFiles(tmpSeqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        this.deleteFileIfExists(targetTsFileResource.getTsFile());
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(new ArrayList(this.seqResources.subList(0, 3)), targetTsFileResource);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        targetTsFileResource.remove();
        compactionLogger.close();
        new CompactionRecoverTask("root.compactionTest", "0", tsFileManager, compactionLogFile, true).doCompaction();
        Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(0)).getTsFile().exists());
        Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(1)).getTsFile().exists());
        Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(2)).getTsFile().exists());
        Assert.assertFalse((boolean)targetTsFileResource.getTsFile().exists());
        Assert.assertFalse((boolean)new File(targetTsFileResource.getTsFilePath().replace(".inner", ".tsfile")).exists());
        Assert.assertFalse((boolean)new File(targetTsFileResource.getTsFilePath() + ".resource").exists());
        path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testRecoverWithoutAllSourceFilesExisted() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
        TsFileResource targetTsFileResource = new TsFileResource(new File(SEQ_DIRS + File.separator.concat("0-0-1-0.inner")));
        File compactionLogFile = new File(((TsFileResource)this.seqResources.get(0)).getTsFile().getParent() + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        compactionLogger.logFiles(tmpSeqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        this.deleteFileIfExists(targetTsFileResource.getTsFile());
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(new ArrayList(this.seqResources.subList(0, 3)), targetTsFileResource);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetTsFileResource), (boolean)true, (String)"root.compactionTest");
        ((TsFileResource)this.seqResources.get(0)).remove();
        compactionLogger.close();
        new CompactionRecoverTask("root.compactionTest", "0", tsFileManager, compactionLogFile, true).doCompaction();
        Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(0)).getTsFile().exists());
        Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(1)).getTsFile().exists());
        Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(2)).getTsFile().exists());
        Assert.assertTrue((boolean)targetTsFileResource.getTsFile().exists());
        Assert.assertTrue((boolean)new File(targetTsFileResource.getTsFilePath() + ".resource").exists());
        Assert.assertFalse((boolean)new File(targetTsFileResource.getTsFilePath().replace(".tsfile", ".inner")).exists());
        tsFileManager.add(targetTsFileResource, true);
        path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true).subList(3, 6), new ArrayList(), null, null, true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testRecoverWithAllSourcesFileAndCompactonModFileExist() throws Exception {
        int i;
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(this.seqResources, targetResource);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
        for (i = 0; i < this.seqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId(), new Pair((Object)((long)i * this.ptNum), (Object)((long)i * this.ptNum + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        CompactionUtils.combineModsInInnerCompaction((Collection)this.seqResources, (TsFileResource)targetResource);
        compactionLogger.close();
        new CompactionRecoverTask("root.compactionTest", "0", this.tsFileManager, logFile, true).doCompaction();
        for (i = 0; i < this.seqResources.size(); ++i) {
            Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(i)).getTsFile().exists());
            Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(i)).resourceFileExists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
        Assert.assertFalse((boolean)new File(targetResource.getTsFilePath().replace(".inner", ".tsfile")).exists());
        Assert.assertFalse((boolean)new File(targetResource.getTsFilePath() + ".resource").exists());
        for (i = 0; i < this.seqResources.size(); ++i) {
            Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(i)).getCompactionModFile().exists());
        }
        for (i = 0; i < this.seqResources.size(); ++i) {
            ((TsFileResource)this.seqResources.get(i)).resetModFile();
            Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(i)).getModFile().exists());
            Assert.assertEquals((long)1L, (long)((TsFileResource)this.seqResources.get(i)).getModFile().getModifications().size());
        }
        Assert.assertFalse((boolean)targetResource.getModFile().exists());
        Assert.assertFalse((boolean)logFile.exists());
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testRecoverWithAllSourcesFileAndCompactonModFileExistAndTargetFileNotExist() throws Exception {
        int i;
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(this.seqResources, targetResource);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        targetResource.remove();
        for (i = 0; i < this.seqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId(), new Pair((Object)((long)i * this.ptNum), (Object)((long)i * this.ptNum + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        compactionLogger.close();
        new CompactionRecoverTask("root.compactionTest", "0", this.tsFileManager, logFile, true).doCompaction();
        for (i = 0; i < this.seqResources.size(); ++i) {
            Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(i)).getTsFile().exists());
            Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(i)).resourceFileExists());
        }
        Assert.assertFalse((boolean)targetResource.getTsFile().exists());
        Assert.assertFalse((boolean)new File(targetResource.getTsFilePath().replace(".inner", ".tsfile")).exists());
        Assert.assertFalse((boolean)new File(targetResource.getTsFilePath() + ".resource").exists());
        for (i = 0; i < this.seqResources.size(); ++i) {
            Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(i)).getCompactionModFile().exists());
        }
        for (i = 0; i < this.seqResources.size(); ++i) {
            ((TsFileResource)this.seqResources.get(i)).resetModFile();
            Assert.assertTrue((boolean)((TsFileResource)this.seqResources.get(i)).getModFile().exists());
            Assert.assertEquals((long)1L, (long)((TsFileResource)this.seqResources.get(i)).getModFile().getModifications().size());
        }
        Assert.assertFalse((boolean)targetResource.getModFile().exists());
        Assert.assertFalse((boolean)logFile.exists());
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testRecoverWithoutAllSourceFilesExistAndModFiles() throws Exception {
        int i;
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        TsFileResource targetResource = TsFileNameGenerator.getInnerCompactionTargetFileResource((List)this.seqResources, (boolean)true);
        File logFile = new File(targetResource.getTsFile().getPath() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(logFile);
        compactionLogger.logFiles(this.seqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetResource), "target");
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(this.seqResources, targetResource);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetResource), (boolean)true, (String)"root.compactionTest");
        for (i = 0; i < this.seqResources.size(); ++i) {
            HashMap<String, Pair<Long, Long>> deleteMap = new HashMap<String, Pair<Long, Long>>();
            deleteMap.put(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId(), new Pair((Object)((long)i * this.ptNum), (Object)((long)i * this.ptNum + 10L)));
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), true);
            CompactionFileGeneratorUtils.generateMods(deleteMap, (TsFileResource)this.seqResources.get(i), false);
        }
        CompactionUtils.combineModsInInnerCompaction((Collection)this.seqResources, (TsFileResource)targetResource);
        ((TsFileResource)this.seqResources.get(0)).remove();
        compactionLogger.close();
        new CompactionRecoverTask("root.compactionTest", "0", this.tsFileManager, logFile, true).doCompaction();
        for (i = 0; i < this.seqResources.size(); ++i) {
            Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(i)).getTsFile().exists());
            Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(i)).resourceFileExists());
        }
        Assert.assertTrue((boolean)targetResource.getTsFile().exists());
        Assert.assertTrue((boolean)targetResource.resourceFileExists());
        Assert.assertFalse((boolean)new File(targetResource.getTsFilePath().replace(".tsfile", ".inner")).exists());
        for (i = 0; i < this.seqResources.size(); ++i) {
            Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(i)).getCompactionModFile().exists());
            Assert.assertFalse((boolean)((TsFileResource)this.seqResources.get(i)).getModFile().exists());
        }
        Assert.assertTrue((boolean)targetResource.getModFile().exists());
        Assert.assertFalse((boolean)logFile.exists());
        Assert.assertTrue((boolean)this.tsFileManager.isAllowCompaction());
    }

    @Test
    public void testRecoverCompleteTargetFileAndCompactionLog() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
        TsFileResource targetTsFileResource = new TsFileResource(new File(SEQ_DIRS + File.separator.concat("0-0-1-0.inner")));
        File compactionLogFile = new File(((TsFileResource)this.seqResources.get(0)).getTsFile().getParent() + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        compactionLogger.logFiles(tmpSeqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        this.deleteFileIfExists(targetTsFileResource.getTsFile());
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(new ArrayList(this.seqResources.subList(0, 3)), targetTsFileResource);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        compactionLogger.close();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetTsFileResource), (boolean)true, (String)"root.compactionTest");
        tsFileManager.add(targetTsFileResource, true);
        new CompactionRecoverTask("root.compactionTest", "0", tsFileManager, compactionLogFile, true).doCompaction();
        path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        TimeSeriesMetadataCache.getInstance().clear();
        ChunkCache.getInstance().clear();
        tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true).subList(0, 5), new ArrayList(), null, null, true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionRecoverWithCompletedTargetFileAndLog() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
        TsFileResource targetTsFileResource = new TsFileResource(new File(SEQ_DIRS + File.separator.concat("0-0-1-0.inner")));
        File compactionLogFile = new File(((TsFileResource)this.seqResources.get(0)).getTsFile().getParent() + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        compactionLogger.logFiles(tmpSeqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        this.deleteFileIfExists(targetTsFileResource.getTsFile());
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(new ArrayList(this.seqResources.subList(0, 3)), targetTsFileResource);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetTsFileResource), (boolean)true, (String)"root.compactionTest");
        compactionLogger.close();
        for (TsFileResource resource : new ArrayList(this.seqResources.subList(0, 3))) {
            this.deleteFileIfExists(resource.getTsFile());
            tsFileManager.remove(resource, true);
        }
        tsFileManager.add(targetTsFileResource, true);
        new CompactionRecoverTask("root.compactionTest", "0", tsFileManager, compactionLogFile, true).doCompaction();
        path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionRecoverWithCompletedTargetFile() throws Exception {
        TsFileManager tsFileManager = new TsFileManager("root.compactionTest", "0", this.tempSGDir.getAbsolutePath());
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, false);
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
        TsFileResource targetTsFileResource = new TsFileResource(new File(SEQ_DIRS + File.separator.concat("0-0-1-0.inner")));
        File compactionLogFile = new File(((TsFileResource)this.seqResources.get(0)).getTsFile().getParent() + File.separator + targetTsFileResource.getTsFile().getName() + ".inner-compaction.log");
        CompactionLogger compactionLogger = new CompactionLogger(compactionLogFile);
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        compactionLogger.logFiles(tmpSeqResources, "source");
        compactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        this.deleteFileIfExists(targetTsFileResource.getTsFile());
        ReadChunkCompactionPerformer performer = new ReadChunkCompactionPerformer(new ArrayList(this.seqResources.subList(0, 3)), targetTsFileResource);
        performer.setSummary(new CompactionTaskSummary());
        performer.perform();
        compactionLogger.close();
        CompactionUtils.moveTargetFile(Collections.singletonList(targetTsFileResource), (boolean)true, (String)"root.compactionTest");
        this.deleteFileIfExists(compactionLogFile);
        for (TsFileResource resource : new ArrayList(this.seqResources.subList(0, 3))) {
            tsFileManager.remove(resource, true);
            this.deleteFileIfExists(resource.getTsFile());
        }
        tsFileManager.add(targetTsFileResource, true);
        new CompactionRecoverTask("root.compactionTest", "0", tsFileManager, compactionLogFile, true).doCompaction();
        path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        logger.warn("TsFiles in list is {}", (Object)tsFileManager.getTsFileList(true));
        tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
        count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionMergeRecoverMergeStartSourceLog() throws IOException, MetadataException {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CompactionLogger sizeTieredCompactionLogger = new CompactionLogger(new File(this.tempSGDir.getPath(), "root.compactionTestroot.compactionTest.inner-compaction.log"));
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        sizeTieredCompactionLogger.logFiles(tmpSeqResources, "source");
        sizeTieredCompactionLogger.close();
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, this.tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionMergeRecoverMergeStartSequenceLog() throws IOException, MetadataException {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CompactionLogger sizeTieredCompactionLogger = new CompactionLogger(new File(this.tempSGDir.getPath(), "root.compactionTest.inner-compaction.log"));
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        sizeTieredCompactionLogger.logFiles(tmpSeqResources, "source");
        sizeTieredCompactionLogger.close();
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, this.tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        tsFilesReader.close();
        this.closeTsFileSequenceReader();
        Assert.assertEquals((long)500L, (long)count);
    }

    @Test
    public void testCompactionMergeRecoverMergeStart() throws IOException, MetadataException {
        this.tsFileManager.addAll(this.seqResources, true);
        this.tsFileManager.addAll(this.unseqResources, false);
        CompactionLogger sizeTieredCompactionLogger = new CompactionLogger(new File(this.tempSGDir.getPath(), "root.compactionTest.inner-compaction.log"));
        ArrayList<TsFileResource> tmpSeqResources = new ArrayList<TsFileResource>();
        tmpSeqResources.add((TsFileResource)this.seqResources.get(0));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(1));
        tmpSeqResources.add((TsFileResource)this.seqResources.get(2));
        sizeTieredCompactionLogger.logFiles(tmpSeqResources, "source");
        TsFileResource targetTsFileResource = new TsFileResource(new File(SEQ_DIRS + File.separator.concat("0-0-1-0.inner")));
        sizeTieredCompactionLogger.logFiles(Collections.singletonList(targetTsFileResource), "target");
        this.tsFileManager.addForRecover(targetTsFileResource, true);
        sizeTieredCompactionLogger.close();
        MeasurementPath path = SchemaTestUtils.getMeasurementPath(this.deviceIds[0] + "." + this.measurementSchemas[0].getMeasurementId());
        SeriesRawDataBatchReader tsFilesReader = new SeriesRawDataBatchReader((PartialPath)path, this.measurementSchemas[0].getType(), EnvironmentUtils.TEST_QUERY_CONTEXT, this.tsFileManager.getTsFileList(true), new ArrayList(), null, null, true);
        int count = 0;
        while (tsFilesReader.hasNextBatch()) {
            BatchData batchData = tsFilesReader.nextBatch();
            for (int i = 0; i < batchData.length(); ++i) {
                Assert.assertEquals((double)batchData.getTimeByIndex(i), (double)batchData.getDoubleByIndex(i), (double)0.001);
                ++count;
            }
        }
        Assert.assertEquals((long)500L, (long)count);
    }

    public void deleteFileIfExists(File file) {
        long waitingTime = 0L;
        while (file.exists()) {
            file.delete();
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((waitingTime += 100L) <= 20000L) continue;
            System.out.println("fail to delete " + file);
            break;
        }
    }

    private void closeTsFileSequenceReader() throws IOException {
        for (TsFileResource tsFileResource : this.seqResources) {
            FileReaderManager.getInstance().closeFileAndRemoveReader(tsFileResource.getTsFilePath());
        }
    }
}

