/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.compaction.cross.rewrite.RewriteCrossSpaceCompactionSelector;
import org.apache.iotdb.db.engine.compaction.utils.CompactionConfigRestorer;
import org.apache.iotdb.db.engine.storagegroup.TsFileManager;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.MergeException;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MergeUpgradeTest {
    private List<TsFileResource> seqResources = new ArrayList<TsFileResource>();
    private List<TsFileResource> unseqResources = new ArrayList<TsFileResource>();
    private int seqFileNum = 2;
    private TSEncoding encoding = TSEncoding.RLE;
    private MeasurementSchema[] measurementSchemas;
    private int timeseriesNum = 5;
    private long ptNum = 10L;
    private boolean changeVersion = true;
    private String deviceName = "root.MergeUpgrade.device0";

    @Before
    public void setUp() throws IOException, WriteProcessException {
        this.prepareSeries();
        this.prepareFiles();
    }

    @After
    public void tearDown() {
        new CompactionConfigRestorer().restoreCompactionConfig();
        this.removeFiles();
        this.seqResources.clear();
        this.unseqResources.clear();
    }

    @Test
    public void testMergeUpgradeSelect() throws MergeException {
        TsFileManager tsFileManager = new TsFileManager("", "", "");
        tsFileManager.addAll(this.seqResources, true);
        tsFileManager.addAll(this.unseqResources, true);
        RewriteCrossSpaceCompactionSelector selector = new RewriteCrossSpaceCompactionSelector("", "", 0L, tsFileManager);
        List selected = selector.selectCrossSpaceTask(this.seqResources, this.unseqResources);
        Assert.assertEquals((long)0L, (long)selected.size());
    }

    private void prepareFiles() throws IOException, WriteProcessException {
        for (int i = 0; i < this.seqFileNum; ++i) {
            File seqfile = FSFactoryProducer.getFSFactory().getFile(TestConstant.BASE_OUTPUT_PATH.concat("seq-" + i + "-" + i + "-" + 0 + ".tsfile"));
            TsFileResource seqTsFileResource = new TsFileResource(seqfile);
            this.seqResources.add(seqTsFileResource);
            this.prepareOldFile(seqTsFileResource, (long)i * this.ptNum, this.ptNum, 0L);
        }
        File unseqfile = FSFactoryProducer.getFSFactory().getFile(TestConstant.BASE_OUTPUT_PATH.concat("unseq-0-0-0.tsfile"));
        TsFileResource unseqTsFileResource = new TsFileResource(unseqfile);
        this.unseqResources.add(unseqTsFileResource);
        this.prepareFile(unseqTsFileResource, 0L, 2L * this.ptNum, 10L);
    }

    private void prepareSeries() {
        this.measurementSchemas = new MeasurementSchema[this.timeseriesNum];
        for (int i = 0; i < this.timeseriesNum; ++i) {
            this.measurementSchemas[i] = new MeasurementSchema("sensor" + i, TSDataType.DOUBLE, this.encoding, CompressionType.UNCOMPRESSED);
        }
    }

    private void prepareOldFile(TsFileResource tsFileResource, long timeOffset, long ptNum, long valueOffset) throws IOException, WriteProcessException {
        TsFileWriter fileWriter = new TsFileWriter(tsFileResource.getTsFile());
        this.prepareData(tsFileResource, fileWriter, timeOffset, ptNum, valueOffset);
        fileWriter.close();
        if (this.changeVersion) {
            try (RandomAccessFile oldTsfile = new RandomAccessFile(tsFileResource.getTsFile(), "rw");){
                oldTsfile.seek("TsFile".length());
                oldTsfile.write("000001".getBytes());
            }
            this.changeVersion = false;
        }
    }

    private void prepareFile(TsFileResource tsFileResource, long timeOffset, long ptNum, long valueOffset) throws IOException, WriteProcessException {
        TsFileWriter fileWriter = new TsFileWriter(tsFileResource.getTsFile());
        this.prepareData(tsFileResource, fileWriter, timeOffset, ptNum, valueOffset);
        fileWriter.close();
    }

    private void removeFiles() {
        for (TsFileResource tsFileResource : this.seqResources) {
            tsFileResource.remove();
        }
        for (TsFileResource tsFileResource : this.unseqResources) {
            tsFileResource.remove();
        }
    }

    private void prepareData(TsFileResource tsFileResource, TsFileWriter fileWriter, long timeOffset, long ptNum, long valueOffset) throws WriteProcessException, IOException {
        for (MeasurementSchema MeasurementSchema2 : this.measurementSchemas) {
            fileWriter.registerTimeseries(new Path(this.deviceName), MeasurementSchema2);
        }
        for (long i = timeOffset; i < timeOffset + ptNum; ++i) {
            TSRecord record = new TSRecord(i, this.deviceName);
            for (int k = 0; k < this.timeseriesNum; ++k) {
                record.addTuple(DataPoint.getDataPoint((TSDataType)this.measurementSchemas[k].getType(), (String)this.measurementSchemas[k].getMeasurementId(), (String)String.valueOf(i + valueOffset)));
            }
            fileWriter.write(record);
            tsFileResource.updateStartTime(this.deviceName, i);
            tsFileResource.updateEndTime(this.deviceName, i);
        }
    }
}

