/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.cache;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.engine.cache.BloomFilterCache;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.utils.BloomFilter;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.Tablet;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BloomFilterCacheTest {
    private List<String> pathList;
    private int pathSize = 3;
    private BloomFilterCache bloomFilterCache;

    @Before
    public void setUp() throws Exception {
        this.pathList = new ArrayList<String>();
        for (int i = 0; i < this.pathSize; ++i) {
            String path = "target".concat(File.separator).concat("data").concat(File.separator).concat("data").concat(File.separator).concat("sequence").concat(File.separator).concat("root.sg" + (i + 1)).concat(File.separator).concat("0").concat(File.separator).concat("0").concat(File.separator).concat("1-0-0-0.tsfile");
            String device = "d" + (i + 1);
            this.pathList.add(path);
            this.createTsFile(path, device);
        }
        this.bloomFilterCache = BloomFilterCache.getInstance();
    }

    @After
    public void tearDown() {
        try {
            FileReaderManager.getInstance().closeAndRemoveAllOpenedReaders();
            for (String filePath : this.pathList) {
                FileUtils.forceDelete((File)new File(filePath));
            }
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testGet() {
        try {
            for (String filePath : this.pathList) {
                BloomFilter bloomFilter = this.bloomFilterCache.get(new BloomFilterCache.BloomFilterCacheKey(filePath));
                TsFileSequenceReader reader = FileReaderManager.getInstance().get(filePath, true);
                BloomFilter bloomFilter1 = reader.readBloomFilter();
                Assert.assertEquals((Object)bloomFilter1, (Object)bloomFilter);
                reader.close();
            }
        }
        catch (IOException e) {
            Assert.fail();
            e.printStackTrace();
        }
    }

    @Test
    public void testRemove() {
        try {
            String path = this.pathList.get(0);
            BloomFilterCache.BloomFilterCacheKey key = new BloomFilterCache.BloomFilterCacheKey(path);
            BloomFilter bloomFilter = this.bloomFilterCache.get(key);
            TsFileSequenceReader reader = FileReaderManager.getInstance().get(path, true);
            BloomFilter bloomFilter1 = reader.readBloomFilter();
            Assert.assertEquals((Object)bloomFilter1, (Object)bloomFilter);
            this.bloomFilterCache.remove(key);
            bloomFilter = this.bloomFilterCache.getIfPresent(key);
            Assert.assertNull((Object)bloomFilter);
            reader.close();
        }
        catch (IOException e) {
            Assert.fail();
            e.printStackTrace();
        }
    }

    @Test
    public void testClear() {
        try {
            BloomFilter bloomFilter;
            BloomFilterCache.BloomFilterCacheKey key;
            for (String path : this.pathList) {
                key = new BloomFilterCache.BloomFilterCacheKey(path);
                bloomFilter = this.bloomFilterCache.get(key);
                TsFileSequenceReader reader = FileReaderManager.getInstance().get(path, true);
                BloomFilter bloomFilter1 = reader.readBloomFilter();
                Assert.assertEquals((Object)bloomFilter1, (Object)bloomFilter);
                reader.close();
            }
            this.bloomFilterCache.clear();
            for (String path : this.pathList) {
                key = new BloomFilterCache.BloomFilterCacheKey(path);
                bloomFilter = this.bloomFilterCache.getIfPresent(key);
                Assert.assertNull((Object)bloomFilter);
            }
        }
        catch (IOException e) {
            Assert.fail();
            e.printStackTrace();
        }
    }

    private void createTsFile(String path, String device) throws Exception {
        try {
            File f = FSFactoryProducer.getFSFactory().getFile(path);
            if (f.exists() && !f.delete()) {
                throw new RuntimeException("can not delete " + f.getAbsolutePath());
            }
            Schema schema = new Schema();
            String sensorPrefix = "sensor_";
            int rowNum = 1000000;
            int sensorNum = 10;
            ArrayList<MeasurementSchema> measurementSchemas = new ArrayList<MeasurementSchema>();
            for (int i = 0; i < sensorNum; ++i) {
                MeasurementSchema measurementSchema = new MeasurementSchema(sensorPrefix + (i + 1), TSDataType.INT64, TSEncoding.TS_2DIFF);
                measurementSchemas.add(measurementSchema);
                schema.registerTimeseries(new Path(device), new MeasurementSchema(sensorPrefix + (i + 1), TSDataType.INT64, TSEncoding.TS_2DIFF));
            }
            try (TsFileWriter tsFileWriter = new TsFileWriter(f, schema);){
                Tablet tablet = new Tablet(device, measurementSchemas);
                long[] timestamps = tablet.timestamps;
                Object[] values = tablet.values;
                long timestamp = 1L;
                long value = 1000000L;
                int r = 0;
                while (r < rowNum) {
                    ++tablet.rowSize;
                    ++timestamp;
                    for (int i = 0; i < sensorNum; ++i) {
                        long[] sensor = (long[])values[i];
                        sensor[row] = value;
                    }
                    if (tablet.rowSize == tablet.getMaxRowNumber()) {
                        tsFileWriter.write(tablet);
                        tablet.reset();
                    }
                    ++r;
                    ++value;
                }
                if (tablet.rowSize != 0) {
                    tsFileWriter.write(tablet);
                    tablet.reset();
                }
            }
        }
        catch (Exception e) {
            throw new Exception("meet error in TsFileWrite with tablet", e);
        }
    }
}

