/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.mockito.PowerMockito;
import org.powermock.core.classloader.annotations.PowerMockIgnore;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.testcontainers.shaded.com.google.common.collect.Lists;

@PowerMockIgnore(value={"com.sun.org.apache.xerces.*", "javax.xml.*", "org.xml.*", "javax.management.*"})
@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={DataRegion.class})
public class StorageEngineV2Test {
    private StorageEngineV2 storageEngineV2;

    @Before
    public void setUp() {
        this.storageEngineV2 = StorageEngineV2.getInstance();
    }

    @After
    public void after() {
        this.storageEngineV2 = null;
    }

    @Test
    public void testGetAllDataRegionIds() throws Exception {
        DataRegionId id1 = new DataRegionId(1);
        DataRegion rg1 = (DataRegion)PowerMockito.mock(DataRegion.class);
        DataRegion rg2 = (DataRegion)PowerMockito.mock(DataRegion.class);
        DataRegionId id2 = new DataRegionId(2);
        this.storageEngineV2.setDataRegion(id1, rg1);
        this.storageEngineV2.setDataRegion(id2, rg2);
        ArrayList actual = Lists.newArrayList((Object[])new DataRegionId[]{id1, id2});
        List expect = this.storageEngineV2.getAllDataRegionIds();
        Assert.assertEquals((long)expect.size(), (long)actual.size());
        Assert.assertTrue((boolean)actual.containsAll(expect));
        rg1.syncDeleteDataFiles();
        rg2.syncDeleteDataFiles();
    }
}

