/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.conf;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.BadNodeUrlException;
import org.apache.iotdb.db.conf.IoTDBStopCheck;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class IoTDBStopCheckTest {
    static List<String> removeIps;
    static List<String> emptyRemoveIps;
    static List<String> reduplicateRemoveIps;
    static List<String> notExistRemovedIps;
    static List<String> onlineIps;
    static List<String> emptyOnlineIps;

    @BeforeClass
    public static void setup() {
        onlineIps = Arrays.asList("192.168.1.1", "192.168.1.2", "192.168.1.3");
        emptyOnlineIps = Collections.emptyList();
        removeIps = Arrays.asList("192.168.1.1", "192.168.1.2");
        notExistRemovedIps = Arrays.asList("192.168.1.1", "192.168.1.4");
        emptyRemoveIps = Collections.emptyList();
        reduplicateRemoveIps = Arrays.asList("192.168.1.1", "192.168.1.2", "192.168.1.2");
    }

    @AfterClass
    public static void after() {
        removeIps = null;
        emptyRemoveIps = null;
        reduplicateRemoveIps = null;
        notExistRemovedIps = null;
        onlineIps = null;
        emptyOnlineIps = null;
    }

    @Test
    public void testGetInstance() {
        IoTDBStopCheck checker = IoTDBStopCheck.getInstance();
        Assert.assertNotNull((Object)checker);
    }

    @Test
    public void testCheckDuplicateIpOK() {
        boolean result = true;
        try {
            IoTDBStopCheck.getInstance().checkDuplicateIp(removeIps);
        }
        catch (BadNodeUrlException e) {
            result = false;
        }
        Assert.assertTrue((boolean)result);
    }

    @Test(expected=BadNodeUrlException.class)
    public void testCheckDuplicateIpEmptyIps() throws BadNodeUrlException {
        IoTDBStopCheck.getInstance().checkDuplicateIp(emptyRemoveIps);
    }

    @Test(expected=BadNodeUrlException.class)
    public void testCheckDuplicateIpException() throws BadNodeUrlException {
        IoTDBStopCheck.getInstance().checkDuplicateIp(reduplicateRemoveIps);
    }

    @Test
    public void testCheckIpInCluster() {
        boolean result = true;
        try {
            IoTDBStopCheck.getInstance().checkIpInCluster(removeIps, onlineIps);
        }
        catch (BadNodeUrlException e) {
            result = false;
        }
        Assert.assertTrue((boolean)result);
    }

    @Test(expected=BadNodeUrlException.class)
    public void testCheckIpInClusterEmptyIp() throws BadNodeUrlException {
        IoTDBStopCheck.getInstance().checkIpInCluster(removeIps, emptyOnlineIps);
    }

    @Test(expected=BadNodeUrlException.class)
    public void testCheckIpInClusterException() throws BadNodeUrlException {
        IoTDBStopCheck.getInstance().checkIpInCluster(notExistRemovedIps, onlineIps);
    }
}

