/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth.user;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.auth.entity.PathPrivilege;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.auth.user.LocalFileUserAccessor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalFileUserAccessorTest {
    private File testFolder;
    private LocalFileUserAccessor accessor;

    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
        this.testFolder = new File(TestConstant.BASE_OUTPUT_PATH.concat("test"));
        this.testFolder.mkdirs();
        this.accessor = new LocalFileUserAccessor(this.testFolder.getPath());
    }

    @After
    public void tearDown() throws Exception {
        FileUtils.deleteDirectory((File)this.testFolder);
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void test() throws IOException {
        int i;
        User[] users = new User[5];
        for (int i2 = 0; i2 < users.length; ++i2) {
            users[i2] = new User("user" + i2, "password" + i2);
            for (int j = 0; j <= i2; ++j) {
                PathPrivilege pathPrivilege = new PathPrivilege("root.a.b.c" + j);
                pathPrivilege.getPrivileges().add(j);
                users[i2].getPrivilegeList().add(pathPrivilege);
                users[i2].getRoleList().add("role" + j);
            }
        }
        for (User user : users) {
            try {
                this.accessor.saveUser(user);
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        for (User user : users) {
            try {
                User loadedUser = this.accessor.loadUser(user.getName());
                Assert.assertEquals((Object)user, (Object)loadedUser);
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
        Assert.assertNull((Object)this.accessor.loadUser("not a user"));
        List usernames = this.accessor.listAllUsers();
        usernames.sort(null);
        for (i = 0; i < users.length; ++i) {
            Assert.assertEquals((Object)users[i].getName(), usernames.get(i));
        }
        Assert.assertFalse((boolean)this.accessor.deleteUser("not a user"));
        Assert.assertTrue((boolean)this.accessor.deleteUser(users[users.length - 1].getName()));
        usernames = this.accessor.listAllUsers();
        Assert.assertEquals((long)(users.length - 1), (long)usernames.size());
        usernames.sort(null);
        for (i = 0; i < users.length - 1; ++i) {
            Assert.assertEquals((Object)users[i].getName(), usernames.get(i));
        }
        User nullUser = this.accessor.loadUser(users[users.length - 1].getName());
        Assert.assertNull((Object)nullUser);
    }
}

