/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.auth;

import java.util.ArrayList;
import java.util.Collections;
import org.apache.iotdb.commons.auth.AuthException;
import org.apache.iotdb.commons.auth.authorizer.IAuthorizer;
import org.apache.iotdb.commons.auth.entity.PrivilegeType;
import org.apache.iotdb.commons.auth.entity.User;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.auth.AuthorityChecker;
import org.apache.iotdb.db.auth.AuthorizerManager;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AuthorityCheckerTest {
    IAuthorizer authorizer;
    User user;
    String nodeName = "root.laptop.d1";

    @Before
    public void setUp() throws Exception {
        EnvironmentUtils.envSetUp();
        this.authorizer = AuthorizerManager.getInstance();
        this.user = new User("user", "password");
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void testAuthorityChecker() throws AuthException, IllegalPathException {
        this.authorizer.createUser(this.user.getName(), this.user.getPassword());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.INSERT_TIMESERIES.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.CREATE_ROLE.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.CREATE_USER.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.READ_TIMESERIES.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.DELETE_TIMESERIES.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.REVOKE_USER_ROLE.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.GRANT_USER_ROLE.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.LIST_USER.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.LIST_ROLE.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.REVOKE_USER_PRIVILEGE.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.GRANT_ROLE_PRIVILEGE.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.GRANT_USER_PRIVILEGE.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.MODIFY_PASSWORD.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.REVOKE_ROLE_PRIVILEGE.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.DELETE_ROLE.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.DELETE_USER.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.SET_STORAGE_GROUP.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.CREATE_TIMESERIES.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.CREATE_CONTINUOUS_QUERY.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.DROP_CONTINUOUS_QUERY.ordinal());
        this.authorizer.grantPrivilegeToUser(this.user.getName(), this.nodeName, PrivilegeType.ALTER_TIMESERIES.ordinal());
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.INSERT, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)"root", null, null, null));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.CREATE_ROLE, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.QUERY, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.DROP_INDEX, (String)this.user.getName()));
        Assert.assertFalse((boolean)AuthorityChecker.check((String)this.user.getName(), new ArrayList(), (Operator.OperatorType)Operator.OperatorType.INSERT, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.MODIFY_PASSWORD, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.GRANT_USER_PRIVILEGE, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.GRANT_ROLE_PRIVILEGE, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.REVOKE_USER_PRIVILEGE, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.REVOKE_ROLE_PRIVILEGE, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.REVOKE_ROLE_PRIVILEGE, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.GRANT_USER_ROLE, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.DELETE_USER, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.DELETE_ROLE, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.LIST_ROLE, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.LIST_USER, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.SET_STORAGE_GROUP, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.CREATE_TIMESERIES, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.DELETE_TIMESERIES, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.FILL, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.GROUP_BY_FILL, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.CREATE_CONTINUOUS_QUERY, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.DROP_CONTINUOUS_QUERY, (String)this.user.getName()));
        Assert.assertTrue((boolean)AuthorityChecker.check((String)this.user.getName(), Collections.singletonList(new PartialPath(this.nodeName)), (Operator.OperatorType)Operator.OperatorType.ALTER_TIMESERIES, (String)this.user.getName()));
    }
}

