/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.recover;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Collections;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.query.reader.chunk.ChunkDataIterator;
import org.apache.iotdb.db.query.reader.universal.PriorityMergeReader;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.MmapUtil;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.apache.iotdb.db.writelog.recover.TsFileRecoverPerformer;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.ChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.IChunkMetadata;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Chunk;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.controller.CachedChunkLoaderImpl;
import org.apache.iotdb.tsfile.read.controller.MetadataQuerierByFileImpl;
import org.apache.iotdb.tsfile.read.reader.IChunkReader;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.read.reader.chunk.ChunkReader;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UnseqTsFileRecoverTest {
    private File tsF;
    private TsFileWriter writer;
    private WriteLogNode node;
    private String logNodePrefix = TestConstant.OUTPUT_DATA_DIR.concat("testNode/0");
    private Schema schema;
    private TsFileResource resource;
    private VersionController versionController = new VersionController(){
        private int i;

        public long nextVersion() {
            return ++this.i;
        }

        public long currVersion() {
            return this.i;
        }
    };

    @Before
    public void setup() throws IOException, WriteProcessException, MetadataException {
        int i;
        EnvironmentUtils.envSetUp();
        this.tsF = SystemFileFactory.INSTANCE.getFile(this.logNodePrefix, "1-1-1.tsfile");
        this.tsF.getParentFile().mkdirs();
        this.schema = new Schema();
        for (int i2 = 0; i2 < 10; ++i2) {
            for (int j = 0; j < 10; ++j) {
                PartialPath path = new PartialPath("root.sg.device" + i2 + '.' + "sensor" + j);
                MeasurementSchema measurementSchema = new MeasurementSchema("sensor" + j, TSDataType.INT64, TSEncoding.PLAIN);
                this.schema.registerTimeseries(new Path(path.toTSFilePath().getDevice()), measurementSchema);
                IoTDB.metaManager.createTimeseries(path, measurementSchema.getType(), measurementSchema.getEncodingType(), measurementSchema.getCompressor(), measurementSchema.getProps());
            }
        }
        this.schema.registerTimeseries(new Path("root.sg.device99"), new MeasurementSchema("sensor4", TSDataType.INT64, TSEncoding.PLAIN));
        IoTDB.metaManager.createTimeseries(new PartialPath("root.sg.device99.sensor4"), TSDataType.INT64, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        this.schema.registerTimeseries(new Path("root.sg.device99"), new MeasurementSchema("sensor2", TSDataType.INT64, TSEncoding.PLAIN));
        IoTDB.metaManager.createTimeseries(new PartialPath("root.sg.device99.sensor2"), TSDataType.INT64, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        this.schema.registerTimeseries(new Path("root.sg.device99"), new MeasurementSchema("sensor1", TSDataType.INT64, TSEncoding.PLAIN));
        IoTDB.metaManager.createTimeseries(new PartialPath("root.sg.device99.sensor1"), TSDataType.INT64, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        this.writer = new TsFileWriter(this.tsF, this.schema);
        TSRecord tsRecord = new TSRecord(100L, "root.sg.device99");
        tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor4", (String)String.valueOf(0)));
        this.writer.write(tsRecord);
        tsRecord = new TSRecord(2L, "root.sg.device99");
        tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor1", (String)String.valueOf(0)));
        this.writer.write(tsRecord);
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                tsRecord = new TSRecord((long)i, "root.sg.device" + j);
                for (int k = 0; k < 10; ++k) {
                    tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)("sensor" + k), (String)String.valueOf(k)));
                }
                this.writer.write(tsRecord);
            }
        }
        this.writer.flushAllChunkGroups();
        this.writer.getIOWriter().close();
        this.node = MultiFileLogNodeManager.getInstance().getNode(this.logNodePrefix + this.tsF.getName(), () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        });
        for (i = 0; i < 10; ++i) {
            for (int j = 0; j < 10; ++j) {
                String[] measurements = new String[10];
                TSDataType[] types = new TSDataType[10];
                String[] values = new String[10];
                for (int k = 0; k < 10; ++k) {
                    measurements[k] = "sensor" + k;
                    types[k] = TSDataType.INT64;
                    values[k] = String.valueOf(k + 10);
                }
                InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.sg.device" + j), (long)i, measurements, types, values);
                this.node.write((PhysicalPlan)insertRowPlan);
            }
            this.node.notifyStartFlush();
        }
        InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.sg.device99"), 1L, "sensor4", TSDataType.INT64, "4");
        this.node.write((PhysicalPlan)insertRowPlan);
        insertRowPlan = new InsertRowPlan(new PartialPath("root.sg.device99"), 300L, "sensor2", TSDataType.INT64, "2");
        this.node.write((PhysicalPlan)insertRowPlan);
        this.node.close();
        this.resource = new TsFileResource(this.tsF);
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        ByteBuffer[] array;
        FileUtils.deleteDirectory((File)this.tsF.getParentFile());
        this.resource.close();
        for (ByteBuffer byteBuffer : array = this.node.delete()) {
            MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
        }
        EnvironmentUtils.cleanEnv();
    }

    @Test
    public void test() throws StorageGroupProcessorException, IOException {
        TsFileRecoverPerformer performer = new TsFileRecoverPerformer(this.logNodePrefix, this.resource, false, false, null);
        performer.recover(true, () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        }, array -> {
            for (ByteBuffer byteBuffer : array) {
                MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
            }
        }).close();
        Assert.assertEquals((long)1L, (long)this.resource.getStartTime("root.sg.device99"));
        Assert.assertEquals((long)300L, (long)this.resource.getEndTime("root.sg.device99"));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)0L, (long)this.resource.getStartTime("root.sg.device" + i));
            Assert.assertEquals((long)9L, (long)this.resource.getEndTime("root.sg.device" + i));
        }
        TsFileSequenceReader fileReader = new TsFileSequenceReader(this.tsF.getPath(), true);
        MetadataQuerierByFileImpl metadataQuerier = new MetadataQuerierByFileImpl(fileReader);
        CachedChunkLoaderImpl chunkLoader = new CachedChunkLoaderImpl(fileReader);
        Path path = new Path("root.sg.device1", "sensor1");
        PriorityMergeReader unSeqMergeReader = new PriorityMergeReader();
        int priorityValue = 1;
        for (IChunkMetadata chunkMetaData : metadataQuerier.getChunkMetaDataList(path)) {
            Chunk chunk = chunkLoader.loadChunk((ChunkMetadata)chunkMetaData);
            ChunkReader chunkReader = new ChunkReader(chunk, null);
            unSeqMergeReader.addReader((IPointReader)new ChunkDataIterator((IChunkReader)chunkReader), (long)priorityValue++);
        }
        for (int i = 0; i < 10; ++i) {
            TimeValuePair timeValuePair = unSeqMergeReader.currentTimeValuePair();
            Assert.assertEquals((long)i, (long)timeValuePair.getTimestamp());
            Assert.assertEquals((long)11L, (long)((Long)timeValuePair.getValue().getValue()));
            unSeqMergeReader.nextTimeValuePair();
        }
        unSeqMergeReader.close();
        fileReader.close();
    }
}

