/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.recover;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.constant.TestConstant;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.version.VersionController;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.MmapUtil;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.apache.iotdb.db.writelog.recover.TsFileRecoverPerformer;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TsFileReader;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.MeasurementGroup;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.Schema;
import org.apache.iotdb.tsfile.write.writer.RestorableTsFileIOWriter;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SeqTsFileRecoverTest {
    private File tsF;
    private TsFileWriter writer;
    private WriteLogNode node;
    private String logNodePrefix = TestConstant.getTestTsFileDir((String)"root.recover", (long)0L, (long)0L);
    private TsFileResource resource;
    private ModificationFile modificationFile;
    private VersionController versionController = new VersionController(){
        private int i;

        public long nextVersion() {
            return ++this.i;
        }

        public long currVersion() {
            return this.i;
        }
    };

    @Before
    public void setup() throws IOException, WriteProcessException, MetadataException {
        EnvironmentUtils.envSetUp();
        this.tsF = SystemFileFactory.INSTANCE.getFile(this.logNodePrefix, System.currentTimeMillis() + "-1-0-0.tsfile");
        if (!this.tsF.getParentFile().exists()) {
            Assert.assertTrue((boolean)this.tsF.getParentFile().mkdirs());
        }
    }

    @After
    public void tearDown() throws IOException, StorageEngineException {
        ByteBuffer[] buffers;
        EnvironmentUtils.cleanEnv();
        FileUtils.deleteDirectory((File)this.tsF.getParentFile());
        this.resource.close();
        for (ByteBuffer byteBuffer : buffers = this.node.delete()) {
            MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
        }
    }

    private void prepareData() throws IOException, MetadataException, WriteProcessException {
        int j;
        int i;
        IoTDB.metaManager.setStorageGroup(new PartialPath("root.sg"));
        for (int i2 = 0; i2 < 10; ++i2) {
            for (int j2 = 0; j2 < 10; ++j2) {
                IoTDB.metaManager.createTimeseries(new PartialPath("root.sg.device" + i2 + ".sensor" + j2), TSDataType.INT64, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
            }
        }
        Schema schema = new Schema();
        HashMap<String, MeasurementSchema> template = new HashMap<String, MeasurementSchema>();
        for (int i3 = 0; i3 < 10; ++i3) {
            template.put("sensor" + i3, new MeasurementSchema("sensor" + i3, TSDataType.INT64, TSEncoding.PLAIN));
        }
        MeasurementGroup group = new MeasurementGroup(false, template);
        schema.registerSchemaTemplate("template1", group);
        for (int i4 = 0; i4 < 10; ++i4) {
            schema.registerDevice("root.sg.device" + i4, "template1");
        }
        schema.registerDevice("root.sg.device99", "template1");
        this.writer = new TsFileWriter(this.tsF, schema);
        TSRecord tsRecord = new TSRecord(100L, "root.sg.device99");
        tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor4", (String)String.valueOf(0)));
        this.writer.write(tsRecord);
        tsRecord = new TSRecord(2L, "root.sg.device99");
        tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor1", (String)String.valueOf(0)));
        this.writer.write(tsRecord);
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 10; ++j) {
                tsRecord = new TSRecord((long)i, "root.sg.device" + j);
                for (int k = 0; k < 10; ++k) {
                    tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)("sensor" + k), (String)String.valueOf(k)));
                }
                this.writer.write(tsRecord);
            }
        }
        this.writer.flushAllChunkGroups();
        this.writer.getIOWriter().writePlanIndices();
        this.writer.getIOWriter().close();
        this.node = MultiFileLogNodeManager.getInstance().getNode(this.logNodePrefix + this.tsF.getName(), () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        });
        for (i = 10; i < 20; ++i) {
            for (j = 0; j < 10; ++j) {
                String[] measurements = new String[10];
                TSDataType[] types = new TSDataType[10];
                String[] values = new String[10];
                for (int k = 0; k < 10; ++k) {
                    measurements[k] = "sensor" + k;
                    types[k] = TSDataType.INT64;
                    values[k] = String.valueOf(k);
                }
                InsertRowPlan insertPlan = new InsertRowPlan(new PartialPath("root.sg.device" + j), (long)i, measurements, types, values);
                this.node.write((PhysicalPlan)insertPlan);
            }
            this.node.notifyStartFlush();
        }
        this.resource = new TsFileResource(this.tsF);
    }

    private void prepareDataWithDeletion() throws IOException, MetadataException, WriteProcessException {
        int i;
        int i2;
        IoTDB.metaManager.setStorageGroup(new PartialPath("root.sg"));
        for (int i3 = 0; i3 < 4; ++i3) {
            IoTDB.metaManager.createTimeseries(new PartialPath("root.sg.device" + i3 + ".sensor1"), TSDataType.INT64, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        }
        Schema schema = new Schema();
        HashMap<String, MeasurementSchema> template = new HashMap<String, MeasurementSchema>();
        template.put("sensor1", new MeasurementSchema("sensor1", TSDataType.INT64, TSEncoding.PLAIN));
        MeasurementGroup group = new MeasurementGroup(false, template);
        schema.registerSchemaTemplate("template1", group);
        for (int i4 = 0; i4 < 4; ++i4) {
            schema.registerDevice("root.sg.device" + i4, "template1");
        }
        this.writer = new TsFileWriter(this.tsF, schema);
        for (i2 = 0; i2 < 500; ++i2) {
            TSRecord tsRecord = new TSRecord((long)i2, "root.sg.device1");
            tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor1", (String)String.valueOf(i2)));
            this.writer.write(tsRecord);
        }
        for (i2 = 500; i2 < 1000; ++i2) {
            TSRecord tsRecord = new TSRecord((long)i2, "root.sg.device2");
            tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor1", (String)String.valueOf(i2)));
            this.writer.write(tsRecord);
        }
        for (i2 = 1000; i2 < 1500; ++i2) {
            TSRecord tsRecord = new TSRecord((long)i2, "root.sg.device3");
            tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor1", (String)String.valueOf(i2)));
            this.writer.write(tsRecord);
        }
        for (i2 = 1500; i2 < 2000; ++i2) {
            TSRecord tsRecord = new TSRecord((long)i2, "root.sg.device4");
            tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor1", (String)String.valueOf(i2)));
            this.writer.write(tsRecord);
        }
        this.writer.flushAllChunkGroups();
        long fileOffset = this.tsF.length();
        ModificationFile modificationFile = new ModificationFile(this.tsF.getAbsolutePath() + ".mods");
        modificationFile.write((Modification)new Deletion(new PartialPath("root.sg.device1", "sensor1"), fileOffset, 300L, Long.MAX_VALUE));
        modificationFile.write((Modification)new Deletion(new PartialPath("root.sg.device2", "sensor1"), fileOffset, Long.MIN_VALUE, 750L));
        modificationFile.write((Modification)new Deletion(new PartialPath("root.sg.device3", "sensor1"), fileOffset, Long.MIN_VALUE, Long.MAX_VALUE));
        modificationFile.write((Modification)new Deletion(new PartialPath("root.sg.device4", "sensor1"), fileOffset, 1500L, 2000L));
        for (i = 2000; i < 2500; ++i) {
            TSRecord tsRecord = new TSRecord((long)i, "root.sg.device1");
            tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor1", (String)String.valueOf(i)));
            this.writer.write(tsRecord);
        }
        for (i = 2500; i < 3000; ++i) {
            TSRecord tsRecord = new TSRecord((long)i, "root.sg.device2");
            tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor1", (String)String.valueOf(i)));
            this.writer.write(tsRecord);
        }
        for (i = 3000; i < 3500; ++i) {
            TSRecord tsRecord = new TSRecord((long)i, "root.sg.device3");
            tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor1", (String)String.valueOf(i)));
            this.writer.write(tsRecord);
        }
        for (i = 3500; i < 4000; ++i) {
            TSRecord tsRecord = new TSRecord((long)i, "root.sg.device4");
            tsRecord.addTuple(DataPoint.getDataPoint((TSDataType)TSDataType.INT64, (String)"sensor1", (String)String.valueOf(i)));
            this.writer.write(tsRecord);
        }
        this.writer.flushAllChunkGroups();
        fileOffset = this.tsF.length();
        modificationFile.write((Modification)new Deletion(new PartialPath("root.sg.device1", "sensor1"), fileOffset, 2300L, Long.MAX_VALUE));
        modificationFile.write((Modification)new Deletion(new PartialPath("root.sg.device2", "sensor1"), fileOffset, Long.MIN_VALUE, 2750L));
        modificationFile.write((Modification)new Deletion(new PartialPath("root.sg.device3", "sensor1"), fileOffset, 3100L, 3400L));
        modificationFile.write((Modification)new Deletion(new PartialPath("root.sg.device4", "sensor1"), fileOffset, 3500L, 4000L));
        this.writer.getIOWriter().writePlanIndices();
        this.writer.getIOWriter().close();
        this.node = MultiFileLogNodeManager.getInstance().getNode(this.logNodePrefix + this.tsF.getName(), () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        });
        for (i = 4000; i < 4500; ++i) {
            this.node.write((PhysicalPlan)new InsertRowPlan(new PartialPath("root.sg.device1"), (long)i, new String[]{"sensor1"}, new TSDataType[]{TSDataType.INT64}, new String[]{String.valueOf(i)}));
        }
        for (i = 4500; i < 5000; ++i) {
            this.node.write((PhysicalPlan)new InsertRowPlan(new PartialPath("root.sg.device2"), (long)i, new String[]{"sensor1"}, new TSDataType[]{TSDataType.INT64}, new String[]{String.valueOf(i)}));
        }
        for (i = 5000; i < 5500; ++i) {
            this.node.write((PhysicalPlan)new InsertRowPlan(new PartialPath("root.sg.device3"), (long)i, new String[]{"sensor1"}, new TSDataType[]{TSDataType.INT64}, new String[]{String.valueOf(i)}));
        }
        for (i = 5500; i < 6000; ++i) {
            this.node.write((PhysicalPlan)new InsertRowPlan(new PartialPath("root.sg.device4"), (long)i, new String[]{"sensor1"}, new TSDataType[]{TSDataType.INT64}, new String[]{String.valueOf(i)}));
        }
        this.node.write((PhysicalPlan)new DeletePlan(4300L, Long.MAX_VALUE, new PartialPath("root.sg.device1", "sensor1")));
        this.node.write((PhysicalPlan)new DeletePlan(Long.MIN_VALUE, 4750L, new PartialPath("root.sg.device2", "sensor1")));
        this.node.write((PhysicalPlan)new DeletePlan(5100L, 5400L, new PartialPath("root.sg.device3", "sensor1")));
        this.node.write((PhysicalPlan)new DeletePlan(5500L, 6000L, new PartialPath("root.sg.device4", "sensor1")));
        modificationFile.write((Modification)new Deletion(new PartialPath("root.sg.device1", "sensor1"), fileOffset, 4300L, Long.MAX_VALUE));
        modificationFile.write((Modification)new Deletion(new PartialPath("root.sg.device2", "sensor1"), fileOffset, Long.MIN_VALUE, 4750L));
        modificationFile.write((Modification)new Deletion(new PartialPath("root.sg.device3", "sensor1"), fileOffset, 5100L, 5400L));
        modificationFile.write((Modification)new Deletion(new PartialPath("root.sg.device4", "sensor1"), fileOffset, 5500L, 6000L));
        this.node.notifyStartFlush();
        modificationFile.close();
        this.resource = new TsFileResource(this.tsF);
    }

    private void prepareNullInsertRowPlan() throws Exception {
        if (!this.tsF.exists()) {
            this.tsF.createNewFile();
        }
        this.node = MultiFileLogNodeManager.getInstance().getNode(this.logNodePrefix + this.tsF.getName(), () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        });
        IoTDB.metaManager.createTimeseries(new PartialPath("root.sg.device1.sensor1"), TSDataType.INT64, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        InsertRowPlan insertRowPlan = new InsertRowPlan(new PartialPath("root.sg.device1"), 50L, new String[]{"sensor1"}, new TSDataType[]{TSDataType.INT64}, new String[]{"1"});
        insertRowPlan.markFailedMeasurementInsertion(0, new Exception());
        this.node.write((PhysicalPlan)insertRowPlan);
        InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath("root.sg.device1"), new String[]{"sensor1"}, Collections.singletonList(TSDataType.INT64.ordinal()));
        long[] times = new long[1];
        Object[] columns = new Object[]{new long[1]};
        times[0] = 1L;
        columns[0] = 1;
        insertTabletPlan.setTimes(times);
        insertTabletPlan.setColumns(columns);
        insertTabletPlan.setRowCount(times.length);
        insertTabletPlan.setStart(0);
        insertTabletPlan.setEnd(1);
        insertTabletPlan.markFailedMeasurementInsertion(0, new Exception());
        this.node.write((PhysicalPlan)insertTabletPlan);
        this.node.notifyStartFlush();
        this.resource = new TsFileResource(this.tsF);
    }

    @Test
    public void testNonLastRecovery() throws StorageGroupProcessorException, IOException, MetadataException, WriteProcessException {
        this.prepareData();
        TsFileRecoverPerformer performer = new TsFileRecoverPerformer(this.logNodePrefix, this.resource, false, false, null);
        RestorableTsFileIOWriter writer = performer.recover(true, () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        }, array -> {
            for (ByteBuffer byteBuffer : array) {
                MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
            }
        });
        Assert.assertFalse((boolean)writer.canWrite());
        writer.close();
        Assert.assertEquals((long)2L, (long)this.resource.getStartTime("root.sg.device99"));
        Assert.assertEquals((long)100L, (long)this.resource.getEndTime("root.sg.device99"));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)0L, (long)this.resource.getStartTime("root.sg.device" + i));
            Assert.assertEquals((long)19L, (long)this.resource.getEndTime("root.sg.device" + i));
        }
        TsFileReader tsFileReader = new TsFileReader(new TsFileSequenceReader(this.tsF.getPath()));
        ArrayList<Path> pathList = new ArrayList<Path>();
        for (int j = 0; j < 10; ++j) {
            for (int k = 0; k < 10; ++k) {
                pathList.add(new Path("root.sg.device" + j, "sensor" + k));
            }
        }
        QueryExpression queryExpression = QueryExpression.create(pathList, null);
        QueryDataSet dataSet = tsFileReader.query(queryExpression);
        for (int i = 0; i < 20; ++i) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((long)i, (long)record.getTimestamp());
            List fields = record.getFields();
            Assert.assertEquals((long)100L, (long)fields.size());
            for (int j = 0; j < 100; ++j) {
                Assert.assertEquals((long)(j % 10), (long)((Field)fields.get(j)).getLongV());
            }
        }
        pathList = new ArrayList();
        pathList.add(new Path("root.sg.device99", "sensor1"));
        pathList.add(new Path("root.sg.device99", "sensor4"));
        queryExpression = QueryExpression.create(pathList, null);
        dataSet = tsFileReader.query(queryExpression);
        Assert.assertTrue((boolean)dataSet.hasNext());
        RowRecord record = dataSet.next();
        Assert.assertEquals((Object)"2\t0\tnull", (Object)record.toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        record = dataSet.next();
        Assert.assertEquals((Object)"100\tnull\t0", (Object)record.toString());
        tsFileReader.close();
    }

    @Test
    public void testLastRecovery() throws StorageGroupProcessorException, IOException, MetadataException, WriteProcessException {
        this.prepareData();
        TsFileRecoverPerformer performer = new TsFileRecoverPerformer(this.logNodePrefix, this.resource, false, true, null);
        RestorableTsFileIOWriter writer = performer.recover(true, () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        }, array -> {
            for (ByteBuffer byteBuffer : array) {
                MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
            }
        });
        writer.makeMetadataVisible();
        Assert.assertEquals((long)11L, (long)writer.getMetadatasForQuery().size());
        Assert.assertEquals((long)2L, (long)this.resource.getStartTime("root.sg.device99"));
        Assert.assertEquals((long)100L, (long)this.resource.getEndTime("root.sg.device99"));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((long)0L, (long)this.resource.getStartTime("root.sg.device" + i));
            Assert.assertEquals((long)19L, (long)this.resource.getEndTime("root.sg.device" + i));
        }
        TsFileReader tsFileReader = new TsFileReader(new TsFileSequenceReader(this.tsF.getPath()));
        ArrayList<Path> pathList = new ArrayList<Path>();
        for (int j = 0; j < 10; ++j) {
            for (int k = 0; k < 10; ++k) {
                pathList.add(new Path("root.sg.device" + j, "sensor" + k));
            }
        }
        QueryExpression queryExpression = QueryExpression.create(pathList, null);
        QueryDataSet dataSet = tsFileReader.query(queryExpression);
        for (int i = 0; i < 20; ++i) {
            RowRecord record = dataSet.next();
            Assert.assertEquals((long)i, (long)record.getTimestamp());
            List fields = record.getFields();
            Assert.assertEquals((long)100L, (long)fields.size());
            for (int j = 0; j < 100; ++j) {
                Assert.assertEquals((long)(j % 10), (long)((Field)fields.get(j)).getLongV());
            }
        }
        pathList = new ArrayList();
        pathList.add(new Path("root.sg.device99", "sensor1"));
        pathList.add(new Path("root.sg.device99", "sensor4"));
        queryExpression = QueryExpression.create(pathList, null);
        dataSet = tsFileReader.query(queryExpression);
        Assert.assertTrue((boolean)dataSet.hasNext());
        RowRecord record = dataSet.next();
        Assert.assertEquals((Object)"2\t0\tnull", (Object)record.toString());
        Assert.assertTrue((boolean)dataSet.hasNext());
        record = dataSet.next();
        Assert.assertEquals((Object)"100\tnull\t0", (Object)record.toString());
        tsFileReader.close();
    }

    @Test
    public void testLastRecoveryWithDeletion() throws StorageGroupProcessorException, IOException, MetadataException, WriteProcessException {
        this.prepareDataWithDeletion();
        TsFileRecoverPerformer performer = new TsFileRecoverPerformer(this.logNodePrefix, this.resource, false, true, null);
        RestorableTsFileIOWriter writer = performer.recover(true, () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        }, array -> {
            for (ByteBuffer byteBuffer : array) {
                MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
            }
        });
        Assert.assertEquals((long)0L, (long)this.resource.getStartTime("root.sg.device1"));
        Assert.assertEquals((long)4299L, (long)this.resource.getEndTime("root.sg.device1"));
        Assert.assertEquals((long)4751L, (long)this.resource.getStartTime("root.sg.device2"));
        Assert.assertEquals((long)4999L, (long)this.resource.getEndTime("root.sg.device2"));
        Assert.assertEquals((long)3000L, (long)this.resource.getStartTime("root.sg.device3"));
        Assert.assertEquals((long)5499L, (long)this.resource.getEndTime("root.sg.device3"));
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.resource.getStartTime("root.sg.device4"));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.resource.getEndTime("root.sg.device4"));
    }

    @Test
    public void testRecoverNullInsertRowPlan() throws Exception {
        this.prepareNullInsertRowPlan();
        TsFileRecoverPerformer performer = new TsFileRecoverPerformer(this.logNodePrefix, this.resource, false, true, null);
        RestorableTsFileIOWriter writer = performer.recover(true, () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        }, array -> {
            for (ByteBuffer byteBuffer : array) {
                MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
            }
        });
        Assert.assertEquals((long)0L, (long)this.resource.getDevices().size());
    }
}

