/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog.recover;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.engine.memtable.PrimitiveMemTable;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.querycontext.ReadOnlyMemChunk;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.StorageGroupProcessorException;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.MmapUtil;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.apache.iotdb.db.writelog.recover.LogReplayer;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.reader.IPointReader;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LogReplayerTest {
    IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    boolean prevIsAutoCreateSchemaEnabled;
    boolean prevIsEnablePartialInsert;

    @Before
    public void before() {
        this.prevIsAutoCreateSchemaEnabled = this.config.isAutoCreateSchemaEnabled();
        this.prevIsEnablePartialInsert = this.config.isEnablePartialInsert();
        this.config.setAutoCreateSchemaEnabled(false);
        this.config.setEnablePartialInsert(true);
        EnvironmentUtils.envSetUp();
    }

    @After
    public void after() throws IOException, StorageEngineException {
        this.config.setAutoCreateSchemaEnabled(this.prevIsAutoCreateSchemaEnabled);
        this.config.setEnablePartialInsert(this.prevIsEnablePartialInsert);
        EnvironmentUtils.cleanEnv();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws IOException, StorageGroupProcessorException, QueryProcessException, MetadataException {
        String logNodePrefix = "testLogNode";
        File tsFile = SystemFileFactory.INSTANCE.getFile("temp", "1-1-1.tsfile");
        File modF = SystemFileFactory.INSTANCE.getFile("test.mod");
        ModificationFile modFile = new ModificationFile(modF.getPath());
        TsFileResource tsFileResource = new TsFileResource(tsFile);
        PrimitiveMemTable memTable = new PrimitiveMemTable();
        CompressionType compressionType = TSFileDescriptor.getInstance().getConfig().getCompressor();
        IoTDB.metaManager.setStorageGroup(new PartialPath("root.sg"));
        try {
            int i;
            TimeValuePair timeValuePair;
            for (int i2 = 0; i2 <= 5; ++i2) {
                for (int j = 0; j <= 5; ++j) {
                    IoTDB.metaManager.createTimeseries(new PartialPath("root.sg.device" + i2 + ".sensor" + j), TSDataType.INT64, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
                }
            }
            IoTDB.metaManager.createAlignedTimeSeries(new PartialPath("root.sg.device6"), Arrays.asList("s1", "s2", "s3", "s4", "s5"), Arrays.asList(TSDataType.INT32, TSDataType.INT64, TSDataType.BOOLEAN, TSDataType.FLOAT, TSDataType.TEXT), Arrays.asList(TSEncoding.RLE, TSEncoding.RLE, TSEncoding.RLE, TSEncoding.RLE, TSEncoding.PLAIN), Arrays.asList(compressionType, compressionType, compressionType, compressionType, compressionType));
            IoTDB.metaManager.deleteTimeseries(new PartialPath("root.sg.device0.sensor2"));
            IoTDB.metaManager.deleteTimeseries(new PartialPath("root.sg.device0.sensor4"));
            IoTDB.metaManager.deleteTimeseries(new PartialPath("root.sg.device6.s1"));
            IoTDB.metaManager.deleteTimeseries(new PartialPath("root.sg.device6.s5"));
            LogReplayer replayer = new LogReplayer(logNodePrefix, tsFile.getPath(), modFile, tsFileResource, (IMemTable)memTable, false);
            WriteLogNode node = MultiFileLogNodeManager.getInstance().getNode(logNodePrefix + tsFile.getName(), () -> {
                ByteBuffer[] byteBuffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
                return byteBuffers;
            });
            node.write((PhysicalPlan)new InsertRowPlan(new PartialPath("root.sg.device0"), 50L, "sensor4", TSDataType.INT64, String.valueOf(0)));
            node.write((PhysicalPlan)new InsertRowPlan(new PartialPath("root.sg.device0"), 100L, "sensor0", TSDataType.INT64, String.valueOf(0)));
            node.write((PhysicalPlan)new InsertRowPlan(new PartialPath("root.sg.device0"), 2L, "sensor1", TSDataType.INT64, String.valueOf(0)));
            for (int i3 = 1; i3 < 5; ++i3) {
                node.write((PhysicalPlan)new InsertRowPlan(new PartialPath("root.sg.device" + i3), (long)i3, "sensor" + i3, TSDataType.INT64, String.valueOf(i3)));
            }
            node.write((PhysicalPlan)this.insertTabletPlan());
            node.write((PhysicalPlan)this.insertAlignedTabletPlan());
            DeletePlan deletePlan = new DeletePlan(0L, 200L, new PartialPath("root.sg.device0.sensor0"));
            node.write((PhysicalPlan)deletePlan);
            node.close();
            replayer.replayLogs(() -> {
                ByteBuffer[] byteBuffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
                return byteBuffers;
            }, null);
            for (int i4 = 0; i4 < 5; ++i4) {
                MeasurementPath fullPath = new MeasurementPath("root.sg.device" + i4, "sensor" + i4, (IMeasurementSchema)new MeasurementSchema("sensor" + i4, TSDataType.INT64, TSEncoding.RLE, CompressionType.UNCOMPRESSED, Collections.emptyMap()));
                ReadOnlyMemChunk memChunk = memTable.query((PartialPath)fullPath, Long.MIN_VALUE, null);
                IPointReader iterator = memChunk.getPointReader();
                if (i4 != 0) {
                    Assert.assertTrue((boolean)iterator.hasNextTimeValuePair());
                    timeValuePair = iterator.nextTimeValuePair();
                    Assert.assertEquals((long)i4, (long)timeValuePair.getTimestamp());
                    Assert.assertEquals((long)i4, (long)timeValuePair.getValue().getLong());
                }
                Assert.assertFalse((boolean)iterator.hasNextTimeValuePair());
            }
            AlignedPath alignedfullPath = new AlignedPath("root.sg.device6", Arrays.asList("s1", "s2", "s3", "s4", "s5"), Arrays.asList(new MeasurementSchema("s1", TSDataType.INT32, TSEncoding.RLE), new MeasurementSchema("s2", TSDataType.INT64, TSEncoding.RLE), new MeasurementSchema("s3", TSDataType.BOOLEAN, TSEncoding.RLE), new MeasurementSchema("s4", TSDataType.FLOAT, TSEncoding.RLE), new MeasurementSchema("s5", TSDataType.TEXT, TSEncoding.PLAIN)));
            ReadOnlyMemChunk memChunk = memTable.query((PartialPath)alignedfullPath, Long.MIN_VALUE, null);
            IPointReader iterator = memChunk.getPointReader();
            int time = 0;
            while (iterator.hasNextTimeValuePair()) {
                timeValuePair = iterator.nextTimeValuePair();
                Assert.assertEquals((long)time, (long)timeValuePair.getTimestamp());
                Assert.assertEquals(null, (Object)timeValuePair.getValue().getVector()[0]);
                Assert.assertEquals(null, (Object)timeValuePair.getValue().getVector()[1]);
                Assert.assertEquals((Object)true, (Object)timeValuePair.getValue().getVector()[2].getBoolean());
                Assert.assertEquals((double)time, (double)timeValuePair.getValue().getVector()[3].getFloat(), (double)1.0E-5);
                Assert.assertEquals(null, (Object)timeValuePair.getValue().getVector()[4]);
                ++time;
            }
            Assert.assertEquals((long)100L, (long)time);
            Modification[] mods = modFile.getModifications().toArray(new Modification[0]);
            Assert.assertEquals((long)1L, (long)mods.length);
            Assert.assertEquals((Object)"root.sg.device0.sensor0", (Object)mods[0].getPathString());
            Assert.assertEquals((long)0L, (long)mods[0].getFileOffset());
            Assert.assertEquals((long)200L, (long)((Deletion)mods[0]).getEndTime());
            Assert.assertEquals((long)2L, (long)tsFileResource.getStartTime("root.sg.device0"));
            Assert.assertEquals((long)2L, (long)tsFileResource.getEndTime("root.sg.device0"));
            Assert.assertEquals((long)0L, (long)tsFileResource.getStartTime("root.sg.device6"));
            Assert.assertEquals((long)99L, (long)tsFileResource.getEndTime("root.sg.device6"));
            for (i = 1; i < 5; ++i) {
                Assert.assertEquals((long)i, (long)tsFileResource.getStartTime("root.sg.device" + i));
                Assert.assertEquals((long)i, (long)tsFileResource.getEndTime("root.sg.device" + i));
            }
            for (i = 0; i < 2; ++i) {
                MeasurementPath fullPath = new MeasurementPath("root.sg.device5", "sensor" + i, (IMeasurementSchema)new MeasurementSchema("sensor" + i, TSDataType.INT64, TSEncoding.PLAIN, CompressionType.UNCOMPRESSED, Collections.emptyMap()));
                memChunk = memTable.query((PartialPath)fullPath, Long.MIN_VALUE, null);
                if (i == 0) {
                    Assert.assertNull((Object)memChunk);
                    continue;
                }
                iterator = memChunk.getPointReader();
                iterator.hasNextTimeValuePair();
                for (time = 0; time < 100; ++time) {
                    TimeValuePair timeValuePair2 = iterator.nextTimeValuePair();
                    Assert.assertEquals((long)time, (long)timeValuePair2.getTimestamp());
                    Assert.assertEquals((long)time, (long)timeValuePair2.getValue().getLong());
                }
            }
        }
        finally {
            modFile.close();
            MultiFileLogNodeManager.getInstance().deleteNode(logNodePrefix + tsFile.getName(), byteBuffers -> {
                for (ByteBuffer byteBuffer : byteBuffers) {
                    MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
                }
            });
            modF.delete();
            tsFile.delete();
            tsFile.getParentFile().delete();
        }
    }

    private InsertTabletPlan insertTabletPlan() throws IllegalPathException {
        String[] measurements = new String[]{"sensor0", "sensor1", "sensor2", "sensor3"};
        ArrayList<Integer> dataTypes = new ArrayList<Integer>();
        dataTypes.add(TSDataType.BOOLEAN.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        dataTypes.add(TSDataType.INT64.ordinal());
        String deviceId = "root.sg.device5";
        IMeasurementMNode[] mNodes = new IMeasurementMNode[]{MeasurementMNode.getMeasurementMNode(null, (String)"sensor0", null, null), MeasurementMNode.getMeasurementMNode(null, (String)"sensor1", null, null), MeasurementMNode.getMeasurementMNode(null, (String)"sensor2", null, null), MeasurementMNode.getMeasurementMNode(null, (String)"sensor3", null, null)};
        InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath(deviceId), measurements, dataTypes);
        long[] times = new long[100];
        Object[] columns = new Object[]{new boolean[100], new long[100], new long[100], new long[100]};
        for (long r = 0L; r < 100L; ++r) {
            times[(int)r] = r;
            ((boolean[])columns[0])[(int)r] = false;
            ((long[])columns[1])[(int)r] = r;
            ((long[])columns[2])[(int)r] = r;
            ((long[])columns[3])[(int)r] = r;
        }
        insertTabletPlan.setTimes(times);
        insertTabletPlan.setColumns(columns);
        insertTabletPlan.setRowCount(times.length);
        insertTabletPlan.setMeasurementMNodes(mNodes);
        insertTabletPlan.setStart(0);
        insertTabletPlan.setEnd(100);
        return insertTabletPlan;
    }

    private InsertTabletPlan insertAlignedTabletPlan() throws IllegalPathException {
        String deviceId = "root.sg.device6";
        List<Integer> dataTypes = Arrays.asList(TSDataType.INT32.ordinal(), TSDataType.BOOLEAN.ordinal(), TSDataType.BOOLEAN.ordinal(), TSDataType.FLOAT.ordinal(), TSDataType.TEXT.ordinal());
        InsertTabletPlan insertTabletPlan = new InsertTabletPlan(new PartialPath(deviceId), new String[]{"s1", "s2", "s3", "s4", "s5"}, dataTypes, true);
        long[] times = new long[100];
        Object[] columns = new Object[]{new int[100], new boolean[100], new boolean[100], new float[100], new Binary[100]};
        for (long r = 0L; r < 100L; ++r) {
            times[(int)r] = r;
            ((int[])columns[0])[(int)r] = (int)r;
            ((boolean[])columns[1])[(int)r] = true;
            ((boolean[])columns[2])[(int)r] = true;
            ((float[])columns[3])[(int)r] = r;
            ((Binary[])columns[4])[(int)r] = Binary.valueOf((String)(r + ""));
        }
        insertTabletPlan.setTimes(times);
        insertTabletPlan.setColumns(columns);
        insertTabletPlan.setRowCount(times.length);
        return insertTabletPlan;
    }
}

