/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import junit.framework.TestCase;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.MmapUtil;
import org.apache.iotdb.db.writelog.manager.MultiFileLogNodeManager;
import org.apache.iotdb.db.writelog.node.WriteLogNode;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class WriteLogNodeManagerTest {
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private boolean enableWal;

    @Before
    public void setUp() {
        this.enableWal = this.config.isEnableWal();
        this.config.setEnableWal(true);
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        this.config.setEnableWal(this.enableWal);
    }

    @Test
    public void testGetAndDelete() throws IOException {
        String identifier = "testLogNode";
        MultiFileLogNodeManager manager = MultiFileLogNodeManager.getInstance();
        WriteLogNode logNode = manager.getNode(identifier, () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        });
        TestCase.assertEquals((String)identifier, (String)logNode.getIdentifier());
        WriteLogNode theSameNode = manager.getNode(identifier, () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        });
        TestCase.assertSame((Object)logNode, (Object)theSameNode);
        manager.deleteNode(identifier, array -> {
            for (ByteBuffer byteBuffer : array) {
                MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
            }
        });
        WriteLogNode anotherNode = manager.getNode(identifier, () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        });
        TestCase.assertNotSame((Object)logNode, (Object)anotherNode);
        manager.deleteNode(identifier, array -> {
            for (ByteBuffer byteBuffer : array) {
                MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
            }
        });
    }

    @Test
    public void testAutoSync() throws IOException, InterruptedException, IllegalPathException {
        ByteBuffer[] buffers;
        int flushWalPeriod = this.config.getFlushWalThreshold();
        this.config.setForceWalPeriodInMs(10000L);
        File tempRestore = File.createTempFile("managerTest", "restore");
        File tempProcessorStore = File.createTempFile("managerTest", "processorStore");
        MultiFileLogNodeManager manager = MultiFileLogNodeManager.getInstance();
        WriteLogNode logNode = manager.getNode("root.managerTest", () -> {
            ByteBuffer[] buffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
            return buffers;
        });
        InsertRowPlan bwInsertPlan = new InsertRowPlan(new PartialPath("logTestDevice"), 100L, new String[]{"s1", "s2", "s3", "s4"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.INT64, TSDataType.TEXT, TSDataType.BOOLEAN}, new String[]{"1.0", "15", "str", "false"});
        DeletePlan deletePlan = new DeletePlan(Long.MIN_VALUE, 50L, new PartialPath("root.logTestDevice.s1"));
        File walFile = new File(logNode.getLogDirectory() + File.separator + "wal1");
        TestCase.assertFalse((boolean)walFile.exists());
        logNode.write((PhysicalPlan)bwInsertPlan);
        logNode.write((PhysicalPlan)deletePlan);
        Thread.sleep(this.config.getForceWalPeriodInMs() + 1000L);
        TestCase.assertTrue((boolean)walFile.exists());
        for (ByteBuffer byteBuffer : buffers = logNode.delete()) {
            MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
        }
        this.config.setForceWalPeriodInMs((long)flushWalPeriod);
        tempRestore.delete();
        tempProcessorStore.delete();
        tempRestore.getParentFile().delete();
    }
}

