/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.writelog;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.Collections;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.metadata.MetadataException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.db.utils.MmapUtil;
import org.apache.iotdb.db.writelog.node.ExclusiveWriteLogNode;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore
public class PerformanceTest {
    private IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private boolean enableWal;
    private boolean skip = true;

    @Before
    public void setUp() {
        this.enableWal = this.config.isEnableWal();
        this.config.setEnableWal(true);
        EnvironmentUtils.envSetUp();
    }

    @After
    public void tearDown() throws Exception {
        EnvironmentUtils.cleanEnv();
        this.config.setEnableWal(this.enableWal);
    }

    @Test
    public void writeLogTest() throws IOException, IllegalPathException {
        if (this.skip) {
            return;
        }
        int[] batchSizes = new int[]{100, 500, 1000, 5000, 10000};
        long[] forceCycle = new long[]{10L, 0L};
        int oldBatchSize = this.config.getFlushWalThreshold();
        long oldForceCycle = this.config.getForceWalPeriodInMs();
        for (int j = 0; j < batchSizes.length; ++j) {
            for (int k = 0; k < forceCycle.length; ++k) {
                ByteBuffer[] array;
                this.config.setFlushWalThreshold(batchSizes[j]);
                this.config.setForceWalPeriodInMs(forceCycle[k]);
                File tempRestore = new File("testtemp", "restore");
                File tempProcessorStore = new File("testtemp", "processorStore");
                tempRestore.getParentFile().mkdirs();
                tempRestore.createNewFile();
                tempProcessorStore.createNewFile();
                ByteBuffer[] byteBuffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
                ExclusiveWriteLogNode logNode = new ExclusiveWriteLogNode("root.testLogNode");
                logNode.initBuffer(byteBuffers);
                long time = System.currentTimeMillis();
                for (int i = 0; i < 1000000; ++i) {
                    InsertRowPlan bwInsertPlan = new InsertRowPlan(new PartialPath("logTestDevice"), 100L, new String[]{"s1", "s2", "s3", "s4"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.INT64, TSDataType.TEXT, TSDataType.BOOLEAN}, new String[]{"1.0", "15", "str", "false"});
                    DeletePlan deletePlan = new DeletePlan(Long.MIN_VALUE, 50L, new PartialPath("root.logTestDevice.s1"));
                    logNode.write((PhysicalPlan)bwInsertPlan);
                    logNode.write((PhysicalPlan)deletePlan);
                }
                logNode.forceSync();
                System.out.println("3000000 logs use " + (System.currentTimeMillis() - time) + " ms at batch size " + this.config.getFlushWalThreshold());
                for (ByteBuffer byteBuffer : array = logNode.delete()) {
                    MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
                }
                tempRestore.delete();
                tempProcessorStore.delete();
                tempRestore.getParentFile().delete();
            }
        }
        this.config.setFlushWalThreshold(oldBatchSize);
        this.config.setForceWalPeriodInMs(oldForceCycle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void recoverTest() throws IOException, MetadataException {
        if (this.skip) {
            return;
        }
        File tempRestore = new File("testtemp", "restore");
        File tempProcessorStore = new File("testtemp", "processorStore");
        tempRestore.getParentFile().mkdirs();
        tempRestore.createNewFile();
        tempProcessorStore.createNewFile();
        try {
            IoTDB.metaManager.setStorageGroup(new PartialPath("root.logTestDevice"));
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        IoTDB.metaManager.createTimeseries(new PartialPath("root.logTestDevice.s1"), TSDataType.DOUBLE, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        IoTDB.metaManager.createTimeseries(new PartialPath("root.logTestDevice.s2"), TSDataType.INT32, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        IoTDB.metaManager.createTimeseries(new PartialPath("root.logTestDevice.s3"), TSDataType.TEXT, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        IoTDB.metaManager.createTimeseries(new PartialPath("root.logTestDevice.s4"), TSDataType.BOOLEAN, TSEncoding.PLAIN, TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
        ByteBuffer[] byteBuffers = new ByteBuffer[]{ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2), ByteBuffer.allocateDirect(IoTDBDescriptor.getInstance().getConfig().getWalBufferSize() / 2)};
        ExclusiveWriteLogNode logNode = new ExclusiveWriteLogNode("root.logTestDevice");
        logNode.initBuffer(byteBuffers);
        for (int i = 0; i < 1000000; ++i) {
            InsertRowPlan bwInsertPlan = new InsertRowPlan(new PartialPath("root.logTestDevice"), 100L, new String[]{"s1", "s2", "s3", "s4"}, new TSDataType[]{TSDataType.DOUBLE, TSDataType.INT64, TSDataType.TEXT, TSDataType.BOOLEAN}, new String[]{"1.0", "15", "str", "false"});
            DeletePlan deletePlan = new DeletePlan(Long.MIN_VALUE, 50L, new PartialPath("root.logTestDevice.s1"));
            logNode.write((PhysicalPlan)bwInsertPlan);
            logNode.write((PhysicalPlan)deletePlan);
        }
        try {
            logNode.forceSync();
            long time = System.currentTimeMillis();
            System.out.println("3000000 logs use " + (System.currentTimeMillis() - time) + "ms when recovering ");
        }
        finally {
            ByteBuffer[] array;
            for (ByteBuffer byteBuffer : array = logNode.delete()) {
                MmapUtil.clean((MappedByteBuffer)((MappedByteBuffer)byteBuffer));
            }
            tempRestore.delete();
            tempProcessorStore.delete();
            tempRestore.getParentFile().delete();
        }
    }
}

