/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.db.utils.datastructure.AlignedTVList;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.junit.Assert;
import org.junit.Test;

public class VectorTVListTest {
    @Test
    public void testVectorTVList1() {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < 5; ++i) {
            dataTypes.add(TSDataType.INT64);
        }
        AlignedTVList tvList = new AlignedTVList(dataTypes);
        for (long i = 0L; i < 1000L; ++i) {
            Object[] value = new Object[5];
            int[] columnOrder = new int[5];
            for (int j = 0; j < 5; ++j) {
                value[j] = i;
                columnOrder[j] = j;
            }
            tvList.putAlignedValue(i, value, columnOrder);
        }
        for (int i = 0; i < tvList.rowCount; ++i) {
            StringBuilder builder = new StringBuilder("[");
            builder.append(String.valueOf(i));
            for (int j = 1; j < 5; ++j) {
                builder.append(", ").append(String.valueOf(i));
            }
            builder.append("]");
            Assert.assertEquals((Object)builder.toString(), (Object)tvList.getAlignedValue(i).toString());
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testVectorTVList2() {
        int i;
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        dataTypes.add(TSDataType.BOOLEAN);
        dataTypes.add(TSDataType.INT32);
        dataTypes.add(TSDataType.INT64);
        dataTypes.add(TSDataType.FLOAT);
        dataTypes.add(TSDataType.DOUBLE);
        dataTypes.add(TSDataType.TEXT);
        AlignedTVList tvList = new AlignedTVList(dataTypes);
        for (i = 1000; i >= 0; --i) {
            Object[] value = new Object[]{false, 100, 1000L, Float.valueOf(0.1f), 0.2, new Binary("Test")};
            int[] columnOrder = new int[6];
            for (int j = 0; j < 6; ++j) {
                columnOrder[j] = j;
            }
            tvList.putAlignedValue((long)i, value, columnOrder);
        }
        tvList.sort();
        for (i = 0; i < tvList.rowCount; ++i) {
            StringBuilder builder = new StringBuilder("[");
            builder.append("false, 100, 1000, 0.1, 0.2, Test");
            builder.append("]");
            Assert.assertEquals((Object)builder.toString(), (Object)tvList.getAlignedValue(i).toString());
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testVectorTVLists() {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        for (int i = 0; i < 5; ++i) {
            dataTypes.add(TSDataType.INT64);
        }
        AlignedTVList tvList = new AlignedTVList(dataTypes);
        long[][] vectorArray = new long[5][1001];
        ArrayList<Long> timeList = new ArrayList<Long>();
        int[] columnOrder = new int[5];
        for (int i = 1000; i >= 0; --i) {
            timeList.add(Long.valueOf(i));
            for (int j = 0; j < 5; ++j) {
                vectorArray[j][i] = i;
                columnOrder[j] = j;
            }
        }
        tvList.putAlignedValues(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), (Object[])vectorArray, null, columnOrder, 0, 1000);
        for (long i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((long)((long)tvList.rowCount - i), (long)tvList.getTime((int)i));
        }
    }

    @Test
    public void testVectorTVListsWithBitMaps() {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        BitMap[] bitMaps = new BitMap[5];
        for (int i = 0; i < 5; ++i) {
            dataTypes.add(TSDataType.INT64);
            bitMaps[i] = new BitMap(1001);
        }
        AlignedTVList tvList = new AlignedTVList(dataTypes);
        long[][] vectorArray = new long[5][1001];
        int[] columnOrder = new int[5];
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (int i = 1000; i >= 0; --i) {
            timeList.add(Long.valueOf(i));
            for (int j = 0; j < 5; ++j) {
                vectorArray[j][i] = i;
                if (i % 100 == 0) {
                    bitMaps[j].mark(i);
                }
                columnOrder[j] = j;
            }
        }
        tvList.putAlignedValues(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), (Object[])vectorArray, bitMaps, columnOrder, 0, 1000);
        for (long i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((long)((long)tvList.rowCount - i), (long)tvList.getTime((int)i));
            if (i % 100L != 0L) continue;
            Assert.assertEquals((Object)"[null, null, null, null, null]", (Object)tvList.getAlignedValue((int)i).toString());
        }
    }

    @Test
    public void testClone() {
        ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
        BitMap[] bitMaps = new BitMap[5];
        for (int i = 0; i < 5; ++i) {
            dataTypes.add(TSDataType.INT64);
            bitMaps[i] = new BitMap(1001);
        }
        AlignedTVList tvList = new AlignedTVList(dataTypes);
        long[][] vectorArray = new long[5][1001];
        int[] columnOrder = new int[5];
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (int i = 1000; i >= 0; --i) {
            timeList.add(Long.valueOf(i));
            for (int j = 0; j < 5; ++j) {
                vectorArray[j][i] = i;
                if (i % 100 == 0) {
                    bitMaps[j].mark(i);
                }
                columnOrder[j] = j;
            }
        }
        tvList.putAlignedValues(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), (Object[])vectorArray, bitMaps, columnOrder, 0, 1000);
        AlignedTVList clonedTvList = tvList.clone();
        for (long i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((long)tvList.getTime((int)i), (long)clonedTvList.getTime((int)i));
            Assert.assertEquals((Object)tvList.getAlignedValue((int)i).toString(), (Object)clonedTvList.getAlignedValue((int)i).toString());
            int column = 0;
            while (i < 5L) {
                Assert.assertEquals((Object)tvList.isValueMarked((int)i, column), (Object)clonedTvList.isValueMarked((int)i, column));
                ++i;
            }
        }
    }
}

