/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils.datastructure;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.iotdb.db.utils.datastructure.BooleanTVList;
import org.apache.iotdb.tsfile.utils.BitMap;
import org.junit.Assert;
import org.junit.Test;

public class BooleanTVListTest {
    @Test
    public void testBooleanTVList() {
        int i;
        BooleanTVList tvList = new BooleanTVList();
        for (i = 0; i < 50; ++i) {
            tvList.putBoolean((long)i, true);
        }
        for (i = 50; i < 100; ++i) {
            tvList.putBoolean((long)i, false);
        }
        for (i = 0; i < tvList.rowCount / 2; ++i) {
            Assert.assertTrue((boolean)tvList.getBoolean(i));
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
        for (i = tvList.rowCount / 2 + 1; i < tvList.rowCount; ++i) {
            Assert.assertFalse((boolean)tvList.getBoolean(i));
            Assert.assertEquals((long)i, (long)tvList.getTime(i));
        }
    }

    @Test
    public void testPutBooleansWithoutBitMap() {
        long i;
        BooleanTVList tvList = new BooleanTVList();
        ArrayList<Boolean> booleanList = new ArrayList<Boolean>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        for (i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            booleanList.add(i % 2L == 0L);
        }
        tvList.putBooleans(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Boolean[])booleanList.toArray(new Boolean[0])), null, 0, 1000);
        for (i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((long)((long)tvList.rowCount - i), (long)tvList.getTime((int)i));
        }
    }

    @Test
    public void testPutBooleansWithBitMap() {
        BooleanTVList tvList = new BooleanTVList();
        ArrayList<Boolean> booleanList = new ArrayList<Boolean>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        BitMap bitMap = new BitMap(1001);
        for (long i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            booleanList.add(i % 2L == 0L);
            if (i % 100L != 0L) continue;
            bitMap.mark((int)i);
        }
        tvList.putBooleans(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Boolean[])booleanList.toArray(new Boolean[0])), bitMap, 0, 1000);
        tvList.sort();
        int nullCnt = 0;
        for (long i = 1L; i < (long)booleanList.size(); ++i) {
            if (i % 100L == 0L) {
                ++nullCnt;
                continue;
            }
            Assert.assertEquals((Object)(i % 2L == 0L ? 1 : 0), (Object)tvList.getBoolean((int)i - nullCnt - 1));
            Assert.assertEquals((long)i, (long)tvList.getTime((int)i - nullCnt - 1));
        }
    }

    @Test
    public void testClone() {
        BooleanTVList tvList = new BooleanTVList();
        ArrayList<Boolean> booleanList = new ArrayList<Boolean>();
        ArrayList<Long> timeList = new ArrayList<Long>();
        BitMap bitMap = new BitMap(1001);
        for (long i = 1000L; i >= 0L; --i) {
            timeList.add(i);
            booleanList.add(i % 2L == 0L);
            if (i % 100L != 0L) continue;
            bitMap.mark((int)i);
        }
        tvList.putBooleans(ArrayUtils.toPrimitive((Long[])timeList.toArray(new Long[0])), ArrayUtils.toPrimitive((Boolean[])booleanList.toArray(new Boolean[0])), bitMap, 0, 1000);
        tvList.sort();
        BooleanTVList clonedTvList = tvList.clone();
        for (long i = 0L; i < (long)tvList.rowCount; ++i) {
            Assert.assertEquals((Object)tvList.getBoolean((int)i), (Object)clonedTvList.getBoolean((int)i));
            Assert.assertEquals((long)tvList.getTime((int)i), (long)clonedTvList.getTime((int)i));
        }
    }
}

