/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.utils;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.exception.metadata.IllegalPathException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.PartialPath;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.executor.IPlanExecutor;
import org.apache.iotdb.db.qp.executor.PlanExecutor;
import org.apache.iotdb.db.tools.TsFileRewriteTool;
import org.apache.iotdb.db.utils.EnvironmentUtils;
import org.apache.iotdb.tsfile.common.conf.TSFileConfig;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.apache.iotdb.tsfile.read.TsFileReader;
import org.apache.iotdb.tsfile.read.TsFileSequenceReader;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.QueryExpression;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.write.TsFileWriter;
import org.apache.iotdb.tsfile.write.record.TSRecord;
import org.apache.iotdb.tsfile.write.record.datapoint.DataPoint;
import org.apache.iotdb.tsfile.write.record.datapoint.LongDataPoint;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TsFileRewriteToolTest {
    private final boolean newEnablePartition = true;
    private final long newPartitionInterval = 3600000L;
    protected final long maxTimestamp = 100000000L;
    protected final String folder = "target" + File.separator + "split";
    protected final String STORAGE_GROUP = "root.sg_0";
    protected final String DEVICE1 = "root.sg_0.device_1";
    protected final String DEVICE2 = "root.sg_0.device_2";
    protected final String SENSOR1 = "sensor_1";
    protected final String SENSOR2 = "sensor_2";
    private final long VALUE_OFFSET = 1L;
    private final IPlanExecutor queryExecutor = new PlanExecutor();
    private final Planner processor = new Planner();
    private String path = null;
    private IoTDBConfig config;
    private boolean originEnablePartition;
    private long originPartitionInterval;

    @Before
    public void setUp() {
        EnvironmentUtils.envSetUp();
        this.config = IoTDBDescriptor.getInstance().getConfig();
        this.originEnablePartition = this.config.isEnablePartition();
        this.originPartitionInterval = this.config.getPartitionInterval();
        this.config.setEnablePartition(true);
        this.config.setPartitionInterval(3600000L);
        StorageEngine.setEnablePartition((boolean)true);
        StorageEngine.setTimePartitionInterval((long)3600000L);
        File f = new File(this.folder);
        if (!f.exists()) {
            boolean success = f.mkdir();
            Assert.assertTrue((boolean)success);
        }
        this.path = this.folder + File.separator + System.currentTimeMillis() + "-" + 0 + "-0.tsfile";
    }

    @After
    public void tearDown() {
        File f = new File(this.path);
        if (f.exists()) {
            boolean deleteSuccess = f.delete();
            Assert.assertTrue((boolean)deleteSuccess);
        }
        this.config.setEnablePartition(this.originEnablePartition);
        this.config.setPartitionInterval(this.originPartitionInterval);
        StorageEngine.setEnablePartition((boolean)this.originEnablePartition);
        StorageEngine.setTimePartitionInterval((long)this.originPartitionInterval);
        File directory = new File(this.folder);
        try {
            FileUtils.deleteDirectory((File)directory);
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
        try {
            EnvironmentUtils.cleanEnv();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void splitOneTsfileWithOneDeviceOneSensorTest() {
        HashMap<String, List<String>> deviceSensorsMap = new HashMap<String, List<String>>();
        ArrayList<String> sensors = new ArrayList<String>();
        sensors.add("sensor_1");
        deviceSensorsMap.put("root.sg_0.device_1", sensors);
        this.createOneTsFile(deviceSensorsMap);
        this.splitFileAndQueryCheck(deviceSensorsMap);
    }

    @Test
    public void splitOneTsfileWithOneDeviceTwoSensorTest() {
        HashMap<String, List<String>> deviceSensorsMap = new HashMap<String, List<String>>();
        ArrayList<String> sensors = new ArrayList<String>();
        sensors.add("sensor_1");
        sensors.add("sensor_2");
        deviceSensorsMap.put("root.sg_0.device_1", sensors);
        this.createOneTsFile(deviceSensorsMap);
        this.splitFileAndQueryCheck(deviceSensorsMap);
    }

    @Test
    public void splitOneTsfileWithTwoDeviceTwoSensorTest() {
        HashMap<String, List<String>> deviceSensorsMap = new HashMap<String, List<String>>();
        ArrayList<String> sensors = new ArrayList<String>();
        sensors.add("sensor_1");
        sensors.add("sensor_2");
        deviceSensorsMap.put("root.sg_0.device_1", sensors);
        deviceSensorsMap.put("root.sg_0.device_2", sensors);
        this.createOneTsFile(deviceSensorsMap);
        this.splitFileAndQueryCheck(deviceSensorsMap);
    }

    @Test
    public void loadFileTest() {
        HashMap<String, List<String>> deviceSensorsMap = new HashMap<String, List<String>>();
        ArrayList<String> sensors = new ArrayList<String>();
        sensors.add("sensor_1");
        deviceSensorsMap.put("root.sg_0.device_1", sensors);
        this.createOneTsFile(deviceSensorsMap);
        String sql = String.format("load '%s' autoregister=true", this.path);
        try {
            this.queryExecutor.processNonQuery(this.processor.parseSQLToPhysicalPlan(sql));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void loadFileWithOnlyOnePageTest() {
        HashMap<String, List<String>> deviceSensorsMap = new HashMap<String, List<String>>();
        ArrayList<String> sensors = new ArrayList<String>();
        sensors.add("sensor_1");
        deviceSensorsMap.put("root.sg_0.device_1", sensors);
        this.createOneTsFileWithOnlyOnePage(deviceSensorsMap);
        String sql = String.format("load '%s' autoregister=true", this.path);
        try {
            this.queryExecutor.processNonQuery(this.processor.parseSQLToPhysicalPlan(sql));
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private void createFile(List<TsFileResource> resourcesToBeSettled, HashMap<String, List<String>> deviceSensorsMap, String timeseriesPath) throws IOException {
        this.createOneTsFile(deviceSensorsMap);
        this.createlModificationFile(timeseriesPath);
        TsFileResource tsFileResource = new TsFileResource(new File(this.path));
        tsFileResource.setModFile(new ModificationFile(tsFileResource.getTsFilePath() + ".mods"));
        tsFileResource.serialize();
        tsFileResource.close();
        resourcesToBeSettled.add(tsFileResource);
    }

    public void createlModificationFile(String timeseriesPath) {
        String modFilePath = this.path + ".mods";
        ModificationFile modificationFile = new ModificationFile(modFilePath);
        ArrayList<Deletion> mods = new ArrayList<Deletion>();
        try {
            PartialPath partialPath = new PartialPath(timeseriesPath);
            mods.add(new Deletion(partialPath, 10000000L, 1500L, 10000L));
            mods.add(new Deletion(partialPath, 10000000L, 20000L, 30000L));
            mods.add(new Deletion(partialPath, 10000000L, 45000L, 50000L));
            for (Modification modification : mods) {
                modificationFile.write(modification);
            }
            modificationFile.close();
        }
        catch (IOException | IllegalPathException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private void splitFileAndQueryCheck(HashMap<String, List<String>> deviceSensorsMap) {
        File tsFile = new File(this.path);
        TsFileResource tsFileResource = new TsFileResource(tsFile);
        ArrayList splitResource = new ArrayList();
        try {
            TsFileRewriteTool.rewriteTsFile((TsFileResource)tsFileResource, splitResource);
        }
        catch (IOException | IllegalPathException | WriteProcessException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)28L, (long)splitResource.size());
        for (int i = 0; i < splitResource.size(); ++i) {
            try {
                this.queryAndCheckTsFileWithOneDevice(((TsFileResource)splitResource.get(i)).getTsFilePath(), i, deviceSensorsMap);
                long partitionId = ((TsFileResource)splitResource.get(i)).getTimePartition();
                Assert.assertEquals((long)i, (long)partitionId);
                continue;
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
            }
        }
    }

    private void createOneTsFileWithOnlyOnePage(HashMap<String, List<String>> deviceSensorsMap) {
        try {
            File f = FSFactoryProducer.getFSFactory().getFile(this.path);
            TsFileWriter tsFileWriter = new TsFileWriter(f);
            try {
                for (Map.Entry<String, List<String>> entry : deviceSensorsMap.entrySet()) {
                    String device = entry.getKey();
                    for (String string : entry.getValue()) {
                        tsFileWriter.registerTimeseries(new Path(device), new MeasurementSchema(string, TSDataType.INT64, TSEncoding.RLE));
                    }
                }
            }
            catch (WriteProcessException e) {
                Assert.fail((String)e.getMessage());
            }
            int count = 0;
            long timestamp = 1L;
            while (count != 2) {
                ++count;
                for (Map.Entry entry : deviceSensorsMap.entrySet()) {
                    String device = (String)entry.getKey();
                    TSRecord tsRecord = new TSRecord(timestamp, device);
                    for (String sensor : (List)entry.getValue()) {
                        LongDataPoint dataPoint = new LongDataPoint(sensor, timestamp + 1L);
                        tsRecord.addTuple((DataPoint)dataPoint);
                    }
                    tsFileWriter.write(tsRecord);
                }
                tsFileWriter.flushAllChunkGroups();
                timestamp += 3600000L;
            }
            tsFileWriter.close();
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
    }

    protected void createOneTsFile(HashMap<String, List<String>> deviceSensorsMap) {
        try {
            File f = FSFactoryProducer.getFSFactory().getFile(this.path);
            TsFileWriter tsFileWriter = new TsFileWriter(f);
            try {
                for (Map.Entry<String, List<String>> entry : deviceSensorsMap.entrySet()) {
                    String device = entry.getKey();
                    for (String sensor : entry.getValue()) {
                        tsFileWriter.registerTimeseries(new Path(device), new MeasurementSchema(sensor, TSDataType.INT64, TSEncoding.RLE));
                    }
                }
            }
            catch (WriteProcessException e) {
                Assert.fail((String)e.getMessage());
            }
            for (long timestamp = 0L; timestamp < 100000000L; timestamp += 1000L) {
                for (Map.Entry<String, List<String>> entry : deviceSensorsMap.entrySet()) {
                    String device = entry.getKey();
                    TSRecord tsRecord = new TSRecord(timestamp, device);
                    for (String sensor : entry.getValue()) {
                        LongDataPoint dataPoint = new LongDataPoint(sensor, timestamp + 1L);
                        tsRecord.addTuple((DataPoint)dataPoint);
                    }
                    tsFileWriter.write(tsRecord);
                }
            }
            tsFileWriter.flushAllChunkGroups();
            tsFileWriter.close();
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void queryAndCheckTsFileWithOneDevice(String tsFilePath, int index, HashMap<String, List<String>> deviceSensorsMap) throws IOException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFilePath);
             TsFileReader readTsFile = new TsFileReader(reader);){
            ArrayList<Path> paths = new ArrayList<Path>();
            int totalSensorCount = 0;
            for (Map.Entry<String, List<String>> entry : deviceSensorsMap.entrySet()) {
                String device = entry.getKey();
                for (String sensor : entry.getValue()) {
                    ++totalSensorCount;
                    paths.add(new Path(device, sensor));
                }
            }
            QueryExpression queryExpression = QueryExpression.create(paths, null);
            QueryDataSet queryDataSet = readTsFile.query(queryExpression);
            long count = 0L;
            while (queryDataSet.hasNext()) {
                RowRecord rowRecord = queryDataSet.next();
                Assert.assertEquals((long)totalSensorCount, (long)rowRecord.getFields().size());
                long timeStamp = rowRecord.getTimestamp();
                Assert.assertEquals((long)((long)index * 3600000L + count), (long)timeStamp);
                for (int i = 0; i < totalSensorCount; ++i) {
                    Assert.assertEquals((long)(timeStamp + 1L), (long)((Field)rowRecord.getFields().get(i)).getLongV());
                }
                count += 1000L;
            }
        }
    }

    @Test
    public void splitOneTsfileWithTwoPagesTest() {
        this.createOneTsFileWithTwoPages("root.sg_0.device_1", "sensor_1");
        this.splitTwoPagesFileAndQueryCheck("root.sg_0.device_1", "sensor_1");
    }

    private void createOneTsFileWithTwoPages(String device, String sensor) {
        TSFileConfig fileConfig = TSFileDescriptor.getInstance().getConfig();
        int originMaxNumberOfPointsInPage = fileConfig.getMaxNumberOfPointsInPage();
        fileConfig.setMaxNumberOfPointsInPage(2);
        try {
            File f = FSFactoryProducer.getFSFactory().getFile(this.path);
            TsFileWriter tsFileWriter = new TsFileWriter(f);
            try {
                tsFileWriter.registerTimeseries(new Path(device), new MeasurementSchema(sensor, TSDataType.INT64, TSEncoding.RLE));
            }
            catch (WriteProcessException e) {
                Assert.fail((String)e.getMessage());
            }
            long timestamp = 1L;
            TSRecord tsRecord = new TSRecord(timestamp, device);
            LongDataPoint dataPoint = new LongDataPoint(sensor, timestamp);
            tsRecord.addTuple((DataPoint)dataPoint);
            tsFileWriter.write(tsRecord);
            tsRecord = new TSRecord(timestamp += 3600000L, device);
            dataPoint = new LongDataPoint(sensor, timestamp);
            tsRecord.addTuple((DataPoint)dataPoint);
            tsFileWriter.write(tsRecord);
            for (int i = 0; i < 2; ++i) {
                tsRecord = new TSRecord(++timestamp, device);
                dataPoint = new LongDataPoint(sensor, timestamp);
                tsRecord.addTuple((DataPoint)dataPoint);
                tsFileWriter.write(tsRecord);
            }
            tsFileWriter.flushAllChunkGroups();
            tsFileWriter.close();
            fileConfig.setMaxNumberOfPointsInPage(originMaxNumberOfPointsInPage);
        }
        catch (Throwable e) {
            Assert.fail((String)e.getMessage());
            fileConfig.setMaxNumberOfPointsInPage(originMaxNumberOfPointsInPage);
        }
    }

    private void splitTwoPagesFileAndQueryCheck(String device, String sensor) {
        File tsFile = new File(this.path);
        TsFileResource tsFileResource = new TsFileResource(tsFile);
        ArrayList splitResource = new ArrayList();
        try {
            TsFileRewriteTool.rewriteTsFile((TsFileResource)tsFileResource, splitResource);
        }
        catch (IOException | IllegalPathException | WriteProcessException e) {
            Assert.fail((String)e.getMessage());
        }
        Assert.assertEquals((long)2L, (long)splitResource.size());
        for (int i = 0; i < splitResource.size(); ++i) {
            try {
                this.queryAndCheckTsFile(((TsFileResource)splitResource.get(i)).getTsFilePath(), i, device, sensor);
                long partitionId = ((TsFileResource)splitResource.get(i)).getTimePartition();
                Assert.assertEquals((long)i, (long)partitionId);
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void queryAndCheckTsFile(String tsFilePath, int index, String device, String sensor) throws IOException {
        try (TsFileSequenceReader reader = new TsFileSequenceReader(tsFilePath);
             TsFileReader readTsFile = new TsFileReader(reader);){
            ArrayList<Path> paths = new ArrayList<Path>();
            paths.add(new Path(device, sensor));
            QueryExpression queryExpression = QueryExpression.create(paths, null);
            QueryDataSet queryDataSet = readTsFile.query(queryExpression);
            if (index == 0) {
                int count = 0;
                while (queryDataSet.hasNext()) {
                    ++count;
                    RowRecord rowRecord = queryDataSet.next();
                    long timeStamp = rowRecord.getTimestamp();
                    Assert.assertEquals((long)1L, (long)timeStamp);
                }
                Assert.assertEquals((long)1L, (long)count);
            } else {
                int count = 0;
                while (queryDataSet.hasNext()) {
                    RowRecord rowRecord = queryDataSet.next();
                    long timeStamp = rowRecord.getTimestamp();
                    Assert.assertEquals((long)(3600000L + (long)(++count)), (long)timeStamp);
                }
                Assert.assertEquals((long)3L, (long)count);
            }
        }
    }
}

